/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.OSGiBundle;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InjectionOSGiTest {
    private InjectionTarget target;
    private Bundle bundle;

    @After
    public void tearDown() throws Exception {
        this.bundle.start();
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        ContextInjectionFactory.uninject((Object)this.target, (IEclipseContext)localContext);
    }

    @Before
    public void setUp() throws Exception {
        BundleContext bundleContext = CoreTestsActivator.getDefault().getBundleContext();
        this.bundle = bundleContext.getBundle();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.target = (InjectionTarget)ContextInjectionFactory.make(InjectionTarget.class, (IEclipseContext)localContext);
    }

    @Test
    public void testInject() {
        Assert.assertTrue((boolean)this.target.hasContext());
    }

    @Test
    public void testUnInject() throws BundleException, InterruptedException {
        Assert.assertTrue((boolean)this.target.hasContext());
        BundleContext firstContext = this.target.getContext();
        this.bundle.stop();
        Assert.assertFalse((boolean)this.target.hasContext());
        this.bundle.start();
        Assert.assertTrue((boolean)this.target.hasContext());
        BundleContext secondContext = this.target.getContext();
        Assert.assertNotSame((Object)firstContext, (Object)secondContext);
    }

    @Test
    public void testBundleInject() throws BundleException {
        Assert.assertNotNull((Object)this.target.getBundle());
        this.bundle.stop();
        Assert.assertNotNull((Object)this.target.getBundle());
        Assert.assertTrue((this.target.getBundle().getState() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.target.getBundle().getSymbolicName());
        Assert.assertNull((Object)this.target.getContext());
    }

    static class InjectionBundleTarget
    extends InjectionTarget {
        InjectionBundleTarget() {
        }
    }

    static class InjectionTarget {
        private BundleContext ctx;
        private Bundle b;

        InjectionTarget() {
        }

        @Inject
        public void setBundleContext(@OSGiBundle @Optional BundleContext ctx) {
            this.ctx = ctx;
        }

        public boolean hasContext() {
            return this.ctx != null;
        }

        public BundleContext getContext() {
            return this.ctx;
        }

        @Inject
        public void setBundle(@OSGiBundle Bundle b) {
            this.b = b;
        }

        public Bundle getBundle() {
            return this.b;
        }

        @Inject
        public void setFoo(@OSGiBundle Object o) {
        }
    }
}

