/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di.extensions;

import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class InjectionPreferencesTest {
    private static final String TEST_PREFS_KEY = "testPreferencesQualifier";
    private static final String TEST_PREFS_NODE = "org.eclipse.e4.core.tests.ext";
    private static final String KEY_INT = "testPreferencesInt";
    private static final String KEY_BOOL = "testPreferencesBoolean";
    private static final String KEY_DOUBLE = "testPreferencesDouble";
    private static final String KEY_FLOAT = "testPreferencesFloat";
    private static final String KEY_LONG = "testPreferencesLong";

    @Test
    public void testPreferencesQualifier() throws BackingStoreException {
        this.setPreference(TEST_PREFS_KEY, "abc");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "123");
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        Assert.assertEquals((long)1L, (long)target.counter);
        Assert.assertEquals((Object)"abc", (Object)target.pref);
        Assert.assertEquals((long)1L, (long)target.counterNode);
        Assert.assertEquals((Object)"123", (Object)target.prefNode);
        Assert.assertEquals((long)1L, (long)target.counterOptional);
        Assert.assertNull((Object)target.prefOptional1);
        Assert.assertEquals((Object)"abc", (Object)target.prefOptional2);
        this.setPreference(TEST_PREFS_KEY, "xyz");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "456");
        Assert.assertEquals((long)2L, (long)target.counter);
        Assert.assertEquals((Object)"xyz", (Object)target.pref);
        Assert.assertEquals((long)2L, (long)target.counterNode);
        Assert.assertEquals((Object)"456", (Object)target.prefNode);
        Assert.assertEquals((long)2L, (long)target.counterOptional);
        Assert.assertNull((Object)target.prefOptional1);
        Assert.assertEquals((Object)"xyz", (Object)target.prefOptional2);
    }

    @Test
    public void testBaseTypeConversion() throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.putInt(KEY_INT, 12);
        node.putBoolean(KEY_BOOL, true);
        node.putDouble(KEY_DOUBLE, 12.35345345345);
        node.putFloat(KEY_FLOAT, 5.13f);
        node.putLong(KEY_LONG, 131232343453453L);
        node.flush();
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetPrimitive target = (InjectTargetPrimitive)ContextInjectionFactory.make(InjectTargetPrimitive.class, (IEclipseContext)context);
        Assert.assertEquals((long)12L, (long)target.intField);
        Assert.assertEquals((Object)true, (Object)target.booleanField);
        Assert.assertEquals((double)12.35345345345, (double)target.doubleField, (double)0.0);
        Assert.assertEquals((float)5.13f, (float)target.floatField, (float)0.0f);
        Assert.assertEquals((long)131232343453453L, (long)target.longField);
        Assert.assertEquals((long)12L, (long)target.intArg);
        Assert.assertEquals((Object)true, (Object)target.booleanArg);
        node.putInt(KEY_INT, 777);
        node.putBoolean(KEY_BOOL, false);
        Assert.assertEquals((long)777L, (long)target.intField);
        Assert.assertEquals((Object)false, (Object)target.booleanField);
        Assert.assertEquals((long)777L, (long)target.intArg);
        Assert.assertEquals((Object)false, (Object)target.booleanArg);
    }

    @Test
    public void testAutoConversion() throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.putInt(KEY_INT, 12);
        node.putBoolean(KEY_BOOL, true);
        node.putDouble(KEY_DOUBLE, 12.35345345345);
        node.putFloat(KEY_FLOAT, 5.13f);
        node.putLong(KEY_LONG, 131232343453453L);
        node.flush();
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetConversion target = (InjectTargetConversion)ContextInjectionFactory.make(InjectTargetConversion.class, (IEclipseContext)context);
        Assert.assertEquals((Object)12, (Object)target.intField);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)target.booleanField);
        Assert.assertEquals((Object)12.35345345345, (Object)target.doubleField);
        Assert.assertEquals((Object)Float.valueOf(5.13f), (Object)target.floatField);
        Assert.assertEquals((Object)131232343453453L, (Object)target.longField);
        Assert.assertEquals((Object)12, (Object)target.intArg);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)target.booleanArg);
        node.putInt(KEY_INT, 777);
        node.putBoolean(KEY_BOOL, false);
        Assert.assertEquals((Object)777, (Object)target.intField);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)target.booleanField);
        Assert.assertEquals((Object)777, (Object)target.intArg);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)target.booleanArg);
        Assert.assertNotNull((Object)target.preferences);
        Assert.assertEquals((Object)"abc", (Object)node.get("testOutValue", null));
    }

    private void setPreference(String key, String value) throws BackingStoreException {
        String nodePath = CoreTestsActivator.getDefault().getBundleContext().getBundle().getSymbolicName();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    private void setPreference(String key, String nodePath, String value) throws BackingStoreException {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(nodePath);
        node.put(key, value);
        node.flush();
    }

    @Test
    public void testPreferencesConstructor() throws BackingStoreException {
        this.setPreference(TEST_PREFS_KEY, "abc");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "123");
        IEclipseContext context = EclipseContextFactory.create();
        InjectTargetConstructor target = (InjectTargetConstructor)ContextInjectionFactory.make(InjectTargetConstructor.class, (IEclipseContext)context);
        Assert.assertEquals((Object)"abc", (Object)target.pref);
        Assert.assertEquals((Object)"123", (Object)target.prefNode);
        this.setPreference(TEST_PREFS_KEY, "xyz");
        this.setPreference(TEST_PREFS_KEY, TEST_PREFS_NODE, "456");
        Assert.assertEquals((Object)"abc", (Object)target.pref);
        Assert.assertEquals((Object)"123", (Object)target.prefNode);
    }

    static class InjectTarget {
        public int counter = 0;
        public int counterNode = 0;
        public int counterOptional = 0;
        public String pref;
        public String prefNode;
        public String prefOptional1;
        public String prefOptional2;

        InjectTarget() {
        }

        @Inject
        public void setPrefs(@Preference(value="testPreferencesQualifier") String string) {
            ++this.counter;
            this.pref = string;
        }

        @Inject
        public void setPrefsNode(@Preference(value="testPreferencesQualifier", nodePath="org.eclipse.e4.core.tests.ext") String string) {
            ++this.counterNode;
            this.prefNode = string;
        }

        @Inject
        public void setOptionalPrefs(@Optional @Preference(value="something") String string1, @Preference(value="testPreferencesQualifier") String string2) {
            ++this.counterOptional;
            this.prefOptional1 = string1;
            this.prefOptional2 = string2;
        }
    }

    static class InjectTargetConstructor {
        public String pref;
        public String prefNode;

        @Inject
        public InjectTargetConstructor(@Preference(value="testPreferencesQualifier") String string, @Preference(value="testPreferencesQualifier", nodePath="org.eclipse.e4.core.tests.ext") String stringNode) {
            this.pref = string;
            this.prefNode = stringNode;
        }
    }

    static class InjectTargetConversion {
        @Inject
        @Preference(value="testPreferencesInt")
        public Integer intField;
        @Inject
        @Preference(value="testPreferencesBoolean")
        public Boolean booleanField;
        @Inject
        @Preference(value="testPreferencesDouble")
        public Double doubleField;
        @Inject
        @Preference(value="testPreferencesFloat")
        public Float floatField;
        @Inject
        @Preference(value="testPreferencesLong")
        public Long longField;
        public IEclipsePreferences preferences;
        public Integer intArg;
        public Boolean booleanArg;

        InjectTargetConversion() {
        }

        @Inject
        public void set(@Preference(value="testPreferencesInt") Integer intArg, @Preference(value="testPreferencesBoolean") Boolean booleanArg) {
            this.intArg = intArg;
            this.booleanArg = booleanArg;
        }

        @Inject
        public void set2(@Preference IEclipsePreferences prefNode) {
            this.preferences = prefNode;
            prefNode.put("testOutValue", "abc");
        }
    }

    static class InjectTargetPrimitive {
        @Inject
        @Preference(value="testPreferencesInt")
        public int intField;
        @Inject
        @Preference(value="testPreferencesBoolean")
        public boolean booleanField;
        @Inject
        @Preference(value="testPreferencesDouble")
        public double doubleField;
        @Inject
        @Preference(value="testPreferencesFloat")
        public float floatField;
        @Inject
        @Preference(value="testPreferencesLong")
        public long longField;
        public int intArg;
        public boolean booleanArg;

        InjectTargetPrimitive() {
        }

        @Inject
        public void set(@Preference(value="testPreferencesInt") int intArg, @Preference(value="testPreferencesBoolean") boolean booleanArg) {
            this.intArg = intArg;
            this.booleanArg = booleanArg;
        }
    }
}

