/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.manual;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.Assert;
import org.junit.Test;

public class ComputedValueLimitationTest {
    @Test
    public synchronized void testInjection() {
        IEclipseContext context = EclipseContextFactory.create();
        int i = 0;
        while (i < 10) {
            context.set("arg" + Integer.toString(i), (Object)Integer.toString(i));
            ++i;
        }
        context.set("computed", (Object)new CalcColor());
        UserObject userObject = new UserObject();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        int i2 = 0;
        while (i2 < 20) {
            int before = ExtenralFactor.useChild();
            String actual = userObject.getComputed();
            int after = ExtenralFactor.useChild();
            System.out.println("[" + before + "] actual: " + actual + " [" + after + "]");
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    @Test
    public void testVolatileFunction() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("time", (Object)new Time());
        long time = (Long)context.get("time");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long newTime = (Long)context.get("time");
        Assert.assertTrue((time != newTime ? 1 : 0) != 0);
    }

    public class CalcColor
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            int useArg = ExtenralFactor.useChild();
            return context.get("arg" + Integer.toString(useArg));
        }
    }

    public static class ExtenralFactor {
        public static int useChild() {
            long time = System.currentTimeMillis();
            return (int)time % 10;
        }
    }

    public class Time
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            context.get(String.valueOf(System.currentTimeMillis()));
            return System.currentTimeMillis();
        }
    }

    public class UserObject {
        private String txt;

        @Inject
        public void Computed(String txt) {
            this.txt = txt;
        }

        public String getComputed() {
            return this.txt;
        }
    }
}

