/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.manual;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.junit.Test;

public class InjectionErrorReportingTest {
    @Test(expected=InjectionException.class)
    public void testMethodInjectionError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        InjectedMethod object = new InjectedMethod();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testMethodInjectionNullError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        InjectedMethodNull object = new InjectedMethodNull();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testConstructorInjectionError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        ContextInjectionFactory.make(InjectedConstructor.class, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testConstructorCastError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        ContextInjectionFactory.make(InjectedConstructorCast.class, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testFieldInjectionError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        InjectedField object = new InjectedField();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testPostConstructError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        ContextInjectionFactory.make(InjectedPostConstruct.class, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testPreDestoryError() {
        IEclipseContext context = EclipseContextFactory.create();
        TestData methodValue = new TestData();
        context.set("testing", (Object)methodValue);
        ContextInjectionFactory.make(InjectedPreDestroy.class, (IEclipseContext)context);
        context.dispose();
    }

    @Test(expected=StackOverflowError.class)
    public void testRecursionError() {
        IEclipseContext context = EclipseContextFactory.create();
        ContextInjectionFactory.make(InjectedRecursive.class, (IEclipseContext)context);
        context.set(InjectedRecursive.class, (Object)new InjectedRecursive());
        ContextInjectionFactory.make(InjectedRecursive.class, (IEclipseContext)context);
    }

    static class InjectedConstructor {
        public int setMethodCalled = 0;
        public TestData value;

        @Inject
        public InjectedConstructor(@Named(value="testing123") TestData arg) {
            ++this.setMethodCalled;
            this.value = arg;
        }
    }

    static class InjectedConstructorCast {
        public int setMethodCalled = 0;
        public TestData value;
        public String nullString = "abc";

        @Inject
        public InjectedConstructorCast(@Named(value="testing") TestData arg) {
            ++this.setMethodCalled;
            this.value = arg;
            TestData otherObject = new TestData();
            this.nullString = (String)((Object)otherObject);
        }
    }

    static class InjectedField {
        @Inject
        @Named(value="testing123")
        public TestData data;

        InjectedField() {
        }
    }

    static class InjectedMethod {
        public int setMethodCalled = 0;
        public TestData value;

        InjectedMethod() {
        }

        @Inject
        public void injectedMethod(@Named(value="testing123") TestData arg) {
            ++this.setMethodCalled;
            this.value = arg;
        }
    }

    static class InjectedMethodNull {
        public int setMethodCalled = 0;
        public String nullString = null;

        InjectedMethodNull() {
        }

        @Inject
        public int injectedMethod(@Named(value="testing") TestData arg) {
            ++this.setMethodCalled;
            return this.nullString.length();
        }
    }

    static class InjectedPostConstruct {
        public int setMethodCalled = 0;
        public String nullString = null;
        public int length;

        InjectedPostConstruct() {
        }

        @PostConstruct
        public void myMethod() {
            ++this.setMethodCalled;
            this.length = this.nullString.length();
        }
    }

    static class InjectedPreDestroy {
        public int setMethodCalled = 0;
        public String nullString = null;
        public int length;

        InjectedPreDestroy() {
        }

        @Inject
        public void injectedMethod(@Named(value="testing") TestData arg) {
            ++this.setMethodCalled;
        }

        @PreDestroy
        public void myMethod() {
            ++this.setMethodCalled;
            this.length = this.nullString.length();
        }
    }

    @Creatable
    static class InjectedRecursive {
        @Inject
        public InjectedRecursive field;

        InjectedRecursive() {
        }
    }

    static class TestData {
        TestData() {
        }
    }
}

