/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.HashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.bindings.tests.Activator;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class KeyDispatcherTest {
    private static final String ID_DIALOG = "org.eclipse.ui.contexts.dialog";
    private static final String ID_DIALOG_AND_WINDOW = "org.eclipse.ui.contexts.dialogAndWindow";
    private static final String ID_WINDOW = "org.eclipse.ui.contexts.window";
    static final String[] CONTEXTS;
    private static final String TEST_CAT1 = "test.cat1";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID2 = "test.id2";
    private Display display;
    private IEclipseContext workbenchContext;
    private CallHandler handler;
    private CallHandler twoStrokeHandler;

    static {
        String[] stringArray = new String[9];
        stringArray[0] = ID_DIALOG_AND_WINDOW;
        stringArray[1] = "DAW";
        stringArray[3] = ID_DIALOG;
        stringArray[4] = "Dialog";
        stringArray[5] = ID_DIALOG_AND_WINDOW;
        stringArray[6] = ID_WINDOW;
        stringArray[7] = "Window";
        stringArray[8] = ID_DIALOG_AND_WINDOW;
        CONTEXTS = stringArray;
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        this.handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)this.handler);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class);
        TriggerSequence seq = bs.createSequence("CTRL+A");
        Binding db = this.createDefaultBinding(bs, seq, cmd);
        bs.activateBinding(db);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        this.twoStrokeHandler = new CallHandler();
        hs.activateHandler(TEST_ID2, (Object)this.twoStrokeHandler);
        TriggerSequence twoKeys = bs.createSequence("CTRL+5 CTRL+A");
        db = this.createDefaultBinding(bs, twoKeys, cmd2);
        bs.activateBinding(db);
    }

    private Binding createDefaultBinding(EBindingService bs, TriggerSequence sequence, ParameterizedCommand command) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("schemeId", "org.eclipse.ui.defaultAcceleratorConfiguration");
        return bs.createBinding(sequence, command, ID_WINDOW, attrs);
    }

    @Before
    public void setUp() {
        this.display = Display.getDefault();
        IEclipseContext globalContext = Activator.getDefault().getGlobalContext();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.workbenchContext);
        this.defineContexts(this.workbenchContext);
        this.defineBindingTables(this.workbenchContext);
        this.defineCommands(this.workbenchContext);
    }

    private void defineContexts(IEclipseContext context) {
        ContextManager contextManager = (ContextManager)context.get(ContextManager.class);
        int i = 0;
        while (i < CONTEXTS.length) {
            Context c = contextManager.getContext(CONTEXTS[i]);
            c.define(CONTEXTS[i + 1], null, CONTEXTS[i + 2]);
            i += 3;
        }
        EContextService cs = (EContextService)context.get(EContextService.class);
        cs.activateContext(ID_DIALOG_AND_WINDOW);
        cs.activateContext(ID_WINDOW);
    }

    private void defineBindingTables(IEclipseContext context) {
        BindingTableManager btm = (BindingTableManager)context.get(BindingTableManager.class);
        ContextManager cm = (ContextManager)context.get(ContextManager.class);
        btm.addTable(new BindingTable(cm.getContext(ID_DIALOG_AND_WINDOW)));
        btm.addTable(new BindingTable(cm.getContext(ID_WINDOW)));
        btm.addTable(new BindingTable(cm.getContext(ID_DIALOG)));
    }

    @After
    public void tearDown() {
        this.workbenchContext.dispose();
        this.workbenchContext = null;
        this.display.dispose();
        this.display = null;
    }

    @Test
    public void testExecuteOneCommand() {
        KeyBindingDispatcher dispatcher = new KeyBindingDispatcher();
        ContextInjectionFactory.inject((Object)dispatcher, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        Assert.assertFalse((boolean)this.handler.q2);
        Shell shell = new Shell(this.display, 0);
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 65;
        shell.notifyListeners(1, event);
        Assert.assertTrue((boolean)this.handler.q2);
    }

    @Test
    public void testExecuteMultiStrokeBinding() {
        KeyBindingDispatcher dispatcher = new KeyBindingDispatcher();
        ContextInjectionFactory.inject((Object)dispatcher, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        Assert.assertFalse((boolean)this.twoStrokeHandler.q2);
        Shell shell = new Shell(this.display, 0);
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 53;
        shell.notifyListeners(1, event);
        Assert.assertFalse((boolean)this.twoStrokeHandler.q2);
        event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 65;
        shell.notifyListeners(1, event);
        this.processEvents();
        Assert.assertTrue((boolean)this.twoStrokeHandler.q2);
        Assert.assertFalse((boolean)this.handler.q2);
    }

    @Test
    @Ignore
    public void TODOtestKeyDispatcherReset() throws Exception {
        KeyBindingDispatcher dispatcher = new KeyBindingDispatcher();
        ContextInjectionFactory.inject((Object)dispatcher, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        Assert.assertFalse((boolean)this.twoStrokeHandler.q2);
        Shell shell = new Shell(this.display, 0);
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 53;
        shell.notifyListeners(1, event);
        Assert.assertFalse((boolean)this.twoStrokeHandler.q2);
        Thread.sleep(2000L);
        this.processEvents();
        event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        shell.notifyListeners(1, event);
        event = new Event();
        event.type = 1;
        event.stateMask = 262144;
        event.keyCode = 65;
        shell.notifyListeners(1, event);
        this.processEvents();
        Assert.assertFalse((boolean)this.twoStrokeHandler.q2);
        Assert.assertTrue((boolean)this.handler.q2);
    }

    @Test
    public void testSendKeyStroke() {
        KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)this.workbenchContext);
        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
        this.display.addFilter(1, (Listener)listener);
        this.display.addFilter(31, (Listener)listener);
        Shell shell = new Shell(this.display, 0);
        shell.setLayout((Layout)new FillLayout());
        StyledText text = new StyledText((Composite)shell, 66);
        shell.setBounds(100, 100, 100, 100);
        shell.layout();
        this.processEvents();
        Assert.assertEquals((Object)"", (Object)text.getText());
        Event event = new Event();
        event.type = 1;
        event.stateMask = 131072;
        event.keyCode = 40;
        event.character = (char)40;
        text.notifyListeners(1, event);
        event = new Event();
        event.type = 2;
        event.stateMask = 131072;
        event.keyCode = 40;
        event.character = (char)40;
        text.notifyListeners(2, event);
        this.processEvents();
        Assert.assertEquals((Object)"(", (Object)text.getText());
    }

    private void processEvents() {
        while (this.display.readAndDispatch()) {
        }
    }

    static class CallHandler {
        public boolean q1;
        public boolean q2;

        CallHandler() {
        }

        @CanExecute
        public boolean canExecute() {
            this.q1 = true;
            return true;
        }

        @Execute
        public Object execute() {
            this.q2 = true;
            if (this.q1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

