/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class StyleRuleTest {
    @Test
    public void testSimpleStyleRule() throws Exception {
        String css = "Label { color: #FF0000 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        Assert.assertNotNull((Object)styleSheet);
        CSSRuleList rules = styleSheet.getCssRules();
        Assert.assertEquals((long)1L, (long)rules.getLength());
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
    }

    @Test
    public void testHexColor() throws Exception {
        String css = "Label { color: #FF0220 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("color");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        RGBColor colorValue = ((CSSPrimitiveValue)value).getRGBColorValue();
        Assert.assertEquals((float)255.0f, (float)colorValue.getRed().getFloatValue((short)1), (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)colorValue.getGreen().getFloatValue((short)1), (float)0.0f);
        Assert.assertEquals((float)32.0f, (float)colorValue.getBlue().getFloatValue((short)1), (float)0.0f);
    }

    @Test
    public void testNamedColor() throws Exception {
        String css = "Label { color: green }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("color");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assert.assertEquals((Object)"green", (Object)colorString);
    }

    @Test
    public void testFont() throws Exception {
        String css = "Label { font: Verdana }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assert.assertEquals((Object)"Verdana", (Object)colorString);
    }

    @Test
    public void testTestFontItalic() throws Exception {
        String css = "Label { font: Arial 12px; font-style: italic }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font-style");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assert.assertEquals((Object)"italic", (Object)colorString);
    }

    @Test
    public void testTestFontBold() throws Exception {
        String css = "Label { font: Arial 12px; font-style: bold }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font-style");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assert.assertEquals((Object)"bold", (Object)colorString);
    }

    @Test
    public void testBackgroundNameColor() throws Exception {
        String css = "Label { background-color: green }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("background-color");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assert.assertEquals((Object)"green", (Object)colorString);
    }

    @Test
    public void testBackgroundHexColor() throws Exception {
        String css = "Label { background-color: #FF0220 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((long)1L, (long)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("background-color");
        Assert.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        RGBColor colorValue = ((CSSPrimitiveValue)value).getRGBColorValue();
        Assert.assertEquals((float)255.0f, (float)colorValue.getRed().getFloatValue((short)1), (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)colorValue.getGreen().getFloatValue((short)1), (float)0.0f);
        Assert.assertEquals((float)32.0f, (float)colorValue.getBlue().getFloatValue((short)1), (float)0.0f);
    }

    @Test
    public void testGetCSSText() throws Exception {
        String css = "Label, * > Label { background-color: rgb(255, 2, 32); }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assert.assertEquals((Object)css, (Object)rule.getCssText());
    }
}

