/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class ViewCSSTest {
    private Display display;
    private CSSSWTEngineImpl engine;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
        this.engine = new CSSSWTEngineImpl(this.display);
    }

    @Test
    public void testGetComputedStyle() throws Exception {
        String css = "Label { color: black; }Button { color: blue; font-weight: bold; }\nButton { color: green; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        CSSStyleDeclaration shellStyle = viewCSS.getComputedStyle((Element)((Object)shell), null);
        Assert.assertNull((Object)shellStyle);
        TestElement label = new TestElement("Label", (CSSEngine)this.engine);
        CSSStyleDeclaration labelStyle = viewCSS.getComputedStyle((Element)((Object)label), null);
        Assert.assertNotNull((Object)labelStyle);
        Assert.assertEquals((long)1L, (long)labelStyle.getLength());
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assert.assertNotNull((Object)buttonStyle);
        Assert.assertEquals((long)2L, (long)buttonStyle.getLength());
    }

    @Test
    public void testBug419482_order1() throws Exception {
        String css = "Shell > * > * { color: red; }\nButton { color: blue; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, (CSSEngine)this.engine);
        TestElement button = new TestElement("Button", composite, (CSSEngine)this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assert.assertNotNull((Object)buttonStyle);
        Assert.assertEquals((long)1L, (long)buttonStyle.getLength());
        Assert.assertEquals((Object)"color: blue;", (Object)buttonStyle.getCssText());
    }

    @Test
    public void testBug419482_order2() throws Exception {
        String css = "Button { color: blue; }\nShell > * > * { color: red; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, (CSSEngine)this.engine);
        TestElement button = new TestElement("Button", composite, (CSSEngine)this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assert.assertNotNull((Object)buttonStyle);
        Assert.assertEquals((long)1L, (long)buttonStyle.getLength());
        Assert.assertEquals((Object)"color: red;", (Object)buttonStyle.getCssText());
    }

    @Test
    public void testBug419482_higherSpecificity() throws Exception {
        String css = "Shell > * > Button { color: blue; }\nShell > * > * { color: red; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(css);
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, (CSSEngine)this.engine);
        TestElement button = new TestElement("Button", composite, (CSSEngine)this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assert.assertNotNull((Object)buttonStyle);
        Assert.assertEquals((long)1L, (long)buttonStyle.getLength());
        Assert.assertEquals((Object)"color: blue;", (Object)buttonStyle.getCssText());
    }

    @Test
    public void testRuleCaching() throws Exception {
        String css = "Shell > * > * { color: red; }\nButton { color: blue; }\n";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet((StyleSheet)styleSheet);
        ViewCSSImpl viewCSS = new ViewCSSImpl((DocumentCSS)docCss);
        Class[] NO_TYPES = new Class[]{};
        Object[] NO_ARGS = new Object[]{};
        Field currentCombinedRulesField = ViewCSSImpl.class.getDeclaredField("currentCombinedRules");
        currentCombinedRulesField.setAccessible(true);
        Assert.assertNull((Object)currentCombinedRulesField.get(viewCSS));
        TestElement shell = new TestElement("Shell", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", shell, (CSSEngine)this.engine);
        TestElement button = new TestElement("Button", composite, (CSSEngine)this.engine);
        CSSStyleDeclaration buttonStyle = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assert.assertNotNull((Object)buttonStyle);
        Assert.assertNotNull((Object)currentCombinedRulesField.get(viewCSS));
        Method getCombinedRulesMethod = ViewCSSImpl.class.getDeclaredMethod("getCombinedRules", NO_TYPES);
        getCombinedRulesMethod.setAccessible(true);
        List cssRules = (List)getCombinedRulesMethod.invoke((Object)viewCSS, NO_ARGS);
        Assert.assertSame((Object)cssRules, (Object)getCombinedRulesMethod.invoke((Object)viewCSS, NO_ARGS));
        css = "Shell > * > * { color: blue; }\nLabel { color: green; }\n";
        styleSheet = ParserTestUtil.parseCss(css);
        docCss.addStyleSheet((StyleSheet)styleSheet);
        Assert.assertNull((Object)currentCombinedRulesField.get(viewCSS));
        List cssRules2 = (List)getCombinedRulesMethod.invoke((Object)viewCSS, NO_ARGS);
        Assert.assertNotSame((Object)cssRules, (Object)cssRules2);
        Assert.assertTrue((cssRules2.size() > cssRules.size() ? 1 : 0) != 0);
    }

    private static ViewCSS createViewCss(String css) throws IOException {
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet((StyleSheet)styleSheet);
        return new ViewCSSImpl((DocumentCSS)docCss);
    }
}

