/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestElement
extends ElementAdapter {
    private final String typeName;
    private String className;
    private String id;
    private Map<String, String> attrs = new HashMap<String, String>();
    private Node parentNode = null;
    private List<Node> children = null;

    public TestElement(String type, CSSEngine engine) {
        super(null, engine);
        this.typeName = type;
    }

    public TestElement(String type, TestElement parent, CSSEngine engine) {
        this(type, engine);
        this.parentNode = parent;
        parent.appendChild((Node)((Object)this));
    }

    public void setClass(String className) {
        this.className = className;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAttribute(String name, String value) {
        this.attrs.put(name, value);
    }

    public String getAttribute(String name) {
        String value = this.attrs.get(name);
        return value == null ? "" : value;
    }

    public boolean hasAttribute(String name) {
        return this.attrs.containsKey(name);
    }

    public String getLocalName() {
        return this.typeName;
    }

    public NodeList getChildNodes() {
        if (this.children == null) {
            return null;
        }
        return new NodeList(){

            @Override
            public int getLength() {
                return TestElement.this.children.size();
            }

            @Override
            public Node item(int index) {
                return (Node)TestElement.this.children.get(index);
            }
        };
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public String getCSSClass() {
        return this.className;
    }

    public String getCSSId() {
        return this.id;
    }

    public String getCSSStyle() {
        return null;
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(newChild);
        return newChild;
    }
}

