/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.css.CSSValue;

public class CSSResourcesHelpersTest
extends CSSSWTHelperTestCase {
    @Test
    public void testGetCSSValueKeyWhenFont() {
        CSS2FontProperties fontProperties = null;
        fontProperties = this.fontProperties("Arial", 10, null, null);
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)fontProperties), (Object)result);
    }

    @Test
    public void testGetCSSValueKeyWhenDefinitionAsFontFamily() {
        CSS2FontProperties fontProperties = null;
        fontProperties = this.fontProperties(this.addFontDefinitionMarker("symbolicName"), 10, null, null);
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)fontProperties), (Object)result);
    }

    @Test
    public void testGetCSSValueKeyWhenRgbAsColorValue() {
        CSSValueImpl colorValue = this.colorValue("rgb(255,0,0)");
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"rgb(255,0,0)", (Object)result);
    }

    @Test
    public void testGetCSSValueKeyWhenDefinitionAsColorValue() {
        CSSValueImpl colorValue = this.colorValue(this.addColorDefinitionMarker("symbolicName"));
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"#symbolicName", (Object)result);
    }
}

