/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.e4.ui.css.swt.resources.ResourceByDefinitionKey;
import org.eclipse.e4.ui.css.swt.resources.SWTResourceRegistryKeyFactory;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.css.CSSValue;

public class SWTResourceRegistryKeyFactoryTest
extends CSSSWTHelperTestCase {
    private SWTResourceRegistryKeyFactory factory = new SWTResourceRegistryKeyFactory();

    @Test
    public void testCreateKeyWhenFontProperty() {
        CSS2FontProperties fontProperties = null;
        fontProperties = this.fontProperties("Arial", 12, CSS_ITALIC, CSS_BOLD);
        Object result = this.factory.createKey((CSSValue)fontProperties);
        Assert.assertEquals(String.class, result.getClass());
        Assert.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties), (Object)result);
    }

    @Test
    public void testCreateKeyWhenColorValue() {
        CSSValueImpl colorValue = this.colorValue("red");
        Object result = this.factory.createKey((CSSValue)colorValue);
        Assert.assertEquals(String.class, result.getClass());
        Assert.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue), (Object)result);
    }

    @Test
    public void testCreateKeyWhenFontByDefinition() {
        CSS2FontProperties fontProperties = null;
        try {
            fontProperties = this.fontProperties("#font-by-definition", 12, CSS_ITALIC, CSS_BOLD);
        }
        catch (Exception exception) {
            Assert.fail((String)"FontProperties should not throw exception");
        }
        Object result = this.factory.createKey((CSSValue)fontProperties);
        Assert.assertEquals(ResourceByDefinitionKey.class, result.getClass());
        Assert.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties).toString(), (Object)result.toString());
    }

    @Test
    public void testCreateKeyWhenColorByDefinition() {
        CSSValueImpl colorValue = this.colorValue("#color-by-definition");
        Object result = this.factory.createKey((CSSValue)colorValue);
        Assert.assertEquals(ResourceByDefinitionKey.class, result.getClass());
        Assert.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue).toString(), (Object)result.toString());
    }
}

