/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.css.CSSValue;

public class CSSSWTColorHelperTest
extends CSSSWTHelperTestCase {
    private Display display;
    private Color result;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @After
    public void tearDown() {
        if (this.result != null) {
            this.result.dispose();
        }
        this.display.dispose();
    }

    @Test
    public void testGetSWTColor() {
        this.result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("red"), (Display)this.display);
        Assert.assertNotNull((Object)this.result);
        Assert.assertEquals((long)255L, (long)this.result.getRed());
        Assert.assertEquals((long)0L, (long)this.result.getBlue());
        Assert.assertEquals((long)0L, (long)this.result.getGreen());
    }

    @Test
    public void testGetSWTColorWhenNotSupportedColorType() {
        this.result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("123213", (short)3), (Display)this.display);
        Assert.assertNull((Object)this.result);
    }

    @Test
    public void testGetSWTColorWhenInvalidColorValue() {
        this.result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("asdsad12"), (Display)this.display);
        Assert.assertNotNull((Object)this.result);
        Assert.assertEquals((long)0L, (long)this.result.getRed());
        Assert.assertEquals((long)0L, (long)this.result.getBlue());
        Assert.assertEquals((long)0L, (long)this.result.getGreen());
    }

    @Test
    public void testGetSWTColorWhenColorFromDefinition() {
        this.registerColorProviderWith("org.eclipse.jdt.debug.ui.InDeadlockColor", new RGB(0, 255, 0));
        this.result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue(this.addColorDefinitionMarker("org-eclipse-jdt-debug-ui-InDeadlockColor")), (Display)this.display);
        Assert.assertNotNull((Object)this.result);
        Assert.assertEquals((long)0L, (long)this.result.getRed());
        Assert.assertEquals((long)0L, (long)this.result.getBlue());
        Assert.assertEquals((long)255L, (long)this.result.getGreen());
    }
}

