/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.swt.graphics.FontData;
import org.junit.Assert;
import org.junit.Test;

public class CSSSWTFontHelperTest
extends CSSSWTHelperTestCase {
    @Test
    public void testGetFontData() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, CSS_ITALIC, CSS_BOLD), (FontData)new FontData());
        Assert.assertEquals((Object)"Times", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWithoutOldFont() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, CSS_ITALIC, CSS_BOLD), null);
        Assert.assertEquals((Object)"Times", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataStyledFont() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, "normal", "normal"), (FontData)new FontData("Courier", 11, 3));
        Assert.assertEquals((Object)"Times", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)0L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenMissingFamilyInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(null, 11, CSS_ITALIC, CSS_BOLD), (FontData)new FontData("Courier", 5, 0));
        Assert.assertEquals((Object)"Courier", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenMissingSizeInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Arial", null, CSS_ITALIC, CSS_BOLD), (FontData)new FontData("Courier", 5, 0));
        Assert.assertEquals((Object)"Arial", (Object)result.getName());
        Assert.assertEquals((long)5L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenMissingStyleInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, null, CSS_BOLD), (FontData)new FontData("Courier", 5, 2));
        Assert.assertEquals((Object)"Times", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenMissingWeightInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, CSS_ITALIC, null), (FontData)new FontData("Courier", 5, 1));
        Assert.assertEquals((Object)"Times", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenMissingAllInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(null, null, null, null), (FontData)new FontData("Courier", 11, 3));
        Assert.assertEquals((Object)"Courier", (Object)result.getName());
        Assert.assertEquals((long)11L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenFontFamilyFromDefinitionAndOverwritingSize() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 3);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), 10, null, null), (FontData)new FontData());
        Assert.assertEquals((Object)"Arial", (Object)result.getName());
        Assert.assertEquals((long)10L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenFontFamilyFromDefinitionAndOverwritingStyle() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 1);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), null, CSS_ITALIC, null), (FontData)new FontData());
        Assert.assertEquals((Object)"Arial", (Object)result.getName());
        Assert.assertEquals((long)15L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataWhenFontFamilyFromDefinitionAndOverwritingWeight() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 2);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), null, null, CSS_BOLD), (FontData)new FontData());
        Assert.assertEquals((Object)"Arial", (Object)result.getName());
        Assert.assertEquals((long)15L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }

    @Test
    public void testGetFontDataFromFontDefinition() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 3);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont")), (FontData)new FontData());
        Assert.assertEquals((Object)"Arial", (Object)result.getName());
        Assert.assertEquals((long)15L, (long)result.getHeight());
        Assert.assertEquals((long)3L, (long)result.getStyle());
    }
}

