/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.properties.tabbed;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.junit.Assert;
import org.junit.Test;

public class TabbedPropertiesListTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    private TabbedPropertySheetWidgetFactory factory;
    private Shell shell;

    private TabbedPropertyList createTabbedPropertiesList(String stylesheet) {
        String s = stylesheet == null ? "TabbedPropertyList { swt-tabAreaBackground-color: #FF0000; swt-tabBackground-color: #FF0000; swt-tabNormalShadow-color: #FF0000; swt-tabDarkShadow-color: #FF0000; color: #FF0000;}" : stylesheet;
        this.engine = this.createEngine(s, this.display);
        this.shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        Composite compositeToTest = new Composite((Composite)this.shell, 0);
        compositeToTest.setLayout((Layout)new FillLayout());
        this.factory = new TabbedPropertySheetWidgetFactory();
        TabbedPropertyList list = new TabbedPropertyList(compositeToTest, this.factory);
        this.shell.pack();
        return list;
    }

    @Test
    public void colorsAreStyled() {
        TabbedPropertyList list = this.createTabbedPropertiesList(null);
        this.engine.applyStyles((Object)this.shell, true);
        Assert.assertEquals((Object)RED, (Object)list.getListBackgroundColor().getRGB());
        Assert.assertEquals((Object)RED, (Object)list.getWidgetBackgroundColor().getRGB());
        Assert.assertEquals((Object)RED, (Object)list.getWidgetNormalShadowColor().getRGB());
        Assert.assertEquals((Object)RED, (Object)list.getWidgetDarkShadowColor().getRGB());
        Assert.assertEquals((Object)RED, (Object)list.getWidgetForegroundColor().getRGB());
    }

    @Test
    public void colorsAreStyledAndReset() {
        TabbedPropertyList list = this.createTabbedPropertiesList(null);
        RGB colorListBackgroundBeforeStyling = list.getListBackgroundColor().getRGB();
        RGB colorWidgetBackgroundBeforStyling = list.getWidgetBackgroundColor().getRGB();
        RGB colorWidgetNormalShadowBeforStyling = list.getWidgetNormalShadowColor().getRGB();
        RGB colorWidgetDarkShadowBeforStyling = list.getWidgetDarkShadowColor().getRGB();
        RGB colorWidgetForegroundBeforStyling = list.getWidgetForegroundColor().getRGB();
        this.engine.applyStyles((Object)this.shell, true);
        this.engine.reset();
        Assert.assertEquals((Object)colorListBackgroundBeforeStyling, (Object)list.getListBackgroundColor().getRGB());
        Assert.assertEquals((Object)colorWidgetBackgroundBeforStyling, (Object)list.getWidgetBackgroundColor().getRGB());
        Assert.assertEquals((Object)colorWidgetNormalShadowBeforStyling, (Object)list.getWidgetNormalShadowColor().getRGB());
        Assert.assertEquals((Object)colorWidgetDarkShadowBeforStyling, (Object)list.getWidgetDarkShadowColor().getRGB());
        Assert.assertEquals((Object)colorWidgetForegroundBeforStyling, (Object)list.getWidgetForegroundColor().getRGB());
    }

    @Test
    public void colorsAreNotChangedWhenNoStyleGivenInCss() {
        TabbedPropertyList list = this.createTabbedPropertiesList("SomeOtherWidget { listBackground-color: #FF0000; widgetBackground-color: #FF0000; widgetNormalShadow-color: #FF0000; widgetDarkShadow-color: #FF0000; widgetForeground-color: #FF0000;}");
        RGB colorListBackgroundBeforeStyling = list.getListBackgroundColor().getRGB();
        RGB colorWidgetBackgroundBeforStyling = list.getWidgetBackgroundColor().getRGB();
        RGB colorWidgetNormalShadowBeforStyling = list.getWidgetNormalShadowColor().getRGB();
        RGB colorWidgetDarkShadowBeforStyling = list.getWidgetDarkShadowColor().getRGB();
        RGB colorWidgetForegroundBeforStyling = list.getWidgetForegroundColor().getRGB();
        this.engine.applyStyles((Object)this.shell, true);
        Assert.assertEquals((Object)colorListBackgroundBeforeStyling, (Object)list.getListBackgroundColor().getRGB());
        Assert.assertEquals((Object)colorWidgetBackgroundBeforStyling, (Object)list.getWidgetBackgroundColor().getRGB());
        Assert.assertEquals((Object)colorWidgetNormalShadowBeforStyling, (Object)list.getWidgetNormalShadowColor().getRGB());
        Assert.assertEquals((Object)colorWidgetDarkShadowBeforStyling, (Object)list.getWidgetDarkShadowColor().getRGB());
        Assert.assertEquals((Object)colorWidgetForegroundBeforStyling, (Object)list.getWidgetForegroundColor().getRGB());
    }
}

