/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.junit.Assert;
import org.junit.Test;

public class Bug419482Test
extends CSSSWTTestCase {
    private static final RGB RGB_BLUE = new RGB(0, 0, 255);
    private static final RGB RGB_RED = new RGB(255, 0, 0);
    private ToolBar toolbar1;
    private ToolBar toolbar2;
    private ToolBar toolbar3;

    @Test
    public void testTwoLevelsWildcard() {
        String cssString = "Shell > * > * { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Assert.assertEquals((Object)RGB_BLUE, (Object)rgb);
    }

    @Test
    public void testOneLevelWildcardOneSpecific() {
        String cssString = "Shell > * > Label { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Assert.assertEquals((Object)RGB_RED, (Object)rgb);
    }

    @Test
    public void testDescendentsWildcard() {
        String cssString = "Shell * { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Assert.assertEquals((Object)RGB_BLUE, (Object)rgb);
    }

    @Test
    public void testDescendentsSpecific() {
        String cssString = "Shell Label { color: red; } \nLabel { color: blue; }";
        Label label = this.createTestLabel(cssString);
        RGB rgb = label.getForeground().getRGB();
        Assert.assertEquals((Object)RGB_RED, (Object)rgb);
    }

    @Test
    public void testOriginalBugReport() {
        String css = "Shell, Shell > *, Shell > * > * {\n    background-color: red;\n}\nToolBar {\n    background-color: blue;\n}";
        this.engine = this.createEngine(css, this.display);
        Shell shell = this.createShellWithToolbars(this.display);
        this.engine.applyStyles((Object)shell, true);
        Assert.assertEquals((Object)RGB_BLUE, (Object)this.toolbar1.getBackground().getRGB());
        Assert.assertEquals((Object)RGB_BLUE, (Object)this.toolbar2.getBackground().getRGB());
        Assert.assertEquals((Object)RGB_BLUE, (Object)this.toolbar3.getBackground().getRGB());
    }

    @Test
    public void testOriginalBugReportDifferentOrder() {
        String css = "ToolBar {\n    background-color: blue;\n}Shell, Shell > *, Shell > * > * {\n    background-color: red;\n}\n";
        this.engine = this.createEngine(css, this.display);
        Shell shell = this.createShellWithToolbars(this.display);
        this.engine.applyStyles((Object)shell, true);
        Assert.assertEquals((Object)RGB_RED, (Object)this.toolbar1.getBackground().getRGB());
        Assert.assertEquals((Object)RGB_RED, (Object)this.toolbar2.getBackground().getRGB());
        Assert.assertEquals((Object)RGB_BLUE, (Object)this.toolbar3.getBackground().getRGB());
    }

    private Shell createShellWithToolbars(Display display) {
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new RowLayout(512));
        this.toolbar1 = new ToolBar((Composite)shell, 2048);
        Composite composite1 = new Composite((Composite)shell, 0);
        composite1.setLayout((Layout)new RowLayout(512));
        this.toolbar2 = new ToolBar(composite1, 2048);
        Composite composite2 = new Composite(composite1, 0);
        composite2.setLayout((Layout)new RowLayout(512));
        this.toolbar3 = new ToolBar(composite2, 2048);
        return shell;
    }
}

