/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    @Rule
    public TestName testName = new TestName();
    protected Display display;
    protected CSSEngine engine;

    public CSSEngine createEngine(String styleSheet, Display display) {
        this.engine = new CSSSWTEngineImpl(display);
        this.engine.setErrorHandler(e -> Assert.fail((String)e.getMessage()));
        try {
            this.engine.parseStyleSheet((Reader)new StringReader(styleSheet));
        }
        catch (IOException e2) {
            Assert.fail((String)e2.getMessage());
        }
        return this.engine;
    }

    public void clearAndApply(CSSEngine engine, Widget widget, String styleSheet) {
        engine.reset();
        if (styleSheet != null) {
            try {
                engine.parseStyleSheet((Reader)new StringReader(styleSheet));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        engine.applyStyles((Object)widget, true, true);
    }

    @Before
    public void setUp() {
        System.out.println("[" + DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now()) + "] " + this.getClass().getName() + "#" + this.testName.getMethodName());
        System.out.format("  memory (free/max/total): %s/%s/%s MB%n", Runtime.getRuntime().freeMemory() / 1000000L, Runtime.getRuntime().maxMemory() / 1000000L, Runtime.getRuntime().totalMemory() / 1000000L);
        this.display = Display.getDefault();
    }

    @After
    public void tearDown() {
        this.display = Display.getDefault();
        if (!this.display.isDisposed()) {
            Shell[] shellArray = this.display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                shell.dispose();
                ++n2;
            }
            this.display.dispose();
        }
    }

    protected Label createTestLabel(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(panel, 0);
        labelToTest.setText("Some label text");
        this.engine.applyStyles((Object)labelToTest, true);
        shell.pack();
        return labelToTest;
    }
}

