/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.function.Supplier;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.dom.html.SWTHTMLElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CSSSWTWidgetTest
extends CSSSWTTestCase {
    @Ignore
    @Test
    public void testEngineKey() {
        Label widget = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        Assert.assertEquals((Object)WidgetElement.getEngine((Widget)widget), (Object)this.engine);
    }

    @Test
    public void testIDKey() {
        Label widget = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        WidgetElement.setID((Widget)widget, (String)"some.test.id");
        Assert.assertEquals((Object)WidgetElement.getID((Widget)widget), (Object)"some.test.id");
    }

    @Test
    public void testCSSClassKey() {
        Label widget = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        WidgetElement.setCSSClass((Widget)widget, (String)"some.test.cssclassname");
        Assert.assertEquals((Object)WidgetElement.getCSSClass((Widget)widget), (Object)"some.test.cssclassname");
    }

    @Test
    public void testHasAttribute() {
        Label widget = this.createTestLabel("Label { }");
        String propertySetToEmptyStringKey = "empty-property";
        widget.setData(propertySetToEmptyStringKey, (Object)"");
        Assert.assertTrue((boolean)this.engine.getElement((Object)widget).hasAttribute(propertySetToEmptyStringKey));
        Assert.assertFalse((boolean)this.engine.getElement((Object)widget).hasAttribute("foo-bar-attribute"));
        Assert.assertNotNull((Object)widget);
    }

    @Test
    public void testGetAttributeWithSwtStylesNull() {
        Label widget = this.createTestLabel("Label { }");
        this.engine.setElementProvider((element, engine) -> new WidgetElementWithSwtStylesNull((Widget)element, engine));
        Assert.assertTrue((boolean)this.engine.getElement((Object)widget).hasAttribute("style"));
        Assert.assertEquals((Object)"", (Object)this.engine.getElement((Object)widget).getAttribute("style"));
    }

    @Test
    public void testGetAttributeWithAttributeTypeNull() {
        Label widget = this.createTestLabel("Label { }");
        this.engine.setElementProvider((element, engine) -> new SWTHTMLElementWithAttributeTypeNull((Widget)element, engine));
        Assert.assertTrue((boolean)this.engine.getElement((Object)widget).hasAttribute("type"));
        Assert.assertEquals((Object)"", (Object)this.engine.getElement((Object)widget).getAttribute("type"));
    }

    @Test(expected=AssertionFailedException.class)
    public void testGetAttributeWithAttributeSupplierReturningNull() {
        Label widget = this.createTestLabel("Label { }");
        this.engine.setElementProvider((element, engine) -> new WidgetElementWithSupplierReturningNull((Widget)element, engine));
        this.engine.getElement((Object)widget).getAttribute("style");
    }

    private final class SWTHTMLElementWithAttributeTypeNull
    extends SWTHTMLElement {
        private SWTHTMLElementWithAttributeTypeNull(Widget widget, CSSEngine engine) {
            super(widget, engine);
            this.attributeType = null;
        }
    }

    private final class WidgetElementWithSupplierReturningNull
    extends WidgetElement {
        private WidgetElementWithSupplierReturningNull(Widget widget, CSSEngine engine) {
            super(widget, engine);
        }

        protected Supplier<String> internalGetAttribute(String attr) {
            return () -> null;
        }
    }

    private final class WidgetElementWithSwtStylesNull
    extends WidgetElement {
        private WidgetElementWithSwtStylesNull(Widget widget, CSSEngine engine) {
            super(widget, engine);
            this.swtStyles = null;
        }
    }
}

