/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ColorDefinitionTest
extends CSSSWTTestCase {
    @Test
    public void testColorDefinition() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        Assert.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assert.assertEquals((Object)new RGB(0, 128, 0), (Object)definition.getValue());
        Assert.assertEquals((Object)"name", (Object)definition.getName());
        Assert.assertEquals((Object)"categoryId", (Object)definition.getCategoryId());
        Assert.assertTrue((boolean)definition.getDescription().startsWith("description"));
        Assert.assertTrue((boolean)definition.isOverridden());
        engine.dispose();
    }

    @Test
    public void testColorDefinitionWhenNameCategoryIdAndDescriptionOverridden() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green;label:'nameOverridden'; category:'#categoryIdOverridden'; description: 'descriptionOverridden'}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        Assert.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assert.assertEquals((Object)new RGB(0, 128, 0), (Object)definition.getValue());
        Assert.assertEquals((Object)"nameOverridden", (Object)definition.getName());
        Assert.assertEquals((Object)"categoryIdOverridden", (Object)definition.getCategoryId());
        Assert.assertTrue((boolean)definition.getDescription().startsWith("descriptionOverridden"));
        Assert.assertTrue((boolean)definition.isOverridden());
        engine.dispose();
    }

    @Test
    public void testColorDefinitionWhenDefinitionStylesheetNotFound() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green}", this.display);
        ColorDefinition definition = this.colorDefinition("color definition uniqueId without matching stylesheet", "name", "categoryId", "description");
        Assert.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assert.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assert.assertFalse((boolean)definition.isOverridden());
        engine.dispose();
    }

    @Test
    public void testWidgetWithColorDefinitionAsBackgroundColor() {
        this.registerColorProviderWith("ACTIVE_HYPERLINK_COLOR", new RGB(255, 0, 0));
        CSSEngine engine = this.createEngine("Label {background-color: '#ACTIVE_HYPERLINK_COLOR'}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Label label = new Label((Composite)shell, 0);
        label.setText("Some label text");
        engine.applyStyles((Object)label, true);
        Assert.assertEquals((Object)new RGB(255, 0, 0), (Object)label.getBackground().getRGB());
        engine.dispose();
        shell.dispose();
    }

    private ColorDefinition colorDefinition(String uniqueId, String name, String categoryId, String description) {
        return new ColorDefinition(name, uniqueId, "defaultsTo", "black", categoryId, true, description, "pluginId");
    }

    private void registerColorProviderWith(final String symbolicName, final RGB rgb) {
        try {
            new CSSActivator(){

                public IColorAndFontProvider getColorAndFontProvider() {
                    IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
                    ((IColorAndFontProvider)Mockito.doReturn((Object)rgb).when((Object)provider)).getColor(symbolicName);
                    return provider;
                }
            }.start(null);
        }
        catch (Exception exception) {
            Assert.fail((String)"Register color provider should not fail");
        }
    }
}

