/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class CompositeTest
extends CSSSWTTestCase {
    protected Composite createTestComposite(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite compositeToTest = new Composite((Composite)shell, 0);
        compositeToTest.setLayout((Layout)new FillLayout());
        this.engine.applyStyles((Object)compositeToTest, true);
        shell.pack();
        return compositeToTest;
    }

    protected Composite createTestCompositeAsInnerClass(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite compositeToTest = new Composite((Composite)shell, 0){};
        compositeToTest.setLayout((Layout)new FillLayout());
        this.engine.applyStyles((Object)compositeToTest, true);
        shell.pack();
        return compositeToTest;
    }

    @Test
    public void testCompositeColor() {
        Composite compositeToTest = this.createTestComposite("Composite { background-color: #FF0000; color: #0000FF }");
        Assert.assertEquals((Object)RED, (Object)compositeToTest.getBackground().getRGB());
        Assert.assertEquals((Object)BLUE, (Object)compositeToTest.getForeground().getRGB());
    }

    @Test
    public void testCompositeAsInnerClass() {
        Composite compositeToTest = this.createTestCompositeAsInnerClass("CompositeTest-1 { background-color: #FF0000; color: #0000FF }");
        Assert.assertEquals((Object)RED, (Object)compositeToTest.getBackground().getRGB());
        Assert.assertEquals((Object)BLUE, (Object)compositeToTest.getForeground().getRGB());
    }
}

