/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class IdClassLabelColorTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final String CSS_CLASS_NAME = "makeItGreenClass";
    static final String CSS_ID = "makeItBlueID";

    @Override
    protected Label createTestLabel(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(panel, 0);
        labelToTest.setText("Some label text");
        WidgetElement.setCSSClass((Widget)labelToTest, (String)CSS_CLASS_NAME);
        WidgetElement.setID((Widget)labelToTest, (String)CSS_ID);
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return labelToTest;
    }

    @Test
    public void testWidgetClass() {
        Label label = this.createTestLabel("Label { background-color: #FF0000 }");
        Assert.assertEquals((Object)RED, (Object)label.getBackground().getRGB());
    }

    @Test
    public void testCssClass() {
        Label labelToTest = this.createTestLabel(".makeItGreenClass { background-color: #00FF00 }");
        Assert.assertEquals((Object)WidgetElement.getCSSClass((Widget)labelToTest), (Object)CSS_CLASS_NAME);
        Assert.assertEquals((Object)GREEN, (Object)labelToTest.getBackground().getRGB());
    }

    @Test
    public void testWidgetId() {
        Label labelToTest = this.createTestLabel("#makeItBlueID { background-color: #0000FF }");
        Assert.assertEquals((Object)WidgetElement.getID((Widget)labelToTest), (Object)CSS_ID);
        Assert.assertEquals((Object)BLUE, (Object)labelToTest.getBackground().getRGB());
    }
}

