/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Label;
import org.junit.Assert;
import org.junit.Test;

public class LabelTest
extends CSSSWTTestCase {
    @Test
    public void testColor() {
        Label labelToTest = this.createTestLabel("Label { background-color: #FF0000; color: #0000FF }");
        Assert.assertEquals((Object)RED, (Object)labelToTest.getBackground().getRGB());
        Assert.assertEquals((Object)BLUE, (Object)labelToTest.getForeground().getRGB());
    }

    @Test
    public void testFontRegular() {
        Label labelToTest = this.createTestLabel("Label { font: Verdana 16px }");
        Assert.assertEquals((long)1L, (long)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assert.assertEquals((long)16L, (long)fontData.getHeight());
        Assert.assertEquals((long)0L, (long)fontData.getStyle());
    }

    @Test
    public void testFontBold() {
        Label labelToTest = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        Assert.assertEquals((long)1L, (long)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        Assert.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assert.assertEquals((long)12L, (long)fontData.getHeight());
        Assert.assertEquals((long)1L, (long)fontData.getStyle());
    }

    @Test
    public void testFontItalic() {
        Label labelToTest = this.createTestLabel("Label { font-style: italic }");
        Assert.assertEquals((long)1L, (long)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        Assert.assertEquals((long)2L, (long)fontData.getStyle());
    }

    @Test
    public void testAlignment() {
        Label labelToTest = this.createTestLabel("Label { swt-alignment: right }");
        Assert.assertEquals((long)131072L, (long)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { swt-alignment: center; }");
        Assert.assertEquals((long)0x1000000L, (long)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { swt-alignment: left; }");
        Assert.assertEquals((long)16384L, (long)labelToTest.getAlignment());
    }

    @Test
    public void testAlignment2() {
        Label labelToTest = this.createTestLabel("Label { swt-alignment: trail }");
        Assert.assertEquals((long)131072L, (long)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { swt-alignment: lead; }");
        Assert.assertEquals((long)16384L, (long)labelToTest.getAlignment());
    }
}

