/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class MarginTest
extends CSSSWTTestCase {
    private static final RGB RED = new RGB(255, 0, 0);
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;

    protected Control createTestControl(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setData("org.eclipse.e4.ui.css.swt.marginWrapper", (Object)true);
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        panel.setLayout((Layout)layout);
        Button buttonToTest = new Button(panel, 32);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        return buttonToTest;
    }

    protected Control createBadControlNoLayout(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setData((Object)"org.eclipse.e4.ui.css.swt.marginWrapper");
        Button buttonToTest = new Button(panel, 32);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        return buttonToTest;
    }

    protected Control createBadControlNoComposite(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        Button buttonToTest = new Button((Composite)shell, 32);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        return buttonToTest;
    }

    protected Control createBadControlNoKey(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        Composite panel = new Composite((Composite)shell, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        panel.setLayout((Layout)layout);
        Button buttonToTest = new Button(panel, 32);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        return buttonToTest;
    }

    @Test
    public void testTopMargin() {
        Control control = this.createTestControl("Button { margin-top: 10}");
        Assert.assertEquals((long)10L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testRightMargin() {
        Control control = this.createTestControl("Button { margin-right: 20}");
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)20L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testBottomMargin() {
        Control control = this.createTestControl("Button { margin-bottom: 30}");
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)30L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testLeftMargin() {
        Control control = this.createTestControl("Button { margin-left: 40}");
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)0L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)40L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testMargin1Value() {
        Control control = this.createTestControl("Button { margin: 15}");
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testMargin2Values() {
        Control control = this.createTestControl("Button { margin: 10 15}");
        Assert.assertEquals((long)10L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)10L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testMargin4Values() {
        Control control = this.createTestControl("Button { margin: 10 15 20 40}");
        Assert.assertEquals((long)10L, (long)this.getMargin(control, 0));
        Assert.assertEquals((long)15L, (long)this.getMargin(control, 1));
        Assert.assertEquals((long)20L, (long)this.getMargin(control, 2));
        Assert.assertEquals((long)40L, (long)this.getMargin(control, 3));
    }

    @Test
    public void testMarginNoLayout() {
        Control control = this.createBadControlNoLayout("Button { margin: 10 15 20 40; background-color: #FF0000 }");
        Assert.assertEquals((Object)RED, (Object)control.getBackground().getRGB());
    }

    @Test
    public void testMarginNoComposite() {
        Control control = this.createBadControlNoComposite("Button { margin: 10 15 20 40; background-color: #FF0000 }");
        Assert.assertEquals((Object)RED, (Object)control.getBackground().getRGB());
    }

    @Test
    public void testMarginNoKey() {
        Control control = this.createBadControlNoKey("Button { margin: 10 15 20 40; background-color: #FF0000 }");
        Assert.assertEquals((Object)RED, (Object)control.getBackground().getRGB());
        Assert.assertNotSame((Object)10, (Object)this.getMargin(control, 0));
    }

    private int getMargin(Control control, int side) {
        GridLayout layout = (GridLayout)control.getParent().getLayout();
        switch (side) {
            case 0: {
                return layout.marginTop;
            }
            case 1: {
                return layout.marginRight;
            }
            case 2: {
                return layout.marginBottom;
            }
            case 3: {
                return layout.marginLeft;
            }
        }
        return -1;
    }
}

