/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.Assert;
import org.junit.Test;

public class Bug299755Test {
    @Test
    public void testBug299755() throws Exception {
        IEclipseContext windowContext = EclipseContextFactory.create();
        windowContext.set(Object.class, new Object());
        windowContext.set(InjectionObject.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(InjectionObject.class, (IEclipseContext)context);
            }
        });
        windowContext.declareModifiable("org.eclipse.ui.selection");
        IEclipseContext outContext = windowContext.createChild();
        IEclipseContext inContext = windowContext.createChild();
        Out out = (Out)ContextInjectionFactory.make(Out.class, (IEclipseContext)outContext);
        In in = (In)ContextInjectionFactory.make(In.class, (IEclipseContext)inContext);
        Assert.assertNull((Object)in.getSelection());
        Object selection = new Object();
        out.setSelection(selection);
        Assert.assertEquals((Object)selection, (Object)in.getSelection());
    }

    static class In {
        @Inject
        InjectionObject object;
        private Object selection;

        In() {
        }

        @Inject
        @Optional
        void setSelection(@Named(value="org.eclipse.ui.selection") Object selection) {
            this.selection = selection;
        }

        public Object getSelection() {
            return this.selection;
        }
    }

    static class InjectionObject {
        @Inject
        Object object;

        InjectionObject() {
        }
    }

    static class Out {
        @Inject
        private IEclipseContext context;

        Out() {
        }

        public void setSelection(Object selection) {
            this.context.modify("org.eclipse.ui.selection", selection);
        }
    }
}

