/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.application.UITest;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.Assert;
import org.junit.Test;

public class EModelServiceTest
extends UITest {
    @Test
    public void testGetPerspectiveFor_RegularElement() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        MPerspective foundPerspective = modelService.getPerspectiveFor((MUIElement)partStack);
        Assert.assertNotNull((Object)foundPerspective);
        Assert.assertEquals((Object)perspective, (Object)foundPerspective);
    }

    @Test
    public void testGetPerspectiveFor_SharedElement() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        placeholder.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholder);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        MPerspective foundPerspective = modelService.getPerspectiveFor((MUIElement)partStack);
        Assert.assertNotNull((Object)foundPerspective);
        Assert.assertEquals((Object)perspective, (Object)foundPerspective);
    }

    @Test
    public void testGetPerspectiveFor_SharedElement2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        placeholder.setRef((MUIElement)partSashContainer);
        partSashContainer.setCurSharedRef(placeholder);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partSashContainer.getChildren().add(partStack);
        partSashContainer.setSelectedElement((MUIElement)partStack);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        MPerspective foundPerspective = modelService.getPerspectiveFor((MUIElement)partStack);
        Assert.assertNotNull((Object)foundPerspective);
        Assert.assertEquals((Object)perspective, (Object)foundPerspective);
    }

    @Test
    public void testBringToTop01() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.bringToTop((MUIElement)windowA);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        modelService.bringToTop((MUIElement)windowB);
        Assert.assertEquals((Object)windowB, (Object)this.application.getSelectedElement());
    }

    @Test
    public void testBringToTop02() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        windowB.getChildren().add(partB);
        windowB.setSelectedElement((MUIElement)partB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        Assert.assertEquals((Object)windowB, (Object)this.application.getSelectedElement());
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.bringToTop((MUIElement)windowA);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        modelService.bringToTop((MUIElement)partB);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
    }

    @Test
    public void testBringToTop_Bug334411() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        detachedWindow.setToBeRendered(false);
        window.getWindows().add(detachedWindow);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setToBeRendered(false);
        detachedWindow.getChildren().add(part);
        this.getEngine().createGui((MUIElement)window);
        Assert.assertEquals((Object)window, (Object)this.application.getSelectedElement());
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.bringToTop((MUIElement)part);
        Assert.assertTrue((boolean)part.isToBeRendered());
        Assert.assertTrue((boolean)detachedWindow.isToBeRendered());
    }

    @Test
    public void testGetElementLocation_Bug331062_01() {
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(part);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        Assert.assertEquals((long)0L, (long)modelService.getElementLocation((MUIElement)part));
    }

    @Test
    public void testGetElementLocation_Bug331062_02() {
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MWindow innerWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        detachedWindow.getWindows().add(innerWindow);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        Assert.assertEquals((long)0L, (long)modelService.getElementLocation((MUIElement)innerWindow));
    }

    @Test
    public void testMoveWithoutIndexNoOtherElements() {
        MWindow source = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        source.getChildren().add(part);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.move((MUIElement)part, (MElementContainer)window);
        Assert.assertEquals((Object)part, window.getChildren().get(0));
    }

    @Test
    public void testMoveWithoutIndexWithOneOtherElements() {
        MWindow source = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        source.getChildren().add(part);
        window.getChildren().add(part2);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.move((MUIElement)part, (MElementContainer)window);
        Assert.assertSame((Object)part, window.getChildren().get(1));
    }

    @Test
    public void testMoveWithIndexWithTwoOtherElement() {
        MWindow source = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        MPart part3 = (MPart)this.ems.createModelElement(MPart.class);
        source.getChildren().add(part);
        window.getChildren().add(part2);
        window.getChildren().add(part3);
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        modelService.move((MUIElement)part, (MElementContainer)window, 1);
        Assert.assertSame((Object)part, window.getChildren().get(1));
    }

    @Test
    public void testCountRenderableChildren_WithWindows() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MWindow perspectiveWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(perspectiveWindow);
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        Assert.assertEquals((long)2L, (long)modelService.countRenderableChildren((MUIElement)perspective));
    }

    @Test
    public void testCreatePartFromDescriptorWithTrimBars() {
        MPartDescriptor mPartDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        MTrimBar mTrimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        mTrimBar.setElementId("test.trimbar.id");
        mPartDescriptor.getTrimBars().add(mTrimBar);
        MPart newPart = this.ems.createPart(mPartDescriptor);
        Assert.assertEquals((long)1L, (long)newPart.getTrimBars().size());
        Assert.assertEquals((long)1L, (long)mPartDescriptor.getTrimBars().size());
        Assert.assertEquals((Object)((MTrimBar)newPart.getTrimBars().get(0)).getElementId(), (Object)((MTrimBar)mPartDescriptor.getTrimBars().get(0)).getElementId());
    }
}

