/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.tests.application.ClientEditor;
import org.eclipse.e4.ui.tests.application.UITest;
import org.eclipse.e4.ui.tests.workbench.TargetedView;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.common.notify.Notifier;
import org.junit.Assert;
import org.junit.Test;

public class EPartServiceTest
extends UITest {
    @Test
    public void testFindPart_PartInWindow() {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.findPart("partId");
        Assert.assertNotNull((Object)part);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        Assert.assertEquals(partStack.getChildren().get(0), (Object)part);
        part = partService.findPart("invalidPartId");
        Assert.assertNull((Object)part);
    }

    @Test
    public void testFindPart_PartNotInWindow() {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.findPart("invalidPartId");
        Assert.assertNull((Object)part);
    }

    @Test
    public void testFindPart_PartInAnotherWindow() {
        this.createApplication(new String[][]{{"partInWindow1"}, {"partInWindow2"}});
        MWindow window1 = (MWindow)this.application.getChildren().get(0);
        MWindow window2 = (MWindow)this.application.getChildren().get(1);
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService partService = (EPartService)window1.getContext().get(EPartService.class);
        MPart part = partService.findPart("partInWindow2");
        Assert.assertNull((Object)part);
        part = partService.findPart("partInWindow1");
        Assert.assertNotNull((Object)part);
        MPartStack partStack = (MPartStack)window1.getChildren().get(0);
        Assert.assertEquals(partStack.getChildren().get(0), (Object)part);
        partService = (EPartService)window2.getContext().get(EPartService.class);
        part = partService.findPart("partInWindow1");
        Assert.assertNull((Object)part);
        part = partService.findPart("partInWindow2");
        Assert.assertNotNull((Object)part);
        partStack = (MPartStack)window2.getChildren().get(0);
        Assert.assertEquals(partStack.getChildren().get(0), (Object)part);
    }

    @Test
    public void testBringToTop_PartOnTop() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.bringToTop(partFront);
        Assert.assertEquals((Object)partStack.getSelectedElement(), (Object)partFront);
    }

    @Test
    public void testBringToTop_PartOnTop_myService() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)partFront.getContext().get(EPartService.class);
        partService.bringToTop(partFront);
        Assert.assertEquals((Object)partStack.getSelectedElement(), (Object)partFront);
    }

    @Test
    public void testBringToTop_PartNotOnTop() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.bringToTop(partBack);
        Assert.assertEquals((Object)partStack.getSelectedElement(), (Object)partBack);
    }

    @Test
    public void testBringToTop_PartNotOnTop_myService() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)partFront.getContext().get(EPartService.class);
        partService.bringToTop(partBack);
        Assert.assertEquals((Object)partStack.getSelectedElement(), (Object)partBack);
    }

    @Test
    public void testBringToTop_PartInAnotherWindow() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        partServiceA.bringToTop(partBackB);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackA);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceA.bringToTop(partBackA);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackB);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partBackB);
    }

    @Test
    public void testBringToTop_PartInAnotherWindow_myService() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class);
        partServiceA.bringToTop(partBackB);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackA);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partFrontA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceA.bringToTop(partBackA);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partFrontB);
        partServiceB.bringToTop(partBackB);
        Assert.assertEquals((Object)partStackA.getSelectedElement(), (Object)partBackA);
        Assert.assertEquals((Object)partStackB.getSelectedElement(), (Object)partBackB);
    }

    @Test
    public void testBringToTop_ActivationChanges01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPart partFrontA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partBackA = (MPart)this.ems.createModelElement(MPart.class);
        partStackA.getChildren().add(partFrontA);
        partStackA.getChildren().add(partBackA);
        window.getChildren().add(partStackA);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPart partFrontB = (MPart)this.ems.createModelElement(MPart.class);
        MPart partBackB = (MPart)this.ems.createModelElement(MPart.class);
        partStackB.getChildren().add(partFrontB);
        partStackB.getChildren().add(partBackB);
        window.getChildren().add(partStackB);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        window.setSelectedElement((MUIElement)partStackA);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partFrontA);
        Assert.assertEquals((Object)partFrontA, (Object)partService.getActivePart());
        partService.bringToTop(partBackB);
        Assert.assertEquals((Object)partFrontA, (Object)partService.getActivePart());
        Assert.assertTrue((boolean)partService.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partService.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partService.isPartVisible(partFrontB));
        Assert.assertTrue((boolean)partService.isPartVisible(partBackB));
        partService.bringToTop(partBackA);
        Assert.assertEquals((Object)partBackA, (Object)partService.getActivePart());
        Assert.assertFalse((boolean)partService.isPartVisible(partFrontA));
        Assert.assertTrue((boolean)partService.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partService.isPartVisible(partFrontB));
        Assert.assertTrue((boolean)partService.isPartVisible(partBackB));
    }

    @Test
    public void testBringToTop_ActivationChanges02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partB.setCurSharedRef(placeholderB);
        placeholderB.setRef((MUIElement)partB);
        partStack.getChildren().add(placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.bringToTop(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testBringToTop_Unrendered() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partBack.setToBeRendered(false);
        partStack.setSelectedElement((MUIElement)partFront);
        window.setSelectedElement((MUIElement)partStack);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        Assert.assertFalse((boolean)partBack.isToBeRendered());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.bringToTop(partBack);
        Assert.assertTrue((String)"Bringing a part to the top should cause it to be rendered", (boolean)partBack.isToBeRendered());
    }

    @Test
    public void testBringToTop_Bug330508_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.bringToTop(partB);
        Assert.assertEquals((String)"Bringing a part to top that's not in the same container as the active part shouldn't change the active part", (Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testBringToTop_Bug330508_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partB.setCurSharedRef(placeholderB);
        placeholderB.setRef((MUIElement)partB);
        partStack.getChildren().add(placeholderB);
        partStack.setSelectedElement((MUIElement)placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.bringToTop(partB);
        Assert.assertEquals((String)"Bringing a part to top that's not in the same container as the active part shouldn't change the active part", (Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testBringToTop_Bug330508_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.activate(partC);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
        partService.bringToTop(partB);
        Assert.assertEquals((String)"Bringing a part to top that's not in the same container as the active part shouldn't change the active part", (Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testBringToTop_Bug330508_04() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        partStack.getChildren().add(placeholderA);
        partStack.setSelectedElement((MUIElement)placeholderA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.activate(partC);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
        partService.bringToTop(partB);
        Assert.assertEquals((String)"Bringing a part to top that's not in the same container as the active part shouldn't change the active part", (Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testGetParts_Empty() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection parts = partService.getParts();
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)0L, (long)parts.size());
    }

    @Test
    public void testGetParts_OneWindow() {
        this.createApplication("partId", "partId2");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection parts = partService.getParts();
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)2L, (long)parts.size());
        Assert.assertTrue((boolean)parts.containsAll(partStack.getChildren()));
    }

    @Test
    public void testGetParts_TwoWindows() {
        this.createApplication(new String[][]{{"partId", "partId2"}, {"partIA", "partIdB", "partIdC"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        Collection partsA = partServiceA.getParts();
        Collection partsB = partServiceB.getParts();
        Assert.assertNotNull((Object)partsA);
        Assert.assertEquals((long)2L, (long)partsA.size());
        Assert.assertTrue((boolean)partsA.containsAll(partStackA.getChildren()));
        Assert.assertNotNull((Object)partsB);
        Assert.assertEquals((long)3L, (long)partsB.size());
        Assert.assertTrue((boolean)partsB.containsAll(partStackB.getChildren()));
        for (MPart partA : partsA) {
            Assert.assertFalse((boolean)partsB.contains(partA));
        }
    }

    @Test
    public void testGetParts_Bug334559_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partB);
        detachedWindow.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection parts = partService.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        Assert.assertTrue((boolean)parts.contains(partA));
        Assert.assertTrue((boolean)parts.contains(partB));
        Assert.assertTrue((boolean)parts.contains(partC));
    }

    @Test
    public void testGetParts_Bug334559_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partB);
        detachedWindow.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection parts = partService.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        Assert.assertTrue((boolean)parts.contains(partA));
        Assert.assertTrue((boolean)parts.contains(partB));
        Assert.assertTrue((boolean)parts.contains(partC));
    }

    @Test
    public void testGetActivePart() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        windowA.getChildren().add(partA);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        windowB.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService applicationPartService = (EPartService)this.application.getContext().get(EPartService.class);
        EPartService windowPartServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService windowPartServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        windowPartServiceA.activate(partA);
        Assert.assertEquals((Object)partA, (Object)applicationPartService.getActivePart());
        Assert.assertEquals((Object)partA, (Object)windowPartServiceA.getActivePart());
        Assert.assertEquals((Object)partB, (Object)windowPartServiceB.getActivePart());
        windowPartServiceB.activate(partB);
        Assert.assertEquals((Object)partB, (Object)applicationPartService.getActivePart());
        Assert.assertEquals((Object)partA, (Object)windowPartServiceA.getActivePart());
        Assert.assertEquals((Object)partB, (Object)windowPartServiceB.getActivePart());
    }

    public void testIsPartVisible_NotInStack(boolean selected, boolean visible) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setVisible(visible);
        window.getChildren().add(part);
        if (selected) {
            window.setSelectedElement((MUIElement)part);
        }
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)visible, (Object)partService.isPartVisible(part));
        partService = (EPartService)part.getContext().get(EPartService.class);
        Assert.assertEquals((Object)visible, (Object)partService.isPartVisible(part));
    }

    @Test
    public void testIsPartVisible_NotInStackTrueTrue() {
        this.testIsPartVisible_NotInStack(true, true);
    }

    @Test
    public void testIsPartVisible_NotInStackFalseTrue() {
        this.testIsPartVisible_NotInStack(false, true);
    }

    @Test
    public void testIsPartVisible_NotInStackFalseFalse() {
        this.testIsPartVisible_NotInStack(false, false);
    }

    @Test
    public void testIsPartVisible_ViewVisible() {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)part);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)partService.isPartVisible(part));
    }

    @Test
    public void testIsPartVisible_ViewVisible_myService() {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)partStack.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)part);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)part.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)partService.isPartVisible(part));
    }

    @Test
    public void testIsPartVisible_ViewNotVisible() {
        this.createApplication("partId", "partId2");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)((MStackElement)partStack.getChildren().get(0)));
        this.getEngine().createGui((MUIElement)window);
        MPart part = (MPart)partStack.getChildren().get(1);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertFalse((boolean)partService.isPartVisible(part));
    }

    @Test
    public void testIsPartVisible_ViewNotVisible_myService() {
        this.createApplication("partId", "partId2");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)((MStackElement)partStack.getChildren().get(0)));
        this.getEngine().createGui((MUIElement)window);
        MPart part1 = (MPart)partStack.getChildren().get(0);
        MPart part2 = (MPart)partStack.getChildren().get(1);
        EPartService partService1 = (EPartService)part1.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)partService1.isPartVisible(part1));
        Assert.assertFalse((boolean)partService1.isPartVisible(part2));
        partService1.activate(part2);
        EPartService partService2 = (EPartService)part2.getContext().get(EPartService.class);
        Assert.assertFalse((boolean)partService1.isPartVisible(part1));
        Assert.assertTrue((boolean)partService1.isPartVisible(part2));
        Assert.assertFalse((boolean)partService2.isPartVisible(part1));
        Assert.assertTrue((boolean)partService2.isPartVisible(part2));
    }

    @Test
    public void testIsPartVisible_ViewInAnotherWindow() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)partServiceA.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        Assert.assertTrue((boolean)partServiceB.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackB));
    }

    @Test
    public void testIsPartVisible_ViewInAnotherWindow_myService() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)partServiceA.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        Assert.assertTrue((boolean)partServiceB.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackB));
    }

    @Test
    public void testIsPartVisible_Placeholder() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setCategory("containerTag");
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.getTags().add("containerTag");
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholder = partService.createSharedPart("partId", true);
        MPart sharedPart = (MPart)placeholder.getRef();
        sharedPart.setCurSharedRef(placeholder);
        partService.showPart(sharedPart, EPartService.PartState.ACTIVATE);
        Assert.assertTrue((boolean)partService.isPartVisible(sharedPart));
    }

    @Test
    public void testActivate_partService() {
        this.createApplication("partId", "partId2");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        partStack.setSelectedElement((MUIElement)((MStackElement)partStack.getChildren().get(0)));
        this.getEngine().createGui((MUIElement)window);
        MPart part1 = (MPart)partStack.getChildren().get(0);
        MPart part2 = (MPart)partStack.getChildren().get(1);
        EPartService partService1 = (EPartService)part1.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)partService1.isPartVisible(part1));
        Assert.assertFalse((boolean)partService1.isPartVisible(part2));
        partService1.activate(part2);
        EPartService partService2 = (EPartService)part2.getContext().get(EPartService.class);
        Assert.assertFalse((boolean)partService1.isPartVisible(part1));
        Assert.assertTrue((boolean)partService1.isPartVisible(part2));
        Assert.assertFalse((boolean)partService2.isPartVisible(part1));
        Assert.assertTrue((boolean)partService2.isPartVisible(part2));
    }

    @Test
    public void testActivate_partService_twoWindows() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        windowA.setSelectedElement((MUIElement)partStackA);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        windowB.setSelectedElement((MUIElement)partStackB);
        this.application.setSelectedElement((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class);
        partServiceA.activate(partBackA);
        Assert.assertEquals((Object)partBackA, (Object)partServiceA.getActivePart());
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partFrontA));
        Assert.assertTrue((boolean)partServiceA.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        partServiceA.activate(partBackB);
        Assert.assertEquals((Object)partBackA, (Object)partServiceA.getActivePart());
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partFrontA));
        Assert.assertTrue((boolean)partServiceA.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceA.isPartVisible(partBackB));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        Assert.assertTrue((boolean)partServiceB.isPartVisible(partFrontB));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackB));
        partServiceB.activate(partBackB);
        Assert.assertEquals((Object)partBackB, (Object)partServiceB.getActivePart());
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partFrontA));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partBackA));
        Assert.assertFalse((boolean)partServiceB.isPartVisible(partFrontB));
        Assert.assertTrue((boolean)partServiceB.isPartVisible(partBackB));
    }

    @Test
    public void testActivate_partService_SelectedElement() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        partStackA.setSelectedElement((MUIElement)partFrontA);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        partStackB.setSelectedElement((MUIElement)partFrontB);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class);
        partServiceA.activate(partBackA);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        IEclipseContext a = this.application.getContext().getActiveLeaf();
        MPart aPart = (MPart)a.get(MPart.class);
        Assert.assertEquals((Object)partBackA, (Object)aPart);
        partServiceB.activate(partBackB);
        Assert.assertEquals((Object)windowB, (Object)this.application.getSelectedElement());
        a = this.application.getContext().getActiveLeaf();
        aPart = (MPart)a.get(MPart.class);
        Assert.assertEquals((Object)partBackB, (Object)aPart);
    }

    @Test
    public void testActivate_partService_activePart() {
        this.createApplication(new String[][]{{"partFrontA", "partBackA"}, {"partFrontB", "partBackB"}});
        MWindow windowA = (MWindow)this.application.getChildren().get(0);
        MPartStack partStackA = (MPartStack)windowA.getChildren().get(0);
        MPart partFrontA = (MPart)partStackA.getChildren().get(0);
        MPart partBackA = (MPart)partStackA.getChildren().get(1);
        MWindow windowB = (MWindow)this.application.getChildren().get(1);
        MPartStack partStackB = (MPartStack)windowB.getChildren().get(0);
        MPart partFrontB = (MPart)partStackB.getChildren().get(0);
        MPart partBackB = (MPart)partStackB.getChildren().get(1);
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)partFrontA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)partFrontB.getContext().get(EPartService.class);
        partServiceA.activate(partBackA);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        MPart shouldBeCorrect = (MPart)partFrontA.getContext().get("e4ActivePart");
        Assert.assertNotNull((Object)shouldBeCorrect);
        Assert.assertEquals((Object)partBackA, (Object)partServiceA.getActivePart());
        partServiceB.activate(partBackB);
        Assert.assertEquals((Object)windowB, (Object)this.application.getSelectedElement());
        shouldBeCorrect = (MPart)partFrontB.getContext().get("e4ActivePart");
        Assert.assertNotNull((Object)shouldBeCorrect);
        Assert.assertEquals((Object)partBackB, (Object)partServiceB.getActivePart());
    }

    @Test
    public void testActivate_Unrendered() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partBack.setToBeRendered(false);
        partStack.setSelectedElement((MUIElement)partFront);
        window.setSelectedElement((MUIElement)partStack);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        Assert.assertFalse((boolean)partBack.isToBeRendered());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partBack);
        Assert.assertTrue((String)"Activating a part should cause it to be rendered", (boolean)partBack.isToBeRendered());
    }

    @Test
    public void testActivate_Focus() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editorB = (ClientEditor)partB.getObject();
        Assert.assertFalse((boolean)editorB.wasFocusCalled());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        Assert.assertTrue((boolean)editorB.wasFocusCalled());
    }

    @Test
    public void testActivate_ChildWindow() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partB);
        detachedWindow.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testActivate_DetachedWindow() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partB);
        detachedWindow.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testActivate_Bug326300() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        windowA.getChildren().add(partA);
        windowA.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        windowA.getChildren().add(partB);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        windowB.getChildren().add(partC);
        windowB.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        ((EPartService)windowA.getContext().get(EPartService.class)).activate(partB);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)((EPartService)windowA.getContext().get(EPartService.class)).getActivePart());
        ((EPartService)windowB.getContext().get(EPartService.class)).activate(partC);
        Assert.assertEquals((Object)windowB, (Object)this.application.getSelectedElement());
        Assert.assertEquals((Object)partC, (Object)((EPartService)windowB.getContext().get(EPartService.class)).getActivePart());
        ((EPartService)windowA.getContext().get(EPartService.class)).activate(partB);
        Assert.assertEquals((Object)windowA, (Object)this.application.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)((EPartService)windowA.getContext().get(EPartService.class)).getActivePart());
    }

    @Test
    public void testActivate_Bug371894() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        window.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext context = window.getContext();
        ((EModelService)context.get(EModelService.class)).hostElement((MUIElement)partA, window, window.getWidget(), context);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
    }

    @Test
    public void testCreatePart() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertNotNull((Object)partService.createPart("partId"));
    }

    @Test
    public void testCreatePart2() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertNull((Object)partService.createPart("partId2"));
    }

    @Test
    public void testCreatePart_WithVariables() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.getVariables().add("testVariable");
        partDescriptor.getProperties().put("testVariable", "testValue");
        this.application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.createPart("partId");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((long)1L, (long)part.getVariables().size());
        Assert.assertEquals((Object)"testVariable", part.getVariables().get(0));
        Assert.assertEquals((long)1L, (long)part.getProperties().size());
        Assert.assertTrue((boolean)part.getProperties().containsKey("testVariable"));
        Assert.assertEquals((Object)"testValue", part.getProperties().get("testVariable"));
    }

    @Test
    public void testCreateSharedPart_NoDescriptor() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertNull((Object)partService.createSharedPart("partId"));
    }

    @Test
    public void testCreateSharedPart_ForceFalse() {
        this.createApplication(1, new String[1][0]);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderA = partService.createSharedPart("partId", false);
        MPlaceholder placeholderB = partService.createSharedPart("partId", false);
        Assert.assertEquals((long)1L, (long)window.getSharedElements().size());
        MPart part = (MPart)window.getSharedElements().get(0);
        Assert.assertEquals((Object)part, (Object)placeholderA.getRef());
        Assert.assertEquals((Object)part, (Object)placeholderB.getRef());
    }

    @Test
    public void testCreateSharedPart_ForceTrue() {
        this.createApplication(1, new String[1][0]);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderA = partService.createSharedPart("partId", true);
        MPlaceholder placeholderB = partService.createSharedPart("partId", true);
        Assert.assertEquals((long)2L, (long)window.getSharedElements().size());
        MPart part1 = (MPart)window.getSharedElements().get(0);
        MPart part2 = (MPart)window.getSharedElements().get(1);
        Assert.assertTrue((part1 == placeholderA.getRef() || part1 == placeholderB.getRef() ? 1 : 0) != 0);
        Assert.assertTrue((part2 == placeholderA.getRef() || part2 == placeholderB.getRef() ? 1 : 0) != 0);
    }

    @Test
    public void testShowPart_Id_ACTIVATE() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)"partId", (Object)part.getElementId());
        Assert.assertEquals((Object)part, (Object)partService.getActivePart());
        Assert.assertTrue((String)"Shown part should be visible", (boolean)part.isVisible());
    }

    @Test
    public void testShowPart_Id_ACTIVATE_DefinedCategoryStackNotExists() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId2");
        this.application.getDescriptors().add(partDescriptor);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)1L, (long)window.getChildren().size());
        Assert.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartStack));
        MPartStack stack = (MPartStack)window.getChildren().get(0);
        Assert.assertTrue((boolean)stack.getTags().contains("categoryId"));
        Assert.assertEquals((long)1L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)part, stack.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)stack.getSelectedElement());
        MPart part2 = partService.showPart("partId2", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)2L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)part, stack.getChildren().get(0));
        Assert.assertEquals((Object)part2, stack.getChildren().get(1));
        Assert.assertEquals((Object)part2, (Object)stack.getSelectedElement());
    }

    @Test
    public void testShowPart_Id_ACTIVATE_DefinedCategoryStackExists() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setCategory("categoryId");
        partDescriptor.setElementId("partId2");
        this.application.getDescriptors().add(partDescriptor);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.getTags().add("categoryId");
        window.getChildren().add(stack);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)1L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)part, stack.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)stack.getSelectedElement());
        MPart part2 = partService.showPart("partId2", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)2L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)part, stack.getChildren().get(0));
        Assert.assertEquals((Object)part2, stack.getChildren().get(1));
        Assert.assertEquals((Object)part2, (Object)stack.getSelectedElement());
    }

    @Test
    public void testShowPart_Id_CREATE() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStackA);
        window.getChildren().add(partStackB);
        MPart partA1 = (MPart)this.ems.createModelElement(MPart.class);
        MPart partA2 = (MPart)this.ems.createModelElement(MPart.class);
        partA1.setElementId("partA1");
        partA2.setElementId("partA2");
        partStackA.getChildren().add(partA1);
        partStackA.getChildren().add(partA2);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        partB1.setElementId("partB1");
        partB2.setElementId("partB2");
        partStackB.getChildren().add(partB1);
        partStackB.getChildren().add(partB2);
        partStackA.setSelectedElement((MUIElement)partA1);
        partStackB.setSelectedElement((MUIElement)partB1);
        window.setSelectedElement((MUIElement)partStackA);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA1);
        Assert.assertEquals((Object)partA1, (Object)partService.getActivePart());
        Assert.assertEquals(null, (Object)partA2.getContext());
        Assert.assertEquals(null, (Object)partB2.getContext());
        MPart shownPart = partService.showPart("partA2", EPartService.PartState.CREATE);
        Assert.assertTrue((boolean)partService.isPartVisible(partA1));
        Assert.assertTrue((boolean)partService.isPartVisible(partB1));
        Assert.assertEquals((Object)partA1, (Object)partService.getActivePart());
        Assert.assertEquals((Object)shownPart, (Object)partA2);
        Assert.assertNotNull((String)"The part should have been created so it should have a context", (Object)partA2.getContext());
        Assert.assertEquals((String)"This part has not been instantiated yet, it should have no context", null, (Object)partB2.getContext());
        shownPart = partService.showPart("partB2", EPartService.PartState.CREATE);
        Assert.assertTrue((boolean)partService.isPartVisible(partA1));
        Assert.assertTrue((boolean)partService.isPartVisible(partB1));
        Assert.assertEquals((Object)partA1, (Object)partService.getActivePart());
        Assert.assertEquals((Object)shownPart, (Object)partB2);
        Assert.assertNotNull((String)"The part should have been created so it should have a context", (Object)partA2.getContext());
        Assert.assertNotNull((String)"The part should have been created so it should have a context", (Object)partB2.getContext());
    }

    @Test
    public void testShowPart_Id_CREATE2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        this.application.getDescriptors().add(partDescriptor);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.setElementId("aCategory");
        window.getChildren().add(partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStack);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.CREATE);
        Assert.assertEquals((long)2L, (long)partStack.getChildren().size());
        Assert.assertEquals((String)"Only creating the part, the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        Assert.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        Assert.assertFalse((boolean)partService.isPartVisible(partB));
    }

    @Test
    public void testShowPart_Id_CREATE3() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        this.application.getDescriptors().add(partDescriptor);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStackA);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStackB.getTags().add("aCategory");
        window.getChildren().add(partStackB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStackA);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.CREATE);
        Assert.assertEquals((long)1L, (long)partStackA.getChildren().size());
        Assert.assertEquals((String)"Only creating the part, the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        Assert.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        Assert.assertTrue((String)"The part is the only one in the stack, it should be visible", (boolean)partService.isPartVisible(partB));
    }

    @Test
    public void testShowPart_Id_CREATE4() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.getTags().add("stackId");
        window.getChildren().add(stack);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("part");
        partDescriptor.setCategory("stackId");
        this.application.getDescriptors().add(partDescriptor);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("part", EPartService.PartState.CREATE);
        Assert.assertEquals((long)1L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)part, stack.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    @Test
    public void testShowPart_Id_VISIBLE() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStackA);
        window.getChildren().add(partStackB);
        MPart partA1 = (MPart)this.ems.createModelElement(MPart.class);
        MPart partA2 = (MPart)this.ems.createModelElement(MPart.class);
        partA1.setElementId("partA1");
        partA2.setElementId("partA2");
        partStackA.getChildren().add(partA1);
        partStackA.getChildren().add(partA2);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        partB1.setElementId("partB1");
        partB2.setElementId("partB2");
        partStackB.getChildren().add(partB1);
        partStackB.getChildren().add(partB2);
        partStackA.setSelectedElement((MUIElement)partA1);
        partStackB.setSelectedElement((MUIElement)partB1);
        window.setSelectedElement((MUIElement)partStackA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA1);
        Assert.assertEquals((Object)partA1, (Object)partService.getActivePart());
        MPart shownPart = partService.showPart("partB1", EPartService.PartState.VISIBLE);
        Assert.assertTrue((boolean)partService.isPartVisible(partA1));
        Assert.assertTrue((boolean)partService.isPartVisible(partB1));
        Assert.assertEquals((Object)partA1, (Object)partService.getActivePart());
        Assert.assertEquals((Object)partB1, (Object)shownPart);
        shownPart = partService.showPart("partB2", EPartService.PartState.VISIBLE);
        Assert.assertTrue((boolean)partService.isPartVisible(partA1));
        Assert.assertTrue((boolean)partService.isPartVisible(partB2));
        Assert.assertEquals((Object)partA1, (Object)partService.getActivePart());
        Assert.assertEquals((Object)partB2, (Object)shownPart);
    }

    @Test
    public void testShowPart_Id_VISIBLE2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        this.application.getDescriptors().add(partDescriptor);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.setElementId("aCategory");
        window.getChildren().add(partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStack);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.VISIBLE);
        Assert.assertEquals((long)2L, (long)partStack.getChildren().size());
        Assert.assertEquals((String)"The part is in the same stack as the active part, so the active part should have changed", (Object)partB, (Object)partService.getActivePart());
        Assert.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        Assert.assertFalse((boolean)partService.isPartVisible(partA));
        Assert.assertTrue((boolean)partService.isPartVisible(partB));
    }

    @Test
    public void testShowPart_Id_VISIBLE3() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        this.application.getDescriptors().add(partDescriptor);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStackA);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStackB.getTags().add("aCategory");
        window.getChildren().add(partStackB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStackA);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partB = partService.showPart("partB", EPartService.PartState.VISIBLE);
        Assert.assertEquals((long)1L, (long)partStackA.getChildren().size());
        Assert.assertEquals((String)"Only making a part visible, the active part should not have changed", (Object)partA, (Object)partService.getActivePart());
        Assert.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        Assert.assertTrue((String)"The part is the only one in the stack, it should be visible", (boolean)partService.isPartVisible(partB));
    }

    @Test
    public void testShowPart_Id_VISIBLE4() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.getTags().add("stackId");
        window.getChildren().add(stack);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("part");
        partDescriptor.setCategory("stackId");
        this.application.getDescriptors().add(partDescriptor);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("part", EPartService.PartState.VISIBLE);
        Assert.assertEquals((long)1L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)part, stack.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    @Test
    public void testShowPart_Id_VISIBLE5() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partB");
        partDescriptor.setCategory("aCategory");
        this.application.getDescriptors().add(partDescriptor);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.setElementId("aCategory");
        window.getChildren().add(partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partStack.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setToBeRendered(false);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partA);
        window.setSelectedElement((MUIElement)partStack);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart shownPart = partService.showPart("partB", EPartService.PartState.VISIBLE);
        Assert.assertEquals((long)2L, (long)partStack.getChildren().size());
        Assert.assertEquals((String)"The part is in the same stack as the active part, so the active part should have changed", (Object)partB, (Object)partService.getActivePart());
        Assert.assertNotNull((String)"The shown part should have a context", (Object)partB.getContext());
        Assert.assertFalse((boolean)partService.isPartVisible(partA));
        Assert.assertTrue((boolean)partService.isPartVisible(partB));
        Assert.assertEquals((Object)partB, (Object)shownPart);
        Assert.assertTrue((boolean)partB.isToBeRendered());
    }

    private void testShowPart_Id_Unrendered(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setElementId("partId");
        part.setToBeRendered(false);
        window.getChildren().add(part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart shownPart = partService.showPart("partId", partState);
        Assert.assertEquals((long)1L, (long)window.getChildren().size());
        Assert.assertEquals((Object)part, window.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)shownPart);
        Assert.assertTrue((String)"A shown part should be rendered", (boolean)part.isToBeRendered());
    }

    @Test
    public void testShowPart_Id_Unrendered_CREATE() {
        this.testShowPart_Id_Unrendered(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Id_Unrendered_VISIBLE() {
        this.testShowPart_Id_Unrendered(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Id_Unrendered_ACTIVATE() {
        this.testShowPart_Id_Unrendered(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Id_Unrendered2(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setToBeRendered(true);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.setToBeRendered(false);
        window.getChildren().add(partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setElementId("partId");
        part.setToBeRendered(false);
        partStack.getChildren().add(part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart shownPart = partService.showPart("partId", partState);
        Assert.assertEquals((long)1L, (long)partStack.getChildren().size());
        Assert.assertEquals((Object)part, partStack.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)shownPart);
        Assert.assertTrue((String)"A shown part should be rendered", (boolean)part.isToBeRendered());
    }

    @Test
    public void testShowPart_Id_Unrendered_CREATE2() {
        this.testShowPart_Id_Unrendered2(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Id_Unrendered_VISIBLE2() {
        this.testShowPart_Id_Unrendered2(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Id_Unrendered_ACTIVATE2() {
        this.testShowPart_Id_Unrendered2(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Id_Unrendered3(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setToBeRendered(true);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        partSashContainer.setToBeRendered(false);
        window.getChildren().add(partSashContainer);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.setToBeRendered(false);
        partSashContainer.getChildren().add(partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setElementId("partId");
        part.setToBeRendered(false);
        partStack.getChildren().add(part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart shownPart = partService.showPart("partId", partState);
        Assert.assertEquals((long)1L, (long)partStack.getChildren().size());
        Assert.assertEquals((Object)part, partStack.getChildren().get(0));
        Assert.assertEquals((Object)part, (Object)shownPart);
        Assert.assertTrue((String)"A shown part should be rendered", (boolean)part.isToBeRendered());
    }

    @Test
    public void testShowPart_Id_Unrendered_CREATE3() {
        this.testShowPart_Id_Unrendered3(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Id_Unrendered_VISIBLE3() {
        this.testShowPart_Id_Unrendered3(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Id_Unrendered_ACTIVATE3() {
        this.testShowPart_Id_Unrendered3(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Id_PartAlreadyShown(EPartService.PartState partState) {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("partId", partState);
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)"partId", (Object)part.getElementId());
        Assert.assertEquals((Object)part, (Object)partService.getActivePart());
        MPart part2 = partService.showPart("partId", partState);
        Assert.assertEquals((String)"Should not have instantiated a new MPart", (Object)part, (Object)part2);
        Assert.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    @Test
    public void testShowPart_Id_PartAlreadyShown_ACTIVATE() {
        this.testShowPart_Id_PartAlreadyShown(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Id_PartAlreadyShown_CREATE() {
        this.testShowPart_Id_PartAlreadyShown(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Id_PartAlreadyShown_VISIBLE() {
        this.testShowPart_Id_PartAlreadyShown(EPartService.PartState.VISIBLE);
    }

    private void testShowPart_Id_IncorrectDescriptor(EPartService.PartState partState) {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertNull((Object)partService.showPart("partId2", partState));
    }

    @Test
    public void testShowPart_Id_IncorrectDescriptor_ACTIVATE() {
        this.testShowPart_Id_IncorrectDescriptor(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Id_IncorrectDescriptor_VISIBLE() {
        this.testShowPart_Id_IncorrectDescriptor(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Id_IncorrectDescriptor_CREATE() {
        this.testShowPart_Id_IncorrectDescriptor(EPartService.PartState.CREATE);
    }

    private void testShowPart_Id_MultipleExists(boolean multipleAllowed, EPartService.PartState partState) {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack stack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setAllowMultiple(multipleAllowed);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        stack.setSelectedElement((MUIElement)part);
        window.setSelectedElement((MUIElement)stack);
        this.application.setSelectedElement((MUIElement)window);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart shownPart = partService.showPart("partId", partState);
        Assert.assertNotNull((Object)shownPart);
        Assert.assertEquals((Object)part, (Object)shownPart);
    }

    @Test
    public void testShowPart_Id_MultipleExists_TrueACTIVATE() {
        this.testShowPart_Id_MultipleExists(true, EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Id_MultipleExists_FalseACTIVATE() {
        this.testShowPart_Id_MultipleExists(false, EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Id_MultipleExists_TrueVISIBLE() {
        this.testShowPart_Id_MultipleExists(true, EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Id_MultipleExists_FalseVISIBLE() {
        this.testShowPart_Id_MultipleExists(false, EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Id_MultipleExists_TrueCREATE() {
        this.testShowPart_Id_MultipleExists(true, EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Id_MultipleExists_FalseCREATE() {
        this.testShowPart_Id_MultipleExists(false, EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Id_PartInInactivePerspective() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        MElementContainer parent = part.getParent();
        while (parent != null) {
            if (parent == perspectiveA) break;
            if (parent == perspectiveB) {
                Assert.fail((String)"Parent should not have been perspectiveB");
            }
            parent = parent.getParent();
        }
        Assert.assertNotNull((Object)parent);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        MPart part2 = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        parent = part2.getParent();
        while (parent != null) {
            if (parent == perspectiveB) break;
            if (parent == perspectiveA) {
                Assert.fail((String)"Parent should not have been perspectiveA");
            }
            parent = parent.getParent();
        }
        Assert.assertNotNull((Object)parent);
        Assert.assertFalse((part == part2 ? 1 : 0) != 0);
    }

    private void testShowPart_Part(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart part = partService.createPart("partId");
        partService.showPart(part, partState);
    }

    @Test
    public void testShowPart_Part_ACTIVATE() {
        this.testShowPart_Part(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Part_VISIBLE() {
        this.testShowPart_Part(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Part_CREATE() {
        this.testShowPart_Part(EPartService.PartState.CREATE);
    }

    private void testShowPart_Part_MultipleExists(boolean multipleAllowed, EPartService.PartState partState) {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack stack = (MPartStack)window.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setAllowMultiple(multipleAllowed);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        stack.setSelectedElement((MUIElement)part);
        window.setSelectedElement((MUIElement)stack);
        this.application.setSelectedElement((MUIElement)window);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, partState);
        Assert.assertNotNull((Object)shownPart);
        if (multipleAllowed) {
            Assert.assertEquals((Object)createdPart, (Object)shownPart);
        } else {
            Assert.assertEquals((Object)part, (Object)shownPart);
        }
    }

    @Test
    public void testShowPart_Part_MultipleExists_TrueACTIVATE() {
        this.testShowPart_Part_MultipleExists(true, EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Part_MultipleExists_FalseACTIVATE() {
        this.testShowPart_Part_MultipleExists(false, EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Part_MultipleExists_TrueVISIBLE() {
        this.testShowPart_Part_MultipleExists(true, EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Part_MultipleExists_FalseVISIBLE() {
        this.testShowPart_Part_MultipleExists(false, EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Part_MultipleExists_TrueCREATE() {
        this.testShowPart_Part_MultipleExists(true, EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Part_MultipleExists_FalseCREATE() {
        this.testShowPart_Part_MultipleExists(false, EPartService.PartState.CREATE);
    }

    private void testShowPart_Part_MultipleNonexistent(boolean multipleAllowed, EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setAllowMultiple(multipleAllowed);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, partState);
        Assert.assertNotNull((Object)shownPart);
        Assert.assertEquals((Object)createdPart, (Object)shownPart);
    }

    @Test
    public void testShowPart_Part_MultipleNonexistent_TrueACTIVATE() {
        this.testShowPart_Part_MultipleNonexistent(true, EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Part_MultipleNonexistent_FalseACTIVATE() {
        this.testShowPart_Part_MultipleNonexistent(false, EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Part_MultipleNonexistent_TrueVISIBLE() {
        this.testShowPart_Part_MultipleNonexistent(true, EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Part_MultipleNonexistent_FalseVISIBLE() {
        this.testShowPart_Part_MultipleNonexistent(false, EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Part_MultipleNonexistent_TrueCREATE() {
        this.testShowPart_Part_MultipleNonexistent(true, EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Part_MultipleNonexistent_FalseCREATE() {
        this.testShowPart_Part_MultipleNonexistent(false, EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Part_MultipleWithoutCategory() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setAllowMultiple(true);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, EPartService.PartState.ACTIVATE);
        Assert.assertNotNull((Object)shownPart);
        Assert.assertEquals((Object)createdPart, (Object)shownPart);
        MPart createdPart2 = partService.createPart("partId");
        MPart shownPart2 = partService.showPart(createdPart2, EPartService.PartState.ACTIVATE);
        Assert.assertFalse((boolean)shownPart.equals(shownPart2));
    }

    @Test
    public void testShowPart_Part_MultipleWithCategory() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.getTags().add("categoryId");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPartDescriptor descriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptor.setAllowMultiple(true);
        descriptor.setElementId("partId");
        descriptor.setCategory("categoryId");
        this.application.getDescriptors().add(descriptor);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart createdPart = partService.createPart("partId");
        MPart shownPart = partService.showPart(createdPart, EPartService.PartState.ACTIVATE);
        Assert.assertNotNull((Object)shownPart);
        Assert.assertEquals((Object)createdPart, (Object)shownPart);
        MPart createdPart2 = partService.createPart("partId");
        MPart shownPart2 = partService.showPart(createdPart2, EPartService.PartState.ACTIVATE);
        Assert.assertFalse((boolean)shownPart.equals(shownPart2));
        Assert.assertTrue((boolean)stack.getChildren().contains(shownPart));
        Assert.assertTrue((boolean)stack.getChildren().contains(shownPart2));
    }

    @Test
    public void testShowPart_Part_ExistingInNonstandardCategory() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.setElementId("categoryId2");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setElementId("partId");
        stack.getChildren().add(part);
        stack.setSelectedElement((MUIElement)part);
        MPartDescriptor descriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptor.setAllowMultiple(true);
        descriptor.setElementId("partId");
        descriptor.setCategory("categoryId");
        this.application.getDescriptors().add(descriptor);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart shownPart = partService.showPart("partId", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)part, (Object)shownPart);
        Assert.assertEquals((Object)stack, (Object)part.getParent());
    }

    @Test
    public void testShowPart_Bug318931() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderA = partService.createSharedPart("partId", true);
        MPart partA = (MPart)placeholderA.getRef();
        partA.setCurSharedRef(placeholderA);
        perspective.getChildren().add(placeholderA);
        MPlaceholder placeholderB = partService.createSharedPart("partId", true);
        MPart partB = (MPart)placeholderB.getRef();
        partB.setCurSharedRef(placeholderB);
        perspective.getChildren().add(placeholderB);
        partService.hidePart(partB);
        partService.showPart(partB, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)2L, (long)perspective.getChildren().size());
        Assert.assertEquals((Object)placeholderA, perspective.getChildren().get(0));
        Assert.assertEquals((Object)placeholderB, perspective.getChildren().get(1));
    }

    @Test
    public void testShowPart_Bug321755() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholder = partService.createSharedPart("partId", true);
        MPart sharedPart = (MPart)placeholder.getRef();
        sharedPart.setCurSharedRef(placeholder);
        partService.showPart(sharedPart, EPartService.PartState.ACTIVATE);
        List placeholders = modelService.findElements((MUIElement)perspective, null, MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholders.size());
        Assert.assertEquals((Object)placeholder, placeholders.get(0));
    }

    @Test
    public void testShowPart_Bug321757() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setCategory("containerTag");
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspective.getTags().add("containerTag");
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholder = partService.createSharedPart("partId", true);
        MPart sharedPart = (MPart)placeholder.getRef();
        sharedPart.setCurSharedRef(placeholder);
        partService.showPart(sharedPart, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)1L, (long)perspective.getChildren().size());
        Assert.assertEquals((Object)placeholder, perspective.getChildren().get(0));
    }

    private void testShowPart_Bug322368_Part(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setToBeRendered(false);
        window.getChildren().add(part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(part, partState);
        Assert.assertNotNull((Object)window.getSelectedElement());
        Assert.assertEquals((Object)part, (Object)window.getSelectedElement());
    }

    @Test
    public void testShowPart_Bug322368_Part_ACTIVATE() {
        this.testShowPart_Bug322368_Part(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Bug322368_Part_VISIBLE() {
        this.testShowPart_Bug322368_Part(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Bug322368_Part_CREATE() {
        this.testShowPart_Bug322368_Part(EPartService.PartState.CREATE);
    }

    private void testShowPart_Bug322368_Placeholder(EPartService.PartState partState) {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholder = partService.createSharedPart("partId", true);
        MPart sharedPart = (MPart)placeholder.getRef();
        sharedPart.setCurSharedRef(placeholder);
        placeholder.setToBeRendered(false);
        sharedPart.setToBeRendered(false);
        perspective.getChildren().add(placeholder);
        partService.showPart(sharedPart, partState);
        Assert.assertNotNull((Object)perspective.getSelectedElement());
        Assert.assertEquals((Object)placeholder, (Object)perspective.getSelectedElement());
    }

    @Test
    public void testShowPart_Bug322368_Placeholder_ACTIVATE() {
        this.testShowPart_Bug322368_Placeholder(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Bug322368_Placeholder_VISIBLE() {
        this.testShowPart_Bug322368_Placeholder(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Bug322368_Placeholder_CREATE() {
        this.testShowPart_Bug322368_Placeholder(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Bug322403_A() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStackA);
        perspective.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        partA.setCurSharedRef(placeholderA);
        placeholderA.setRef((MUIElement)partA);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStackB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderB = partService.createSharedPart("partId", true);
        MPart partB = (MPart)placeholderB.getRef();
        partB.setCurSharedRef(placeholderB);
        placeholderB.setToBeRendered(false);
        partB.setToBeRendered(false);
        partStackB.getChildren().add(placeholderB);
        partStackB.setSelectedElement(null);
        partService.showPart(partB, EPartService.PartState.VISIBLE);
        Assert.assertNotNull((Object)partStackB.getSelectedElement());
        Assert.assertEquals((Object)placeholderB, (Object)partStackB.getSelectedElement());
    }

    @Test
    public void testShowPart_Bug322403_B() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setAllowMultiple(true);
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStackA);
        perspective.setSelectedElement((MUIElement)partStackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStackB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderB = partService.createSharedPart("partId", true);
        MPart partB = (MPart)placeholderB.getRef();
        partB.setCurSharedRef(placeholderB);
        placeholderB.setToBeRendered(false);
        partB.setToBeRendered(false);
        partStackB.getChildren().add(placeholderB);
        partStackB.setSelectedElement(null);
        partService.showPart(partB, EPartService.PartState.VISIBLE);
        Assert.assertNotNull((Object)partStackB.getSelectedElement());
        Assert.assertEquals((Object)placeholderB, (Object)partStackB.getSelectedElement());
    }

    @Test
    public void testShowPart_Bug322403_C() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStackA);
        perspective.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        partA.setCurSharedRef(placeholderA);
        placeholderA.setRef((MUIElement)partA);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStackB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setToBeRendered(false);
        partStackB.getChildren().add(partB);
        partStackB.setSelectedElement(null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(partB, EPartService.PartState.VISIBLE);
        Assert.assertNotNull((Object)partStackB.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)partStackB.getSelectedElement());
    }

    @Test
    public void testShowPart_Bug320578_A() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partId");
        window.getSharedElements().add(partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)perspectiveA.getContext().get(EPartService.class);
        partService.showPart(partA, EPartService.PartState.ACTIVATE);
        Assert.assertNotNull((Object)partA.getCurSharedRef());
    }

    @Test
    public void testShowPart_Bug320578_B() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)perspectiveA.getContext().get(EPartService.class);
        partService.showPart(partA, EPartService.PartState.ACTIVATE);
        Assert.assertNotNull((Object)partA.getCurSharedRef());
    }

    @Test
    public void testShowPart_Bug320578_C() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setElementId("partId");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
        List partsA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)partsA.size());
        Assert.assertEquals((Object)part, partsA.get(0));
        List placeholdersA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholdersA.size());
        Assert.assertEquals((Object)part.getCurSharedRef(), placeholdersA.get(0));
        Assert.assertEquals((Object)part, (Object)((MPlaceholder)placeholdersA.get(0)).getRef());
        List partsB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)0L, (long)partsB.size());
        List placeholdersB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)0L, (long)placeholdersB.size());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        partService.showPart(part, EPartService.PartState.ACTIVATE);
        partsA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)partsA.size());
        Assert.assertEquals((Object)part, partsA.get(0));
        placeholdersA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholdersA.size());
        Assert.assertEquals((Object)part, (Object)((MPlaceholder)placeholdersA.get(0)).getRef());
        partsB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)partsB.size());
        Assert.assertEquals((Object)part, partsB.get(0));
        placeholdersB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholdersB.size());
        Assert.assertEquals((Object)part.getCurSharedRef(), placeholdersB.get(0));
    }

    @Test
    public void testShowPart_Bug320578_D() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setElementId("partId");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
        List partsA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)partsA.size());
        Assert.assertEquals((Object)part, partsA.get(0));
        List placeholdersA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholdersA.size());
        Assert.assertEquals((Object)part.getCurSharedRef(), placeholdersA.get(0));
        Assert.assertEquals((Object)part, (Object)((MPlaceholder)placeholdersA.get(0)).getRef());
        List partsB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)0L, (long)partsB.size());
        List placeholdersB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)0L, (long)placeholdersB.size());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        partService.showPart(part, EPartService.PartState.ACTIVATE);
        partsA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)partsA.size());
        Assert.assertEquals((Object)part, partsA.get(0));
        placeholdersA = modelService.findElements((MUIElement)perspectiveA, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholdersA.size());
        Assert.assertEquals((Object)part, (Object)((MPlaceholder)placeholdersA.get(0)).getRef());
        partsB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)partsB.size());
        Assert.assertEquals((Object)part, partsB.get(0));
        placeholdersB = modelService.findElements((MUIElement)perspectiveB, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholdersB.size());
        Assert.assertEquals((Object)part.getCurSharedRef(), placeholdersB.get(0));
    }

    @Test
    public void testShowPart_Bug320578_E() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        part.setCurSharedRef(placeholder);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
        List parts = modelService.findElements((MUIElement)perspective, part.getElementId(), MPart.class, null);
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertEquals((Object)part, parts.get(0));
        List placeholders = modelService.findElements((MUIElement)perspective, part.getElementId(), MPlaceholder.class, null);
        Assert.assertEquals((long)1L, (long)placeholders.size());
        Assert.assertEquals((Object)placeholder, placeholders.get(0));
        Assert.assertEquals((Object)part.getCurSharedRef(), placeholders.get(0));
        Assert.assertEquals((Object)part, (Object)((MPlaceholder)placeholders.get(0)).getRef());
    }

    @Test
    public void testShowPart_Bug329310_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        perspective.getChildren().add(partSashContainer);
        perspective.setSelectedElement((MUIElement)partSashContainer);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.getChildren().add(partA);
        partSashContainer.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partService.showPart(partB, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)2L, (long)partSashContainer.getChildren().size());
        Assert.assertEquals((Object)partA, partSashContainer.getChildren().get(0));
        Assert.assertTrue((boolean)(partSashContainer.getChildren().get(1) instanceof MPartStack));
    }

    @Test
    public void testShowPart_Bug329310_02() {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        perspective.getChildren().add(partSashContainer);
        perspective.setSelectedElement((MUIElement)partSashContainer);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.getChildren().add(partA);
        partSashContainer.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart("partId", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)2L, (long)partSashContainer.getChildren().size());
        Assert.assertEquals((Object)partA, partSashContainer.getChildren().get(0));
        Assert.assertTrue((boolean)(partSashContainer.getChildren().get(1) instanceof MPartStack));
    }

    private void testShowPart_Bug331047(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partStack.getChildren().add(placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        Assert.assertNull((String)"The part shouldn't have been rendered", (Object)partB.getContext());
        Assert.assertEquals((Object)partB, (Object)placeholderB.getRef());
        Assert.assertNull((Object)partB.getCurSharedRef());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(partB, partState);
        Assert.assertNotNull((String)"The part should have been rendered", (Object)partB.getContext());
        Assert.assertEquals((Object)partB, (Object)placeholderB.getRef());
        Assert.assertEquals((Object)placeholderB, (Object)partB.getCurSharedRef());
    }

    @Test
    public void testShowPart_Bug331047_CREATE() {
        this.testShowPart_Bug331047(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Bug331047_VISIBLE() {
        this.testShowPart_Bug331047(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Bug331047_ACTIVATE() {
        this.testShowPart_Bug331047(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Bug347837() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        partSashContainer.setToBeRendered(false);
        window.getChildren().add(partSashContainer);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setToBeRendered(false);
        placeholder.setRef((MUIElement)part);
        part.setCurSharedRef(placeholder);
        partSashContainer.getChildren().add(placeholder);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(part, EPartService.PartState.CREATE);
        Assert.assertNotNull((Object)part.getContext());
    }

    @Test
    public void testHidePart_PartInAnotherWindow() {
        this.createApplication(new String[][]{{"partInWindow1"}, {"partInWindow2"}});
        MWindow window1 = (MWindow)this.application.getChildren().get(0);
        MWindow window2 = (MWindow)this.application.getChildren().get(1);
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService partService1 = (EPartService)window1.getContext().get(EPartService.class);
        EPartService partService2 = (EPartService)window2.getContext().get(EPartService.class);
        MPart part1 = partService1.findPart("partInWindow1");
        MPart part2 = partService2.findPart("partInWindow2");
        Assert.assertTrue((boolean)part1.isToBeRendered());
        Assert.assertTrue((boolean)part2.isToBeRendered());
        partService1.hidePart(part2);
        Assert.assertTrue((boolean)part1.isToBeRendered());
        Assert.assertTrue((boolean)part2.isToBeRendered());
        partService2.hidePart(part1);
        Assert.assertTrue((boolean)part1.isToBeRendered());
        Assert.assertTrue((boolean)part2.isToBeRendered());
        partService1.hidePart(part1);
        Assert.assertFalse((boolean)part1.isToBeRendered());
        Assert.assertTrue((boolean)part2.isToBeRendered());
        partService2.hidePart(part2);
        Assert.assertFalse((boolean)part1.isToBeRendered());
        Assert.assertFalse((boolean)part2.isToBeRendered());
    }

    private void testHidePart_Tagged(boolean tagged) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        if (tagged) {
            part.getTags().add("removeOnHide");
        }
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(part);
        Assert.assertFalse((boolean)part.isToBeRendered());
        Assert.assertEquals((Object)(tagged ? null : window), (Object)part.getParent());
    }

    @Test
    public void testHidePart_Tagged_True() {
        this.testHidePart_Tagged(true);
    }

    @Test
    public void testHidePart_Tagged_False() {
        this.testHidePart_Tagged(false);
    }

    @Test
    public void testGetDirtyParts() {
        this.createApplication(1, new String[1][0]);
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection dirtyParts = partService.getDirtyParts();
        Assert.assertNotNull((Object)dirtyParts);
        Assert.assertEquals((long)0L, (long)dirtyParts.size());
    }

    @Test
    public void testGetDirtyParts2() {
        this.createApplication("partId");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection dirtyParts = partService.getDirtyParts();
        Assert.assertNotNull((Object)dirtyParts);
        Assert.assertEquals((long)0L, (long)dirtyParts.size());
    }

    private void testGetDirtyParts3(boolean before, boolean after) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPart saveablePart = (MPart)this.ems.createModelElement(MPart.class);
        saveablePart.setDirty(before);
        window.getChildren().add(saveablePart);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Collection dirtyParts = partService.getDirtyParts();
        Assert.assertNotNull((Object)dirtyParts);
        if (before) {
            Assert.assertEquals((long)1L, (long)dirtyParts.size());
            Assert.assertEquals((Object)saveablePart, dirtyParts.iterator().next());
        } else {
            Assert.assertEquals((long)0L, (long)dirtyParts.size());
        }
        saveablePart.setDirty(after);
        dirtyParts = partService.getDirtyParts();
        if (after) {
            Assert.assertEquals((long)1L, (long)dirtyParts.size());
            Assert.assertEquals((Object)saveablePart, dirtyParts.iterator().next());
        } else {
            Assert.assertEquals((long)0L, (long)dirtyParts.size());
        }
    }

    @Test
    public void testGetDirtyParts3_TrueTrue() {
        this.testGetDirtyParts3(true, true);
    }

    @Test
    public void testGetDirtyParts3_TrueFalse() {
        this.testGetDirtyParts3(true, false);
    }

    @Test
    public void testGetDirtyParts3_FalseTrue() {
        this.testGetDirtyParts3(false, true);
    }

    @Test
    public void testGetDirtyParts3_FalseFalse() {
        this.testGetDirtyParts3(false, false);
    }

    @Test
    public void testEvent_PartActivated() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        Assert.assertEquals((long)1L, (long)partListener.getActivated());
        Assert.assertEquals((Object)partBack, (Object)partListener.getActivatedParts().get(0));
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testPartActivationTimeData_Bug461063() {
        this.createApplication("activePart", "nonActivePart");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart activePart = (MPart)partStack.getChildren().get(0);
        MPart nonActivePart = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)activePart);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertTrue((boolean)activePart.getTransientData().containsKey("partActivationTime"));
        Assert.assertFalse((boolean)nonActivePart.getTransientData().containsKey("partActivationTime"));
        Assert.assertTrue((boolean)Long.class.isInstance(activePart.getTransientData().get("partActivationTime")));
        partService.activate(nonActivePart);
        Assert.assertTrue((boolean)activePart.getTransientData().containsKey("partActivationTime"));
        Assert.assertTrue((boolean)nonActivePart.getTransientData().containsKey("partActivationTime"));
    }

    @Test
    public void testEvent_PartActivated2() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.getChildren().add(windowB);
        this.application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        Assert.assertEquals((long)0L, (long)partListener.getActivated());
        Assert.assertEquals((long)0L, (long)partListener.getActivatedParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        Assert.assertEquals((long)0L, (long)partListener.getActivated());
        Assert.assertEquals((long)0L, (long)partListener.getActivatedParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testEvent_PartDeactivated() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        Assert.assertEquals((long)1L, (long)partListener.getDeactivated());
        Assert.assertEquals((Object)partFront, (Object)partListener.getDeactivatedParts().get(0));
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testEvent_PartDeactivated2() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.getChildren().add(windowB);
        this.application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        Assert.assertEquals((long)0L, (long)partListener.getDeactivated());
        Assert.assertEquals((long)0L, (long)partListener.getDeactivatedParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        Assert.assertEquals((long)0L, (long)partListener.getDeactivated());
        Assert.assertEquals((long)0L, (long)partListener.getDeactivatedParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testEvent_PartHidden() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        Assert.assertEquals((long)1L, (long)partListener.getHidden());
        Assert.assertEquals((Object)partFront, (Object)partListener.getHiddenParts().get(0));
        Assert.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partService.activate(partFront);
        Assert.assertEquals((long)1L, (long)partListener.getHidden());
        Assert.assertEquals((Object)partBack, (Object)partListener.getHiddenParts().get(0));
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testEvent_PartHidden2() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.getChildren().add(windowB);
        this.application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        Assert.assertEquals((long)0L, (long)partListener.getHidden());
        Assert.assertEquals((long)0L, (long)partListener.getHiddenParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        Assert.assertEquals((long)0L, (long)partListener.getHidden());
        Assert.assertEquals((long)0L, (long)partListener.getHiddenParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testEvent_PartVisible() {
        this.createApplication("partFront", "partBack");
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MPartStack partStack = (MPartStack)window.getChildren().get(0);
        MPart partFront = (MPart)partStack.getChildren().get(0);
        MPart partBack = (MPart)partStack.getChildren().get(1);
        partStack.setSelectedElement((MUIElement)partFront);
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)partFront, (Object)partService.getActivePart());
        PartListener partListener = new PartListener();
        partService.addPartListener((IPartListener)partListener);
        partService.activate(partBack);
        Assert.assertEquals((long)1L, (long)partListener.getVisible());
        Assert.assertEquals((Object)partBack, (Object)partListener.getVisibleParts().get(0));
        Assert.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partService.activate(partFront);
        Assert.assertEquals((long)1L, (long)partListener.getVisible());
        Assert.assertEquals((Object)partFront, (Object)partListener.getVisibleParts().get(0));
        Assert.assertTrue((boolean)partListener.isValid());
    }

    @Test
    public void testEvent_PartVisible2() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.getChildren().add(windowB);
        this.application.setSelectedElement((MUIElement)windowA);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        windowB.getChildren().add(stack);
        windowB.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService partServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService partServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        PartListener partListener = new PartListener();
        partServiceA.addPartListener((IPartListener)partListener);
        partServiceB.activate(partB);
        Assert.assertEquals((long)0L, (long)partListener.getVisible());
        Assert.assertEquals((long)0L, (long)partListener.getVisibleParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
        partListener.clear();
        partServiceB.activate(partA);
        Assert.assertEquals((long)0L, (long)partListener.getVisible());
        Assert.assertEquals((long)0L, (long)partListener.getVisibleParts().size());
        Assert.assertTrue((boolean)partListener.isValid());
    }

    private void testSavePart(final ISaveHandler.Save returnValue, boolean confirm, boolean beforeDirty, boolean afterDirty, boolean success, boolean saveCalled, boolean throwException) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPart saveablePart = (MPart)this.ems.createModelElement(MPart.class);
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(saveablePart);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException);
        window.getContext().set(ISaveHandler.class.getName(), (Object)new PartServiceSaveHandler(){

            public ISaveHandler.Save[] promptToSave(Collection<MPart> saveablePart) {
                return null;
            }

            public ISaveHandler.Save promptToSave(MPart saveablePart) {
                return returnValue;
            }
        });
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        if (beforeDirty) {
            Assert.assertEquals((Object)success, (Object)partService.savePart(saveablePart, confirm));
        } else {
            Assert.assertTrue((String)"The part is not dirty, the save operation should complete successfully", (boolean)partService.savePart(saveablePart, confirm));
        }
        Assert.assertEquals((Object)afterDirty, (Object)saveablePart.isDirty());
        Assert.assertEquals((Object)saveCalled, (Object)editor.wasSaveCalled());
    }

    private void testSavePart(ISaveHandler.Save returnValue, boolean confirm, boolean beforeDirty, boolean throwException) {
        switch (returnValue) {
            case YES: {
                if (throwException) {
                    if (beforeDirty) {
                        this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, beforeDirty, false, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, beforeDirty, true, false, throwException);
                    break;
                }
                if (beforeDirty) {
                    if (confirm) {
                        this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, true, throwException);
                    break;
                }
                if (confirm) {
                    this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, false, throwException);
                    break;
                }
                this.testSavePart(ISaveHandler.Save.YES, confirm, beforeDirty, false, true, false, throwException);
                break;
            }
            case NO: {
                if (throwException) {
                    if (beforeDirty) {
                        if (confirm) {
                            this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, beforeDirty, true, false, throwException);
                            break;
                        }
                        this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, beforeDirty, false, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, beforeDirty, true, false, throwException);
                    break;
                }
                if (beforeDirty) {
                    if (confirm) {
                        this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, true, true, false, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, false, true, true, throwException);
                    break;
                }
                if (confirm) {
                    this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, false, true, false, throwException);
                    break;
                }
                this.testSavePart(ISaveHandler.Save.NO, confirm, beforeDirty, false, true, false, throwException);
                break;
            }
            case CANCEL: {
                if (throwException) {
                    if (beforeDirty) {
                        if (confirm) {
                            this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, beforeDirty, false, false, throwException);
                            break;
                        }
                        this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, beforeDirty, false, true, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, beforeDirty, true, false, throwException);
                    break;
                }
                if (beforeDirty) {
                    if (confirm) {
                        this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, true, false, false, throwException);
                        break;
                    }
                    this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, false, true, true, throwException);
                    break;
                }
                if (confirm) {
                    this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, false, true, false, throwException);
                    break;
                }
                this.testSavePart(ISaveHandler.Save.CANCEL, confirm, beforeDirty, false, true, false, throwException);
                break;
            }
            default: {
                Assert.fail((String)("Unknown expected return value set: " + returnValue));
            }
        }
    }

    @Test
    public void testSavePart_YesTrueTrueTrue() {
        this.testSavePart(ISaveHandler.Save.YES, true, true, true);
    }

    @Test
    public void testSavePart_YesTrueTrueFalse() {
        this.testSavePart(ISaveHandler.Save.YES, true, true, false);
    }

    @Test
    public void testSavePart_YesTrueFalseTrue() {
        this.testSavePart(ISaveHandler.Save.YES, true, false, true);
    }

    @Test
    public void testSavePart_YesTrueFalseFalse() {
        this.testSavePart(ISaveHandler.Save.YES, true, false, false);
    }

    @Test
    public void testSavePart_YesFalseTrueTrue() {
        this.testSavePart(ISaveHandler.Save.YES, false, true, true);
    }

    @Test
    public void testSavePart_YesFalseTrueFalse() {
        this.testSavePart(ISaveHandler.Save.YES, false, true, false);
    }

    @Test
    public void testSavePart_YesFalseFalseTrue() {
        this.testSavePart(ISaveHandler.Save.YES, false, false, true);
    }

    @Test
    public void testSavePart_YesFalseFalseFalse() {
        this.testSavePart(ISaveHandler.Save.YES, false, false, false);
    }

    @Test
    public void testSavePart_NoTrueTrueTrue() {
        this.testSavePart(ISaveHandler.Save.NO, true, true, true);
    }

    @Test
    public void testSavePart_NoTrueTrueFalse() {
        this.testSavePart(ISaveHandler.Save.NO, true, true, false);
    }

    @Test
    public void testSavePart_NoTrueFalseTrue() {
        this.testSavePart(ISaveHandler.Save.NO, true, false, true);
    }

    @Test
    public void testSavePart_NoTrueFalseFalse() {
        this.testSavePart(ISaveHandler.Save.NO, true, false, false);
    }

    @Test
    public void testSavePart_NoFalseTrueTrue() {
        this.testSavePart(ISaveHandler.Save.NO, false, true, true);
    }

    @Test
    public void testSavePart_NoFalseTrueFalse() {
        this.testSavePart(ISaveHandler.Save.NO, false, true, false);
    }

    @Test
    public void testSavePart_NoFalseFalseTrue() {
        this.testSavePart(ISaveHandler.Save.NO, false, false, true);
    }

    @Test
    public void testSavePart_NoFalseFalseFalse() {
        this.testSavePart(ISaveHandler.Save.NO, false, false, false);
    }

    @Test
    public void testSavePart_CancelTrueTrueTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, true, true);
    }

    @Test
    public void testSavePart_CancelTrueTrueFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, true, false);
    }

    @Test
    public void testSavePart_CancelTrueFalseTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, false, true);
    }

    @Test
    public void testSavePart_CancelTrueFalseFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, true, false, false);
    }

    @Test
    public void testSavePart_CancelFalseTrueTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, true, true);
    }

    @Test
    public void testSavePart_CancelFalseTrueFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, true, false);
    }

    @Test
    public void testSavePart_CancelFalseFalseTrue() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, false, true);
    }

    @Test
    public void testSavePart_CancelFalseFalseFalse() {
        this.testSavePart(ISaveHandler.Save.CANCEL, false, false, false);
    }

    private void testSavePart_NoHandler(boolean beforeDirty, boolean throwException, boolean confirm) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPart saveablePart = (MPart)this.ems.createModelElement(MPart.class);
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(saveablePart);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException);
        this.applicationContext.set(ISaveHandler.class.getName(), null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        if (beforeDirty) {
            Assert.assertEquals((Object)(!throwException ? 1 : 0), (Object)partService.savePart(saveablePart, confirm));
        } else {
            Assert.assertTrue((String)"The part is not dirty, the save operation should have complete successfully", (boolean)partService.savePart(saveablePart, confirm));
        }
        Assert.assertEquals((Object)(beforeDirty && throwException ? 1 : 0), (Object)saveablePart.isDirty());
        Assert.assertEquals((Object)beforeDirty, (Object)editor.wasSaveCalled());
    }

    @Test
    public void testSavePart_NoHandler_TTT() {
        this.testSavePart_NoHandler(true, true, true);
    }

    @Test
    public void testSavePart_NoHandler_TTF() {
        this.testSavePart_NoHandler(true, true, false);
    }

    @Test
    public void testSavePart_NoHandler_TFT() {
        this.testSavePart_NoHandler(true, false, true);
    }

    @Test
    public void testSavePart_NoHandler_TFF() {
        this.testSavePart_NoHandler(true, false, false);
    }

    @Test
    public void testSavePart_NoHandler_FTT() {
        this.testSavePart_NoHandler(false, true, true);
    }

    @Test
    public void testSavePart_NoHandler_FTF() {
        this.testSavePart_NoHandler(false, true, false);
    }

    @Test
    public void testSavePart_NoHandler_FFT() {
        this.testSavePart_NoHandler(false, false, true);
    }

    @Test
    public void testSavePart_NoHandler_FFF() {
        this.testSavePart_NoHandler(false, false, false);
    }

    private MPart createSaveablePart(MElementContainer<MWindowElement> container, boolean beforeDirty) {
        MPart saveablePart = (MPart)this.ems.createModelElement(MPart.class);
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        container.getChildren().add(saveablePart);
        return saveablePart;
    }

    private ISaveHandler.Save prompt(ISaveHandler.Save[] candidates, MPart partToTest, MPart part) {
        return partToTest == part ? candidates[0] : candidates[1];
    }

    private void testSaveAll(final ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] afterDirty, boolean success, boolean[] saveCalled, boolean[] throwException) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        final MPart saveablePart = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[0]);
        MPart saveablePart2 = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[1]);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException[0]);
        ClientEditor editor2 = (ClientEditor)saveablePart2.getObject();
        editor2.setThrowException(throwException[1]);
        window.getContext().set(ISaveHandler.class.getName(), (Object)new PartServiceSaveHandler(){

            public ISaveHandler.Save[] promptToSave(Collection<MPart> saveableParts) {
                int index = 0;
                ISaveHandler.Save[] prompt = new ISaveHandler.Save[saveableParts.size()];
                Iterator<MPart> it = saveableParts.iterator();
                while (it.hasNext()) {
                    prompt[index] = EPartServiceTest.this.prompt(returnValues, it.next(), saveablePart);
                    ++index;
                }
                return prompt;
            }

            public ISaveHandler.Save promptToSave(MPart saveablePart2) {
                return null;
            }
        });
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)success, (Object)partService.saveAll(confirm));
        Assert.assertEquals((Object)afterDirty[0], (Object)saveablePart.isDirty());
        Assert.assertEquals((Object)saveCalled[0], (Object)editor.wasSaveCalled());
        Assert.assertEquals((Object)afterDirty[1], (Object)saveablePart2.isDirty());
        Assert.assertEquals((Object)saveCalled[1], (Object)editor2.wasSaveCalled());
    }

    private boolean hasCancel(ISaveHandler.Save[] returnValues, boolean[] beforeDirty) {
        int i = 0;
        while (i < returnValues.length) {
            if (returnValues[i] == ISaveHandler.Save.CANCEL && beforeDirty[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSuccessful(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (confirm) {
            if (returnValues[0] == ISaveHandler.Save.YES) {
                if (returnValues[1] == ISaveHandler.Save.YES) {
                    if (beforeDirty[0]) {
                        if (beforeDirty[1]) {
                            return !throwException[0] && !throwException[1];
                        }
                        return !throwException[0];
                    }
                    if (beforeDirty[1]) {
                        return !throwException[1];
                    }
                    return true;
                }
                if (beforeDirty[0]) {
                    return !throwException[0];
                }
                return true;
            }
            if (returnValues[1] == ISaveHandler.Save.YES && beforeDirty[1]) {
                return !throwException[1];
            }
            return true;
        }
        return this.isSuccessful(beforeDirty, throwException);
    }

    private boolean isSuccessful(boolean[] beforeDirty, boolean[] throwException) {
        if (beforeDirty[0]) {
            if (beforeDirty[1]) {
                return !throwException[0] && !throwException[1];
            }
            return !throwException[0];
        }
        if (beforeDirty[1]) {
            return !throwException[1];
        }
        return true;
    }

    private boolean[] afterDirty(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (confirm) {
            if (returnValues[0] == ISaveHandler.Save.YES) {
                if (returnValues[1] == ISaveHandler.Save.YES) {
                    if (beforeDirty[0]) {
                        boolean[] blArray = new boolean[2];
                        blArray[0] = throwException[0];
                        blArray[1] = beforeDirty[1] ? throwException[0] || throwException[1] : false;
                        return blArray;
                    }
                    return new boolean[]{beforeDirty[0], beforeDirty[1] ? throwException[1] : false};
                }
                return new boolean[]{beforeDirty[0] ? throwException[0] : false, beforeDirty[1]};
            }
            if (returnValues[1] == ISaveHandler.Save.YES) {
                return new boolean[]{beforeDirty[0], beforeDirty[1] ? throwException[1] : false};
            }
            return beforeDirty;
        }
        return this.afterDirty(beforeDirty, throwException);
    }

    private boolean[] afterDirty(boolean[] beforeDirty, boolean[] throwException) {
        if (beforeDirty[0]) {
            if (beforeDirty[1]) {
                return new boolean[]{throwException[0], throwException[0] || throwException[1]};
            }
            boolean[] blArray = new boolean[2];
            blArray[0] = throwException[0];
            return blArray;
        }
        if (beforeDirty[1]) {
            boolean[] blArray = new boolean[2];
            blArray[1] = throwException[1];
            return blArray;
        }
        return new boolean[2];
    }

    private boolean[] saveCalled(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (confirm) {
            if (returnValues[0] == ISaveHandler.Save.YES) {
                if (returnValues[1] == ISaveHandler.Save.YES) {
                    if (beforeDirty[0]) {
                        return new boolean[]{true, !throwException[0] && beforeDirty[1]};
                    }
                    return beforeDirty;
                }
                boolean[] blArray = new boolean[2];
                blArray[0] = beforeDirty[0];
                return blArray;
            }
            if (returnValues[1] == ISaveHandler.Save.YES) {
                boolean[] blArray = new boolean[2];
                blArray[1] = beforeDirty[1];
                return blArray;
            }
            return new boolean[2];
        }
        return this.saveCalled(beforeDirty, throwException);
    }

    private boolean[] saveCalled(boolean[] beforeDirty, boolean[] throwException) {
        boolean[] blArray = new boolean[2];
        blArray[0] = beforeDirty[0];
        blArray[1] = beforeDirty[0] ? !throwException[0] && beforeDirty[1] : beforeDirty[1];
        return blArray;
    }

    private void testSaveAll(ISaveHandler.Save[] returnValues, boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        if (this.hasCancel(returnValues, beforeDirty) && confirm) {
            this.testSaveAll(returnValues, confirm, beforeDirty, beforeDirty, false, new boolean[2], throwException);
        } else {
            this.testSaveAll(returnValues, confirm, beforeDirty, this.afterDirty(returnValues, confirm, beforeDirty, throwException), this.isSuccessful(returnValues, confirm, beforeDirty, throwException), this.saveCalled(returnValues, confirm, beforeDirty, throwException), throwException);
        }
    }

    @Test
    public void testSaveAll_YY_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YY_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YY_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_YY_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YY_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YY_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_YY_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YY_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YY_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_YY_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YY_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YY_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YY_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YY_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_YN_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YN_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YN_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_YN_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YN_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YN_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_YN_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YN_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YN_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_YN_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YN_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YN_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YN_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YN_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_YC_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YC_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YC_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_YC_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YC_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YC_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_YC_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YC_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_YC_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_YC_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_YC_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_YC_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YC_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_YC_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.YES, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NY_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NY_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NY_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NY_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NY_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NY_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NY_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NY_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NY_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NY_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NY_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NY_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NY_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NY_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NN_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NN_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NN_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NN_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NN_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NN_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NN_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NN_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NN_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NN_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NN_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NN_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NN_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NN_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NC_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NC_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NC_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NC_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NC_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NC_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NC_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NC_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NC_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NC_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NC_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NC_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NC_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NC_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.NO, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_CY_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CY_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CY_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_CY_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CY_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CY_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_CY_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CY_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CY_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_CY_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CY_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CY_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CY_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CY_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.YES}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_CN_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CN_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CN_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_CN_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CN_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CN_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_CN_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CN_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CN_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_CN_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CN_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CN_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CN_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CN_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.NO}, false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_CC_True_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_True_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CC_True_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CC_True_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_True_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_True_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_True_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_CC_True_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_True_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_True_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_True_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_True_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CC_True_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CC_True_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_CC_False_TT_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_False_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CC_False_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_CC_False_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_False_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_False_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_False_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_CC_False_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_False_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_False_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_CC_False_FF_TT() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_CC_False_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CC_False_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_CC_False_FF_FF() {
        this.testSaveAll(new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL, ISaveHandler.Save.CANCEL}, false, new boolean[2], new boolean[2]);
    }

    private void testSaveAll_NoHandler(boolean beforeDirty, boolean throwException, boolean confirm) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPart saveablePart = (MPart)this.ems.createModelElement(MPart.class);
        saveablePart.setDirty(beforeDirty);
        saveablePart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getChildren().add(saveablePart);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException);
        this.applicationContext.set(ISaveHandler.class.getName(), null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        if (beforeDirty) {
            Assert.assertEquals((Object)(!throwException ? 1 : 0), (Object)partService.saveAll(confirm));
        } else {
            Assert.assertTrue((String)"The part is not dirty, the save operation should have complete successfully", (boolean)partService.saveAll(confirm));
        }
        Assert.assertEquals((Object)(beforeDirty && throwException ? 1 : 0), (Object)saveablePart.isDirty());
        Assert.assertEquals((Object)beforeDirty, (Object)editor.wasSaveCalled());
    }

    @Test
    public void testSaveAll_NoHandler_TTT() {
        this.testSaveAll_NoHandler(true, true, true);
    }

    @Test
    public void testSaveAll_NoHandler_TTF() {
        this.testSaveAll_NoHandler(true, true, false);
    }

    @Test
    public void testSaveAll_NoHandler_TFT() {
        this.testSaveAll_NoHandler(true, false, true);
    }

    @Test
    public void testSaveAll_NoHandler_TFF() {
        this.testSaveAll_NoHandler(true, false, false);
    }

    @Test
    public void testSaveAll_NoHandler_FTT() {
        this.testSaveAll_NoHandler(false, true, true);
    }

    @Test
    public void testSaveAll_NoHandler_FTF() {
        this.testSaveAll_NoHandler(false, true, false);
    }

    @Test
    public void testSaveAll_NoHandler_FFT() {
        this.testSaveAll_NoHandler(false, false, true);
    }

    @Test
    public void testSaveAll_NoHandler_FFF() {
        this.testSaveAll_NoHandler(false, false, false);
    }

    private void testSaveAll_NoHandlers(boolean confirm, boolean[] beforeDirty, boolean[] afterDirty, boolean success, boolean[] saveCalled, boolean[] throwException) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPart saveablePart = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[0]);
        MPart saveablePart2 = this.createSaveablePart((MElementContainer<MWindowElement>)window, beforeDirty[1]);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ClientEditor editor = (ClientEditor)saveablePart.getObject();
        editor.setThrowException(throwException[0]);
        ClientEditor editor2 = (ClientEditor)saveablePart2.getObject();
        editor2.setThrowException(throwException[1]);
        window.getContext().set(ISaveHandler.class.getName(), null);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        Assert.assertEquals((Object)success, (Object)partService.saveAll(confirm));
        Assert.assertEquals((Object)afterDirty[0], (Object)saveablePart.isDirty());
        Assert.assertEquals((Object)saveCalled[0], (Object)editor.wasSaveCalled());
        Assert.assertEquals((Object)afterDirty[1], (Object)saveablePart2.isDirty());
        Assert.assertEquals((Object)saveCalled[1], (Object)editor2.wasSaveCalled());
    }

    private void testSaveAll_NoHandlers(boolean confirm, boolean[] beforeDirty, boolean[] throwException) {
        this.testSaveAll_NoHandlers(confirm, beforeDirty, this.afterDirty(beforeDirty, throwException), this.isSuccessful(beforeDirty, throwException), this.saveCalled(beforeDirty, throwException), throwException);
    }

    @Test
    public void testSaveAll_NoHandlers_T_TT_TT() {
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_T_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_T_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_T_TT_FF() {
        this.testSaveAll_NoHandlers(true, new boolean[]{true, true}, new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_T_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_T_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_T_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_T_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_T_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_T_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_T_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_T_FT_FF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_T_FF_TT() {
        this.testSaveAll_NoHandlers(true, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_T_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_T_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(true, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_T_FF_FF() {
        this.testSaveAll_NoHandlers(true, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_F_TT_TT() {
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_F_TT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_F_TT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_F_TT_FF() {
        this.testSaveAll_NoHandlers(false, new boolean[]{true, true}, new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_F_TF_TT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_F_TF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_F_TF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_F_TF_FF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_F_FT_TT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_F_FT_TF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_F_FT_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, blArray2);
    }

    @Test
    public void testSaveAll_NoHandlers_F_FT_FF() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, blArray, new boolean[2]);
    }

    @Test
    public void testSaveAll_NoHandlers_F_FF_TT() {
        this.testSaveAll_NoHandlers(false, new boolean[2], new boolean[]{true, true});
    }

    @Test
    public void testSaveAll_NoHandlers_F_FF_TF() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testSaveAll_NoHandlers(false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_F_FF_FT() {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.testSaveAll_NoHandlers(false, new boolean[2], blArray);
    }

    @Test
    public void testSaveAll_NoHandlers_F_FF_FF() {
        this.testSaveAll_NoHandlers(false, new boolean[2], new boolean[2]);
    }

    @Test
    public void testSwitchWindows() {
        MWindow window1 = (MWindow)this.ems.createModelElement(MWindow.class);
        MWindow window2 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window1);
        this.application.getChildren().add(window2);
        this.application.setSelectedElement((MUIElement)window1);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window1.getChildren().add(part);
        window1.setSelectedElement((MUIElement)part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService windowService1 = (EPartService)window1.getContext().get(EPartService.class);
        EPartService windowService2 = (EPartService)window2.getContext().get(EPartService.class);
        Assert.assertNotNull((Object)windowService1);
        Assert.assertNotNull((Object)windowService2);
        Assert.assertNotNull((String)"The first part is active in the first window", (Object)windowService1.getActivePart());
        Assert.assertNull((String)"There should be nothing active in the second window", (Object)windowService2.getActivePart());
        windowService1.activate(part);
        Assert.assertEquals((String)"The part should have been activated", (Object)part, (Object)windowService1.getActivePart());
        Assert.assertNull((String)"The second window has no parts, this should be null", (Object)windowService2.getActivePart());
        window2.getChildren().add(part);
        windowService2.activate(part);
        Assert.assertEquals((String)"No parts in this window, this should be null", null, (Object)windowService1.getActivePart());
        Assert.assertEquals((String)"We activated it just now, this should be active", (Object)part, (Object)windowService2.getActivePart());
    }

    @Test
    public void testApplicationContextHasActivePart() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.getChildren().add(partB);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Object o = this.applicationContext.get("e4ActivePart");
        Assert.assertEquals((Object)partA, (Object)o);
        partService.activate(partB);
        o = this.applicationContext.get("e4ActivePart");
        Assert.assertEquals((Object)partB, (Object)o);
    }

    private void testShowPart_Bug307747(EPartService.PartState partState) {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setCategory("category");
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.setElementId("category");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        MPart partB = partService.showPart("partId", partState);
        Assert.assertNotNull((String)"The part should have been rendered", (Object)partB.getContext());
    }

    @Test
    public void testShowPart_Bug307747_CREATE() {
        this.testShowPart_Bug307747(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Bug307747_VISIBLE() {
        this.testShowPart_Bug307747(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Bug307747_ACTIVATE() {
        this.testShowPart_Bug307747(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Bug328078(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partStack.getChildren().remove(partA);
        partService.showPart(partB, partState);
        Assert.assertEquals((Object)partB, (Object)partStack.getSelectedElement());
    }

    @Test
    public void testShowPart_Bug328078_CREATE() {
        this.testShowPart_Bug328078(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Bug328078_VISIBLE() {
        this.testShowPart_Bug328078(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Bug328078_ACTIVATE() {
        this.testShowPart_Bug328078(EPartService.PartState.ACTIVATE);
    }

    @Test
    public void testShowPart_Bug370026_CREATE() {
        this.testShowPart_Bug370026(EPartService.PartState.CREATE);
    }

    @Test
    public void testShowPart_Bug370026_VISIBLE() {
        this.testShowPart_Bug370026(EPartService.PartState.VISIBLE);
    }

    @Test
    public void testShowPart_Bug370026_ACTIVATE() {
        this.testShowPart_Bug370026(EPartService.PartState.ACTIVATE);
    }

    private void testShowPart_Bug370026(EPartService.PartState partState) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SimpleView");
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.TargetedView");
        window.getChildren().add(partB);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SimpleView");
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.applicationContext.set(EPartService.PartState.class, (Object)partState);
        this.applicationContext.set("org.eclipse.e4.ui.tests.targetedViewTarget", (Object)partC);
        this.getEngine().createGui((MUIElement)window);
        TargetedView view = (TargetedView)partB.getObject();
        Assert.assertTrue((boolean)view.passed);
    }

    private void testHidePart_Bug325148(boolean force) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setToBeRendered(false);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        placeholder.setToBeRendered(false);
        perspective.getChildren().add(placeholder);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(part, force);
        Assert.assertEquals((Object)force, (Object)(!perspective.getChildren().contains(placeholder) ? 1 : 0));
    }

    @Test
    public void testHidePart_Bug325148_True() {
        this.testHidePart_Bug325148(true);
    }

    @Test
    public void testHidePart_Bug325148_False() {
        this.testHidePart_Bug325148(false);
    }

    private void testHidePart_Bug325148_Unrendered(boolean force) {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("partId");
        partDescriptor.setCategory("category");
        this.application.getDescriptors().add(partDescriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.setElementId("category");
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setToBeRendered(false);
        stack.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(partB, force);
    }

    @Test
    public void testHidePart_Bug325148_Unrendered_True() {
        this.testHidePart_Bug325148_Unrendered(true);
    }

    @Test
    public void testHidePart_Bug325148_Unrendered_False() {
        this.testHidePart_Bug325148_Unrendered(false);
    }

    @Test
    public void testHidePart_Bug327026() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setToBeRendered(false);
        stack.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ((EPartService)window.getContext().get(EPartService.class)).hidePart(partA, true);
        Assert.assertNull((Object)stack.getSelectedElement());
    }

    private void testHidePart_Bug327044(boolean force) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(part);
        stack.setSelectedElement((MUIElement)part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ((EPartService)window.getContext().get(EPartService.class)).hidePart(part, force);
        Assert.assertNull((Object)stack.getSelectedElement());
    }

    @Test
    public void testHidePart_Bug327044_True() {
        this.testHidePart_Bug327044(true);
    }

    @Test
    public void testHidePart_Bug327044_False() {
        this.testHidePart_Bug327044(false);
    }

    private void testHidePart_Bug327765(boolean force) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setToBeRendered(false);
        placeholderB.setRef((MUIElement)part);
        perspectiveB.getChildren().add(placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(part);
        Assert.assertNotNull((Object)part.getContext());
        partService.switchPerspective(perspectiveB);
        Assert.assertNotNull((Object)part.getContext());
        partService.hidePart(part, force);
        Assert.assertNotNull((Object)part.getContext());
    }

    @Test
    public void testHidePart_Bug327765_True() {
        this.testHidePart_Bug327765(true);
    }

    @Test
    public void testHidePart_Bug327765_False() {
        this.testHidePart_Bug327765(false);
    }

    private void testHidePart_Bug327917(boolean force) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPlaceholder placeholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB1);
        partStackA.getChildren().add(placeholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partC.setCurSharedRef(placeholderC);
        placeholderC.setRef((MUIElement)partC);
        partStackB.getChildren().add(placeholderC);
        partStackB.setSelectedElement((MUIElement)placeholderC);
        MPlaceholder placeholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB2.setRef((MUIElement)partB);
        partStackB.getChildren().add(placeholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.switchPerspective(perspectiveB);
        partService.activate(partB);
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partC);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.hidePart(partB, force);
        Assert.assertFalse((boolean)placeholderB1.isToBeRendered());
    }

    @Test
    public void testHidePart_Bug327917_True() {
        this.testHidePart_Bug327917(true);
    }

    @Test
    public void testHidePart_Bug327917_False() {
        this.testHidePart_Bug327917(false);
    }

    private void testHidePart_Bug327964(boolean force) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder areaPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholder.setRef((MUIElement)area);
        part.setCurSharedRef(areaPlaceholder);
        perspective.getChildren().add(areaPlaceholder);
        perspective.setSelectedElement((MUIElement)areaPlaceholder);
        MPlaceholder partPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholder.setRef((MUIElement)part);
        part.setCurSharedRef(partPlaceholder);
        area.getChildren().add(partPlaceholder);
        area.setSelectedElement((MUIElement)partPlaceholder);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(part, force);
        Assert.assertFalse((boolean)partPlaceholder.isToBeRendered());
    }

    @Test
    public void testHidePart_Bug327964_True() {
        this.testHidePart_Bug327964(true);
    }

    @Test
    public void testHidePart_Bug327964_False() {
        this.testHidePart_Bug327964(false);
    }

    private void testHidePart_Bug332163(boolean force) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective1 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective1);
        perspectiveStack.setSelectedElement((MUIElement)perspective1);
        MPlaceholder partPlaceholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA1.setRef((MUIElement)part);
        part.setCurSharedRef(partPlaceholderA1);
        perspective1.getChildren().add(partPlaceholderA1);
        perspective1.setSelectedElement((MUIElement)partPlaceholderA1);
        MPerspective perspective2 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective2);
        MPlaceholder partPlaceholder2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholder2.setRef((MUIElement)part);
        perspective2.getChildren().add(partPlaceholder2);
        perspective2.setSelectedElement((MUIElement)partPlaceholder2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext perspectiveContext1 = perspective1.getContext();
        IEclipseContext partContext = part.getContext();
        Assert.assertEquals((Object)perspectiveContext1, (Object)partContext.getParent());
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspective2);
        IEclipseContext perspectiveContext2 = perspective2.getContext();
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        Assert.assertEquals((Object)perspectiveContext2, (Object)partContext.getParent());
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext2.getActiveChild());
        partService.hidePart(part, force);
        Assert.assertEquals((Object)perspectiveContext1, (Object)partContext.getParent());
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        Assert.assertNull((String)"perspective2 doesn't have any parts, it should not have an active child context", (Object)perspectiveContext2.getActiveChild());
    }

    @Test
    public void testHidePart_Bug332163_True() {
        this.testHidePart_Bug332163(true);
    }

    @Test
    public void testHidePart_Bug332163_False() {
        this.testHidePart_Bug332163(false);
    }

    @Test
    public void testHidePart_ActivationHistory01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB1);
        stackB.setSelectedElement((MUIElement)partB1);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB2);
        MPart partB3 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB3);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB2);
        partService.activate(partB3);
        partService.activate(partA);
        partService.hidePart(partB3);
        Assert.assertEquals((Object)partB2, (Object)stackB.getSelectedElement());
    }

    @Test
    public void testHidePart_ActivationHistory02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB);
        stackB.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB);
        stackB.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory04() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partB, (Object)stack.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertNull((Object)stack.getSelectedElement());
        Assert.assertNull((Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory05() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partB, (Object)stack.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertNull((Object)stack.getSelectedElement());
        Assert.assertNull((Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory06() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stack);
        perspective.setSelectedElement((MUIElement)stack);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partA.setCurSharedRef(placeholderA);
        placeholderA.setRef((MUIElement)partA);
        stack.getChildren().add(placeholderA);
        stack.setSelectedElement((MUIElement)placeholderA);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partB.setCurSharedRef(placeholderB);
        placeholderB.setRef((MUIElement)partB);
        stack.getChildren().add(placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)placeholderB, (Object)stack.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertNull((Object)stack.getSelectedElement());
        Assert.assertNull((Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory07() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stack);
        perspective.setSelectedElement((MUIElement)stack);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partA.setCurSharedRef(placeholderA);
        placeholderA.setRef((MUIElement)partA);
        stack.getChildren().add(placeholderA);
        stack.setSelectedElement((MUIElement)placeholderA);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partB.setCurSharedRef(placeholderB);
        placeholderB.setRef((MUIElement)partB);
        stack.getChildren().add(placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)placeholderB, (Object)stack.getSelectedElement());
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertNull((Object)stack.getSelectedElement());
        Assert.assertNull((Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory08() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackA);
        perspective.setSelectedElement((MUIElement)stackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPlaceholder areaPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholder.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholder);
        perspective.getChildren().add(areaPlaceholder);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(stackB);
        area.setSelectedElement((MUIElement)stackB);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB1);
        stackB.setSelectedElement((MUIElement)partB1);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB2);
        MPart partB3 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB3);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB1);
        partService.activate(partB2);
        partService.activate(partA);
        partService.activate(partB3);
        partService.hidePart(partB3);
        Assert.assertEquals((Object)partB2, (Object)stackB.getSelectedElement());
        Assert.assertEquals((Object)partB2, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory09() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackA);
        perspective.setSelectedElement((MUIElement)stackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPlaceholder areaPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholder.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholder);
        perspective.getChildren().add(areaPlaceholder);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(stackB);
        area.setSelectedElement((MUIElement)stackB);
        MPartStack stackC = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(stackC);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB);
        stackB.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        stackC.getChildren().add(partC);
        stackC.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partA);
        partService.activate(partB);
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory10() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackB);
        MPartStack stackC = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackC);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB);
        stackB.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        stackC.getChildren().add(partC);
        stackC.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.hidePart(partA);
        MPart activePart = partService.getActivePart();
        if (activePart == partB) {
            partService.hidePart(partB);
            Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
        } else if (activePart == partC) {
            partService.hidePart(partC);
            Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        } else if (activePart == partA) {
            Assert.fail((String)"Part A should have been deactivated");
        } else {
            Assert.fail((String)"Another part should have been activated");
        }
    }

    @Test
    public void testHidePart_ActivationHistory11() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackA);
        perspective.setSelectedElement((MUIElement)stackA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        stackA.getChildren().add(placeholderA);
        stackA.setSelectedElement((MUIElement)placeholderA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        stackB.getChildren().add(placeholderB);
        stackB.setSelectedElement((MUIElement)placeholderB);
        MPartStack stackC = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackC);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        stackC.getChildren().add(placeholderC);
        stackC.setSelectedElement((MUIElement)placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partA);
        partService.hidePart(partA);
        MPart activePart = partService.getActivePart();
        if (activePart == partB) {
            partService.hidePart(partB);
            Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
        } else if (activePart == partC) {
            partService.hidePart(partC);
            Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        } else if (activePart == partA) {
            Assert.fail((String)"Part A should have been deactivated");
        } else {
            Assert.fail((String)"Another part should have been activated");
        }
    }

    @Test
    public void testHidePart_ActivationHistory12() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackA);
        perspective.setSelectedElement((MUIElement)stackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPlaceholder areaPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholder.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholder);
        perspective.getChildren().add(areaPlaceholder);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(stackB);
        area.setSelectedElement((MUIElement)stackB);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB1);
        stackB.setSelectedElement((MUIElement)partB1);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB1);
        partService.activate(partB2);
        partService.hidePart(partB2);
        Assert.assertEquals((Object)partB1, (Object)stackB.getSelectedElement());
        Assert.assertEquals((Object)partB1, (Object)partService.getActivePart());
        partService.hidePart(partB1);
        Assert.assertNull((Object)stackB.getSelectedElement());
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory13() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB2);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(stackA);
        perspective.setSelectedElement((MUIElement)stackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPlaceholder areaPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholder.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholder);
        perspective.getChildren().add(areaPlaceholder);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(stackB);
        area.setSelectedElement((MUIElement)stackB);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB1);
        stackB.setSelectedElement((MUIElement)partB1);
        MPlaceholder placeholderPartB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderPartB2.setRef((MUIElement)partB2);
        partB2.setCurSharedRef(placeholderPartB2);
        stackB.getChildren().add(placeholderPartB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB1);
        partService.activate(partB2);
        partService.hidePart(partB2);
        Assert.assertEquals((Object)partB1, (Object)stackB.getSelectedElement());
        Assert.assertEquals((Object)partB1, (Object)partService.getActivePart());
        partService.hidePart(partB1);
        Assert.assertNull((Object)stackB.getSelectedElement());
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory14() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderC1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC1.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC1);
        perspectiveA.getChildren().add(placeholderC1);
        perspectiveA.setSelectedElement((MUIElement)placeholderC1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA2);
        perspectiveB.getChildren().add(placeholderA2);
        perspectiveB.setSelectedElement((MUIElement)placeholderA2);
        MPlaceholder placeholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB2.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB2);
        perspectiveB.getChildren().add(placeholderB2);
        MPlaceholder placeholderC2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC2.setRef((MUIElement)partC);
        perspectiveB.getChildren().add(placeholderC2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partC);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        partService.activate(partA);
        partService.activate(partB);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        perspectiveA.getContext().activate();
        partService.activate(partC);
        partService.hidePart(partC);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory15() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPart sharedPart = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(sharedPart);
        area.getChildren().add(sharedPart);
        area.setSelectedElement((MUIElement)sharedPart);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder areaPlaceholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholderA.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholderA);
        perspectiveA.getChildren().add(areaPlaceholderA);
        perspectiveA.setSelectedElement((MUIElement)areaPlaceholderA);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(stackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder areaPlaceholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholderB.setRef((MUIElement)area);
        perspectiveB.getChildren().add(areaPlaceholderB);
        perspectiveB.setSelectedElement((MUIElement)areaPlaceholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(sharedPart);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        Assert.assertEquals((Object)sharedPart, (Object)partService.getActivePart());
        partService.hidePart(sharedPart);
        Assert.assertNull((Object)partService.getActivePart());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory16A() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder partPlaceholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(partPlaceholderA1);
        perspectiveA.getChildren().add(partPlaceholderA1);
        perspectiveA.setSelectedElement((MUIElement)partPlaceholderA1);
        MPlaceholder partPlaceholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(partPlaceholderB1);
        perspectiveA.getChildren().add(partPlaceholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder partPlaceholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(partPlaceholderA2);
        perspectiveB.setSelectedElement((MUIElement)partPlaceholderA2);
        MPlaceholder partPlaceholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB2.setRef((MUIElement)partB);
        perspectiveB.getChildren().add(partPlaceholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partB is in both perspectives, active part should have been preserved", (Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((String)"Hiding partB should have caused partA to be activated", (Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((String)"partA is in both perspectives, active part should have been preserved", (Object)partA, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((String)"partB should have been activated by activate(MPart)", (Object)partB, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partA should be the only part that's being shown in perspectiveB, thus, it should be the active part", (Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory16B() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder partPlaceholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(partPlaceholderB1);
        perspectiveA.getChildren().add(partPlaceholderB1);
        perspectiveA.setSelectedElement((MUIElement)partPlaceholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder partPlaceholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(partPlaceholderA2);
        perspectiveB.setSelectedElement((MUIElement)partPlaceholderA2);
        MPlaceholder partPlaceholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB2.setRef((MUIElement)partB);
        perspectiveB.getChildren().add(partPlaceholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partB is in both perspectives, active part should have been preserved", (Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((String)"Hiding partB should have caused partA to be activated", (Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((String)"partB is the only part in perspectiveA, thus, it should be the active part", (Object)partB, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partA should be the only part that's being shown in perspectiveB, thus, it should be the active part", (Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory16C() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder partPlaceholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(partPlaceholderA1);
        partStackA.getChildren().add(partPlaceholderA1);
        partStackA.setSelectedElement((MUIElement)partPlaceholderA1);
        MPlaceholder partPlaceholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(partPlaceholderB1);
        partStackA.getChildren().add(partPlaceholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder partPlaceholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA2.setRef((MUIElement)partA);
        partStackB.getChildren().add(partPlaceholderA2);
        partStackB.setSelectedElement((MUIElement)partPlaceholderA2);
        MPlaceholder partPlaceholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB2.setRef((MUIElement)partB);
        partStackB.getChildren().add(partPlaceholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        Assert.assertEquals((String)"partB should be the active part", (Object)partB, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        partService.hidePart(partB);
        Assert.assertEquals((String)"partA should still be the active part", (Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((String)"partA is in both perspectives, but since partA is obscured by partB, partB should be the active part", (Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((String)"partB should have been activated by activate(MPart)", (Object)partB, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partA should be the only part that's being shown in perspectiveB, thus, it should be the active part", (Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory16D() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder partPlaceholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(partPlaceholderB1);
        partStackA.getChildren().add(partPlaceholderB1);
        partStackA.setSelectedElement((MUIElement)partPlaceholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder partPlaceholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA2.setRef((MUIElement)partA);
        partStackB.getChildren().add(partPlaceholderA2);
        partStackB.setSelectedElement((MUIElement)partPlaceholderA2);
        MPlaceholder partPlaceholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB2.setRef((MUIElement)partB);
        partStackB.getChildren().add(partPlaceholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partB is in both perspectives, but since partB is obscured by partA, partA should be the active part", (Object)partA, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((String)"partA should still be the active part", (Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((String)"partB is the only part in perspectiveA, thus, it should be the active part", (Object)partB, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((String)"partA should be the only part that's being shown in perspectiveB, thus, it should be the active part", (Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory17() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        Assert.assertNull((Object)partB.getObject());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory18() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        partStack.getChildren().add(placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        partStack.getChildren().add(placeholderC);
        partStack.setSelectedElement((MUIElement)placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        Assert.assertNull((Object)partB.getObject());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory19() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partD);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderD1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderD1.setRef((MUIElement)partD);
        partD.setCurSharedRef(placeholderD1);
        perspectiveA.getChildren().add(placeholderD1);
        perspectiveA.setSelectedElement((MUIElement)placeholderD1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partA);
        perspectiveB.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        MPlaceholder placeholderD2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderD2.setRef((MUIElement)partD);
        partStack.getChildren().add(placeholderD2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partD);
        partService.switchPerspective(perspectiveB);
        partService.activate(partB);
        partService.switchPerspective(perspectiveA);
        partService.hidePart(partD);
        partService.switchPerspective(perspectiveB);
        partService.hidePart(partB);
        Assert.assertEquals((Object)placeholderD2, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory20() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory21() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getChildren().add(area);
        window.setSelectedElement((MUIElement)area);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        area.getChildren().add(partA);
        area.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory22() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA1);
        perspectiveA.getChildren().add(placeholderA1);
        perspectiveA.setSelectedElement((MUIElement)placeholderA1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStack.setToBeRendered(false);
        perspectiveB.getChildren().add(partStack);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setRef((MUIElement)partA);
        partStack.getChildren().add(placeholderA2);
        partStack.setSelectedElement((MUIElement)placeholderA2);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        perspectiveB.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory23() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA1);
        perspectiveA.getChildren().add(placeholderA1);
        perspectiveA.setSelectedElement((MUIElement)placeholderA1);
        MPlaceholder placeholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB1);
        perspectiveA.getChildren().add(placeholderB1);
        MPlaceholder placeholderC1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC1.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC1);
        perspectiveA.getChildren().add(placeholderC1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(placeholderA2);
        perspectiveB.setSelectedElement((MUIElement)placeholderA2);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStack);
        MPlaceholder placeholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB2.setRef((MUIElement)partB);
        partStack.getChildren().add(placeholderB2);
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partStack.setSelectedElement((MUIElement)partD);
        MPlaceholder placeholderC2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC2.setRef((MUIElement)partC);
        perspectiveB.getChildren().add(placeholderC2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partC);
        partService.activate(partB);
        partService.activate(partA);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.hidePart(partA);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory24() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partStack.setToBeRendered(false);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug327952_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partB);
        detachedWindow.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.activate(partA);
        partService.activate(partB);
        partService.hidePart(partB);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug327952_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        detachedWindow.getChildren().add(partB);
        detachedWindow.setSelectedElement((MUIElement)partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.hidePart(partB);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug327952_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        detachedWindow.getChildren().add(area);
        detachedWindow.setSelectedElement((MUIElement)area);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        area.getChildren().add(partB);
        area.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        area.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.activate(partA);
        partService.activate(partB);
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug327952_04() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        detachedWindow.getChildren().add(area);
        detachedWindow.setSelectedElement((MUIElement)area);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        area.getChildren().add(partB);
        area.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        area.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.activate(partA);
        partService.activate(partB);
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(partStack);
        detachedWindow.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(partStack);
        detachedWindow.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        partStack.getChildren().add(placeholderB);
        partStack.setSelectedElement((MUIElement)placeholderB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(partStack);
        detachedWindow.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        partStack.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_04() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(partStack);
        detachedWindow.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        partStack.getChildren().add(placeholderB);
        partStack.setSelectedElement((MUIElement)placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        partStack.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_05() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_06() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        partStack.getChildren().add(placeholderB);
        partStack.setSelectedElement((MUIElement)placeholderB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_07() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        partStack.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328339_08() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        partStack.getChildren().add(placeholderB);
        partStack.setSelectedElement((MUIElement)placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        partStack.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partC);
        partService.hidePart(partC);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveA.getChildren().add(partA);
        perspectiveA.setSelectedElement((MUIElement)partA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partB);
        perspectiveB.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partB);
        perspectiveB.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveA.getChildren().add(partA);
        perspectiveA.setSelectedElement((MUIElement)partA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_04() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveA.getChildren().add(partA);
        perspectiveA.setSelectedElement((MUIElement)partA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partB);
        perspectiveB.setSelectedElement((MUIElement)partB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        perspectiveB.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_05() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_06() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partB);
        perspectiveB.setSelectedElement((MUIElement)partB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        perspectiveB.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_07() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveA.getChildren().add(partA);
        perspectiveA.setSelectedElement((MUIElement)partA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        perspectiveB.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_08() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        perspectiveB.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_09() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA1);
        perspectiveA.getChildren().add(placeholderA1);
        perspectiveA.setSelectedElement((MUIElement)placeholderA1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setToBeRendered(false);
        placeholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(placeholderA2);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        perspectiveB.getChildren().add(placeholderC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug328946_10() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partC);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA1);
        perspectiveA.getChildren().add(placeholderA1);
        perspectiveA.setSelectedElement((MUIElement)placeholderA1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholderB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStack);
        MPlaceholder placeholderC = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderC.setRef((MUIElement)partC);
        partC.setCurSharedRef(placeholderC);
        partStack.getChildren().add(placeholderC);
        partStack.setSelectedElement((MUIElement)placeholderC);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setRef((MUIElement)partA);
        partStack.getChildren().add(placeholderA2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
        partService.hidePart(partB);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug329482_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(partSashContainer);
        window.setSelectedElement((MUIElement)partSashContainer);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.getChildren().add(partA);
        partSashContainer.setSelectedElement((MUIElement)partA);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        partSashContainer.getChildren().add(area);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(partStack);
        area.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partService.showPart(partD, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)partD, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
        partService.hidePart(partD);
        Assert.assertEquals((Object)partC, (Object)partStack.getSelectedElement());
        Assert.assertEquals((String)"The active part should have remained in the area", (Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug329482_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(partSashContainer);
        window.setSelectedElement((MUIElement)partSashContainer);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.getChildren().add(partA);
        partSashContainer.setSelectedElement((MUIElement)partA);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        partSashContainer.getChildren().add(area);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(partStack);
        area.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partService.showPart(partD, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)partD, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
        partService.hidePart(partD);
        Assert.assertEquals((Object)partC, (Object)partStack.getSelectedElement());
        Assert.assertEquals((String)"The active part should have remained in the area", (Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug329482_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA1);
        perspectiveA.getChildren().add(placeholderA1);
        perspectiveA.setSelectedElement((MUIElement)placeholderA1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        perspectiveB.getChildren().add(partSashContainer);
        perspectiveB.setSelectedElement((MUIElement)partSashContainer);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(placeholderA2);
        perspectiveB.setSelectedElement((MUIElement)placeholderA2);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        partSashContainer.getChildren().add(area);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(partStack);
        area.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partService.showPart(partD, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)partD, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
        partService.hidePart(partD);
        Assert.assertEquals((Object)partC, (Object)partStack.getSelectedElement());
        Assert.assertEquals((String)"The active part should have remained in the area", (Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug329482_04() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(partSashContainer);
        window.setSelectedElement((MUIElement)partSashContainer);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.getChildren().add(partA);
        partSashContainer.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partSashContainer.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partService.showPart(partD, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)partD, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
        partService.hidePart(partD);
        Assert.assertEquals((Object)partC, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug329482_05() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(partSashContainer);
        window.setSelectedElement((MUIElement)partSashContainer);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partSashContainer.getChildren().add(partA);
        partSashContainer.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partSashContainer.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partService.showPart(partD, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)partD, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
        partService.hidePart(partD);
        Assert.assertEquals((Object)partC, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testHidePart_ActivationHistory_Bug329482_06() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA1);
        perspectiveA.getChildren().add(placeholderA1);
        perspectiveA.setSelectedElement((MUIElement)placeholderA1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        perspectiveB.getChildren().add(partSashContainer);
        perspectiveB.setSelectedElement((MUIElement)partSashContainer);
        MPlaceholder placeholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(placeholderA2);
        perspectiveB.setSelectedElement((MUIElement)placeholderA2);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partSashContainer.getChildren().add(partStack);
        partSashContainer.setSelectedElement((MUIElement)partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partD);
        partService.showPart(partD, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((Object)partD, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partD, (Object)partService.getActivePart());
        partService.hidePart(partD);
        Assert.assertEquals((Object)partC, (Object)partStack.getSelectedElement());
        Assert.assertEquals((Object)partA, (Object)partService.getActivePart());
    }

    @Test
    public void testActivationHistory01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder partPlaceholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(partPlaceholderA1);
        perspectiveA.getChildren().add(partPlaceholderA1);
        perspectiveA.setSelectedElement((MUIElement)partPlaceholderA1);
        MPlaceholder partPlaceholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(partPlaceholderB1);
        perspectiveA.getChildren().add(partPlaceholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder partPlaceholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(partPlaceholderA2);
        perspectiveB.setSelectedElement((MUIElement)partPlaceholderA2);
        MPlaceholder partPlaceholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB2.setRef((MUIElement)partB);
        perspectiveB.getChildren().add(partPlaceholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)partB, (Object)partService.getActivePart());
    }

    @Test
    public void testSwitchPerspective01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext perspectiveContextA = perspectiveA.getContext();
        Assert.assertEquals((Object)perspectiveContextA, (Object)windowContext.getActiveChild());
        ((EPartService)window.getContext().get(EPartService.class)).switchPerspective(perspectiveB);
        IEclipseContext perspectiveContextB = perspectiveB.getContext();
        Assert.assertEquals((Object)perspectiveContextB, (Object)windowContext.getActiveChild());
    }

    @Test
    public void testSwitchPerspective02() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MPerspectiveStack perspectiveStackA = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        windowA.getChildren().add(perspectiveStackA);
        windowA.setSelectedElement((MUIElement)perspectiveStackA);
        MPerspective perspectiveA1 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStackA.getChildren().add(perspectiveA1);
        perspectiveStackA.setSelectedElement((MUIElement)perspectiveA1);
        MPerspective perspectiveA2 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStackA.getChildren().add(perspectiveA2);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        MPerspectiveStack perspectiveStackB = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        windowB.getChildren().add(perspectiveStackB);
        windowB.setSelectedElement((MUIElement)perspectiveStackB);
        MPerspective perspectiveB1 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStackB.getChildren().add(perspectiveB1);
        perspectiveStackB.setSelectedElement((MUIElement)perspectiveB1);
        MPerspective perspectiveB2 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStackB.getChildren().add(perspectiveB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService windowPartServiceA = (EPartService)windowA.getContext().get(EPartService.class);
        EPartService windowPartServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        Assert.assertEquals((Object)windowA.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveA1.getContext(), (Object)windowA.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB1.getContext(), (Object)windowB.getContext().getActiveChild());
        windowPartServiceB.switchPerspective(perspectiveA2);
        Assert.assertEquals((Object)windowA.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveA1.getContext(), (Object)windowA.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB1.getContext(), (Object)windowB.getContext().getActiveChild());
        windowPartServiceA.switchPerspective(perspectiveA2);
        Assert.assertEquals((Object)windowA.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveA2.getContext(), (Object)windowA.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB1.getContext(), (Object)windowB.getContext().getActiveChild());
        windowPartServiceB.switchPerspective(perspectiveB2);
        Assert.assertEquals((Object)windowA.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveA2.getContext(), (Object)windowA.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB2.getContext(), (Object)windowB.getContext().getActiveChild());
    }

    @Test
    public void testSwitchPerspective03() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        MPerspectiveStack perspectiveStackB = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        windowB.getChildren().add(perspectiveStackB);
        windowB.setSelectedElement((MUIElement)perspectiveStackB);
        MPerspective perspectiveB1 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStackB.getChildren().add(perspectiveB1);
        perspectiveStackB.setSelectedElement((MUIElement)perspectiveB1);
        MPart partB1 = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB1.getChildren().add(partB1);
        perspectiveB1.setSelectedElement((MUIElement)partB1);
        MPerspective perspectiveB2 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStackB.getChildren().add(perspectiveB2);
        MPart partB2 = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB2.getChildren().add(partB2);
        perspectiveB2.setSelectedElement((MUIElement)partB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)windowA);
        this.getEngine().createGui((MUIElement)windowB);
        EPartService windowPartServiceB = (EPartService)windowB.getContext().get(EPartService.class);
        Assert.assertEquals((Object)windowB.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB1.getContext(), (Object)windowB.getContext().getActiveChild());
        windowPartServiceB.switchPerspective(perspectiveB2);
        Assert.assertEquals((Object)windowB.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB2.getContext(), (Object)windowB.getContext().getActiveChild());
    }

    @Test
    public void testSwitchPerspective04() {
        MWindow window1 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window1);
        this.application.setSelectedElement((MUIElement)window1);
        MWindow window2 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window2);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window2.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window2.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window2.getChildren().add(perspectiveStack);
        window2.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder partPlaceholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA1.setRef((MUIElement)partA);
        partA.setCurSharedRef(partPlaceholderA1);
        perspectiveA.getChildren().add(partPlaceholderA1);
        perspectiveA.setSelectedElement((MUIElement)partPlaceholderA1);
        MPlaceholder partPlaceholderB1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB1.setRef((MUIElement)partB);
        partB.setCurSharedRef(partPlaceholderB1);
        perspectiveA.getChildren().add(partPlaceholderB1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder partPlaceholderA2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA2.setRef((MUIElement)partA);
        perspectiveB.getChildren().add(partPlaceholderA2);
        perspectiveB.setSelectedElement((MUIElement)partPlaceholderA2);
        MPlaceholder partPlaceholderB2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderB2.setRef((MUIElement)partB);
        perspectiveB.getChildren().add(partPlaceholderB2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        Assert.assertEquals((Object)window2.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)window2.getContext().getActiveChild());
        EPartService partService = (EPartService)window2.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)window2.getContext(), (Object)this.application.getContext().getActiveChild());
        Assert.assertEquals((Object)perspectiveB.getContext(), (Object)window2.getContext().getActiveChild());
    }

    @Test
    public void testSwitchPerspective05() {
        MWindow window1 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window1);
        this.application.setSelectedElement((MUIElement)window1);
        MWindow window2 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window2);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window2.getSharedElements().add(area);
        MPart sharedPart = (MPart)this.ems.createModelElement(MPart.class);
        window2.getSharedElements().add(sharedPart);
        area.getChildren().add(sharedPart);
        area.setSelectedElement((MUIElement)sharedPart);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window2.getChildren().add(perspectiveStack);
        window2.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder areaPlaceholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholderA.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholderA);
        perspectiveA.getChildren().add(areaPlaceholderA);
        perspectiveA.setSelectedElement((MUIElement)areaPlaceholderA);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(stackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder areaPlaceholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholderB.setRef((MUIElement)area);
        perspectiveB.getChildren().add(areaPlaceholderB);
        perspectiveB.setSelectedElement((MUIElement)areaPlaceholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window1);
        this.getEngine().createGui((MUIElement)window2);
        EPartService partService = (EPartService)window2.getContext().get(EPartService.class);
        partService.activate(sharedPart);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)sharedPart, (Object)partService.getActivePart());
        partService.hidePart(sharedPart);
        Assert.assertNull((Object)partService.getActivePart());
        this.application.setSelectedElement((MUIElement)window1);
        window1.getContext().activate();
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)window2.getContext().getActiveChild());
    }

    @Test
    public void testSwitchPerspective06() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getSharedElements().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.ClientEditor");
        window.getSharedElements().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partA);
        partA.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partB);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        ClientEditor editorA = (ClientEditor)partA.getObject();
        ClientEditor editorB = (ClientEditor)partB.getObject();
        editorA.focusCalled = false;
        editorB.focusCalled = false;
        partService.switchPerspective(perspectiveB);
        Assert.assertFalse((boolean)editorA.focusCalled);
        Assert.assertTrue((boolean)editorB.focusCalled);
        editorB.focusCalled = false;
        partService.switchPerspective(perspectiveA);
        Assert.assertTrue((boolean)editorA.focusCalled);
        Assert.assertFalse((boolean)editorB.focusCalled);
    }

    @Test
    public void testSwitchPerspective07() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partD = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(partD);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderD1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderD1.setRef((MUIElement)partD);
        partD.setCurSharedRef(placeholderD1);
        perspectiveA.getChildren().add(placeholderD1);
        perspectiveA.setSelectedElement((MUIElement)placeholderD1);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspectiveB.getChildren().add(partA);
        perspectiveB.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        MPlaceholder placeholderD2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderD2.setRef((MUIElement)partD);
        partStack.getChildren().add(placeholderD2);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        partService.activate(partB);
        Assert.assertEquals((Object)perspectiveB, (Object)perspectiveStack.getSelectedElement());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((Object)perspectiveA, (Object)perspectiveStack.getSelectedElement());
    }

    @Test
    public void testSwitchPerspective08() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        area.getChildren().add(partA);
        area.setSelectedElement((MUIElement)partA);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder areaPlaceholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholderA.setRef((MUIElement)area);
        area.setCurSharedRef(areaPlaceholderA);
        perspectiveA.getChildren().add(areaPlaceholderA);
        perspectiveA.setSelectedElement((MUIElement)areaPlaceholderA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStack);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partC);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder areaPlaceholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        areaPlaceholderB.setRef((MUIElement)area);
        perspectiveB.getChildren().add(areaPlaceholderB);
        perspectiveB.setSelectedElement((MUIElement)areaPlaceholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.switchPerspective(perspectiveB);
        partService.hidePart(partA);
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((Object)partC, (Object)partService.getActivePart());
    }

    @Test
    public void testSwitchPerspective_Bug329184() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MWindow detachedWindowB = (MWindow)this.ems.createModelElement(MWindow.class);
        perspectiveB.getWindows().add(detachedWindowB);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindowB.getChildren().add(partStack);
        detachedWindowB.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)part);
        partStack.getChildren().add(placeholderB);
        partStack.setSelectedElement((MUIElement)placeholderB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(part);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)part, (Object)partService.getActivePart());
    }

    @Test
    public void testLeak() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partA);
        WeakReference<MPart> ref = new WeakReference<MPart>(partA);
        Assert.assertEquals((Object)partA, ref.get());
        partService.hidePart(partA, true);
        Assert.assertEquals((Object)partB, (Object)window.getSelectedElement());
        Assert.assertFalse((boolean)window.getChildren().contains(partA));
        partA = null;
        System.runFinalization();
        System.gc();
        Assert.assertNull((String)"The part should no longer be reachable", ref.get());
    }

    @Test
    public void testsEventWithExceptions() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partA);
        partService.activate(partB);
        partService.activate(partA);
        partService.addPartListener((IPartListener)new ExceptionListener());
        PartListener listener = new PartListener();
        partService.addPartListener((IPartListener)listener);
        partService.activate(partB);
        Assert.assertEquals((long)1L, (long)listener.getActivated());
        Assert.assertEquals((long)1L, (long)listener.getDeactivated());
        Assert.assertEquals((long)1L, (long)listener.getVisible());
        Assert.assertEquals((long)1L, (long)listener.getHidden());
        Assert.assertEquals((long)1L, (long)listener.getBroughtToTop());
    }

    private void createApplication(String partId) {
        this.createApplication(new String[]{partId});
    }

    private void createApplication(String ... partIds) {
        this.createApplication(new String[][]{partIds});
    }

    private void createApplication(String[] ... partIds) {
        this.createApplication(partIds.length, partIds);
    }

    private void createApplication(int windows, String[][] partIds) {
        int i = 0;
        while (i < windows) {
            MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
            this.application.getChildren().add(window);
            MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
            window.getChildren().add(partStack);
            int j = 0;
            while (j < partIds[i].length) {
                MPart part = (MPart)this.ems.createModelElement(MPart.class);
                part.setElementId(partIds[i][j]);
                partStack.getChildren().add(part);
                ++j;
            }
            ++i;
        }
        this.initialize();
    }

    private void initialize() {
        UIEventPublisher ep = new UIEventPublisher(this.applicationContext);
        ((Notifier)this.application).eAdapters().add((Object)ep);
        this.applicationContext.set(UIEventPublisher.class, (Object)ep);
        this.applicationContext.set(ISaveHandler.class.getName(), (Object)new PartServiceSaveHandler(){

            public ISaveHandler.Save[] promptToSave(Collection<MPart> saveablePart) {
                Object[] ret = new ISaveHandler.Save[saveablePart.size()];
                Arrays.fill(ret, ISaveHandler.Save.YES);
                return ret;
            }

            public ISaveHandler.Save promptToSave(MPart saveablePart) {
                return ISaveHandler.Save.YES;
            }
        });
    }

    class ExceptionListener
    implements IPartListener {
        ExceptionListener() {
        }

        public void partActivated(MPart part) {
            throw new RuntimeException();
        }

        public void partBroughtToTop(MPart part) {
            throw new RuntimeException();
        }

        public void partDeactivated(MPart part) {
            throw new RuntimeException();
        }

        public void partHidden(MPart part) {
            throw new RuntimeException();
        }

        public void partVisible(MPart part) {
            throw new RuntimeException();
        }
    }

    class PartListener
    implements IPartListener {
        private List<MPart> activatedParts = new ArrayList<MPart>();
        private List<MPart> deactivatedParts = new ArrayList<MPart>();
        private List<MPart> hiddenParts = new ArrayList<MPart>();
        private List<MPart> visibleParts = new ArrayList<MPart>();
        private List<MPart> broughtToTopParts = new ArrayList<MPart>();
        private int activated = 0;
        private int deactivated = 0;
        private int hidden = 0;
        private int visible = 0;
        private int broughtToTop = 0;
        private boolean valid = true;

        PartListener() {
        }

        public void clear() {
            this.activated = 0;
            this.deactivated = 0;
            this.hidden = 0;
            this.visible = 0;
            this.activatedParts.clear();
            this.deactivatedParts.clear();
            this.hiddenParts.clear();
            this.visibleParts.clear();
            this.valid = true;
        }

        public int getActivated() {
            return this.activated;
        }

        public int getDeactivated() {
            return this.deactivated;
        }

        public int getHidden() {
            return this.hidden;
        }

        public int getVisible() {
            return this.visible;
        }

        public int getBroughtToTop() {
            return this.broughtToTop;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<MPart> getActivatedParts() {
            return this.activatedParts;
        }

        public List<MPart> getDeactivatedParts() {
            return this.deactivatedParts;
        }

        public List<MPart> getHiddenParts() {
            return this.hiddenParts;
        }

        public List<MPart> getVisibleParts() {
            return this.visibleParts;
        }

        public void partActivated(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.activated;
            this.activatedParts.add(part);
        }

        public void partBroughtToTop(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.broughtToTop;
            this.broughtToTopParts.add(part);
        }

        public void partDeactivated(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.deactivated;
            this.deactivatedParts.add(part);
        }

        public void partHidden(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.hidden;
            this.hiddenParts.add(part);
        }

        public void partVisible(MPart part) {
            if (this.valid && part == null) {
                this.valid = false;
            }
            ++this.visible;
            this.visibleParts.add(part);
        }
    }
}

