/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.List;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Test;

public class ModelRobustnessTest {
    @Test
    public void testLoadingInvalidContainments() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/InvalidContainment.e4xmi", (boolean)true);
        ResourceSetImpl set = new ResourceSetImpl();
        Resource resource = null;
        try {
            resource = set.getResource(uri, true);
            Assert.fail((String)"This should have thrown an exception");
        }
        catch (Exception exception) {
            resource = set.getResource(uri, false);
        }
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals(E4XMIResource.class, resource.getClass());
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        MApplication app = (MApplication)resource.getContents().get(0);
        Assert.assertEquals((long)1L, (long)app.getChildren().size());
        MWindow w = (MWindow)app.getChildren().get(0);
        Assert.assertEquals((Object)"window1", (Object)w.getElementId());
        Assert.assertEquals((long)2L, (long)w.getChildren().size());
        MPartStack stack = (MPartStack)w.getChildren().get(0);
        Assert.assertEquals((Object)"window1.partstack1", (Object)stack.getElementId());
        Assert.assertEquals((long)1L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)"window1.partstack1.part1", (Object)((MStackElement)stack.getChildren().get(0)).getElementId());
        stack = (MPartStack)w.getChildren().get(1);
        Assert.assertEquals((Object)"window1.partstack2", (Object)stack.getElementId());
        Assert.assertEquals((long)1L, (long)stack.getChildren().size());
        Assert.assertEquals((Object)"window1.partstack2.part1", (Object)((MStackElement)stack.getChildren().get(0)).getElementId());
    }

    @Test
    public void testAddingInvalidElements() {
        MApplication app = MApplicationFactory.INSTANCE.createApplication();
        List l = app.getChildren();
        l.add(MBasicFactory.INSTANCE.createWindow());
        try {
            l.add(MBasicFactory.INSTANCE.createPart());
            Assert.fail((String)"The adding of this should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayStoreException arrayStoreException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        l.add(MBasicFactory.INSTANCE.createWindow());
        Assert.assertEquals((long)2L, (long)l.size());
    }
}

