/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HandlerTest {
    private static final String HELP_COMMAND_ID = "org.eclipse.ui.commands.help";
    private static final String HELP_COMMAND1_ID = "org.eclipse.ui.commands.help1";
    private IEclipseContext appContext;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext);
    }

    @After
    public void tearDown() throws Exception {
        this.appContext.dispose();
    }

    @Test
    public void testOneCommand() throws Exception {
        this.defineCommands(this.appContext);
        ParameterizedCommand helpCommand = this.getCommand(this.appContext, HELP_COMMAND_ID);
        ParameterizedCommand help1Command = this.getCommand(this.appContext, HELP_COMMAND1_ID);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)this.appContext.get(EHandlerService.class);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        ECommandService cmdService = (ECommandService)this.appContext.get(ECommandService.class);
        Command command = cmdService.getCommand(HELP_COMMAND_ID);
        Assert.assertEquals((Object)HELP_COMMAND_ID, (Object)command.getId());
        Assert.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        Assert.assertTrue((boolean)handler.ran);
        Assert.assertNull((Object)service.executeHandler(help1Command));
    }

    @Test
    public void testTwoCommands() throws Exception {
        this.defineCommands(this.appContext);
        ParameterizedCommand helpCommand = this.getCommand(this.appContext, HELP_COMMAND_ID);
        ParameterizedCommand help1Command = this.getCommand(this.appContext, HELP_COMMAND1_ID);
        EHandlerService service = (EHandlerService)this.appContext.get(EHandlerService.class);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        TestHandler handler1 = new TestHandler(false, HELP_COMMAND1_ID);
        service.activateHandler(HELP_COMMAND1_ID, (Object)handler1);
        Assert.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        Assert.assertNull((Object)service.executeHandler(help1Command));
        Assert.assertFalse((boolean)handler1.ran);
        handler1.canRun = true;
        Assert.assertEquals((Object)HELP_COMMAND1_ID, (Object)service.executeHandler(help1Command));
        Assert.assertTrue((boolean)handler1.ran);
    }

    @Test
    public void testTwoHandlers() throws Exception {
        this.defineCommands(this.appContext);
        ParameterizedCommand helpCommand = this.getCommand(this.appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)this.appContext.get(EHandlerService.class);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.appContext.createChild("windowContext");
        window.activate();
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class);
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(false, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        Assert.assertNull((Object)service.executeHandler(helpCommand));
        Assert.assertFalse((boolean)windowHandler.ran);
        Assert.assertFalse((boolean)handler.ran);
        windowHandler.canRun = true;
        Assert.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        Assert.assertTrue((boolean)windowHandler.ran);
        Assert.assertFalse((boolean)handler.ran);
    }

    private ParameterizedCommand getCommand(IEclipseContext appContext, String commandId) {
        ECommandService cs = (ECommandService)appContext.get(ECommandService.class);
        Command cmd = cs.getCommand(commandId);
        return new ParameterizedCommand(cmd, null);
    }

    @Test
    public void testCanExecute() throws Exception {
        this.defineCommands(this.appContext);
        ParameterizedCommand helpCommand = this.getCommand(this.appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)this.appContext.get(EHandlerService.class);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.appContext.createChild("windowContext");
        window.activate();
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class);
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(false, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        Assert.assertFalse((boolean)windowService.canExecute(helpCommand));
        windowHandler.canRun = true;
        Assert.assertTrue((boolean)windowService.canExecute(helpCommand));
        windowHandler.canRun = false;
        Assert.assertFalse((boolean)windowService.canExecute(helpCommand));
        windowService.deactivateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        Assert.assertTrue((boolean)windowService.canExecute(helpCommand));
    }

    @Test
    public void testThreeContexts() throws Exception {
        this.defineCommands(this.appContext);
        ParameterizedCommand helpCommand = this.getCommand(this.appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)this.appContext.get(EHandlerService.class);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.appContext.createChild("windowContext");
        window.activate();
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class);
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(true, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        Assert.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        IEclipseContext dialog = this.appContext.createChild("dialogContext");
        dialog.activate();
        Assert.assertEquals((Object)HELP_COMMAND_ID, (Object)service.executeHandler(helpCommand));
        window.activate();
        Assert.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
    }

    @Test
    public void testDifferentExecutionContexts() throws Exception {
        this.defineCommands(this.appContext);
        ParameterizedCommand helpCommand = this.getCommand(this.appContext, HELP_COMMAND_ID);
        EHandlerService service = (EHandlerService)this.appContext.get(EHandlerService.class);
        TestHandler handler = new TestHandler(true, HELP_COMMAND_ID);
        service.activateHandler(HELP_COMMAND_ID, (Object)handler);
        IEclipseContext window = this.appContext.createChild("windowContext");
        window.activate();
        EHandlerService windowService = (EHandlerService)window.get(EHandlerService.class);
        String windowRC = "org.eclipse.ui.commands.help.window";
        TestHandler windowHandler = new TestHandler(true, windowRC);
        windowService.activateHandler(HELP_COMMAND_ID, (Object)windowHandler);
        Assert.assertEquals((Object)windowRC, (Object)service.executeHandler(helpCommand));
        Assert.assertEquals((Object)windowRC, (Object)windowService.executeHandler(helpCommand));
        IEclipseContext dialog = this.appContext.createChild("dialogContext");
        EHandlerService dialogService = (EHandlerService)dialog.get(EHandlerService.class);
        Assert.assertEquals((Object)HELP_COMMAND_ID, (Object)dialogService.executeHandler(helpCommand));
    }

    private void defineCommands(IEclipseContext appContext) {
        ECommandService cmdService = (ECommandService)appContext.get(ECommandService.class.getName());
        Category category = cmdService.defineCategory("cat.org.eclipse.ui.commands.help", "Help Category", null);
        cmdService.defineCommand(HELP_COMMAND_ID, "Help Command", null, category, null);
        cmdService.defineCommand(HELP_COMMAND1_ID, "Help 1 Command", null, category, null);
    }

    public static class TestHandler {
        boolean ran = false;
        boolean canRun;
        String rc;

        public TestHandler(boolean c, String ret) {
            this.canRun = c;
            this.rc = ret;
        }

        @CanExecute
        public boolean canExecute() {
            return this.canRun;
        }

        @Execute
        public Object execute() {
            this.ran = true;
            return this.rc;
        }
    }
}

