/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import javax.inject.Named;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.addons.CommandProcessingAddon;
import org.eclipse.e4.ui.internal.workbench.addons.HandlerProcessingAddon;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MImperativeExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MMenuItemTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.appContext);
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    private void testMMenuItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MMenuItem menuItem = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menuItem.setLabel(before);
        window.setMainMenu(menu);
        menu.getChildren().add(menuItem);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget = menuItem.getWidget();
        Assert.assertNotNull((Object)widget);
        Assert.assertTrue((boolean)(widget instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget;
        Assert.assertEquals((Object)beforeExpected, (Object)menuItemWidget.getText());
        menuItem.setLabel(after);
        Assert.assertEquals((Object)afterExpected, (Object)menuItemWidget.getText());
    }

    @Test
    public void testMMenuItem_Text_NullNull() {
        this.testMMenuItem_Text(null, "", null, "");
    }

    @Test
    public void testMMenuItem_Text_NullEmpty() {
        this.testMMenuItem_Text(null, "", "", "");
    }

    @Test
    public void testMMenuItem_Text_NullString() {
        this.testMMenuItem_Text(null, "", "label", "label");
    }

    @Test
    public void testMMenuItem_Text_EmptyNull() {
        this.testMMenuItem_Text("", "", null, "");
    }

    @Test
    public void testMMenuItem_Text_EmptyEmpty() {
        this.testMMenuItem_Text("", "", "", "");
    }

    @Test
    public void testMMenuItem_Text_EmptyString() {
        this.testMMenuItem_Text("", "", "label", "label");
    }

    @Test
    public void testMMenuItem_Text_StringNull() {
        this.testMMenuItem_Text("label", "label", null, "");
    }

    @Test
    public void testMMenuItem_Text_StringEmpty() {
        this.testMMenuItem_Text("label", "label", "", "");
    }

    @Test
    public void testMMenuItem_Text_StringStringUnchanged() {
        this.testMMenuItem_Text("label", "label", "label", "label");
    }

    @Test
    public void testMMenuItem_Text_StringStringChanged() {
        this.testMMenuItem_Text("label", "label", "label2", "label2");
    }

    @Test
    public void testMMenuItem_RadioItems() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MMenuItem menuItem1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        MMenuItem menuItem2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menuItem1.setType(ItemType.RADIO);
        menuItem2.setType(ItemType.RADIO);
        menu.getChildren().add(menuItem1);
        menu.getChildren().add(menuItem2);
        window.setMainMenu(menu);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget1 = menuItem1.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof MenuItem));
        Object widget2 = menuItem2.getWidget();
        Assert.assertNotNull((Object)widget2);
        Assert.assertTrue((boolean)(widget2 instanceof MenuItem));
        MenuItem menuItemWidget1 = (MenuItem)widget1;
        MenuItem menuItemWidget2 = (MenuItem)widget2;
        menuItemWidget1.setSelection(false);
        menuItemWidget2.setSelection(true);
        menuItemWidget1.notifyListeners(13, new Event());
        menuItemWidget2.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)menuItem1.isSelected());
        Assert.assertTrue((boolean)menuItem2.isSelected());
        menuItemWidget2.setSelection(false);
        menuItemWidget1.setSelection(true);
        menuItemWidget2.notifyListeners(13, new Event());
        menuItemWidget1.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)menuItem1.isSelected());
        Assert.assertFalse((boolean)menuItem2.isSelected());
        menuItem1.setSelected(false);
        Assert.assertFalse((boolean)menuItemWidget1.getSelection());
        menuItem2.setSelected(true);
        Assert.assertTrue((boolean)menuItemWidget2.getSelection());
    }

    @Test
    public void testMDirectMenuItem_Check_Bug316752() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MMenuItem menuItem = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget1 = menuItem.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        Assert.assertTrue((boolean)menuItemWidget.getSelection());
    }

    @Test
    public void testMHandledMenuItem_Check_Bug316752() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MHandledMenuItem menuItem = (MHandledMenuItem)this.ems.createModelElement(MHandledMenuItem.class);
        MCommand command = (MCommand)this.ems.createModelElement(MCommand.class);
        command.setElementId("commandId");
        menuItem.setCommand(command);
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManager barManager = (MenuManager)((Menu)menu.getWidget()).getData();
        barManager.updateAll(true);
        Object widget1 = menuItem.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        Assert.assertTrue((boolean)menuItemWidget.getSelection());
    }

    @Test
    public void testMHandledMenuItem_Check_Bug463280() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MHandledMenuItem menuItem = (MHandledMenuItem)this.ems.createModelElement(MHandledMenuItem.class);
        MCommand command = (MCommand)this.ems.createModelElement(MCommand.class);
        command.setElementId("commandId");
        menuItem.setCommand(command);
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menuItem.setLabel("&Test Xxx");
        menuItem.setMnemonics("");
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManager barManager = (MenuManager)((Menu)menu.getWidget()).getData();
        barManager.updateAll(true);
        Object widget1 = menuItem.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        Assert.assertFalse((boolean)menuItemWidget.getText().startsWith("&&"));
    }

    @Test
    public void testSubMenuCreation() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager manager = renderer.getManager(mainMenu);
        Assert.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        Assert.assertEquals((long)1L, (long)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        Assert.assertEquals((Object)fileManager, (Object)fileR);
        Assert.assertEquals((long)3L, (long)fileManager.getSize());
    }

    @Test
    public void testTbrItem() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        item2.setToBeRendered(false);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager manager = renderer.getManager(mainMenu);
        Assert.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        Assert.assertEquals((long)1L, (long)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        Assert.assertEquals((Object)fileManager, (Object)fileR);
        Assert.assertEquals((long)2L, (long)fileManager.getSize());
    }

    @Test
    public void testInvisibleItem() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        item2.setVisible(false);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager manager = renderer.getManager(mainMenu);
        Assert.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        Assert.assertEquals((long)1L, (long)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        Assert.assertEquals((Object)fileManager, (Object)fileR);
        Assert.assertEquals((long)3L, (long)fileManager.getSize());
        Assert.assertEquals((Object)false, (Object)fileManager.getItems()[2].isVisible());
    }

    @Test
    public void testMenuContribution() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        application.getMenuContributions().add(this.createContribution(false));
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager fileManager = renderer.getManager(fileMenu);
        Assert.assertNotNull((String)"No file menu?", (Object)fileManager);
        Assert.assertEquals((long)4L, (long)fileManager.getSize());
        Assert.assertEquals((Object)"mmc.item1", (Object)fileManager.getItems()[3].getId());
    }

    @Test
    public void testWithVisible() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        application.getMenuContributions().add(this.createContribution(true));
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager fileManager = renderer.getManager(fileMenu);
        Assert.assertNotNull((String)"No file menu?", (Object)fileManager);
        Assert.assertEquals((long)4L, (long)fileManager.getSize());
        IContributionItem mmcItem = fileManager.getItems()[3];
        Assert.assertEquals((Object)"mmc.item1", (Object)mmcItem.getId());
        Assert.assertEquals((String)"before the first show, we have no context to evaluate", (Object)true, (Object)mmcItem.isVisible());
        MenuManager manager = renderer.getManager(mainMenu);
        manager.updateAll(true);
        Menu fileWidget = fileManager.getMenu();
        Assert.assertNotNull((Object)fileWidget);
        Event show = new Event();
        show.widget = fileWidget;
        show.type = 22;
        Event hide = new Event();
        hide.widget = fileWidget;
        hide.type = 23;
        fileWidget.notifyListeners(22, show);
        Assert.assertEquals((String)"after the first show, it should not be visible", (Object)false, (Object)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        Assert.assertEquals((String)"Change should not show up until next show", (Object)false, (Object)mmcItem.isVisible());
        fileWidget.notifyListeners(22, show);
        Assert.assertEquals((Object)true, (Object)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
        this.appContext.remove("mmc1");
        fileWidget.notifyListeners(22, show);
        Assert.assertEquals((Object)false, (Object)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
    }

    @Test
    public void testVisibilityOfMenuItemChangesBasedOnCoreExpression() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.createMenuContributionWithCoreExpression(application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager manager = renderer.getManager(mainMenu);
        manager.updateAll(true);
        Assert.assertEquals((long)2L, (long)manager.getSize());
        MenuManager vanishManager = (MenuManager)manager.getItems()[1];
        Assert.assertEquals((Object)"vanish", (Object)vanishManager.getId());
        Assert.assertFalse((boolean)vanishManager.isVisible());
        Assert.assertNull((Object)vanishManager.getMenu());
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        Assert.assertTrue((boolean)vanishManager.isVisible());
        Assert.assertNotNull((Object)vanishManager.getMenu());
        this.appContext.remove("mmc1");
        Assert.assertFalse((boolean)vanishManager.isVisible());
        Menu vanishMenu = vanishManager.getMenu();
        if (vanishMenu != null) {
            Assert.assertTrue((boolean)vanishMenu.isDisposed());
        }
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        Assert.assertTrue((boolean)vanishManager.isVisible());
        Assert.assertNotNull((Object)vanishManager.getMenu());
        Assert.assertFalse((boolean)vanishManager.getMenu().isDisposed());
    }

    @Test
    public void testVisibilityOfMenuItemChangesBasedOnImperativeExpression() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MMenu mainMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        mainMenu.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(mainMenu);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        mainMenu.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = (MMenuSeparator)this.ems.createModelElement(MMenuSeparator.class);
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.createMenuContributionWithImperativeExpression(application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)mainMenu);
        MenuManager manager = renderer.getManager(mainMenu);
        manager.updateAll(true);
        Assert.assertEquals((long)2L, (long)manager.getSize());
        MenuManager vanishManager = (MenuManager)manager.getItems()[1];
        Assert.assertEquals((Object)"vanish", (Object)vanishManager.getId());
        Assert.assertFalse((boolean)vanishManager.isVisible());
        Assert.assertNull((Object)vanishManager.getMenu());
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        Assert.assertTrue((boolean)vanishManager.isVisible());
        Assert.assertNotNull((Object)vanishManager.getMenu());
        this.appContext.remove("mmc1");
        Assert.assertFalse((boolean)vanishManager.isVisible());
        Menu vanishMenu = vanishManager.getMenu();
        if (vanishMenu != null) {
            Assert.assertTrue((boolean)vanishMenu.isDisposed());
        }
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        Assert.assertTrue((boolean)vanishManager.isVisible());
        Assert.assertNotNull((Object)vanishManager.getMenu());
        Assert.assertFalse((boolean)vanishManager.getMenu().isDisposed());
    }

    @Test
    public void testElementHierarchyInContext_DirectItem() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        final MPart activePart = (MPart)this.ems.createModelElement(MPart.class);
        MPart inactivePart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(activePart);
        stack.getChildren().add(inactivePart);
        stack.setSelectedElement((MUIElement)activePart);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MDirectMenuItem menuItem = (MDirectMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        final boolean[] executed = new boolean[1];
        menuItem.setObject(new Object(){

            @Execute
            public void execute(MUIElement uiElement, MMenuItem menuItem, MDirectMenuItem directMenuItem, MPart part, @Named(value="key") String key) {
                Assert.assertEquals((Object)menuItem, (Object)directMenuItem);
                Assert.assertEquals((Object)menuItem, (Object)menuItem);
                Assert.assertEquals((Object)menuItem, (Object)uiElement);
                Assert.assertEquals((Object)part, (Object)activePart);
                Assert.assertEquals((Object)key, (Object)"active");
                executed[0] = true;
            }
        });
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService eps = (EPartService)window.getContext().get(EPartService.class);
        eps.activate(inactivePart);
        eps.activate(activePart);
        Assert.assertEquals((Object)activePart, (Object)eps.getActivePart());
        activePart.getContext().set("key", (Object)"active");
        inactivePart.getContext().set("key", (Object)"inactive");
        Assert.assertFalse((boolean)executed[0]);
        Object widget1 = menuItem.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof MenuItem));
        ((MenuItem)widget1).notifyListeners(13, new Event());
        Assert.assertTrue((boolean)executed[0]);
    }

    @Test
    public void testElementHierarchyInContext_HandledItem() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        final MPart activePart = (MPart)this.ems.createModelElement(MPart.class);
        MPart inactivePart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(activePart);
        stack.getChildren().add(inactivePart);
        stack.setSelectedElement((MUIElement)activePart);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MCommand command = (MCommand)this.ems.createModelElement(MCommand.class);
        command.setElementId("testElementHierarchyInContext_HandledItem");
        command.setCommandName("Test HandledItem");
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        MHandledMenuItem menuItem = (MHandledMenuItem)this.ems.createModelElement(MHandledMenuItem.class);
        menuItem.setCommand(command);
        MHandler handler = (MHandler)this.ems.createModelElement(MHandler.class);
        handler.setCommand(command);
        final boolean[] executed = new boolean[1];
        handler.setObject(new Object(){

            @Execute
            public void execute(MUIElement uiElement, MMenuItem menuItem, MHandledMenuItem handledMenuItem, MPart part, @Named(value="key") String key) {
                Assert.assertEquals((Object)menuItem, (Object)handledMenuItem);
                Assert.assertEquals((Object)menuItem, (Object)menuItem);
                Assert.assertEquals((Object)menuItem, (Object)uiElement);
                Assert.assertEquals((Object)part, (Object)activePart);
                Assert.assertEquals((Object)key, (Object)"active");
                executed[0] = true;
            }
        });
        window.getHandlers().add(handler);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getCommands().add(command);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        ContextInjectionFactory.make(CommandProcessingAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(HandlerProcessingAddon.class, (IEclipseContext)this.appContext);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService eps = (EPartService)window.getContext().get(EPartService.class);
        eps.activate(inactivePart);
        eps.activate(activePart);
        Assert.assertEquals((Object)activePart, (Object)eps.getActivePart());
        activePart.getContext().set("key", (Object)"active");
        inactivePart.getContext().set("key", (Object)"inactive");
        Assert.assertFalse((boolean)executed[0]);
        Assert.assertEquals((Object)activePart, (Object)((EPartService)window.getContext().get(EPartService.class)).getActivePart());
        Object widget1 = menuItem.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof MenuItem));
        ((MenuItem)widget1).notifyListeners(13, new Event());
        Assert.assertTrue((boolean)executed[0]);
    }

    private MMenuContribution createContribution(boolean withVisibleWhen) {
        MMenuContribution mmc = (MMenuContribution)this.ems.createModelElement(MMenuContribution.class);
        mmc.setElementId("test.contrib1");
        mmc.setParentId("file");
        mmc.setPositionInParent("after=additions");
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("mmc.item1");
        item1.setLabel("mmc.item1");
        mmc.getChildren().add(item1);
        if (withVisibleWhen) {
            MCoreExpression exp = (MCoreExpression)this.ems.createModelElement(MCoreExpression.class);
            exp.setCoreExpressionId("org.eclipse.e4.ui.tests.withMmc1");
            mmc.setVisibleWhen((MExpression)exp);
        }
        return mmc;
    }

    private void createMenuContributionWithCoreExpression(MApplication application) {
        MMenuContribution mmc = (MMenuContribution)this.ems.createModelElement(MMenuContribution.class);
        mmc.setElementId("test.contrib2");
        mmc.setParentId("org.eclipse.ui.main.menu");
        mmc.setPositionInParent("after=additions");
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        menu.setElementId("vanish");
        menu.setLabel("Vanish");
        mmc.getChildren().add(menu);
        MCoreExpression exp = (MCoreExpression)this.ems.createModelElement(MCoreExpression.class);
        exp.setCoreExpressionId("org.eclipse.e4.ui.tests.withMmc1");
        mmc.setVisibleWhen((MExpression)exp);
        application.getMenuContributions().add(mmc);
        mmc = (MMenuContribution)this.ems.createModelElement(MMenuContribution.class);
        mmc.setElementId("test.contrib3");
        mmc.setParentId("vanish");
        mmc.setPositionInParent("after=additions");
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("mmc.item2");
        item1.setLabel("mmc.item2");
        mmc.getChildren().add(item1);
        application.getMenuContributions().add(mmc);
    }

    private void createMenuContributionWithImperativeExpression(MApplication application) {
        MMenuContribution mmc = (MMenuContribution)this.ems.createModelElement(MMenuContribution.class);
        mmc.setElementId("test.contrib2");
        mmc.setParentId("org.eclipse.ui.main.menu");
        mmc.setPositionInParent("after=additions");
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        menu.setElementId("vanish");
        menu.setLabel("Vanish");
        mmc.getChildren().add(menu);
        MImperativeExpression exp = (MImperativeExpression)this.ems.createModelElement(MImperativeExpression.class);
        exp.setTracking(true);
        exp.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.ImperativeExpressionTestEvaluation");
        mmc.setVisibleWhen((MExpression)exp);
        menu.setVisibleWhen((MExpression)exp);
        application.getMenuContributions().add(mmc);
        mmc = (MMenuContribution)this.ems.createModelElement(MMenuContribution.class);
        mmc.setElementId("test.contrib3");
        mmc.setParentId("vanish");
        mmc.setPositionInParent("after=additions");
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("mmc.item2");
        item1.setLabel("mmc.item2");
        mmc.getChildren().add(item1);
        application.getMenuContributions().add(mmc);
    }

    private MenuManagerRenderer getRenderer(IEclipseContext context, MUIElement element) {
        IRendererFactory rendererFactory = (IRendererFactory)context.get(IRendererFactory.class);
        AbstractPartRenderer renderer = rendererFactory.getRenderer(element, null);
        Assert.assertEquals(MenuManagerRenderer.class, renderer.getClass());
        return (MenuManagerRenderer)renderer;
    }
}

