/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MSashTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    @Test
    public void testSashWeights() {
        MWindow window = this.createSashWithNViews(2);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        ((Shell)topWidget).layout(true);
        MPartSashContainer sash = (MPartSashContainer)window.getChildren().get(0);
        MPart part0 = (MPart)sash.getChildren().get(0);
        MPart part1 = (MPart)sash.getChildren().get(1);
        int cdVal0 = -1;
        try {
            cdVal0 = Integer.parseInt(part0.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        Assert.assertTrue((String)"Part0 data is not an integer", (cdVal0 != -1 ? 1 : 0) != 0);
        int cdVal1 = -1;
        try {
            cdVal1 = Integer.parseInt(part1.getContainerData());
        }
        catch (NumberFormatException numberFormatException) {}
        Assert.assertTrue((String)"Part1 data is not an integer", (cdVal1 != -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Values should be equal", (cdVal0 == cdVal1 ? 1 : 0) != 0);
    }

    private MWindow createSashWithNViews(int n) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setHeight(300);
        window.setWidth(401);
        window.setLabel("MyWindow");
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sash);
        int i = 0;
        while (i < n) {
            MPart contributedPart = (MPart)this.ems.createModelElement(MPart.class);
            contributedPart.setLabel("Sample View" + i);
            contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
            sash.getChildren().add(contributedPart);
            ++i;
        }
        return window;
    }
}

