/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentComparator;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentWrapper;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.fragment.MFragmentFactory;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ModelAssemblerFragmentOrderingTests {
    private static final String APPLICATION_ID = "org.eclipse.e4.ui.tests.modelassembler.fragmentordering.app";
    private IEclipseContext appContext;
    private MApplication application;
    private E4XMIResourceFactory factory;
    private ResourceSetImpl resourceSet;
    private E4XMIResource appResource;
    private ModelAssembler assembler;
    private Logger logger;
    private MToolBar toolBar;
    private static final String MAIN_TOOLBAR_ID = "org.eclipse.e4.ui.tests.modelassembler.fragmentordering.mainWindow.mainToolBar";
    private static final String MAIN_WINDOW_ID = "org.eclipse.e4.ui.tests.modelassembler.fragmentordering.mainWindow";

    @Before
    public void setup() {
        this.appContext = E4Application.createDefaultContext();
        this.application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        this.application.setElementId(APPLICATION_ID);
        this.application.setContext(this.appContext);
        this.logger = (Logger)Mockito.mock(Logger.class);
        this.appContext.set(Logger.class, (Object)this.logger);
        this.appContext.set(MApplication.class, (Object)this.application);
        this.factory = new E4XMIResourceFactory();
        this.appResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"virtualuri"));
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResources().add((Object)this.appResource);
        this.appResource.getContents().add((Object)((EObject)this.application));
        this.assembler = new ModelAssembler();
        ContextInjectionFactory.inject((Object)this.assembler, (IEclipseContext)this.appContext);
        this.createWindowWithToolbar();
    }

    private void createWindowWithToolbar() {
        MTrimmedWindow window = MBasicFactory.INSTANCE.createTrimmedWindow();
        window.setElementId(MAIN_WINDOW_ID);
        MTrimBar trimBar = MBasicFactory.INSTANCE.createTrimBar();
        trimBar.setElementId("org.eclipse.e4.ui.tests.modelassembler.fragmentordering.mainWindow.trimBar");
        this.toolBar = MMenuFactory.INSTANCE.createToolBar();
        this.toolBar.setElementId(MAIN_TOOLBAR_ID);
        trimBar.getChildren().add(this.toolBar);
        window.getTrimBars().add(trimBar);
        this.application.getChildren().add(window);
    }

    private ModelFragmentWrapper createFragmentWrapper(MModelFragments fragmentsContainer, String featureName, String parentElementId, List<? extends MApplicationElement> contributedElements, String positionInList, String contributorName, String contributorURI, boolean checkExists) {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename(featureName);
        fragment.setParentElementId(parentElementId);
        fragment.getElements().addAll(contributedElements);
        fragment.setPositionInList(positionInList);
        fragmentsContainer.getFragments().add(fragment);
        ModelFragmentWrapper wrapper = new ModelFragmentWrapper(fragmentsContainer, (MModelFragment)fragment, contributorName, contributorURI, checkExists);
        return wrapper;
    }

    @Test
    public void testInvalidPositionEmptyApplication() {
        Assert.assertTrue((boolean)this.toolBar.getChildren().isEmpty());
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapperA = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), null, "testNoPositionEmptyApplication", contributorURI, false);
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapperB = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "", "testNoPositionEmptyApplication", contributorURI, false);
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapperC = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "qwerty", "testNoPositionEmptyApplication", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapperA, fragmentWrapperB, fragmentWrapperC));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapperA, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperB, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperC, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(2));
    }

    @Test
    public void testInvalidPositionNotEmptyApplication() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapperA = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "", "testNoPositionNotEmptyApplication", contributorURI, false);
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapperB = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), null, "testNoPositionNotEmptyApplication", contributorURI, false);
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapperC = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "qwerty", "testNoPositionNotEmptyApplication", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapperA, fragmentWrapperB, fragmentWrapperC));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapperA, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperB, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperC, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)6L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testIncorrectIndexEmptyApplication() {
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        ModelFragmentWrapper fragmentWrapperA = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "index:-70", "testIncorrectIndex1", contributorURI, false);
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        ModelFragmentWrapper fragmentWrapperB = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "index:70", "testIncorrectIndex1", contributorURI, false);
        Assert.assertTrue((boolean)this.toolBar.getChildren().isEmpty());
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapperA, fragmentWrapperB));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapperA, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperB, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
    }

    @Test
    public void testIncorrectIndexNotEmptyApplication() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        ModelFragmentWrapper fragmentWrapperA = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "index:-70", "testIncorrectIndex1", contributorURI, false);
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        ModelFragmentWrapper fragmentWrapperB = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "index:70", "testIncorrectIndex1", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapperA, fragmentWrapperB));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapperA, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperB, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testIndex1EmptyApplication() {
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "index:1", "testIndex1", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "index:2", "testIndex1", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "index:3", "testIndex1", contributorURI, false);
        Assert.assertTrue((boolean)this.toolBar.getChildren().isEmpty());
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(2));
    }

    @Test
    public void testIndex2EmptyApplication() {
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "index:3", "testIndex2", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "index:2", "testIndex2", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "index:1", "testIndex2", contributorURI, false);
        Assert.assertTrue((boolean)this.toolBar.getChildren().isEmpty());
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
    }

    @Test
    public void testIndex3EmptyApplication() {
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "index:3", "testIndex3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "index:1", "testIndex3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "index:2", "testIndex3", contributorURI, false);
        Assert.assertTrue((boolean)this.toolBar.getChildren().isEmpty());
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
    }

    @Test
    public void testIndex4NotEmptyApplication() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        MModelFragments fragmentsContainerD = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerD));
        MHandledToolItem d = MMenuFactory.INSTANCE.createHandledToolItem();
        d.setElementId("d");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "index:9", "testIndex4", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "index:1", "testIndex4", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "index:0", "testIndex4", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper4 = this.createFragmentWrapper(fragmentsContainerD, "children", MAIN_TOOLBAR_ID, Arrays.asList(d), "index:3", "testIndex4", contributorURI, false);
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3, fragmentWrapper4));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper4, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)d, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(5));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(6));
    }

    @Test
    public void testFirstEmptyApplication() {
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "first", "testFirstEmptyApplication", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper));
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)1L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
    }

    @Test
    public void testFirstNotEmptyApplication() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "first", "testFirstNotEmptyApplication", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper));
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testFirstMultipleElements() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "first", "testFirstMultipleElements", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "first", "testFirstMultipleElements", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "first", "testFirstMultipleElements", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((long)1L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)4L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testLastEmptyApplication() {
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "last", "testLastEmptyApplication", contributorURI, false);
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)1L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
    }

    @Test
    public void testLastNotEmptyApplication() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "last", "testLastNotEmptyApplication", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper));
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testLastMultipleElements() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "last", "testLastMultipleElements", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "last", "testLastMultipleElements", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testBeforeApplicationReferences() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:x", "testBefore", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:y", "testBefore", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "before:z", "testBefore", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testBeforeNoReference() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:", "testBeforeEmptyTag", contributorURI, false);
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)4L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testBeforeIncorrectRefElement() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:w", "testBeforeIncorrectRefElement", contributorURI, false);
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)4L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testBeforeFragmentReference1() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:y", "testBeforeFragmentReference", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:a", "testBeforeFragmentReference", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testBeforeFragmentReference2() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:a", "testBeforeFragmentReference2", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:y", "testBeforeFragmentReference2", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testBeforeFragmentReference3() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:b", "testBeforeFragmentReference3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:c", "testBeforeFragmentReference3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "before:y", "testBeforeFragmentReference3", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)6L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testBeforeCrossReference() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:b", "testBeforeCrossReference", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:a", "testBeforeCrossReference", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testBeforeFragmentNoPosition() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "before:b", "testBeforeFragmentNoPosition", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), null, "testBeforeFragmentNoPosition", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "last", "testBeforeFragmentNoPosition", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)6L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testAfterApplicationReferences() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:x", "testAfter", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:y", "testAfter", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "after:z", "testAfter", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testAfterNoReference() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:", "testAfterEmptyTag", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper));
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)4L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testAfterIncorrectRefElement() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:w", "testAfterIncorrectRefElement", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1));
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)4L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
    }

    @Test
    public void testAfterFragmentReference1() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:y", "testAfterFragmentReference", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:a", "testAfterFragmentReference", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testAfterFragmentReference2() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        String contributorURI = fragmentResource.getURI().toString();
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:a", "testAfterFragmentReference1", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainer, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:y", "testAfterFragmentReference1", contributorURI, false);
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testAfterFragmentReference3() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:b", "testAfterFragmentReference3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:c", "testAfterFragmentReference3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "after:y", "testAfterFragmentReference3", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)6L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testAfterFragmentNoPosition() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:b", "testAfterFragmentNoPosition", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "", "testAfterFragmentNoPosition", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "last", "testAfterFragmentNoPosition", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper3, fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)6L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(5));
    }

    @Test
    public void testAfterCrossReference() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:b", "testAfterCrossReference", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:a", "testAfterCrossReference", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testAfterBeforeCrossReference() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:b", "testAfterBeforeCrossReference", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:a", "testAfterBeforeCrossReference", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testFirstBefore() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "first", "testFirstBefore", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "before:a", "testFirstBefore", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testLastAfter() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "last", "testLastAfter", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:a", "testLastAfter", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)5L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(4));
    }

    @Test
    public void testOrderAndMerge() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        MModelFragments fragmentsContainerD = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerD));
        MHandledToolItem d = MMenuFactory.INSTANCE.createHandledToolItem();
        d.setElementId("d");
        MModelFragments fragmentsContainerE = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerE));
        MHandledToolItem e = MMenuFactory.INSTANCE.createHandledToolItem();
        e.setElementId("e");
        MModelFragments fragmentsContainerF = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerF));
        MHandledToolItem f = MMenuFactory.INSTANCE.createHandledToolItem();
        f.setElementId("f");
        MModelFragments fragmentsContainerG = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerG));
        MHandledToolItem g = MMenuFactory.INSTANCE.createHandledToolItem();
        g.setElementId("g");
        MModelFragments fragmentsContainerH = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerH));
        MHandledToolItem h = MMenuFactory.INSTANCE.createHandledToolItem();
        h.setElementId("h");
        MModelFragments fragmentsContainerI = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerI));
        MHandledToolItem i = MMenuFactory.INSTANCE.createHandledToolItem();
        i.setElementId("i");
        MModelFragments fragmentsContainerJ = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerJ));
        MHandledToolItem j = MMenuFactory.INSTANCE.createHandledToolItem();
        j.setElementId("j");
        MModelFragments fragmentsContainerK = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerK));
        MHandledToolItem k = MMenuFactory.INSTANCE.createHandledToolItem();
        k.setElementId("k");
        ModelFragmentWrapper fragmentWrapperA = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "first", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperB = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "last", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperC = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), null, "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperD = this.createFragmentWrapper(fragmentsContainerD, "children", MAIN_TOOLBAR_ID, Arrays.asList(d), "", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperE = this.createFragmentWrapper(fragmentsContainerE, "children", MAIN_TOOLBAR_ID, Arrays.asList(e), "qwert", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperF = this.createFragmentWrapper(fragmentsContainerF, "children", MAIN_TOOLBAR_ID, Arrays.asList(f), "index:1", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperG = this.createFragmentWrapper(fragmentsContainerG, "children", MAIN_TOOLBAR_ID, Arrays.asList(g), "index:-1", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperH = this.createFragmentWrapper(fragmentsContainerH, "children", MAIN_TOOLBAR_ID, Arrays.asList(h), "before:x", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperI = this.createFragmentWrapper(fragmentsContainerI, "children", MAIN_TOOLBAR_ID, Arrays.asList(i), "before:a", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperJ = this.createFragmentWrapper(fragmentsContainerJ, "children", MAIN_TOOLBAR_ID, Arrays.asList(j), "after:z", "testFirstNotEmptyApplication", contributorURI, false);
        ModelFragmentWrapper fragmentWrapperK = this.createFragmentWrapper(fragmentsContainerK, "children", MAIN_TOOLBAR_ID, Arrays.asList(k), "after:b", "testFirstNotEmptyApplication", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapperA, fragmentWrapperB, fragmentWrapperC, fragmentWrapperD, fragmentWrapperE, fragmentWrapperF, fragmentWrapperG, fragmentWrapperH, fragmentWrapperI, fragmentWrapperJ, fragmentWrapperK));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapperG, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperF, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperC, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperD, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperE, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperA, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperB, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperJ, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperH, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperI, iterator.next());
        Assert.assertEquals((Object)fragmentWrapperK, iterator.next());
        Assert.assertEquals((long)3L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(2));
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((Object)i, this.toolBar.getChildren().get(0));
        Assert.assertEquals((Object)a, this.toolBar.getChildren().get(1));
        Assert.assertEquals((Object)h, this.toolBar.getChildren().get(2));
        Assert.assertEquals((Object)x, this.toolBar.getChildren().get(3));
        Assert.assertEquals((Object)f, this.toolBar.getChildren().get(4));
        Assert.assertEquals((Object)y, this.toolBar.getChildren().get(5));
        Assert.assertEquals((Object)z, this.toolBar.getChildren().get(6));
        Assert.assertEquals((Object)j, this.toolBar.getChildren().get(7));
        Assert.assertEquals((Object)g, this.toolBar.getChildren().get(8));
        Assert.assertEquals((Object)c, this.toolBar.getChildren().get(9));
        Assert.assertEquals((Object)d, this.toolBar.getChildren().get(10));
        Assert.assertEquals((Object)e, this.toolBar.getChildren().get(11));
        Assert.assertEquals((Object)b, this.toolBar.getChildren().get(12));
        Assert.assertEquals((Object)k, this.toolBar.getChildren().get(13));
    }

    @Test
    public void testMenuAndItemsInFragments() {
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MMenu menu0 = MMenuFactory.INSTANCE.createMenu();
        window.setMainMenu(menu0);
        menu0.setElementId("menu0");
        HashSet<ModelFragmentWrapper> fragmentList = new HashSet<ModelFragmentWrapper>();
        MMenu menu00 = MMenuFactory.INSTANCE.createMenu();
        menu00.setElementId("menu00");
        MMenu menu01 = MMenuFactory.INSTANCE.createMenu();
        menu01.setElementId("menu01");
        MMenu menu02 = MMenuFactory.INSTANCE.createMenu();
        menu02.setElementId("menu02");
        MHandledMenuItem menuitem000 = MMenuFactory.INSTANCE.createHandledMenuItem();
        menuitem000.setElementId("menuitem000");
        MHandledMenuItem menuitem001 = MMenuFactory.INSTANCE.createHandledMenuItem();
        menuitem001.setElementId("menuitem001");
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri1"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu0", Arrays.asList(menu00), "index:1", "menu00", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri2"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu0", Arrays.asList(menu01), "index:10", "menu01", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri3"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu0", Arrays.asList(menu02), "index:20", "menu02", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri4"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu00", Arrays.asList(menuitem000), "index:0", "menuitem000", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri5"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu00", Arrays.asList(menuitem001), "index:10", "menuitem001", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)3L, (long)menu0.getChildren().size());
        Assert.assertEquals((Object)menu00, menu0.getChildren().get(0));
        Assert.assertEquals((Object)menu01, menu0.getChildren().get(1));
        Assert.assertEquals((Object)menu02, menu0.getChildren().get(2));
        Assert.assertEquals((long)2L, (long)menu00.getChildren().size());
        Assert.assertEquals((Object)menuitem000, menu00.getChildren().get(0));
        Assert.assertEquals((Object)menuitem001, menu00.getChildren().get(1));
    }

    @Test
    public void testMenuAndItemsInFragmentsWithImports() {
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MMenu menu0 = MMenuFactory.INSTANCE.createMenu();
        window.setMainMenu(menu0);
        menu0.setElementId("menu0");
        HashSet<ModelFragmentWrapper> fragmentList = new HashSet<ModelFragmentWrapper>();
        MMenu menu00 = MMenuFactory.INSTANCE.createMenu();
        menu00.setElementId("menu00");
        MMenu menu01 = MMenuFactory.INSTANCE.createMenu();
        menu01.setElementId("menu01");
        MMenu menu02 = MMenuFactory.INSTANCE.createMenu();
        menu02.setElementId("menu02");
        MHandledMenuItem menuitem000 = MMenuFactory.INSTANCE.createHandledMenuItem();
        menuitem000.setElementId("menuitem000");
        MHandledMenuItem menuitem001 = MMenuFactory.INSTANCE.createHandledMenuItem();
        menuitem001.setElementId("menuitem001");
        MHandledMenuItem menuitem002 = MMenuFactory.INSTANCE.createHandledMenuItem();
        menuitem002.setElementId("menuitem002");
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri1"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        ModelFragmentWrapper fragmentWrapperMenuItem000 = this.createFragmentWrapper(fragmentsContainer, "children", "menu00", Arrays.asList(menuitem000), "index:0", "fragment1", contributorURI, false);
        fragmentList.add(fragmentWrapperMenuItem000);
        ModelFragmentWrapper fragmentWrapperMenuItem002 = this.createFragmentWrapper(fragmentsContainer, "children", "menu00", Arrays.asList(menuitem002), "index:20", "fragment1", contributorURI, false);
        fragmentList.add(fragmentWrapperMenuItem002);
        ModelFragmentWrapper fragmentWrapperMenu01 = this.createFragmentWrapper(fragmentsContainer, "children", "menu0", Arrays.asList(menu01), "index:10", "fragment1", contributorURI, false);
        fragmentList.add(fragmentWrapperMenu01);
        fragmentsContainer.getImports().add(menu00);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri2"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        ModelFragmentWrapper fragmentWrapperMenu00 = this.createFragmentWrapper(fragmentsContainer, "children", "menu0", Arrays.asList(menu00), "index:1", "fragment2", contributorURI, false);
        fragmentList.add(fragmentWrapperMenu00);
        ModelFragmentWrapper fragmentWrapperMenu02 = this.createFragmentWrapper(fragmentsContainer, "children", "menu0", Arrays.asList(menu02), "index:20", "fragment2", contributorURI, false);
        fragmentList.add(fragmentWrapperMenu02);
        ModelFragmentWrapper fragmentWrapperMenuItem001 = this.createFragmentWrapper(fragmentsContainer, "children", "menu00", Arrays.asList(menuitem001), "index:3", "fragment2", contributorURI, false);
        fragmentList.add(fragmentWrapperMenuItem001);
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)3L, (long)menu0.getChildren().size());
        Assert.assertEquals((Object)menu00, menu0.getChildren().get(0));
        Assert.assertEquals((Object)menu01, menu0.getChildren().get(1));
        Assert.assertEquals((Object)menu02, menu0.getChildren().get(2));
        Assert.assertEquals((long)3L, (long)menu00.getChildren().size());
        Assert.assertEquals((Object)menuitem000, menu00.getChildren().get(0));
        Assert.assertEquals((Object)menuitem001, menu00.getChildren().get(1));
        Assert.assertEquals((Object)menuitem002, menu00.getChildren().get(2));
    }

    @Test
    public void testMenuAndItemsInFragments2() {
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        window.setMainMenu(menu);
        menu.setElementId("menu");
        HashSet<ModelFragmentWrapper> fragmentList = new HashSet<ModelFragmentWrapper>();
        MMenu menu1 = MMenuFactory.INSTANCE.createMenu();
        menu1.setElementId("menu1");
        MMenu menu2 = MMenuFactory.INSTANCE.createMenu();
        menu2.setElementId("menu2");
        MMenu menu3 = MMenuFactory.INSTANCE.createMenu();
        menu3.setElementId("menu3");
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri3"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu2", Arrays.asList(menu3), "index:0", "menu3", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri1"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu", Arrays.asList(menu1), "index:10", "menu1", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri2"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu1", Arrays.asList(menu2), "index:20", "menu2", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)1L, (long)menu.getChildren().size());
        Assert.assertEquals((Object)menu1, menu.getChildren().get(0));
        Assert.assertEquals((Object)menu2, menu1.getChildren().get(0));
        Assert.assertEquals((Object)menu3, menu2.getChildren().get(0));
    }

    @Test
    public void testMenuAndItemsInFragments3() {
        MWindow window = (MWindow)this.application.getChildren().get(0);
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        window.setMainMenu(menu);
        menu.setElementId("menu");
        HashSet<ModelFragmentWrapper> fragmentList = new HashSet<ModelFragmentWrapper>();
        MMenu menu1 = MMenuFactory.INSTANCE.createMenu();
        menu1.setElementId("menu1");
        MMenu menu2 = MMenuFactory.INSTANCE.createMenu();
        menu2.setElementId("menu2");
        MMenu menu3 = MMenuFactory.INSTANCE.createMenu();
        menu3.setElementId("menu3");
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri1"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        ModelFragmentWrapper fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu", Arrays.asList(menu1), "index:10", "menu1", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri3"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu2", Arrays.asList(menu3), "index:0", "menu3", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri2"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        contributorURI = fragmentResource.getURI().toString();
        fragmentsContainer = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainer));
        fragmentWrapper = this.createFragmentWrapper(fragmentsContainer, "children", "menu1", Arrays.asList(menu2), "index:20", "menu2", contributorURI, false);
        fragmentList.add(fragmentWrapper);
        this.assembler.processFragmentWrappers(fragmentList);
        Assert.assertEquals((long)1L, (long)menu.getChildren().size());
        Assert.assertEquals((Object)menu1, menu.getChildren().get(0));
        Assert.assertEquals((Object)menu2, menu1.getChildren().get(0));
        Assert.assertEquals((Object)menu3, menu2.getChildren().get(0));
    }

    @Test
    public void testModelFragmentComparatorWithCorrectlySortedList() {
        MHandledToolItem x = MMenuFactory.INSTANCE.createHandledToolItem();
        x.setElementId("x");
        this.toolBar.getChildren().add(x);
        MHandledToolItem y = MMenuFactory.INSTANCE.createHandledToolItem();
        y.setElementId("y");
        this.toolBar.getChildren().add(y);
        MHandledToolItem z = MMenuFactory.INSTANCE.createHandledToolItem();
        z.setElementId("z");
        this.toolBar.getChildren().add(z);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        String contributorURI = fragmentResource.getURI().toString();
        MModelFragments fragmentsContainerA = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerA));
        MHandledToolItem a = MMenuFactory.INSTANCE.createHandledToolItem();
        a.setElementId("a");
        MModelFragments fragmentsContainerB = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerB));
        MHandledToolItem b = MMenuFactory.INSTANCE.createHandledToolItem();
        b.setElementId("b");
        MModelFragments fragmentsContainerC = MFragmentFactory.INSTANCE.createModelFragments();
        fragmentResource.getContents().add((Object)((EObject)fragmentsContainerC));
        MHandledToolItem c = MMenuFactory.INSTANCE.createHandledToolItem();
        c.setElementId("c");
        ModelFragmentWrapper fragmentWrapper1 = this.createFragmentWrapper(fragmentsContainerA, "children", MAIN_TOOLBAR_ID, Arrays.asList(a), "after:b", "testAfterFragmentReference3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper2 = this.createFragmentWrapper(fragmentsContainerB, "children", MAIN_TOOLBAR_ID, Arrays.asList(b), "after:c", "testAfterFragmentReference3", contributorURI, false);
        ModelFragmentWrapper fragmentWrapper3 = this.createFragmentWrapper(fragmentsContainerC, "children", MAIN_TOOLBAR_ID, Arrays.asList(c), "after:y", "testAfterFragmentReference3", contributorURI, false);
        TreeSet<ModelFragmentWrapper> fragmentList = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList.addAll(Arrays.asList(fragmentWrapper1, fragmentWrapper2, fragmentWrapper3));
        Iterator iterator = fragmentList.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator.next());
        TreeSet<ModelFragmentWrapper> fragmentList2 = new TreeSet<ModelFragmentWrapper>((Comparator<ModelFragmentWrapper>)new ModelFragmentComparator(this.application));
        fragmentList2.addAll(fragmentList);
        Iterator iterator2 = fragmentList2.iterator();
        Assert.assertEquals((Object)fragmentWrapper3, iterator2.next());
        Assert.assertEquals((Object)fragmentWrapper2, iterator2.next());
        Assert.assertEquals((Object)fragmentWrapper1, iterator2.next());
    }
}

