/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewMWindowTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    @Test
    public void testCreateWindow() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setLabel("MyWindow");
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Assert.assertEquals((Object)"MyWindow", (Object)((Shell)topWidget).getText());
        Assert.assertEquals((Object)topWidget, (Object)this.appContext.get("activeShell"));
    }

    @Test
    public void testCreateView() {
        MWindow window = this.createWindowWithOneView();
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Assert.assertEquals((Object)"MyWindow", (Object)shell.getText());
        Control[] controls = shell.getChildren();
        Assert.assertEquals((long)1L, (long)controls.length);
        SashForm sash = (SashForm)controls[0];
        Control[] sashChildren = sash.getChildren();
        Assert.assertEquals((long)1L, (long)sashChildren.length);
        CTabFolder folder = (CTabFolder)sashChildren[0];
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        Control c = folder.getItem(0).getControl();
        Assert.assertTrue((boolean)(c instanceof Composite));
        Control[] viewPart = ((Composite)c).getChildren();
        Assert.assertEquals((long)1L, (long)viewPart.length);
        Assert.assertTrue((boolean)(viewPart[0] instanceof Tree));
    }

    @Test
    public void testContextChildren() {
        MWindow window = this.createWindowWithOneView();
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Assert.assertEquals((Object)"MyWindow", (Object)shell.getText());
        IEclipseContext child = this.appContext.getActiveChild();
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)window.getContext(), (Object)child);
        MPart modelPart = this.getContributedPart(window);
        Assert.assertNotNull((Object)modelPart);
        Assert.assertEquals((Object)window, (Object)modelPart.getParent().getParent().getParent());
        AbstractPartRenderer factory = (AbstractPartRenderer)modelPart.getRenderer();
        factory.activate(modelPart);
        IEclipseContext next = child.getActiveChild();
        while (next != null) {
            child = next;
            if ((next = child.getActiveChild()) != child) continue;
            Assert.fail((String)"Cycle detected in part context");
            break;
        }
        Assert.assertFalse((window.getContext() == child ? 1 : 0) != 0);
        MPart contextPart = (MPart)child.get(MPart.class);
        Assert.assertNotNull((Object)contextPart);
        Assert.assertEquals((Object)window, (Object)contextPart.getParent().getParent().getParent());
    }

    @Test
    public void testCreateMenu() {
        MWindow window = this.createWindowWithOneViewAndMenu();
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Menu menuBar = shell.getMenuBar();
        Assert.assertNotNull((Object)menuBar);
        Assert.assertEquals((long)1L, (long)menuBar.getItemCount());
        MenuItem fileItem = menuBar.getItem(0);
        Assert.assertEquals((Object)"File", (Object)fileItem.getText());
        Menu fileMenu = fileItem.getMenu();
        fileMenu.notifyListeners(22, null);
        Assert.assertEquals((long)2L, (long)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        MMenu mainMenu = window.getMainMenu();
        MMenu modelFileMenu = (MMenu)mainMenu.getChildren().get(0);
        MMenuItem item2Model = (MMenuItem)modelFileMenu.getChildren().get(0);
        item2Model.setToBeRendered(false);
        fileMenu.notifyListeners(22, null);
        Assert.assertEquals((long)1L, (long)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        item2Model.setToBeRendered(true);
        fileMenu.notifyListeners(22, null);
        Assert.assertEquals((long)2L, (long)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
    }

    private MPart getContributedPart(MWindow window) {
        MPartSashContainer psc = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)psc.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        return part;
    }

    private MWindow createWindowWithOneView() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sash);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        MPart contributedPart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel("Sample View");
        contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    private MWindow createWindowWithOneViewAndMenu() {
        MWindow window = this.createWindowWithOneView();
        MMenu menuBar = (MMenu)this.ems.createModelElement(MMenu.class);
        window.setMainMenu(menuBar);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setLabel("File");
        fileMenu.setElementId("file");
        menuBar.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        return window;
    }
}

