/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.tests.workbench.PartBackend;
import org.eclipse.e4.ui.tests.workbench.TextField;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.FrameworkUtil;

public class PartFocusTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    protected EPartService eps;
    protected MWindow window;
    protected MPart part;
    protected MToolControl toolControl;
    protected MPart otherPart;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
        this.window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.window.setWidth(500);
        this.window.setHeight(500);
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        this.window.getChildren().add(sash);
        this.window.setSelectedElement((MUIElement)sash);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        sash.setSelectedElement((MUIElement)stack);
        this.part = (MPart)this.ems.createModelElement(MPart.class);
        this.part.setElementId("Part");
        this.part.setLabel("Part");
        this.part.setToolbar((MToolBar)this.ems.createModelElement(MToolBar.class));
        this.part.setContributionURI(PartFocusTest.asURI(PartBackend.class));
        stack.getChildren().add(this.part);
        this.toolControl = (MToolControl)this.ems.createModelElement(MToolControl.class);
        this.toolControl.setElementId("ToolControl");
        this.toolControl.setContributionURI(PartFocusTest.asURI(TextField.class));
        this.part.getToolbar().getChildren().add(this.toolControl);
        stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        sash.setSelectedElement((MUIElement)stack);
        this.otherPart = (MPart)this.ems.createModelElement(MPart.class);
        this.otherPart.setElementId("OtherPart");
        this.otherPart.setLabel("OtherPart");
        this.otherPart.setContributionURI(PartFocusTest.asURI(PartBackend.class));
        stack.getChildren().add(this.otherPart);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(this.window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)this.window);
        this.eps = (EPartService)this.window.getContext().get(EPartService.class);
        this.eps.activate(this.part);
        this.eps.activate(this.otherPart);
        this.processEvents();
        Assert.assertNotNull((Object)this.part.getObject());
        Assert.assertNotNull((Object)this.toolControl.getObject());
        Assert.assertNotNull((Object)this.otherPart.getObject());
        Assert.assertNotNull((Object)this.part.getWidget());
        Assert.assertNotNull((Object)this.toolControl.getWidget());
        Assert.assertNotNull((Object)this.otherPart.getWidget());
        this.eps.activate(this.otherPart);
        this.processEvents();
        Assert.assertTrue((boolean)((PartBackend)this.otherPart.getObject()).text1.isFocusControl());
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    /*
     * Exception decompiling
     */
    private void processEvents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testFocusChangesOnExplicitPartActivation() {
        Assert.assertFalse((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
        this.eps.activate(this.part);
        this.processEvents();
        Assert.assertTrue((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
    }

    @Ignore
    @Test
    public void XXXtestNoFocusChangeOnExplicitWidgetSelection() {
        Assert.assertFalse((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
        ((TextField)this.toolControl.getObject()).text.setFocus();
        this.processEvents();
        Assert.assertEquals((Object)this.part.getElementId(), (Object)this.eps.getActivePart().getElementId());
        Assert.assertFalse((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
        Assert.assertTrue((boolean)((TextField)this.toolControl.getObject()).text.isFocusControl());
    }

    @Test
    public void testNoActivationOnExplicitInPartWidgetSelection() {
        Assert.assertTrue((this.eps.getActivePart() == this.otherPart ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((PartBackend)this.otherPart.getObject()).text1.isFocusControl());
        final boolean[] changed = new boolean[1];
        this.eps.addPartListener(new IPartListener(){

            public void partVisible(MPart part) {
                changed[0] = true;
            }

            public void partHidden(MPart part) {
                changed[0] = true;
            }

            public void partDeactivated(MPart part) {
                changed[0] = true;
            }

            public void partBroughtToTop(MPart part) {
                changed[0] = true;
            }

            public void partActivated(MPart part) {
                changed[0] = true;
            }
        });
        ((PartBackend)this.otherPart.getObject()).text2.setFocus();
        this.processEvents();
        Assert.assertTrue((boolean)((PartBackend)this.otherPart.getObject()).text2.isFocusControl());
        Assert.assertFalse((boolean)changed[0]);
    }

    private static String asURI(Class<?> clazz) {
        return "bundleclass://" + FrameworkUtil.getBundle(clazz).getSymbolicName() + '/' + clazz.getName();
    }
}

