/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class PartOnTopManagerTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;
    private boolean logged = false;
    private LogListener listener = new LogListener(){

        public void logged(LogEntry entry) {
            if (!PartOnTopManagerTest.this.logged) {
                PartOnTopManagerTest.this.logged = entry.getLevel() == 1;
            }
        }
    };

    @Before
    public void setUp() {
        this.logged = false;
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        final Display d = Display.getDefault();
        this.appContext.set(Realm.class, (Object)DisplayRealm.getRealm((Display)d));
        this.appContext.set(UISynchronize.class, (Object)new UISynchronize(){

            public void syncExec(Runnable runnable) {
                d.syncExec(runnable);
            }

            public void asyncExec(Runnable runnable) {
                d.asyncExec(runnable);
            }
        });
        LogReaderService logReaderService = (LogReaderService)this.appContext.get(LogReaderService.class);
        logReaderService.addLogListener(this.listener);
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() {
        LogReaderService logReaderService = (LogReaderService)this.appContext.get(LogReaderService.class);
        logReaderService.removeLogListener(this.listener);
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    private boolean isPartOnTop(MContext context) {
        if (context.getContext() != null) {
            Object object = context.getContext().get("elementOnTop");
            return Boolean.TRUE.equals(object);
        }
        return false;
    }

    @Test
    public void test_PartOnTop() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
    }

    @Test
    public void test_PlaceholderOnTop() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
    }

    @Test
    public void test_PartOnTopStackSwitch() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        partStack.setSelectedElement((MUIElement)part);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(secondPart);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        partStack.setSelectedElement((MUIElement)secondPart);
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)part));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPart));
    }

    @Test
    public void test_PlaceholderOnTopStackSwitch() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        partStack.getChildren().add(placeholder);
        partStack.setSelectedElement((MUIElement)placeholder);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(secondPart);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        partStack.setSelectedElement((MUIElement)secondPart);
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)part));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPart));
        partStack.setSelectedElement((MUIElement)placeholder);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
    }

    @Test
    public void test_PartOnTopPerspectiveSwitch() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPerspective secondPerspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(secondPerspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        partStack.setSelectedElement((MUIElement)part);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(secondPart);
        MPart secondPerspectivePart = (MPart)this.ems.createModelElement(MPart.class);
        secondPerspectivePart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        secondPerspective.getChildren().add(secondPerspectivePart);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(secondPerspective);
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPerspectivePart));
    }

    @Test
    public void test_PlaceholderOnTopPerspectiveSwitch() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart sharedPart = (MPart)this.ems.createModelElement(MPart.class);
        sharedPart.setElementId("sharedPart");
        sharedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(sharedPart);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective firstPerspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(firstPerspective);
        perspectiveStack.setSelectedElement((MUIElement)firstPerspective);
        MPlaceholder firstPerspectivePlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        firstPerspectivePlaceholder.setElementId("firstPerspectivePlaceholder");
        firstPerspectivePlaceholder.setRef((MUIElement)sharedPart);
        firstPerspective.getChildren().add(firstPerspectivePlaceholder);
        MPerspective secondPerspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(secondPerspective);
        MPartSashContainer secondPerspectiveSash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        secondPerspective.getChildren().add(secondPerspectiveSash);
        secondPerspective.setSelectedElement((MUIElement)secondPerspectiveSash);
        MPartStack secondPerspectivePartStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        secondPerspectiveSash.getChildren().add(secondPerspectivePartStack);
        secondPerspectiveSash.setSelectedElement((MUIElement)secondPerspectivePartStack);
        MPlaceholder secondPerspectivePartStackPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        secondPerspectivePartStackPlaceholder.setElementId("secondPerspectivePartStackPlaceholder");
        secondPerspectivePartStackPlaceholder.setRef((MUIElement)sharedPart);
        secondPerspectivePartStack.getChildren().add(secondPerspectivePartStackPlaceholder);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setElementId("secondPart");
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        secondPerspectivePartStack.getChildren().add(secondPart);
        secondPerspectivePartStack.setSelectedElement((MUIElement)secondPart);
        MPart secondPerspectiveOnTopPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPerspectiveOnTopPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        secondPerspectiveSash.getChildren().add(secondPerspectiveOnTopPart);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(secondPerspective);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        secondPerspectivePartStack.setSelectedElement((MUIElement)secondPerspectivePartStackPlaceholder);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
        partService.switchPerspective(firstPerspective);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
    }
}

