/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StackRendererTest {
    private IEclipseContext context;
    private E4Workbench wb;
    private MPart part;
    private CTabItemStylingMethodsListener executedMethodsListener;
    private MPartStack partStack;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.context = E4Application.createDefaultContext();
        this.context.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.context.get(EModelService.class);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        this.part = (MPart)this.ems.createModelElement(MPart.class);
        this.part.setLabel("some title");
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        window.getChildren().add(this.partStack);
        this.partStack.getChildren().add(this.part);
        application.setContext(this.context);
        this.context.set(MApplication.class, (Object)application);
        this.executedMethodsListener = new CTabItemStylingMethodsListener(this.part);
        this.wb = new E4Workbench((MApplicationElement)application, this.context);
        this.wb.getContext().set(IStylingEngine.class, (Object)((IStylingEngine)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IStylingEngine.class}, (InvocationHandler)this.executedMethodsListener)));
        this.wb.createAndRunUI((MApplicationElement)window);
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.context.dispose();
    }

    @Test
    public void testTabStateHandlerWhenOneOfSupportedTagChangeEvents() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ChangedElement", this.part);
        params.put("NewValue", "busy");
        params.put("OldValue", null);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*".replace("*", "SET"), params);
        Assert.assertEquals((long)1L, (long)this.executedMethodsListener.getMethodExecutionCount("setClassnameAndId(.+)"));
    }

    @Test
    public void testTabStateHandlerWhenSelectionChangedEvent() throws Exception {
        MPlaceholder placeHolder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeHolder.setRef((MUIElement)this.part);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ChangedElement", this.partStack);
        params.put("NewValue", placeHolder);
        params.put("OldValue", null);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*".replace("*", "SET"), params);
        Assert.assertEquals((long)1L, (long)this.executedMethodsListener.getMethodExecutionCount("setClassnameAndId(.+)"));
    }

    private static class CTabItemStylingMethodsListener
    implements InvocationHandler {
        private MPart part;
        private List<String> methods;

        public CTabItemStylingMethodsListener(MPart part) {
            this.part = part;
            this.methods = new ArrayList<String>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.isTabItemForPart(args[0])) {
                this.methods.add(String.format("%s(%s)", method.getName(), Arrays.toString(args)));
            }
            return null;
        }

        private boolean isTabItemForPart(Object obj) {
            return obj instanceof CTabItem && this.part.getLabel().equals(((CTabItem)obj).getText());
        }

        public int getMethodExecutionCount(String methodPattern) {
            int result = 0;
            for (String method : this.methods) {
                if (!method.matches(methodPattern)) continue;
                ++result;
            }
            return result;
        }
    }
}

