/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.event.Event;

public class TabStateHandlerTest {
    private StackRendererTestable renderer;
    private StackRenderer.TabStateHandler handler;
    private Shell shell;

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell();
        this.renderer = new StackRendererTestable();
        this.handler = new StackRenderer.TabStateHandler((StackRenderer)this.renderer);
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
    }

    @Test
    public void testValidateElement() throws Exception {
        Assert.assertTrue((boolean)this.handler.validateElement((Object)MBasicFactory.INSTANCE.createPart()));
        Assert.assertTrue((boolean)this.handler.validateElement((Object)MBasicFactory.INSTANCE.createPartStack()));
    }

    @Test
    public void testValidateElementWhenInvalidElement() throws Exception {
        Assert.assertFalse((boolean)this.handler.validateElement((Object)MBasicFactory.INSTANCE.createTrimBar()));
        Assert.assertFalse((boolean)this.handler.validateElement(null));
    }

    @Test
    public void testValidateValues() throws Exception {
        Assert.assertTrue((boolean)this.handler.validateValues(null, (Object)this.placeHolder(MBasicFactory.INSTANCE.createPart())));
        Assert.assertTrue((boolean)this.handler.validateValues(null, (Object)"busy"));
        Assert.assertTrue((boolean)this.handler.validateValues((Object)"busy", null));
        Assert.assertTrue((boolean)this.handler.validateValues(null, (Object)"contentChange"));
    }

    @Test
    public void testValidateValuesWhenInvalidValue() throws Exception {
        Assert.assertFalse((boolean)this.handler.validateValues(null, (Object)MBasicFactory.INSTANCE.createPart()));
        Assert.assertFalse((boolean)this.handler.validateValues(null, (Object)"new not supported tag"));
    }

    @Test
    public void testHandleEventWhenTabBusyEvent() throws Exception {
        CTabItem tabItem;
        MPart part = MBasicFactory.INSTANCE.createPart();
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 0);
        this.renderer.tabItemForPart = tabItem = new CTabItem(tabFolder, 0);
        this.handler.handleEvent(this.event(new EventParam("ChangedElement", part), new EventParam("NewValue", "busy"), new EventParam("OldValue", null)));
        Assert.assertEquals((long)0L, (long)part.getTags().size());
        Assert.assertTrue((boolean)this.renderer.setCSSInfoExecuted);
        Assert.assertTrue((boolean)this.renderer.reapplyStylesExecuted);
        tabItem.dispose();
        tabFolder.dispose();
    }

    @Test
    public void testHandleEventWhenTabIdleEvent() throws Exception {
        CTabItem tabItem;
        MPart part = MBasicFactory.INSTANCE.createPart();
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 0);
        this.renderer.tabItemForPart = tabItem = new CTabItem(tabFolder, 0);
        this.handler.handleEvent(this.event(new EventParam("ChangedElement", part), new EventParam("NewValue", null), new EventParam("OldValue", "busy")));
        Assert.assertEquals((long)0L, (long)part.getTags().size());
        Assert.assertTrue((boolean)this.renderer.setCSSInfoExecuted);
        Assert.assertTrue((boolean)this.renderer.reapplyStylesExecuted);
        tabItem.dispose();
        tabFolder.dispose();
    }

    @Test
    public void testHandleEventWhenTabContentChangedEventAndTabInactive() throws Exception {
        MPart part = MBasicFactory.INSTANCE.createPart();
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 0);
        CTabItem tabItem1 = new CTabItem(tabFolder, 0);
        CTabItem tabItem2 = new CTabItem(tabFolder, 0);
        part.getTags().add("contentChange");
        tabFolder.setSelection(tabItem2);
        this.renderer.tabItemForPart = tabItem1;
        this.handler.handleEvent(this.event(new EventParam("ChangedElement", part), new EventParam("NewValue", "contentChange"), new EventParam("OldValue", null)));
        Assert.assertTrue((boolean)part.getTags().contains("highlighted"));
        Assert.assertFalse((boolean)part.getTags().contains("contentChange"));
        Assert.assertTrue((boolean)this.renderer.setCSSInfoExecuted);
        Assert.assertTrue((boolean)this.renderer.reapplyStylesExecuted);
        tabItem1.dispose();
        tabItem2.dispose();
        tabFolder.dispose();
    }

    @Test
    public void testHandleEventWhenTabContentChangedEventAndTabActive() throws Exception {
        MPart part = MBasicFactory.INSTANCE.createPart();
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 0);
        CTabItem tabItem1 = new CTabItem(tabFolder, 0);
        CTabItem tabItem2 = new CTabItem(tabFolder, 0);
        part.getTags().add("contentChange");
        tabFolder.setSelection(tabItem1);
        this.renderer.tabItemForPart = tabItem1;
        this.handler.handleEvent(this.event(new EventParam("ChangedElement", part), new EventParam("NewValue", "contentChange"), new EventParam("OldValue", null)));
        Assert.assertFalse((boolean)part.getTags().contains("highlighted"));
        Assert.assertFalse((boolean)part.getTags().contains("contentChange"));
        Assert.assertTrue((boolean)this.renderer.setCSSInfoExecuted);
        Assert.assertTrue((boolean)this.renderer.reapplyStylesExecuted);
        tabItem1.dispose();
        tabItem2.dispose();
        tabFolder.dispose();
    }

    @Test
    public void testHandleEventWhenTabActivateEventAndItsContentChanged() throws Exception {
        MPart part = MBasicFactory.INSTANCE.createPart();
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 0);
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        part.getTags().add("highlighted");
        this.renderer.tabItemForPart = tabItem;
        this.handler.handleEvent(this.event(new EventParam("ChangedElement", part), new EventParam("NewValue", this.placeHolder(part)), new EventParam("OldValue", null)));
        Assert.assertFalse((boolean)part.getTags().contains("highlighted"));
        Assert.assertTrue((boolean)this.renderer.setCSSInfoExecuted);
        Assert.assertTrue((boolean)this.renderer.reapplyStylesExecuted);
        tabItem.dispose();
        tabFolder.dispose();
    }

    @Test
    public void testHandleEventWhenTabActivateEventAndTabItemForPartNotFound() throws Exception {
        MPart part = MBasicFactory.INSTANCE.createPart();
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 0);
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        part.getTags().add("highlighted");
        this.renderer.tabItemForPart = null;
        this.handler.handleEvent(this.event(new EventParam("ChangedElement", part), new EventParam("NewValue", this.placeHolder(part)), new EventParam("OldValue", null)));
        Assert.assertTrue((boolean)part.getTags().contains("highlighted"));
        Assert.assertFalse((boolean)this.renderer.setCSSInfoExecuted);
        Assert.assertFalse((boolean)this.renderer.reapplyStylesExecuted);
        tabItem.dispose();
        tabFolder.dispose();
    }

    private MPlaceholder placeHolder(final MPart part) {
        return (MPlaceholder)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MPlaceholder.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, Method method, Object[] arg2) throws Throwable {
                if ("getRef".equals(method.getName())) {
                    return part;
                }
                return null;
            }
        });
    }

    private Event event(EventParam ... params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        EventParam[] eventParamArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            EventParam param = eventParamArray[n2];
            paramsMap.put(param.getKey(), param.getValue());
            ++n2;
        }
        return new Event("topic", paramsMap);
    }

    private class EventParam
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        public EventParam(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object arg0) {
            return null;
        }
    }

    private static class StackRendererTestable
    extends StackRenderer {
        boolean setCSSInfoExecuted;
        boolean reapplyStylesExecuted;
        CTabItem tabItemForPart;

        private StackRendererTestable() {
        }

        public void setCSSInfo(MUIElement me, Object widget) {
            this.setCSSInfoExecuted = true;
        }

        protected void reapplyStyles(Widget widget) {
            this.reapplyStylesExecuted = true;
        }

        public CTabItem findItemForPart(MPart part) {
            return this.tabItemForPart;
        }
    }
}

