/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.tests;

import org.eclipse.equinox.bidi.internal.StructuredTextStringRecord;
import org.eclipse.equinox.bidi.internal.tests.StructuredTextTestBase;
import org.junit.Assert;
import org.junit.Test;

public class StructuredTextStringRecordTest
extends StructuredTextTestBase {
    @Test
    public void testStringRecord() {
        String str;
        StructuredTextStringRecord sr;
        boolean catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord(null, (int)1, (String)"email", (int)0, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch null string argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, null, (int)0, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch null handler argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)0, (String)"email", (int)0, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch invalid segment count argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)-1, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch invalid start argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)4, (int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch invalid start argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)0, (int)0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch invalid limit argument", (boolean)catchFlag);
        catchFlag = false;
        try {
            sr = StructuredTextStringRecord.addRecord((String)"abc", (int)1, (String)"email", (int)0, (int)5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch invalid limit argument", (boolean)catchFlag);
        int poolSize = 100;
        int lim = poolSize / 2;
        sr = StructuredTextStringRecord.getRecord((String)"XXX");
        Assert.assertEquals(null, (Object)sr);
        int i = 0;
        while (i < lim) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.addRecord((String)str, (int)1, (String)"email", (int)0, (int)1);
            ++i;
        }
        sr = StructuredTextStringRecord.getRecord(null);
        Assert.assertEquals(null, (Object)sr);
        sr = StructuredTextStringRecord.getRecord((String)"");
        Assert.assertEquals(null, (Object)sr);
        i = 0;
        while (i < poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.getRecord((String)str);
            if (i < lim) {
                Assert.assertFalse((sr == null ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((sr == null ? 1 : 0) != 0);
            }
            ++i;
        }
        i = lim;
        while (i <= poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.addRecord((String)str, (int)1, (String)"email", (int)0, (int)1);
            ++i;
        }
        i = 1;
        while (i <= poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.getRecord((String)str);
            Assert.assertFalse((sr == null ? 1 : 0) != 0);
            ++i;
        }
        sr = StructuredTextStringRecord.getRecord((String)"0");
        Assert.assertEquals(null, (Object)sr);
        sr = StructuredTextStringRecord.addRecord((String)"thisisalongstring", (int)3, (String)"email", (int)0, (int)2);
        sr.addSegment("java", 4, 5);
        sr.addSegment("file", 6, 7);
        catchFlag = false;
        try {
            sr.addSegment("email", 10, 13);
        }
        catch (IllegalStateException illegalStateException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch too many segments", (boolean)catchFlag);
        Assert.assertEquals((long)3L, (long)sr.getSegmentCount());
        Assert.assertEquals((Object)"email", (Object)sr.getHandler(0));
        Assert.assertEquals((Object)"java", (Object)sr.getHandler(1));
        Assert.assertEquals((Object)"file", (Object)sr.getHandler(2));
        Assert.assertEquals((long)0L, (long)sr.getStart(0));
        Assert.assertEquals((long)4L, (long)sr.getStart(1));
        Assert.assertEquals((long)6L, (long)sr.getStart(2));
        Assert.assertEquals((long)2L, (long)sr.getLimit(0));
        Assert.assertEquals((long)5L, (long)sr.getLimit(1));
        Assert.assertEquals((long)7L, (long)sr.getLimit(2));
        catchFlag = false;
        try {
            sr.getLimit(3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            catchFlag = true;
        }
        Assert.assertTrue((String)"Catch segment number too large", (boolean)catchFlag);
        StructuredTextStringRecord.clear();
        i = 0;
        while (i <= poolSize) {
            str = Integer.toString(i);
            sr = StructuredTextStringRecord.getRecord((String)str);
            Assert.assertEquals(null, (Object)sr);
            ++i;
        }
    }
}

