/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.tests.tbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.eclipse.equinox.ds.tests.BundleInstaller;
import org.eclipse.equinox.ds.tests.DSTestsActivator;
import org.eclipse.equinox.ds.tests.tbc.BoundCountProvider;
import org.eclipse.equinox.ds.tests.tbc.BoundMainProvider;
import org.eclipse.equinox.ds.tests.tbc.BoundTester;
import org.eclipse.equinox.ds.tests.tbc.BundleContextProvider;
import org.eclipse.equinox.ds.tests.tbc.ComponentContextProvider;
import org.eclipse.equinox.ds.tests.tbc.ComponentManager;
import org.eclipse.equinox.ds.tests.tbc.DSEvent;
import org.eclipse.equinox.ds.tests.tbc.DSEventsProvider;
import org.eclipse.equinox.ds.tests.tbc.DefaultPropertiesProvider;
import org.eclipse.equinox.ds.tests.tbc.DynamicWorker;
import org.eclipse.equinox.ds.tests.tbc.NamespaceProvider;
import org.eclipse.equinox.ds.tests.tbc.PropertiesProvider;
import org.eclipse.equinox.ds.tests.tbc.StaticWorker;
import org.eclipse.equinox.ds.tests.tbc.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;
import org.osgi.util.tracker.ServiceTracker;

public class DSTest {
    private static final String NAMED_CLASS = "org.eclipse.equinox.ds.tests.tb4.NamedService";
    private static final String EXTENDED_CLASS = "org.eclipse.equinox.ds.tests.tb1.BindUnbindSuccessor";
    private static final String SAC_CLASS = "org.eclipse.equinox.ds.tests.tb1.impl.AnotherComponent";
    private static final String SC_CLASS = "org.eclipse.equinox.ds.tests.tb1.impl.BaseComp";
    private static final String DYN_SERVICE_CLASS = "org.eclipse.equinox.ds.tests.tb4.DynamicService";
    private static final String BSRC_CLASS = "org.eclipse.equinox.ds.tests.tb4.BoundReplacer";
    private static final String MBSRC_CLASS = "org.eclipse.equinox.ds.tests.tb4.AdvancedBounder";
    private static final String SECURITY_CLASS = "org.eclipse.equinox.ds.tests.tb5.impl.SecurityTester";
    private static final String BLOCK_ACTIVE_CLASS = "org.eclipse.equinox.ds.tests.tb2.impl.Blocker";
    private static final String BLOCK_BIND_CLASS = "org.eclipse.equinox.ds.tests.tb3.impl.BindBlocker";
    private static final String STATIC_CLASS = "org.eclipse.equinox.ds.tests.tb6.StaticComp";
    private static final String REFERENCED_CLASS = "org.eclipse.equinox.ds.tests.tb6.ReferencedComp";
    private static final String NS_CLASS = "org.eclipse.equinox.ds.tests.tbc.NamespaceProvider";
    private static final String COMP_OPTIONAL_100 = "org.eclipse.equinox.ds.tests.tb11.optionalNS100";
    private static final String COMP_OPTIONAL_110 = "org.eclipse.equinox.ds.tests.tb11.optionalNS110";
    private static final String COMP_REQUIRE_100 = "org.eclipse.equinox.ds.tests.tb11.requireNS100";
    private static final String COMP_REQUIRE_110 = "org.eclipse.equinox.ds.tests.tb11.requireNS110";
    private static final String COMP_IGNORE_100 = "org.eclipse.equinox.ds.tests.tb11.ignoreNS100";
    private static final String COMP_IGNORE_110 = "org.eclipse.equinox.ds.tests.tb11.ignoreNS110";
    private static final String COMP_NOTSET_100 = "org.eclipse.equinox.ds.tests.tb11.notsetNS100";
    private static final String COMP_NOTSET_110 = "org.eclipse.equinox.ds.tests.tb11.notsetNS110";
    private static final String MOD_NOTSET_NS100 = "org.eclipse.equinox.ds.tests.tb21.notsetNS100";
    private static final String MOD_NOTSET_NS110 = "org.eclipse.equinox.ds.tests.tb21.notsetNS110";
    private static final String MOD_NOARGS_NS100 = "org.eclipse.equinox.ds.tests.tb21.NoArgs100";
    private static final String MOD_NOARGS_NS110 = "org.eclipse.equinox.ds.tests.tb21.NoArgs110";
    private static final String MOD_CC_NS100 = "org.eclipse.equinox.ds.tests.tb21.CcNS100";
    private static final String MOD_CC_NS110 = "org.eclipse.equinox.ds.tests.tb21.CcNS110";
    private static final String MOD_BC_NS100 = "org.eclipse.equinox.ds.tests.tb21.BcNS100";
    private static final String MOD_BC_NS110 = "org.eclipse.equinox.ds.tests.tb21.BcNS110";
    private static final String MOD_MAP_NS100 = "org.eclipse.equinox.ds.tests.tb21.MapNS100";
    private static final String MOD_MAP_NS110 = "org.eclipse.equinox.ds.tests.tb21.MapNS110";
    private static final String MOD_CC_BC_MAP_NS100 = "org.eclipse.equinox.ds.tests.tb21.CcBcMapNS100";
    private static final String MOD_CC_BC_MAP_NS110 = "org.eclipse.equinox.ds.tests.tb21.CcBcMapNS110";
    private static final String MOD_NOT_EXIST_NS110 = "org.eclipse.equinox.ds.tests.tb21.NotExistNS110";
    private static final String MOD_THROW_EX_NS110 = "org.eclipse.equinox.ds.tests.tb21.ThrowExNS110";
    private static final String COMP_OPTIONAL = "org.eclipse.equinox.ds.tests.tb24.optional";
    private static final String COMP_REQUIRE = "org.eclipse.equinox.ds.tests.tb24.require";
    private static final String COMP_IGNORE = "org.eclipse.equinox.ds.tests.tb24.ignore";
    private static int timeout = 1000;
    private Bundle tb1;
    private ServiceTracker trackerNamedService;
    private ServiceTracker trackerNamedServiceFactory;
    private ServiceTracker trackerCM;
    private ServiceTracker trackerExtendedClass;
    private ServiceTracker trackerSAC;
    private ServiceTracker trackerSC;
    private ServiceTracker trackerDynService;
    private ServiceTracker trackerDynServiceFactory;
    private ServiceTracker trackerBSRC;
    private ServiceTracker trackerMBSRC;
    private ServiceTracker trackerSecurity;
    private ServiceTracker trackerBAS;
    private ServiceTracker trackerBBS;
    private ServiceTracker trackerStatic;
    private ServiceTracker trackerReferenced;
    private ServiceTracker trackerNS;
    private ServiceTracker trackerBoundServiceCounterFactory;
    private ServiceTracker trackerBoundServiceCounterHelperFactory;
    private ServiceTracker trackerStaticServiceCounterFactory;
    private ServiceTracker trackerBaseService;
    private Hashtable registeredServices = new Hashtable();
    private int scr_restart_timeout = 33000;
    private boolean synchronousBuild = false;
    private BundleInstaller installer;

    @Before
    public void setUp() throws Exception {
        DSTestsActivator.activateSCR();
        timeout = this.getSystemProperty("scr.test.timeout", timeout);
        this.scr_restart_timeout = this.getSystemProperty("scr.restart.timeout", this.scr_restart_timeout);
        String synchronousBuildProp = System.getProperty("equinox.ds.synchronous_build");
        this.synchronousBuild = synchronousBuildProp == null || !synchronousBuildProp.equalsIgnoreCase("false");
        this.clearConfigurations();
        BundleContext bc = this.getContext();
        this.installer = new BundleInstaller("/scr_test/", bc);
        this.tb1 = this.installBundle("tb1");
        this.tb1.start();
        this.waitBundleStart();
        this.trackerNamedService = new ServiceTracker(bc, NAMED_CLASS, null);
        Filter filter = bc.createFilter("(&(component.factory=org.eclipse.equinox.ds.tests.tb4.NamedService)(objectClass=" + ComponentFactory.class.getName() + "))");
        this.trackerNamedServiceFactory = new ServiceTracker(bc, filter, null);
        this.trackerCM = new ServiceTracker(bc, ConfigurationAdmin.class.getName(), null);
        this.trackerExtendedClass = new ServiceTracker(bc, EXTENDED_CLASS, null);
        this.trackerSAC = new ServiceTracker(bc, SAC_CLASS, null);
        this.trackerSC = new ServiceTracker(bc, SC_CLASS, null);
        this.trackerDynService = new ServiceTracker(bc, DYN_SERVICE_CLASS, null);
        filter = bc.createFilter("(&(component.factory=org.eclipse.equinox.ds.tests.tb4.DynamicService)(objectClass=" + ComponentFactory.class.getName() + "))");
        this.trackerDynServiceFactory = new ServiceTracker(bc, filter, null);
        this.trackerBSRC = new ServiceTracker(bc, BSRC_CLASS, null);
        this.trackerMBSRC = new ServiceTracker(bc, MBSRC_CLASS, null);
        this.trackerSecurity = new ServiceTracker(bc, SECURITY_CLASS, null);
        this.trackerBAS = new ServiceTracker(bc, BLOCK_ACTIVE_CLASS, null);
        this.trackerBBS = new ServiceTracker(bc, BLOCK_BIND_CLASS, null);
        this.trackerStatic = new ServiceTracker(bc, STATIC_CLASS, null);
        this.trackerReferenced = new ServiceTracker(bc, REFERENCED_CLASS, null);
        this.trackerNS = new ServiceTracker(bc, NS_CLASS, null);
        filter = bc.createFilter("(&(component.factory=CountFactory)(objectClass=" + ComponentFactory.class.getName() + "))");
        this.trackerBoundServiceCounterFactory = new ServiceTracker(bc, filter, null);
        filter = bc.createFilter("(&(component.factory=CountHelperFactory)(objectClass=" + ComponentFactory.class.getName() + "))");
        this.trackerBoundServiceCounterHelperFactory = new ServiceTracker(bc, filter, null);
        filter = bc.createFilter("(&(component.factory=StaticServiceCountFactory)(objectClass=" + ComponentFactory.class.getName() + "))");
        this.trackerStaticServiceCounterFactory = new ServiceTracker(bc, filter, null);
        this.trackerBaseService = new ServiceTracker(bc, PropertiesProvider.class.getName(), null);
        this.trackerNamedService.open();
        this.trackerNamedServiceFactory.open();
        this.trackerCM.open();
        this.trackerExtendedClass.open();
        this.trackerSAC.open();
        this.trackerSC.open();
        this.trackerDynService.open();
        this.trackerDynServiceFactory.open();
        this.trackerBSRC.open();
        this.trackerMBSRC.open();
        this.trackerSecurity.open();
        this.trackerBAS.open();
        this.trackerBBS.open();
        this.trackerStatic.open();
        this.trackerReferenced.open();
        this.trackerNS.open();
        this.trackerBoundServiceCounterFactory.open();
        this.trackerBoundServiceCounterHelperFactory.open();
        this.trackerStaticServiceCounterFactory.open();
        this.trackerBaseService.open();
    }

    private void clearConfigurations() throws IOException, InvalidSyntaxException {
        ServiceReference cmSR = this.getContext().getServiceReference(ConfigurationAdmin.class.getName());
        if (cmSR == null) {
            return;
        }
        ConfigurationAdmin cm = (ConfigurationAdmin)this.getContext().getService(cmSR);
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb4.NamedService)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb4.NamedService)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb1.impl.AnotherComponent)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.optionalNS100)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.optionalNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.optionalNS110)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.optionalNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.requireNS100)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.requireNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.requireNS110)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.requireNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.ignoreNS100)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.ignoreNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.ignoreNS110)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.ignoreNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.notsetNS100)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.notsetNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb11.notsetNS110)");
        this.clearConfiguration(cm, "(service.factoryPid=org.eclipse.equinox.ds.tests.tb11.notsetNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.notsetNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.notsetNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.NoArgs100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.NoArgs110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.CcNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.CcNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.BcNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.BcNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.MapNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.MapNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.CcBcMapNS100)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.CcBcMapNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.NotExistNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb21.ThrowExNS110)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb24.ignore)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb24.optional)");
        this.clearConfiguration(cm, "(service.pid=org.eclipse.equinox.ds.tests.tb24.require)");
        this.getContext().ungetService(cmSR);
    }

    private void clearConfiguration(ConfigurationAdmin cm, String filter) throws IOException, InvalidSyntaxException {
        Configuration[] configs = cm.listConfigurations(filter);
        int i = 0;
        while (configs != null && i < configs.length) {
            Configuration configuration = configs[i];
            configuration.delete();
            ++i;
        }
    }

    private int getSystemProperty(String propertyKey, int defaultValue) {
        String propertyString = System.getProperty(propertyKey);
        int sleepTime = defaultValue;
        if (propertyString != null) {
            try {
                sleepTime = Integer.parseInt(propertyString);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error while parsing sleep value! The default one will be used : " + defaultValue);
            }
            if (sleepTime < 100) {
                this.log("The sleep value is too low : " + sleepTime + " ! The default one will be used : " + defaultValue);
                return defaultValue;
            }
            return sleepTime;
        }
        return defaultValue;
    }

    public void tearDown() throws Exception {
        this.unregisterAllServices();
        this.trackerNamedService.close();
        this.trackerNamedServiceFactory.close();
        this.trackerExtendedClass.close();
        this.trackerSAC.close();
        this.trackerSC.close();
        this.trackerDynService.close();
        this.trackerDynServiceFactory.close();
        this.trackerBSRC.close();
        this.trackerMBSRC.close();
        this.trackerSecurity.close();
        this.trackerBAS.close();
        this.trackerBBS.close();
        this.trackerStatic.close();
        this.trackerReferenced.close();
        this.trackerNS.close();
        this.trackerBoundServiceCounterFactory.close();
        this.trackerBoundServiceCounterHelperFactory.close();
        this.trackerBaseService.close();
        if (this.installer != null) {
            BundleInstaller bi = this.installer;
            this.installer = null;
            bi.shutdown();
        }
        this.clearConfigurations();
    }

    @Test
    public void testBindUnbind() throws Exception {
        Assert.assertEquals((String)"TestBundle1 must be running.", (long)32L, (long)this.tb1.getState());
        Bundle tb1a = this.installBundle("tb1a");
        tb1a.start();
        this.waitBundleStart();
        ServiceReference sr1 = this.getContext().getServiceReference("org.eclipse.equinox.ds.tests.tb1a.Comp1");
        Assert.assertNotNull((String)"Incorrect components should be ignored and the component Comp1 should be available", (Object)sr1);
        this.getContext().ungetService(sr1);
        this.uninstallBundle(tb1a);
        Object s = this.trackerExtendedClass.getService();
        Assert.assertNotNull((String)"The BindUnbindSuccessor component should be available", (Object)s);
        Assert.assertTrue((String)"The bind method on BindUnbindSuccessor component should be called to save the service reference", (((BoundTester)s).getBoundObjectsCount() > 0 ? 1 : 0) != 0);
        ComponentManager enabler = (ComponentManager)s;
        enabler.enableComponent(SAC_CLASS, false);
        Thread.sleep(timeout);
        Assert.assertNull((String)"The SAC component should be disabled (unavailable)", (Object)this.trackerSAC.getServiceReference());
        Assert.assertTrue((String)"The unbind method on BindUnbindSuccessor component should be called to reset the service reference", (((BoundTester)s).getBoundObjectsCount() < 1 ? 1 : 0) != 0);
        enabler = (ComponentManager)this.trackerExtendedClass.getService();
        enabler.enableComponent(SAC_CLASS, true);
        Thread.sleep(timeout);
        Assert.assertNotNull((String)"The SAC component should be available", (Object)this.trackerSAC.getServiceReference());
    }

    @Test
    public void testUniqueComponentContext() throws Exception {
        Bundle bundle = this.installBundle("tb4");
        bundle.start();
        this.waitBundleStart();
        ComponentFactory factory = (ComponentFactory)this.trackerNamedServiceFactory.getService();
        Assert.assertNotNull((String)"The NamedService component factory should be available", (Object)factory);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "hello");
        ComponentInstance ci1 = factory.newInstance(props);
        ComponentInstance ci2 = factory.newInstance(props);
        ComponentContextProvider cce1 = (ComponentContextProvider)ci1.getInstance();
        ComponentContextProvider cce2 = (ComponentContextProvider)ci2.getInstance();
        Assert.assertNotSame((String)"The two instances created must be different", (Object)cce1, (Object)cce2);
        ComponentContext cc1 = cce1.getComponentContext();
        ComponentContext cc2 = cce2.getComponentContext();
        Assert.assertNotSame((String)"The two component contexts must be not the same", (Object)cc1, (Object)cc2);
        this.uninstallBundle(bundle);
    }

    @Test
    public void testComponentContextMethods() throws Exception {
        Object extendedClass = this.trackerExtendedClass.getService();
        Assert.assertNotNull((String)"BindUnbindSuccessor component should be available", (Object)extendedClass);
        ComponentContext ctxt = ((ComponentContextProvider)extendedClass).getComponentContext();
        Assert.assertNotNull((String)"The BindUnbindSuccessor component should be activated properly", (Object)ctxt);
        Assert.assertNotNull((String)"The AnotherComponent should be available before we disable it", (Object)this.trackerSAC.getServiceReferences());
        Assert.assertTrue((String)"The AnotherComponent should be available before we disable it", (this.trackerSAC.getServiceReferences().length > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"The Worker should be available before we disable it", (Object)this.trackerSC.getServiceReferences());
        Assert.assertTrue((String)"The Worker should be available before we disable it", (this.trackerSC.getServiceReferences().length > 0 ? 1 : 0) != 0);
        try {
            ((ComponentManager)extendedClass).enableComponent("InvalidParameter", true);
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception " + e.getMessage()));
        }
        ((ComponentManager)extendedClass).enableComponent(SAC_CLASS, false);
        Thread.sleep(timeout);
        Assert.assertNull((String)"The service must not be available after we had disabled the component (AnotherComponent)", (Object)this.trackerSAC.getServiceReferences());
        ((ComponentManager)extendedClass).enableComponent(SC_CLASS, false);
        Thread.sleep(timeout);
        Assert.assertNull((String)"The service must not be available after we had disabled the component (Worker)", (Object)this.trackerSC.getServiceReferences());
        ((ComponentManager)extendedClass).enableComponent(SAC_CLASS, true);
        Thread.sleep(timeout);
        Assert.assertNotNull((String)"The service must be available after we had enabled the component", (Object)this.trackerSAC.getServiceReferences());
        Assert.assertTrue((String)"The service must be available after we had enabled the component", (this.trackerSAC.getServiceReferences().length > 0 ? 1 : 0) != 0);
        ((ComponentManager)extendedClass).enableComponent(null, true);
        Thread.sleep(timeout);
        Assert.assertNotNull((String)"The enableComponent() with passed null parameter, must enable the remaining disabled components", (Object)this.trackerSC.getServiceReferences());
        Assert.assertTrue((String)"The enableComponent() with passed null parameter, must enable the remaining disabled components", (this.trackerSC.getServiceReferences().length > 0 ? 1 : 0) != 0);
        BundleContextProvider sacBCE = (BundleContextProvider)this.trackerSAC.getService();
        Assert.assertNotNull((String)"AnotherComponent should be available", (Object)sacBCE);
        Assert.assertSame((String)"The two bundle context (this from the activator and from the ComponentContext object must be the same", (Object)sacBCE.getBundleContext(), (Object)((ComponentContextProvider)extendedClass).getComponentContext().getBundleContext());
        Bundle bundle = this.installBundle("tb4");
        Assert.assertNotNull((String)"Installing tb4.jar should succeed", (Object)bundle);
        bundle.start();
        this.waitBundleStart();
        ComponentFactory factory = (ComponentFactory)this.trackerNamedServiceFactory.getService();
        Assert.assertNotNull((String)"NamedService component factory should be available", (Object)factory);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", "hello");
        ComponentInstance ci = factory.newInstance(props);
        Assert.assertNotNull((String)"newInstance() should not return null", (Object)ci);
        ComponentContextProvider cce = (ComponentContextProvider)ci.getInstance();
        Assert.assertNotNull((String)"getInstance() should not return null if we haven't disposed the component", (Object)cce);
        Assert.assertNotNull((String)"the component instance should be initialized correctly", (Object)cce.getComponentContext());
        ComponentInstance ctxtInstance = cce.getComponentContext().getComponentInstance();
        Assert.assertSame((String)"The ComponentInstance object retrieved from the factory and from the ComponentContext must be the same", (Object)ci, (Object)ctxtInstance);
        ci.dispose();
        Assert.assertNull((String)"getInstance() should return null when disposed", (Object)ci.getInstance());
        ComponentContextProvider simpleComponentCCE = (ComponentContextProvider)this.trackerSC.getService();
        Assert.assertNotNull((String)"Worker should be available", (Object)simpleComponentCCE);
        Assert.assertNotNull((String)"Worker's context should be not null", (Object)simpleComponentCCE.getComponentContext());
        Assert.assertNotNull((String)"At least this bundle (TBC) must be using the Worker service", (Object)simpleComponentCCE.getComponentContext().getUsingBundle());
        Dictionary p = simpleComponentCCE.getComponentContext().getProperties();
        Assert.assertNotNull((String)"Worker properties must be not null", (Object)p);
        Assert.assertEquals((String)"The properties must contain the custom property defined in the component description", p.get("custom"), (Object)"customvalue");
        Assert.assertEquals((String)"The properties must contain the component.name property", p.get("component.name"), (Object)SC_CLASS);
        Assert.assertNotNull((String)"The properties must contain the component.id property", p.get("component.id"));
        Assert.assertEquals((String)"The component.id property must be of type java.lang.Long", (Object)p.get("component.id").getClass().getName(), (Object)Long.class.getName());
        ServiceReference ctxtServiceReference = ctxt.getServiceReference();
        ServiceReference bcServiceReference = this.trackerExtendedClass.getServiceReference();
        Assert.assertEquals((String)"The two ServiceReference should be equal", (Object)ctxtServiceReference, (Object)bcServiceReference);
        Object locateSac = ctxt.locateService("StandAloneComp");
        Assert.assertNotNull((String)"The locateService() method should return non-null object", (Object)locateSac);
        Assert.assertEquals((String)"The object must implement org.eclipse.equinox.ds.tests.tb1.impl.AnotherComponent", (Object)locateSac.getClass().getName(), (Object)SAC_CLASS);
        Assert.assertNull((String)"Trying to get invalid reference should return null", (Object)ctxt.locateService("InvalidReference"));
        ((ComponentManager)extendedClass).enableComponent(SAC_CLASS, false);
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Check that the component is correctly disabled", (long)0L, (long)this.countAvailableServices(this.trackerSAC));
        locateSac = ctxt.locateService("StandAloneComp");
        Assert.assertNull((String)"The reference shouldn't be available with optional cardinality and disabled component", (Object)locateSac);
        ((ComponentManager)extendedClass).enableComponent(SAC_CLASS, true);
        Thread.sleep(timeout);
        Assert.assertTrue((String)"Check that the component is correctly enabled", (this.countAvailableServices(this.trackerSAC) > 0 ? 1 : 0) != 0);
        Object[] boundObjects = ctxt.locateServices("StandAloneComp");
        int boundCount = ((BoundTester)extendedClass).getBoundObjectsCount();
        Assert.assertNotNull((String)"The returned array of bound services should not be null", (Object)boundObjects);
        Assert.assertEquals((String)"The returned array of bound services should have the length equal to the internal count", (long)boundCount, (long)boundObjects.length);
        int i = 0;
        while (i < boundObjects.length) {
            Assert.assertNotNull((String)("There shouldn't be null element in the bound objects array (" + i + ")"), (Object)boundObjects[i]);
            ++i;
        }
        Assert.assertNull((String)"The locateServices() method should return null on invalid reference name", (Object)ctxt.locateServices("InvalidReference"));
        Assert.assertTrue((String)"There must be at least one bound element", (((BoundTester)extendedClass).getBoundObjectsCount() > 0 ? 1 : 0) != 0);
        ServiceReference sr1 = ((BoundTester)extendedClass).getBoundServiceRef(0);
        Assert.assertNotNull((String)"The ServiceReference bound to the BindUnbindSuccessor components should not be null", (Object)sr1);
        Object fromSR1 = ctxt.getBundleContext().getService(sr1);
        Object fromCtxt = ctxt.locateService("StandAloneComp", sr1);
        try {
            Assert.assertNotNull((String)"The service object from BundleContext must not be null", (Object)fromSR1);
            Assert.assertNotNull((String)"The service object from locateService() must not be null", (Object)fromCtxt);
            Assert.assertSame((String)"The two objects retrieved from BundleContext and from locateService(String, ServiceReference) method must be the same", (Object)fromSR1, (Object)fromCtxt);
        }
        finally {
            ctxt.getBundleContext().ungetService(sr1);
        }
        Assert.assertNull((String)"locateService() must return null when passed ServiceReference isn't bound to the component", (Object)ctxt.locateService("StandAloneComp", this.trackerExtendedClass.getServiceReference()));
        Assert.assertNull((String)"locateService() must return null when the referenceName isn't correct even if the service reference is correct", (Object)ctxt.locateService("InvalidReference", sr1));
        this.uninstallBundle(bundle);
    }

    @Test
    public void testPropertiesHandling() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>(10);
        props.put("test.property.value", "setFromCM");
        props.put("test.property.list", "setFromCM");
        props.put("component.name", "setFromCM");
        props.put("component.id", -1L);
        Configuration config = cm.getConfiguration(SAC_CLASS, null);
        Assert.assertNotNull((String)"The Configuration object should be created if don't exist", (Object)config);
        config.update(props);
        Thread.sleep(timeout * 2);
        ServiceReference ref = this.trackerSAC.getServiceReference();
        Assert.assertNotNull((String)"The AnotherComponent's reference should be available", (Object)ref);
        Assert.assertEquals((String)"Properties not overriden from later ones should not be lost", (Object)"setFromFile", (Object)ref.getProperty("test.property.array"));
        Assert.assertEquals((String)"Properties set through the CM should take precedence before those set from file", (Object)"setFromCM", (Object)ref.getProperty("test.property.value"));
        Assert.assertEquals((String)"Properties overriden from later ones in definition should take precedence", (Object)"setFromDefinition", (Object)ref.getProperty("test.property.name"));
        Assert.assertEquals((String)"Properties set through the CM should take precedence before those set from definition", (Object)"setFromCM", (Object)ref.getProperty("test.property.list"));
        Assert.assertEquals((String)"Properties not overriden from later ones should not be lost", (Object)"setFromDefinition", (Object)ref.getProperty("test.property.cont"));
        Assert.assertEquals((String)"Must not allow overriding the component.name property", (Object)SAC_CLASS, (Object)ref.getProperty("component.name"));
        Assert.assertNotNull((String)"component.id property should be present", (Object)ref.getProperty("component.id"));
        Assert.assertTrue((String)"Must not allow overriding the component.id property", ((Long)ref.getProperty("component.id") > 0L ? 1 : 0) != 0);
        Bundle bundle = this.installBundle("tb4");
        bundle.start();
        this.waitBundleStart();
        Configuration c = cm.getConfiguration(NAMED_CLASS, null);
        Assert.assertNotNull((String)"The Configuration should be created properly", (Object)c);
        Hashtable<String, String> cmProps = new Hashtable<String, String>();
        cmProps.put("override.property.3", "setFromCM");
        c.update(cmProps);
        Thread.sleep(timeout * 2);
        ComponentFactory factory = (ComponentFactory)this.trackerNamedServiceFactory.getService();
        Assert.assertNotNull((String)"The NamedService ComponentFactory should be available", (Object)factory);
        Hashtable<String, Object> newProps = new Hashtable<String, Object>();
        newProps.put("override.property.1", "setFromMethod");
        newProps.put("override.property.2", "setFromMethod");
        newProps.put("override.property.3", "setFromMethod");
        newProps.put("component.name", "setFromMethod");
        newProps.put("component.id", -1L);
        newProps.put("name", "test");
        ArrayList<ComponentInstance> cis = new ArrayList<ComponentInstance>();
        ComponentInstance ci = factory.newInstance(newProps);
        Assert.assertNotNull((String)"newInstance() method shouldn't return null", (Object)ci);
        cis.add(ci);
        ci = factory.newInstance(newProps);
        Assert.assertNotNull((String)"newInstance() method shouldn't return null", (Object)ci);
        cis.add(ci);
        ci = factory.newInstance(newProps);
        Assert.assertNotNull((String)"newInstance() method shouldn't return null", (Object)ci);
        cis.add(ci);
        ServiceReference[] refs = this.trackerNamedService.getServiceReferences();
        boolean serviceFound = false;
        int i = 0;
        while (refs != null && i < refs.length) {
            ServiceReference current = refs[i];
            if ("test".equals(current.getProperty("name"))) {
                serviceFound = true;
                Assert.assertEquals((String)"Properties set through newInstance method must override those from definition", (Object)"setFromMethod", (Object)current.getProperty("override.property.1"));
                Assert.assertEquals((String)"Properties set through newInstance method must override those from file", (Object)"setFromMethod", (Object)current.getProperty("override.property.2"));
                Assert.assertEquals((String)"Properties set through newInstance method must override those from ConfigurationAdmin", (Object)"setFromMethod", (Object)current.getProperty("override.property.3"));
                Assert.assertEquals((String)"Must not override component.name", (Object)current.getProperty("component.name"), (Object)NAMED_CLASS);
                Assert.assertTrue((String)"Must not override component.id", ((Long)current.getProperty("component.id") > 0L ? 1 : 0) != 0);
            }
            ++i;
        }
        Assert.assertTrue((String)"Must have found service", (boolean)serviceFound);
        for (ComponentInstance i2 : cis) {
            i2.dispose();
        }
        c.delete();
        factory = (ComponentFactory)this.trackerNamedServiceFactory.getService();
        ci = factory.newInstance(newProps);
        Assert.assertNotNull((String)"newInstance() method shouldn't return null", (Object)ci);
        c = cm.createFactoryConfiguration(NAMED_CLASS, null);
        Assert.assertNotNull((String)"CM should not return null Configuration from createFactoryConfiguration()", (Object)c);
        c.update(cmProps);
        Thread.sleep(timeout);
        bundle.start();
        this.waitBundleStart();
        Assert.assertNotNull((String)"The named service ComponentFactory should be available even when there is factory configuration for it", (Object)this.trackerNamedServiceFactory.getService());
        c.delete();
        Thread.sleep(timeout * 2);
        Configuration scConfig1 = cm.createFactoryConfiguration(SC_CLASS, null);
        Hashtable<String, String> scProps1 = new Hashtable<String, String>();
        scProps1.put("name", "instance1");
        scConfig1.update(scProps1);
        Configuration scConfig2 = cm.createFactoryConfiguration(SC_CLASS, null);
        Hashtable<String, String> scProps2 = new Hashtable<String, String>();
        scProps2.put("name", "instance2");
        scConfig2.update(scProps2);
        Thread.sleep(timeout * 2);
        try {
            Assert.assertEquals((String)"The Worker should have two instances", (long)2L, (long)this.countAvailableServices(this.trackerSC));
        }
        finally {
            scConfig1.delete();
            scConfig2.delete();
        }
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"The Worker should have one instance", (long)1L, (long)this.countAvailableServices(this.trackerSC));
        ServiceReference scRef = this.trackerSC.getServiceReference();
        Assert.assertNull((String)"The Worker only instance shouldn't have \"name\" property", (Object)scRef.getProperty("name"));
        this.uninstallBundle(bundle);
    }

    @Test
    public void testBoundServiceReplacement() throws Exception {
        Hashtable<String, String> mandatoryProperty = new Hashtable<String, String>();
        mandatoryProperty.put("mandatory.property", "true");
        Bundle tb4 = this.installBundle("tb4");
        tb4.start();
        this.waitBundleStart();
        Assert.assertEquals((String)"tb4.jar should be ACTIVE", (long)32L, (long)tb4.getState());
        ComponentFactory namedFactory = (ComponentFactory)this.trackerNamedServiceFactory.getService();
        Assert.assertNotNull((String)"NamedService component factory should be available", (Object)namedFactory);
        ComponentFactory dynFactory = (ComponentFactory)this.trackerDynServiceFactory.getService();
        Assert.assertNotNull((String)"DynamicWorker component factory should be available", (Object)dynFactory);
        ComponentInstance namedServiceInstance = namedFactory.newInstance((Dictionary)mandatoryProperty.clone());
        Assert.assertNotNull((String)"NamedService component instance should not be null", (Object)namedServiceInstance);
        Object namedService = namedServiceInstance.getInstance();
        Assert.assertNotNull((String)"NamedService should be created properly", (Object)namedService);
        ComponentInstance dynServiceInstance = dynFactory.newInstance((Dictionary)mandatoryProperty.clone());
        Assert.assertNotNull((String)"DynamicWorker component instance should not be null", (Object)dynServiceInstance);
        Object dynService = dynServiceInstance.getInstance();
        Assert.assertNotNull((String)"DynamicWorker should be created properly", (Object)dynService);
        Object bsrc = this.trackerBSRC.getService();
        Assert.assertNotNull((String)"BoundReplacer should be available", (Object)bsrc);
        Assert.assertSame((String)"NamedService bound should be our first instance", (Object)((BoundMainProvider)bsrc).getBoundService("NamedService"), (Object)namedService);
        Assert.assertSame((String)"DynamicWorker bound should be our first instance", (Object)((BoundMainProvider)bsrc).getBoundService("DynamicWorker"), (Object)dynService);
        ComponentInstance dynServiceInstance2 = dynFactory.newInstance((Dictionary)mandatoryProperty.clone());
        Assert.assertNotNull((String)"Second DynamicWorker component instance should not be null", (Object)dynServiceInstance2);
        Object dynService2 = dynServiceInstance2.getInstance();
        Assert.assertNotNull((String)"Second DynamicWorker instance should be available", (Object)dynService2);
        ((DSEventsProvider)bsrc).resetEvents();
        dynServiceInstance.dispose();
        Assert.assertNotSame((String)"The bound dynamic service shouldn't be our first instance", (Object)((BoundMainProvider)bsrc).getBoundService("DynamicWorker"), (Object)dynService);
        Assert.assertSame((String)"The bound dynamic service should be our second instance", (Object)((BoundMainProvider)bsrc).getBoundService("DynamicWorker"), (Object)dynService2);
        DSEvent[] replacedBoundDynamicServicesEvents = ((DSEventsProvider)bsrc).getEvents();
        Assert.assertEquals((String)"There should two events after we have disposed the bound service", (long)2L, (long)replacedBoundDynamicServicesEvents.length);
        Assert.assertEquals((String)"The first event should be bind event", (long)1L, (long)replacedBoundDynamicServicesEvents[0].getAction());
        Assert.assertSame((String)"The first event should have associated object the second instance", (Object)dynService2, (Object)replacedBoundDynamicServicesEvents[0].getObject());
        Assert.assertEquals((String)"The second event should be unbind event", (long)2L, (long)replacedBoundDynamicServicesEvents[1].getAction());
        Assert.assertSame((String)"The second event should have associated object the first instance", (Object)dynService, (Object)replacedBoundDynamicServicesEvents[1].getObject());
        dynServiceInstance2.dispose();
        Assert.assertNull((String)"The BoundReplacer should not be available as the destroyed service hasn't replacement", (Object)this.trackerBSRC.getService());
        Assert.assertNotNull((String)"The DynamicWorker component instance should be created properly", (Object)dynFactory.newInstance((Dictionary)mandatoryProperty.clone()));
        Object bsrcObject = this.trackerBSRC.getService();
        Assert.assertNotNull((String)"The BoundReplacer should be available again", (Object)bsrcObject);
        ComponentContext bsrcCtxt1 = ((ComponentContextProvider)bsrcObject).getComponentContext();
        Assert.assertNotNull((String)"The BoundReplacer should be activated and ComponentContext available", (Object)bsrcCtxt1);
        ComponentInstance namedServiceInstance2 = namedFactory.newInstance((Dictionary)mandatoryProperty.clone());
        Assert.assertNotNull((String)"Second NamedService instance should be created properly", (Object)namedServiceInstance2);
        Object namedService2 = namedServiceInstance2.getInstance();
        Assert.assertNotNull((String)"Second NamedService instance should be created properly", (Object)namedService2);
        int beforeCount = this.countAvailableServices(this.trackerNamedService);
        namedServiceInstance.dispose();
        int afterCount = this.countAvailableServices(this.trackerNamedService);
        Assert.assertEquals((String)"The NamedService instance should be removed from the registry", (long)(beforeCount - 1), (long)afterCount);
        Object bsrcObject2 = this.trackerBSRC.getService();
        Assert.assertNotNull((String)"The BoundReplacer should not be null", (Object)bsrcObject2);
        ComponentContext bsrcCtxt2 = ((ComponentContextProvider)bsrcObject2).getComponentContext();
        Assert.assertNotNull((String)"The second ComponentContext should not be null", (Object)bsrcCtxt2);
        Assert.assertNotSame((String)"The second ComponentContext should be different than the first one", (Object)bsrcCtxt1, (Object)bsrcCtxt2);
        namedServiceInstance2.dispose();
        Assert.assertNull((String)"The BSRC should be disabled", (Object)this.trackerBSRC.getService());
        this.uninstallBundle(tb4);
    }

    private int countAvailableServices(ServiceTracker tracker) {
        if (tracker == null) {
            return -1;
        }
        ServiceReference[] refs = tracker.getServiceReferences();
        return refs != null ? refs.length : 0;
    }

    @Test
    public void testBoundServiceReplacementOnModification() throws Exception {
        BundleContext bc = this.getContext();
        Hashtable<String, String> initialProps = new Hashtable<String, String>();
        Hashtable<String, String> modifiedProps = new Hashtable<String, String>();
        initialProps.put("mandatory.property", "true");
        modifiedProps.put("mandatory.property", "false");
        ServiceRegistration dynRegistration1 = this.registerService(DynamicWorker.class.getName(), new DynamicWorker(), (Dictionary)initialProps.clone());
        ServiceRegistration staticRegistration1 = this.registerService(StaticWorker.class.getName(), new StaticWorker(), (Dictionary)initialProps.clone());
        Bundle tb4 = this.installBundle("tb4");
        tb4.start();
        this.waitBundleStart();
        Assert.assertEquals((String)"tb4.jar should be ACTIVE", (long)32L, (long)tb4.getState());
        Assert.assertTrue((String)"The AdvancedBounder must be available", (this.countAvailableServices(this.trackerMBSRC) > 0 ? 1 : 0) != 0);
        Object bsrc = this.trackerMBSRC.getService();
        Assert.assertNotNull((String)"MBSRC isntance should be not null", (Object)bsrc);
        ServiceRegistration dynRegistration2 = this.registerService(DynamicWorker.class.getName(), new DynamicWorker(), (Dictionary)initialProps.clone());
        ((DSEventsProvider)bsrc).resetEvents();
        dynRegistration1.setProperties(modifiedProps);
        Object instance1 = bc.getService(dynRegistration1.getReference());
        Object instance2 = bc.getService(dynRegistration2.getReference());
        try {
            Assert.assertNotSame((String)"The bound dynamic service shouldn't be our first instance", (Object)((BoundMainProvider)bsrc).getBoundService("DynamicWorker"), (Object)instance1);
            Assert.assertSame((String)"The bound dynamic service should be our second instance", (Object)((BoundMainProvider)bsrc).getBoundService("DynamicWorker"), (Object)instance2);
            DSEvent[] replacedBoundDynamicServicesEvents = ((DSEventsProvider)bsrc).getEvents();
            Assert.assertEquals((String)"There should two events after we have disposed the bound service", (long)2L, (long)replacedBoundDynamicServicesEvents.length);
            Assert.assertEquals((String)"The first event should be bind event", (long)1L, (long)replacedBoundDynamicServicesEvents[0].getAction());
            Assert.assertSame((String)"The first event should have associated object the second instance", (Object)instance2, (Object)replacedBoundDynamicServicesEvents[0].getObject());
            Assert.assertEquals((String)"The second event should be unbind event", (long)2L, (long)replacedBoundDynamicServicesEvents[1].getAction());
            Assert.assertSame((String)"The second event should have associated object the first instance", (Object)instance1, (Object)replacedBoundDynamicServicesEvents[1].getObject());
        }
        finally {
            bc.ungetService(dynRegistration1.getReference());
            bc.ungetService(dynRegistration2.getReference());
        }
        instance2 = null;
        instance1 = null;
        ComponentContext bsrcCtxt1 = ((ComponentContextProvider)bsrc).getComponentContext();
        Assert.assertNotNull((String)"ComponentContext object should be available", (Object)bsrcCtxt1);
        ServiceRegistration staticRegistration2 = this.registerService(StaticWorker.class.getName(), new StaticWorker(), (Dictionary)initialProps.clone());
        staticRegistration1.setProperties((Dictionary)modifiedProps.clone());
        Object bsrcObject2 = this.trackerMBSRC.getService();
        Assert.assertNotNull((String)"The BoundReplacer should not be null", (Object)bsrcObject2);
        ComponentContext bsrcCtxt2 = ((ComponentContextProvider)bsrcObject2).getComponentContext();
        Assert.assertNotNull((String)"The second ComponentContext should not be null", (Object)bsrcCtxt2);
        Assert.assertNotSame((String)"The second ComponentContext should be different than the first one", (Object)bsrcCtxt1, (Object)bsrcCtxt2);
        this.unregisterService(staticRegistration1);
        this.unregisterService(staticRegistration2);
        Assert.assertTrue((String)"The AdvancedBounder must not be available", (this.countAvailableServices(this.trackerMBSRC) == 0 ? 1 : 0) != 0);
        staticRegistration1 = this.registerService(StaticWorker.class.getName(), new StaticWorker(), (Dictionary)initialProps.clone());
        Assert.assertTrue((String)"The AdvancedBounder must be available", (this.countAvailableServices(this.trackerMBSRC) > 0 ? 1 : 0) != 0);
        staticRegistration2 = this.registerService(StaticWorker.class.getName(), new StaticWorker(), (Dictionary)initialProps.clone());
        bsrcCtxt2 = ((ComponentContextProvider)this.trackerMBSRC.getService()).getComponentContext();
        staticRegistration2.setProperties((Dictionary)modifiedProps.clone());
        bsrcCtxt1 = ((ComponentContextProvider)this.trackerMBSRC.getService()).getComponentContext();
        Assert.assertEquals((String)"The component context must not be changed", (Object)bsrcCtxt2, (Object)bsrcCtxt1);
        this.unregisterService(staticRegistration1);
        this.unregisterService(staticRegistration2);
        Assert.assertTrue((String)"The AdvancedBounder must not be available", (this.countAvailableServices(this.trackerMBSRC) == 0 ? 1 : 0) != 0);
        staticRegistration1 = this.registerService(StaticWorker.class.getName(), new StaticWorker(), (Dictionary)initialProps.clone());
        Assert.assertTrue((String)"The AdvancedBounder must be available", (this.countAvailableServices(this.trackerMBSRC) > 0 ? 1 : 0) != 0);
        bsrcCtxt1 = ((ComponentContextProvider)this.trackerMBSRC.getService()).getComponentContext();
        Hashtable modified = (Hashtable)initialProps.clone();
        modified.put("a", "a");
        staticRegistration1.setProperties((Dictionary)modified);
        bsrcCtxt2 = ((ComponentContextProvider)this.trackerMBSRC.getService()).getComponentContext();
        Assert.assertEquals((String)"The component context must not be changed", (Object)bsrcCtxt1, (Object)bsrcCtxt2);
        this.unregisterService(dynRegistration1);
        this.unregisterService(dynRegistration2);
        Assert.assertTrue((String)"The AdvancedBounder must not be available", (this.countAvailableServices(this.trackerMBSRC) == 0 ? 1 : 0) != 0);
        dynRegistration1 = this.registerService(DynamicWorker.class.getName(), new DynamicWorker(), (Dictionary)initialProps.clone());
        Assert.assertTrue((String)"The AdvancedBounder must be available", (this.countAvailableServices(this.trackerMBSRC) > 0 ? 1 : 0) != 0);
        bsrc = this.trackerMBSRC.getService();
        ((DSEventsProvider)bsrc).resetEvents();
        modified = (Hashtable)initialProps.clone();
        modified.put("a", "a");
        dynRegistration1.setProperties((Dictionary)modified);
        Assert.assertEquals((String)"There must be no unbind/bind activity when modifying reference which still satsfies the component reference", (long)0L, (long)((DSEventsProvider)bsrc).getEvents().length);
        this.uninstallBundle(tb4);
        this.unregisterService(dynRegistration1);
        this.unregisterService(dynRegistration2);
        this.unregisterService(staticRegistration1);
        this.unregisterService(staticRegistration2);
    }

    @Test
    public void testSecurity() throws Exception {
        if (System.getSecurityManager() == null) {
            return;
        }
        BundleContext bc = this.getContext();
        ServiceReference padmRef = bc.getServiceReference(PermissionAdmin.class.getName());
        Assert.assertNotNull((String)"Permission Admin service not available.", (Object)padmRef);
        PermissionAdmin padm = (PermissionAdmin)bc.getService(padmRef);
        Assert.assertNotNull((String)"Permission Admin service should be available", (Object)padm);
        Assert.assertEquals((String)"TestBundle1 must be running.", (long)32L, (long)this.tb1.getState());
        PermissionInfo registerServiceInfo = new PermissionInfo(ServicePermission.class.getName(), SECURITY_CLASS, "register");
        PermissionInfo getServiceInfo = new PermissionInfo(ServicePermission.class.getName(), SAC_CLASS, "get");
        PermissionInfo importPackage = new PermissionInfo(PackagePermission.class.getName(), "org.eclipse.equinox.ds.tests.tb1.impl", "import");
        Bundle tb5 = this.installBundle("tb5");
        tb5.start();
        this.waitBundleStart();
        String bundleLocation = tb5.getLocation();
        this.uninstallBundle(tb5);
        padm.setPermissions(bundleLocation, new PermissionInfo[]{registerServiceInfo, getServiceInfo, importPackage});
        tb5 = this.installBundle("tb5");
        tb5.start();
        this.waitBundleStart();
        Assert.assertEquals((String)"The bundle location should be the same as the first one registered", (Object)bundleLocation, (Object)tb5.getLocation());
        Assert.assertTrue((String)"The SecurityTester should be present because all needed permissions are set", (this.countAvailableServices(this.trackerSecurity) > 0 ? 1 : 0) != 0);
        this.uninstallBundle(tb5);
        padm.setPermissions(bundleLocation, new PermissionInfo[]{importPackage, getServiceInfo});
        tb5 = this.installBundle("tb5");
        tb5.start();
        this.waitBundleStart();
        Assert.assertEquals((String)"The bundle location should be the same as the first one registered", (Object)bundleLocation, (Object)tb5.getLocation());
        Assert.assertEquals((String)"The SecurityTester shouldn't be present due to missing ServicePermission.REGISTER", (long)0L, (long)this.countAvailableServices(this.trackerSecurity));
        this.uninstallBundle(tb5);
        padm.setPermissions(bundleLocation, new PermissionInfo[]{importPackage, registerServiceInfo});
        tb5 = this.installBundle("tb5");
        tb5.start();
        this.waitBundleStart();
        Assert.assertEquals((String)"The bundle location should be the same as the first one registered", (Object)bundleLocation, (Object)tb5.getLocation());
        Assert.assertEquals((String)"The SecurityTester shouldn't be present due to missing ServicePermission.GET", (long)0L, (long)this.countAvailableServices(this.trackerSecurity));
        this.uninstallBundle(tb5);
        padm.setPermissions(bundleLocation, null);
        bc.ungetService(padmRef);
        padm = null;
    }

    @Test
    public void testImmediateComponents() throws Exception {
        Bundle tb4 = this.installBundle("tb4");
        tb4.start();
        this.waitBundleStart();
        Assert.assertNotNull((String)"The ServiceProvider should be registered as service", (Object)this.getContext().getServiceReference("org.eclipse.equinox.ds.tests.tb4.ServiceProvider"));
        Assert.assertTrue((String)"The ServiceProvider should be activated", (boolean)TestHelper.isActivatedServiceProvider());
        Assert.assertTrue((String)"The AnotherComponent should be activated", (boolean)TestHelper.isActivatedStandAlone());
        this.uninstallBundle(tb4);
    }

    @Test
    public void testRowReference() throws Exception {
        Bundle tb4 = this.installBundle("tb4");
        tb4.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The Component3 should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component3"));
        Assert.assertTrue((String)"The Component2 should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component2"));
        Assert.assertTrue((String)"The Component1 should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component1"));
        BundleContext bc = this.getContext();
        ServiceReference cceRef = bc.getServiceReference("org.eclipse.equinox.ds.tests.tbc.ComponentContextProvider");
        Assert.assertNotNull((String)"The GiveMeContext should be available", (Object)cceRef);
        Assert.assertEquals((String)"The GiveMeContext should be the implementation present in tb4.jar", (Object)"org.eclipse.equinox.ds.tests.tb4.GiveMeContext", (Object)cceRef.getProperty("component.name"));
        ComponentContextProvider cce = (ComponentContextProvider)bc.getService(cceRef);
        Assert.assertNotNull((String)"The service object should be retrieved correctly", (Object)cce);
        ComponentContext ctxt = cce.getComponentContext();
        Assert.assertNotNull((String)"The ComponentContext object should not be null", (Object)ctxt);
        ctxt.disableComponent("org.eclipse.equinox.ds.tests.tb4.Component3");
        Thread.sleep(timeout);
        Assert.assertTrue((String)"The Component3 shouldn't be available", (!this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component3") ? 1 : 0) != 0);
        Assert.assertTrue((String)"The Component2 shouldn't be available", (!this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component2") ? 1 : 0) != 0);
        Assert.assertTrue((String)"The Component1 shouldn't be available", (!this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component1") ? 1 : 0) != 0);
        ctxt.enableComponent("org.eclipse.equinox.ds.tests.tb4.Component3");
        Thread.sleep(timeout);
        Assert.assertTrue((String)"The Component3 should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component3"));
        Assert.assertTrue((String)"The Component2 should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component2"));
        Assert.assertTrue((String)"The Component1 should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb4.Component1"));
        bc.ungetService(cceRef);
        this.uninstallBundle(tb4);
    }

    private boolean checkAvailability(String service) {
        BundleContext bc = this.getContext();
        ServiceReference ref = bc.getServiceReference(service);
        return ref != null;
    }

    private boolean checkFactoryAvailability(String factory) throws InvalidSyntaxException {
        BundleContext bc = this.getContext();
        ServiceReference[] refs = bc.getServiceReferences(ComponentFactory.class.getName(), "(component.factory=" + factory + ")");
        return refs != null && refs.length > 0;
    }

    @Test
    public void testBlockingComponents() throws Exception {
        final Bundle tb2 = this.installBundle("tb2");
        final Bundle tb3 = this.installBundle("tb3");
        final Bundle tb4 = this.installBundle("tb4");
        new Thread(){

            public void run() {
                try {
                    tb2.start();
                }
                catch (BundleException bundleException) {}
            }
        }.start();
        this.sleep0(this.scr_restart_timeout + timeout * 2);
        new Thread(){

            public void run() {
                try {
                    tb4.start();
                }
                catch (BundleException bundleException) {}
            }
        }.start();
        this.sleep0(timeout * 2);
        Assert.assertEquals((String)"The blocking service should not be available", (long)0L, (long)this.countAvailableServices(this.trackerBAS));
        Assert.assertTrue((String)"The service in the bundle should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tbc.ComponentContextProvider"));
        tb2.stop();
        tb4.stop();
        Assert.assertTrue((String)"The AnotherComponent should be available", (boolean)this.checkAvailability(SAC_CLASS));
        new Thread(){

            public void run() {
                try {
                    tb3.start();
                }
                catch (BundleException bundleException) {}
            }
        }.start();
        this.sleep0(this.scr_restart_timeout + timeout * 2);
        new Thread(){

            public void run() {
                try {
                    tb4.start();
                }
                catch (BundleException bundleException) {}
            }
        }.start();
        this.sleep0(timeout * 2);
        Assert.assertEquals((String)"The blocking service should not be available", (long)0L, (long)this.countAvailableServices(this.trackerBBS));
        Assert.assertTrue((String)"The service in the bundle should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tbc.ComponentContextProvider"));
        this.uninstallBundle(tb2);
        this.uninstallBundle(tb3);
        this.uninstallBundle(tb4);
    }

    @Test
    public void testStaticPolicyBinding() throws Exception {
        Bundle tb6 = this.installBundle("tb6");
        tb6.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The StaticComp should be available", (boolean)this.checkAvailability(STATIC_CLASS));
        Assert.assertTrue((String)"The ReferencedComp shouldn't be available (disabled)", (!this.checkAvailability(REFERENCED_CLASS) ? 1 : 0) != 0);
        Object initialStatic = this.trackerStatic.getService();
        Assert.assertNotNull((String)"org.eclipse.equinox.ds.tests.tb6.StaticComp component should be non-null", (Object)initialStatic);
        ComponentContext initialCtxt = ((ComponentContextProvider)initialStatic).getComponentContext();
        ((DSEventsProvider)initialStatic).resetEvents();
        Assert.assertEquals((String)"There shouldn't be bound service to StaticComp", (long)0L, (long)((BoundTester)initialStatic).getBoundObjectsCount());
        initialCtxt.enableComponent(REFERENCED_CLASS);
        Thread.sleep(timeout);
        Assert.assertTrue((String)"The StaticComp should be available", (boolean)this.checkAvailability(STATIC_CLASS));
        Assert.assertTrue((String)"The ReferencedComp should be available", (boolean)this.checkAvailability(REFERENCED_CLASS));
        Object enabledStatic = this.trackerStatic.getService();
        Assert.assertNotNull((String)"org.eclipse.equinox.ds.tests.tb6.StaticComp component should be non-null", (Object)enabledStatic);
        ComponentContext enabledCtxt = ((ComponentContextProvider)enabledStatic).getComponentContext();
        Assert.assertSame((String)"The StaticComp must not have been restarted", (Object)initialCtxt, (Object)enabledCtxt);
        Assert.assertEquals((String)"There should be no bound service to StaticComp", (long)0L, (long)((BoundTester)enabledStatic).getBoundObjectsCount());
        enabledCtxt.disableComponent(REFERENCED_CLASS);
        Thread.sleep(timeout);
        Assert.assertTrue((String)"The StaticComp should be available", (boolean)this.checkAvailability(STATIC_CLASS));
        Assert.assertTrue((String)"The ReferencedComp shouldn't be available", (!this.checkAvailability(REFERENCED_CLASS) ? 1 : 0) != 0);
        Object staticRefComp = this.trackerStatic.getService();
        Assert.assertNotNull((String)"org.eclipse.equinox.ds.tests.tb6.StaticComp component should be non-null", (Object)staticRefComp);
        ComponentContext ctxt = ((ComponentContextProvider)staticRefComp).getComponentContext();
        Assert.assertSame((String)"The StaticComp must not have been restarted", (Object)enabledCtxt, (Object)ctxt);
        Assert.assertEquals((String)"There should be none bound service to StaticComp", (long)0L, (long)((BoundTester)staticRefComp).getBoundObjectsCount());
        this.uninstallBundle(tb6);
    }

    @Test
    public void testCircularityHandling() throws Exception {
        Bundle tb7 = this.installBundle("tb7");
        tb7.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The first service from the unbreakable circularity shouldn't be available", (!this.checkAvailability("org.eclipse.equinox.ds.tests.tb7.UnbreakableCircuit1") ? 1 : 0) != 0);
        Assert.assertTrue((String)"The second service from the unbreakable circularity shouldn't be available", (!this.checkAvailability("org.eclipse.equinox.ds.tests.tb7.UnbreakableCircuit2") ? 1 : 0) != 0);
        Assert.assertTrue((String)"The first service from the breakable circularity with dynamic optional reference should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb7.DynamicCircuit1"));
        Assert.assertTrue((String)"The second service from the breakable circularity with dynamic optional reference should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb7.DynamicCircuit2"));
        ServiceReference dynBreak1Ref = this.getContext().getServiceReference("org.eclipse.equinox.ds.tests.tb7.DynamicCircuit1");
        Object dynBreak1 = this.getContext().getService(dynBreak1Ref);
        ServiceReference dynBreak2Ref = this.getContext().getServiceReference("org.eclipse.equinox.ds.tests.tb7.DynamicCircuit2");
        Object dynBreak2 = this.getContext().getService(dynBreak2Ref);
        this.sleep0(timeout * 2);
        try {
            Assert.assertNotNull((String)"The DynamicCircuit1 component should be available", (Object)dynBreak1);
            Assert.assertEquals((String)"The DynamicCircuit2 component should have one bound object", (long)1L, (long)((BoundTester)dynBreak2).getBoundObjectsCount());
            Assert.assertNotNull((String)"The DynamicCircuit2 component should have one non-null bound object", (Object)((BoundTester)dynBreak2).getBoundService(0));
        }
        finally {
            this.getContext().ungetService(dynBreak2Ref);
        }
        Assert.assertTrue((String)"The first service from the breakable circularity with static optional reference should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb7.StaticCircuit1"));
        Assert.assertTrue((String)"The second service from the breakable circularity with static optional reference should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb7.StaticCircuit2"));
        ServiceReference staticBreak2Ref = this.getContext().getServiceReference("org.eclipse.equinox.ds.tests.tb7.StaticCircuit2");
        Object staticBreak2 = this.getContext().getService(staticBreak2Ref);
        try {
            Assert.assertEquals((String)"The StaticCircuit2 component shouldn't have bound objects", (long)0L, (long)((BoundTester)staticBreak2).getBoundObjectsCount());
        }
        finally {
            this.getContext().ungetService(staticBreak2Ref);
        }
        Bundle tb5 = this.installBundle("tb5");
        tb5.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The AnotherComponent should be available", (boolean)this.checkAvailability(SAC_CLASS));
        Assert.assertTrue((String)"The service in TB5 should be available which means that the working thread of the SCR isn't blocked", (boolean)this.checkAvailability(SECURITY_CLASS));
        this.uninstallBundle(tb5);
        this.uninstallBundle(tb7);
    }

    public void testNamespaceHandling() throws Exception {
        Bundle tb8 = this.installBundle("tb8");
        tb8.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The root1 component should be available", (boolean)this.isNSComponentAvailable(101));
        Assert.assertTrue((String)"The root2 component should be available", (boolean)this.isNSComponentAvailable(102));
        Assert.assertTrue((String)"The root3 component should not be available", (!this.isNSComponentAvailable(103) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The root4 component should be available", (boolean)this.isNSComponentAvailable(104));
        Assert.assertTrue((String)"The root5 component should not be available", (!this.isNSComponentAvailable(105) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot1 component should not be available", (!this.isNSComponentAvailable(111) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot2 component should be available", (boolean)this.isNSComponentAvailable(112));
        Assert.assertTrue((String)"The nonroot3 component should not be available", (!this.isNSComponentAvailable(113) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot4 component should be available", (boolean)this.isNSComponentAvailable(114));
        Assert.assertTrue((String)"The nonroot5 component should not be available", (!this.isNSComponentAvailable(115) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot6 component should be available", (boolean)this.isNSComponentAvailable(116));
        Assert.assertTrue((String)"The nonroot7 component should not be available", (!this.isNSComponentAvailable(117) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot8 component should not be available", (!this.isNSComponentAvailable(118) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot9 component should not be available", (!this.isNSComponentAvailable(119) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot10 component should not be available", (!this.isNSComponentAvailable(120) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot11 component should be available", (boolean)this.isNSComponentAvailable(121));
        Assert.assertTrue((String)"The nonroot12 component should not be available", (!this.isNSComponentAvailable(122) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot13 component should not be available", (!this.isNSComponentAvailable(123) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The nonroot14 component should be available", (boolean)this.isNSComponentAvailable(124));
        Assert.assertTrue((String)"The nonroot15 component should be available", (boolean)this.isNSComponentAvailable(125));
        Assert.assertTrue((String)"The nonroot16 component should be available", (boolean)this.isNSComponentAvailable(126));
        Assert.assertTrue((String)"The nonroot17 component should be available", (boolean)this.isNSComponentAvailable(127));
        this.uninstallBundle(tb8);
    }

    private boolean isNSComponentAvailable(int nsid) {
        Object[] services = this.trackerNS.getServices();
        if (services == null) {
            return false;
        }
        int i = 0;
        while (i < services.length) {
            NamespaceProvider s;
            if (services[i] instanceof NamespaceProvider && (s = (NamespaceProvider)services[i]).getComponentNSID() == nsid) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Test
    public void testWildcardHandling() throws Exception {
        Bundle tb9 = this.installBundle("tb9");
        tb9.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The first Wildcard component should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb9.Wildcard1"));
        Assert.assertTrue((String)"The second Wildcard component should be available", (boolean)this.checkAvailability("org.eclipse.equinox.ds.tests.tb9.Wildcard2"));
        this.uninstallBundle(tb9);
    }

    @Test
    public void testDynamicComponentFactoryServiceBinding() throws Exception {
        Bundle tb10 = this.installBundle("tb10");
        Assert.assertNotNull((String)"Failed to install test bundle tb10.jar", (Object)tb10);
        tb10.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The referenced simple component should be available", (boolean)this.checkAvailability(SC_CLASS));
        Assert.assertTrue((String)"The referenced factory component should be available", (boolean)this.checkFactoryAvailability("CountHelperFactory"));
        Assert.assertTrue((String)"The dependent dynamic factory component should be available", (boolean)this.checkFactoryAvailability("CountFactory"));
        ComponentFactory helperFactory = (ComponentFactory)this.trackerBoundServiceCounterHelperFactory.getService();
        Assert.assertNotNull((String)"The helper factory must be retrievable", (Object)helperFactory);
        ComponentFactory observedFactory = (ComponentFactory)this.trackerBoundServiceCounterFactory.getService();
        Assert.assertNotNull((String)"The observed factory must be retrievable", (Object)observedFactory);
        ComponentInstance observedInstance1 = observedFactory.newInstance(null);
        Assert.assertNotNull((String)"Cannot instantiate component from observed factory [1]", (Object)observedInstance1);
        ComponentInstance observedInstance2 = observedFactory.newInstance(null);
        Assert.assertNotNull((String)"Cannot instantiate component from observed factory [2]", (Object)observedInstance2);
        BoundCountProvider observedComponent1 = (BoundCountProvider)observedInstance1.getInstance();
        BoundCountProvider observedComponent2 = (BoundCountProvider)observedInstance2.getInstance();
        Assert.assertNotNull((String)"The observed component must be non-null [1]", (Object)observedComponent1);
        Assert.assertNotNull((String)"The observed component must be non-null [2]", (Object)observedComponent2);
        Assert.assertEquals((String)"The bound service count must be 1 - only the simple component is available [1]", (long)1L, (long)observedComponent1.getBoundServiceCount(null));
        Assert.assertEquals((String)"The bound service count must be 1 - only the simple component is available [2]", (long)1L, (long)observedComponent2.getBoundServiceCount(null));
        int i = 0;
        while (i < 3) {
            helperFactory.newInstance(null);
            ++i;
        }
        Assert.assertEquals((String)"The bound service count must be 4 - 1 simple component, 3 helper factory components [1]", (long)4L, (long)observedComponent1.getBoundServiceCount(null));
        Assert.assertEquals((String)"The bound service count must be 4 - 1 simple component, 3 helper factory components [2]", (long)4L, (long)observedComponent2.getBoundServiceCount(null));
        this.uninstallBundle(tb10);
    }

    @Test
    public void testStaticComponentFactoryServiceBinding() throws Exception {
        Bundle tb10 = this.installBundle("tb10");
        Assert.assertNotNull((String)"Failed to install test bundle tb10.jar", (Object)tb10);
        tb10.start();
        this.waitBundleStart();
        Assert.assertTrue((String)"The referenced simple component should be available", (boolean)this.checkAvailability(SC_CLASS));
        Assert.assertTrue((String)"The referenced factory component should be available", (boolean)this.checkFactoryAvailability("CountHelperFactory"));
        Assert.assertTrue((String)"The dependent static factory component should be available", (boolean)this.checkFactoryAvailability("StaticServiceCountFactory"));
        ComponentFactory helperFactory = (ComponentFactory)this.trackerBoundServiceCounterHelperFactory.getService();
        ComponentFactory observedFactory = (ComponentFactory)this.trackerStaticServiceCounterFactory.getService();
        Assert.assertNotNull((String)"The helper factory must be retrievable", (Object)helperFactory);
        Assert.assertNotNull((String)"The observed factory must be retrievable", (Object)observedFactory);
        ComponentInstance observedInstance1 = observedFactory.newInstance(null);
        ComponentInstance observedInstance2 = observedFactory.newInstance(null);
        Assert.assertNotNull((String)"Cannot instantiate component from observed factory [1]", (Object)observedInstance1);
        Assert.assertNotNull((String)"Cannot instantiate component from observed factory [2]", (Object)observedInstance2);
        BoundCountProvider observedComponent1 = (BoundCountProvider)observedInstance1.getInstance();
        BoundCountProvider observedComponent2 = (BoundCountProvider)observedInstance2.getInstance();
        Assert.assertNotNull((String)"The observed component must be non-null [1]", (Object)observedComponent1);
        Assert.assertNotNull((String)"The observed component must be non-null [2]", (Object)observedComponent2);
        Assert.assertEquals((String)"The bound service count must be 1 - only the simple component is available [1]", (long)1L, (long)observedComponent1.getBoundServiceCount(null));
        Assert.assertEquals((String)"The bound service count must be 1 - only the simple component is available [2]", (long)1L, (long)observedComponent2.getBoundServiceCount(null));
        int i = 0;
        while (i < 3) {
            helperFactory.newInstance(null);
            ++i;
        }
        Assert.assertSame((Object)observedFactory, (Object)this.trackerStaticServiceCounterFactory.getService());
        observedFactory = (ComponentFactory)this.trackerStaticServiceCounterFactory.getService();
        observedInstance1 = observedFactory.newInstance(null);
        observedInstance2 = observedFactory.newInstance(null);
        Assert.assertNotNull((String)"Cannot instantiate new observed component instance [1]", (Object)observedInstance1);
        Assert.assertNotNull((String)"Cannot instantiate new observed component instance [2]", (Object)observedInstance2);
        observedComponent1 = (BoundCountProvider)observedInstance1.getInstance();
        observedComponent2 = (BoundCountProvider)observedInstance2.getInstance();
        Assert.assertNotNull((String)"The observed component instance must be non-null [1]", (Object)observedComponent1);
        Assert.assertNotNull((String)"The observed component instance must be non-null [2]", (Object)observedComponent2);
        Assert.assertEquals((String)"The bound service count must be 4 - 1 simple component, 3 helper factory components [1]", (long)4L, (long)observedComponent1.getBoundServiceCount(null));
        Assert.assertEquals((String)"The bound service count must be 4 - 1 simple component, 3 helper factory components [2]", (long)4L, (long)observedComponent2.getBoundServiceCount(null));
        this.uninstallBundle(tb10);
    }

    @Test
    public void testConfigurationPolicy() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Bundle tb11 = this.installBundle("tb11");
        tb11.start();
        this.waitBundleStart();
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(10);
        props.put("config.base.data", 1);
        Assert.assertEquals((String)"Configuration data should not be available for notsetNS100", (long)0L, (long)this.getBaseConfigData(COMP_NOTSET_100));
        Configuration config = cm.getConfiguration(COMP_NOTSET_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for notsetNS100 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_NOTSET_100));
        Assert.assertEquals((String)"Configuration data should not be available for notsetNS110", (long)0L, (long)this.getBaseConfigData(COMP_NOTSET_110));
        config = cm.getConfiguration(COMP_NOTSET_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for notsetNS110 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_NOTSET_110));
        Assert.assertEquals((String)"Component optionalNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_OPTIONAL_100));
        config = cm.getConfiguration(COMP_OPTIONAL_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Component optionalNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_OPTIONAL_100));
        Assert.assertEquals((String)"Configuration data should not be available for optionalNS110", (long)0L, (long)this.getBaseConfigData(COMP_OPTIONAL_110));
        config = cm.getConfiguration(COMP_OPTIONAL_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for optionalNS110 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_OPTIONAL_110));
        Assert.assertEquals((String)"Component requireNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE_100));
        config = cm.getConfiguration(COMP_REQUIRE_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Component requireNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE_100));
        Assert.assertEquals((String)"Configuration data should not be available for requireNS110, and it should not be satisfied", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE_110));
        config = cm.getConfiguration(COMP_REQUIRE_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for requireNS110 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_REQUIRE_110));
        Assert.assertEquals((String)"Component ignoreNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_IGNORE_100));
        config = cm.getConfiguration(COMP_IGNORE_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Component ignoreNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_IGNORE_100));
        Assert.assertEquals((String)"Configuration data should not be available for ignoreNS110, but it should be satisfied", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE_110));
        config = cm.getConfiguration(COMP_IGNORE_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should not be available for ignoreNS110, but it should be satisfied", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE_110));
        this.uninstallBundle(tb11);
    }

    @Test
    public void testConfigurationPolicyFactoryConf() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Bundle tb11 = this.installBundle("tb11");
        tb11.start();
        this.waitBundleStart();
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(10);
        props.put("config.base.data", 1);
        Assert.assertEquals((String)"Configuration data should not be available for notsetNS100", (long)0L, (long)this.getBaseConfigData(COMP_NOTSET_100));
        Configuration config = cm.createFactoryConfiguration(COMP_NOTSET_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for notsetNS100 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_NOTSET_100));
        Assert.assertEquals((String)"Configuration data should not be available for notsetNS110", (long)0L, (long)this.getBaseConfigData(COMP_NOTSET_110));
        config = cm.createFactoryConfiguration(COMP_NOTSET_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for notsetNS110 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_NOTSET_110));
        Assert.assertEquals((String)"Component optionalNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_OPTIONAL_100));
        config = cm.createFactoryConfiguration(COMP_OPTIONAL_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Component optionalNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_OPTIONAL_100));
        Assert.assertEquals((String)"Configuration data should not be available for optionalNS110", (long)0L, (long)this.getBaseConfigData(COMP_OPTIONAL_110));
        config = cm.createFactoryConfiguration(COMP_OPTIONAL_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for optionalNS110 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_OPTIONAL_110));
        Assert.assertEquals((String)"Component requireNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE_100));
        config = cm.createFactoryConfiguration(COMP_REQUIRE_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Component requireNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE_100));
        Assert.assertEquals((String)"Configuration data should not be available for requireNS110, and it should not be satisfied", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE_110));
        config = cm.createFactoryConfiguration(COMP_REQUIRE_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should be available for requireNS110 and equal to 1", (long)1L, (long)this.getBaseConfigData(COMP_REQUIRE_110));
        Assert.assertEquals((String)"Component ignoreNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_IGNORE_100));
        config = cm.createFactoryConfiguration(COMP_IGNORE_100, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Component ignoreNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(COMP_IGNORE_100));
        Assert.assertEquals((String)"Configuration data should not be available for ignoreNS110, but it should be satisfied", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE_110));
        config = cm.createFactoryConfiguration(COMP_IGNORE_110, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Configuration data should not be available for ignoreNS110, but it should be satisfied", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE_110));
        this.uninstallBundle(tb11);
    }

    @Test
    public void testActivateDeactivate() throws Exception {
        Bundle tb12 = this.installBundle("tb12");
        tb12.start();
        this.waitBundleStart();
        PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.notsetNS100");
        ComponentContext cc = bs instanceof ComponentContextProvider ? ((ComponentContextProvider)bs).getComponentContext() : null;
        Assert.assertNotNull((String)"Component context should be available", (Object)cc);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.notsetNS100 should be called", (long)1L, (long)(1 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.notsetNS100");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.notsetNS100 should be called", (long)2L, (long)(2 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.notsetNS110");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.notsetNS110 should be called", (long)1L, (long)(1 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.notsetNS110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.notsetNS110 should be called", (long)2L, (long)(2 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.NoArgs100");
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb12.NoArgs100 should not be activated", (long)-1L, (long)this.getBaseConfigData(bs));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.NoArgs110");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.NoArgs110 should be called", (long)4L, (long)(4 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.NoArgs110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.NoArgs110 should be called", (long)8L, (long)(8 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcNS100");
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb12.CcNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(bs));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcNS110");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.CcNS110 should be called", (long)16L, (long)(0x10 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.CcNS110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.CcNS110 should be called", (long)32L, (long)(0x20 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.Bc100");
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb12.Bc100 should not be activated", (long)-1L, (long)this.getBaseConfigData(bs));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.Bc110");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.Bc110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.Bc110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.Bc110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.MapNS100");
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb12.MapNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(bs));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.MapNS110");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.MapNS110 should be called", (long)256L, (long)(0x100 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.MapNS110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.MapNS110 should be called", (long)512L, (long)(0x200 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapNS100");
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb12.CcBcMapNS100 should not be activated", (long)-1L, (long)this.getBaseConfigData(bs));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapNS110");
        Assert.assertNotNull((Object)bs);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb12.CcBcMapNS110 should be called", (long)1024L, (long)(0x400 & this.getBaseConfigData(bs)));
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.CcBcMapNS110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.CcBcMapNS110 should be called", (long)2048L, (long)(0x800 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.IntNS110");
        Assert.assertNotNull((Object)bs);
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.IntNS110");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.IntNS110 should be called", (long)4096L, (long)(0x1000 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Assert.assertNotNull((Object)bs);
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Thread.sleep(timeout);
        int data = this.getBaseConfigData(bs);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110 should be called", (long)8192L, (long)(0x2000 & data));
        Assert.assertEquals((String)"Deactivation reason shall be DEACTIVATION_REASON_DISABLED", (long)1L, (long)(0xFF & data >> 16));
        cc.enableComponent("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Thread.sleep(timeout);
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Assert.assertNotNull((Object)bs);
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb12.ContextExp");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Deactivation reason shall be DEACTIVATION_REASON_REFERENCE", (long)2L, (long)(0xFF & this.getBaseConfigData(bs) >> 16));
        cc.enableComponent("org.eclipse.equinox.ds.tests.tb12.ContextExp");
        Thread.sleep(timeout);
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Assert.assertNotNull((Object)bs);
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Configuration config = cm.getConfiguration("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110", null);
        Hashtable<String, String> properties = config.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        ((Dictionary)properties).put("configuration.dummy", "dummy");
        config.update(properties);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivation reason shall be DEACTIVATION_REASON_CONFIGURATION_MODIFIED", (long)3L, (long)(0xFF & this.getBaseConfigData(bs) >> 16));
        cc.enableComponent("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Thread.sleep(timeout);
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Assert.assertNotNull((Object)bs);
        config = cm.getConfiguration("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110", null);
        config.delete();
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivation reason shall be DEACTIVATION_REASON_CONFIGURATION_DELETED", (long)4L, (long)(0xFF & this.getBaseConfigData(bs) >> 16));
        cc.enableComponent("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Thread.sleep(timeout);
        cc.enableComponent("org.eclipse.equinox.ds.tests.tb12.IntNS110");
        Thread.sleep(timeout);
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.IntNS110");
        Assert.assertNotNull((Object)bs);
        ComponentContext ccIntNS110 = bs instanceof ComponentContextProvider ? ((ComponentContextProvider)bs).getComponentContext() : null;
        Assert.assertNotNull((String)"Component context should be available for org.eclipse.equinox.ds.tests.tb12.IntNS110", (Object)ccIntNS110);
        ccIntNS110.getComponentInstance().dispose();
        Assert.assertEquals((String)"Deactivation reason shall be DEACTIVATION_REASON_DISPOSED", (long)5L, (long)(0xFF & this.getBaseConfigData(bs) >> 16));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb12.CcBcMapIntNS110");
        Assert.assertNotNull((Object)bs);
        tb12.stop();
        Assert.assertEquals((String)"Deactivation reason shall be DEACTIVATION_REASON_BUNDLE_STOPPED", (long)6L, (long)(0xFF & this.getBaseConfigData(bs) >> 16));
        this.uninstallBundle(tb12);
    }

    @Test
    public void testBindUnbindParams() throws Exception {
        Bundle tb13 = this.installBundle("tb13");
        tb13.start();
        this.waitBundleStart();
        ServiceReference ref = this.getContext().getServiceReference(ComponentManager.class.getName());
        Assert.assertNotNull((String)"Component Enabler Service Reference should be available", (Object)ref);
        ComponentManager enabler = (ComponentManager)this.getContext().getService(ref);
        Assert.assertNotNull((String)"Component Enabler Service should be available", (Object)enabler);
        PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb13.SrNS100");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb13.SrNS100 should be activated", (Object)bs);
        Assert.assertEquals((String)"Bind method of org.eclipse.equinox.ds.tests.tb13.SrNS100 should be called", (long)1L, (long)(1 & this.getBaseConfigData(bs)));
        enabler.enableComponent("org.eclipse.equinox.ds.tests.tb13.SrNS100", false);
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Unbind method of org.eclipse.equinox.ds.tests.tb13.SrNS100 should be called", (long)2L, (long)(2 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb13.SrNS110");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb13.SrNS110 should be activated", (Object)bs);
        Assert.assertEquals((String)"Bind method of org.eclipse.equinox.ds.tests.tb13.SrNS110 should be called", (long)1L, (long)(1 & this.getBaseConfigData(bs)));
        enabler.enableComponent("org.eclipse.equinox.ds.tests.tb13.SrNS110", false);
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Unbind method of org.eclipse.equinox.ds.tests.tb13.SrNS110 should be called", (long)32L, (long)(0x20 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb13.CeNS100");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb13.CeNS100 should be activated", (Object)bs);
        Assert.assertEquals((String)"Bind method of org.eclipse.equinox.ds.tests.tb13.CeNS100 should be called", (long)4L, (long)(4 & this.getBaseConfigData(bs)));
        enabler.enableComponent("org.eclipse.equinox.ds.tests.tb13.CeNS100", false);
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Unbind method of org.eclipse.equinox.ds.tests.tb13.CeNS100 should be called", (long)8L, (long)(8 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb13.CeNS110");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb13.CeNS110 should be activated", (Object)bs);
        Assert.assertEquals((String)"Bind method of org.eclipse.equinox.ds.tests.tb13.CeNS110 should be called", (long)4L, (long)(4 & this.getBaseConfigData(bs)));
        enabler.enableComponent("org.eclipse.equinox.ds.tests.tb13.CeNS110", false);
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Unbind method of org.eclipse.equinox.ds.tests.tb13.CeNS110 should be called", (long)8L, (long)(8 & this.getBaseConfigData(bs)));
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb13.CeMapNS100");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb13.CeMapNS100 should be activated", (Object)bs);
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb13.CeMapNS110");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb13.CeMapNS110 should be activated", (Object)bs);
        Assert.assertEquals((String)"Bind method of org.eclipse.equinox.ds.tests.tb13.CeMapNS110 should be called", (long)16L, (long)(0x10 & this.getBaseConfigData(bs)));
        enabler.enableComponent("org.eclipse.equinox.ds.tests.tb13.CeMapNS110", false);
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Unbind method of org.eclipse.equinox.ds.tests.tb13.CeMapNS110 should be called", (long)32L, (long)(0x20 & this.getBaseConfigData(bs)));
        this.getContext().ungetService(ref);
        this.uninstallBundle(tb13);
    }

    @Test
    public void testOptionalNames() throws Exception {
        Bundle tb14 = this.installBundle("tb14");
        tb14.start();
        this.waitBundleStart();
        Assert.assertNull((String)"Component org.eclipse.equinox.ds.tests.tb14.Optional should not be activated", (Object)this.getBaseService("org.eclipse.equinox.ds.tests.tb14.Optional"));
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb14.Optional2 should be activated", (Object)this.getBaseService("org.eclipse.equinox.ds.tests.tb14.Optional2"));
        Assert.assertNull((String)"Component org.eclipse.equinox.ds.tests.tb14.OptRef100 should not be activated", (Object)this.getBaseService("org.eclipse.equinox.ds.tests.tb14.OptRef100"));
        PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb14.OptRef110");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb14.OptRef110 should be activated", (Object)bs);
        ComponentContext cc = bs instanceof ComponentContextProvider ? ((ComponentContextProvider)bs).getComponentContext() : null;
        Assert.assertNotNull((String)"Component context should be available", (Object)cc);
        Assert.assertNotNull((String)"Optional reference name should be set to interface attribute", (Object)cc.locateService(ComponentContextProvider.class.getName()));
        this.uninstallBundle(tb14);
    }

    @Test
    public void testDisposingMultipleDependencies() throws Exception {
        Bundle tb15 = this.installBundle("tb15");
        tb15.start();
        this.waitBundleStart();
        PropertiesProvider serviceC1 = this.getBaseService("org.eclipse.equinox.ds.tests.tb15.Component1");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb15.Component1 should be activated", (Object)serviceC1);
        PropertiesProvider serviceC2 = this.getBaseService("org.eclipse.equinox.ds.tests.tb15.Component2");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb15.Component2 should be activated", (Object)serviceC2);
        PropertiesProvider serviceC3 = this.getBaseService("org.eclipse.equinox.ds.tests.tb15.Component3");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb15.Component3 should be activated", (Object)serviceC3);
        ComponentContext cc = serviceC1 instanceof ComponentContextProvider ? ((ComponentContextProvider)serviceC1).getComponentContext() : null;
        Assert.assertNotNull((String)"Component context should be available", (Object)cc);
        cc.disableComponent("org.eclipse.equinox.ds.tests.tb15.Component1");
        Thread.sleep(timeout);
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb15.Component3 should be deactivated first", (long)0L, (long)this.getBaseConfigData(serviceC3));
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb15.Component2 should be deactivated second", (long)1L, (long)this.getBaseConfigData(serviceC2));
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb15.Component1 should be deactivated third", (long)2L, (long)this.getBaseConfigData(serviceC1));
        this.uninstallBundle(tb15);
    }

    @Test
    public void testReferenceTargetProperty() throws Exception {
        Bundle tb16 = this.installBundle("tb16");
        tb16.start();
        this.waitBundleStart();
        PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb16.Exposer");
        ComponentContext cc = bs instanceof ComponentContextProvider ? ((ComponentContextProvider)bs).getComponentContext() : null;
        Assert.assertNotNull((String)"Component context should be available", (Object)cc);
        PropertiesProvider serviceC2 = this.getBaseService("org.eclipse.equinox.ds.tests.tb16.C2");
        Assert.assertNull((String)"Component org.eclipse.equinox.ds.tests.tb16.C2 should not be activated because of unsatisfied reference", (Object)serviceC2);
        cc.enableComponent("org.eclipse.equinox.ds.tests.tb16.C1");
        Thread.sleep(timeout);
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb16.C1 should be available", (Object)this.getBaseService("org.eclipse.equinox.ds.tests.tb16.C1"));
        serviceC2 = this.getBaseService("org.eclipse.equinox.ds.tests.tb16.C2");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb16.C2 should be activated", (Object)serviceC2);
        this.uninstallBundle(tb16);
    }

    @Test
    public void testOverload() throws Exception {
        Bundle tb17 = this.installBundle("tb17");
        Bundle tb18 = this.installBundle("tb18");
        Bundle tb19 = this.installBundle("tb19");
        tb17.start();
        tb18.start();
        tb19.start();
        this.waitBundleStart();
        OverloadManager manager17 = new OverloadManager("org.eclipse.equinox.ds.tests.tb17.C", 1, 10);
        OverloadManager manager18 = new OverloadManager("org.eclipse.equinox.ds.tests.tb18.C", 1, 10);
        OverloadManager manager19 = new OverloadManager("org.eclipse.equinox.ds.tests.tb19.C", 1, 10);
        long startTime = System.currentTimeMillis();
        manager17.start();
        manager18.start();
        manager19.start();
        manager17.join();
        manager18.join();
        manager19.join();
        int successCount = 0;
        while (successCount < 5 && System.currentTimeMillis() - startTime < 60000L) {
            Thread.sleep(100L);
            if (!(manager17.isAllComponentsRunning() && manager18.isAllComponentsRunning() && manager19.isAllComponentsRunning())) {
                successCount = 0;
                continue;
            }
            ++successCount;
        }
        long elapsed = System.currentTimeMillis() - startTime;
        this.log("testOverload(): Overload processing finished for " + elapsed + " ms.");
        Assert.assertTrue((String)"All components of tb17 should be activated", (boolean)manager17.isAllComponentsRunning());
        Assert.assertTrue((String)"All components of tb18 should be activated", (boolean)manager18.isAllComponentsRunning());
        Assert.assertTrue((String)"All components of tb19 should be activated", (boolean)manager19.isAllComponentsRunning());
        this.uninstallBundle(tb17);
        this.uninstallBundle(tb18);
        this.uninstallBundle(tb19);
    }

    @Test
    public void testLazyBundles() throws Exception {
        Bundle tb20 = this.installBundle("tb20");
        tb20.start(2);
        this.waitBundleStart();
        Assert.assertTrue((String)"Provided service of Component org.eclipse.equinox.ds.tests.tb20.component should be available.", (this.trackerBaseService.size() > 0 ? 1 : 0) != 0);
        this.uninstallBundle(tb20);
    }

    @Test
    public void testModified100() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Bundle tb21 = this.installBundle("tb21");
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(10);
        props.put("config.dummy.data", 1);
        cm.getConfiguration(MOD_NOTSET_NS100, null).update(props);
        cm.getConfiguration(MOD_NOARGS_NS100, null).update(props);
        cm.getConfiguration(MOD_CC_NS100, null).update(props);
        cm.getConfiguration(MOD_BC_NS100, null).update(props);
        cm.getConfiguration(MOD_MAP_NS100, null).update(props);
        cm.getConfiguration(MOD_CC_BC_MAP_NS100, null).update(props);
        Thread.sleep(timeout * 2);
        tb21.start();
        this.waitBundleStart();
        props.put("config.dummy.data", 2);
        Hashtable<String, String> unsatisfyingProps = new Hashtable<String, String>(10);
        unsatisfyingProps.put("ref.target", "(component.name=org.eclipse.equinox.ds.tests.tb21.unexisting.provider)");
        PropertiesProvider bs = this.getBaseService(MOD_NOTSET_NS100);
        Assert.assertNotNull((Object)bs);
        cm.getConfiguration(MOD_NOTSET_NS100, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.notsetNS100 should not be called", (long)0L, (long)(1 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.notsetNS100 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOTSET_NS100);
        cm.getConfiguration(MOD_NOTSET_NS100, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.notsetNS100 should not be called", (long)0L, (long)(1 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.notsetNS100 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOARGS_NS100);
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb21.NoArgs100 should not be activated", null, (Object)bs);
        bs = this.getBaseService(MOD_CC_NS100);
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb21.CcNS100 should not be activated", null, (Object)bs);
        bs = this.getBaseService(MOD_BC_NS100);
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb21.BcNS100 should not be activated", null, (Object)bs);
        bs = this.getBaseService(MOD_MAP_NS100);
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb21.MapNS100 should not be activated", null, (Object)bs);
        bs = this.getBaseService(MOD_CC_BC_MAP_NS100);
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb21.CcBcMapNS100 should not be activated", null, (Object)bs);
        this.uninstallBundle(tb21);
    }

    @Test
    public void testModified110() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Bundle tb21a = this.installBundle("tb21a");
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(10);
        props.put("config.dummy.data", 1);
        cm.getConfiguration(MOD_NOTSET_NS110, null).update(props);
        cm.getConfiguration(MOD_NOARGS_NS110, null).update(props);
        cm.getConfiguration(MOD_CC_NS110, null).update(props);
        cm.getConfiguration(MOD_BC_NS110, null).update(props);
        cm.getConfiguration(MOD_MAP_NS110, null).update(props);
        cm.getConfiguration(MOD_CC_BC_MAP_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        tb21a.start();
        this.waitBundleStart();
        props.put("config.dummy.data", 2);
        Hashtable<String, String> unsatisfyingProps = new Hashtable<String, String>(10);
        unsatisfyingProps.put("ref.target", "(component.name=org.eclipse.equinox.ds.tests.tb21.unexisting.provider)");
        PropertiesProvider bs = this.getBaseService(MOD_NOTSET_NS110);
        cm.getConfiguration(MOD_NOTSET_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.notsetNS110 should not be called", (long)0L, (long)(1 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.notsetNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOTSET_NS110);
        cm.getConfiguration(MOD_NOTSET_NS110, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.notsetNS110 should not be called", (long)0L, (long)(1 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.notsetNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOTSET_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.notsetNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOARGS_NS110);
        cm.getConfiguration(MOD_NOARGS_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.NoArgs110 should be called", (long)2L, (long)(2 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.NoArgs110 should not be called", (long)0L, (long)(0x80 & this.getBaseConfigData(bs)));
        cm.getConfiguration(MOD_NOARGS_NS110, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.NoArgs110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOARGS_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.NoArgs110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_CC_NS110);
        cm.getConfiguration(MOD_CC_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.CcNS110 should be called", (long)4L, (long)(4 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.CcNS110 should not be called", (long)0L, (long)(0x80 & this.getBaseConfigData(bs)));
        cm.getConfiguration(MOD_CC_NS110, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.CcNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_CC_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.CcNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_BC_NS110);
        cm.getConfiguration(MOD_BC_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should be called", (long)8L, (long)(8 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should not be called", (long)0L, (long)(0x80 & this.getBaseConfigData(bs)));
        cm.getConfiguration(MOD_BC_NS110, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_BC_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_MAP_NS110);
        cm.getConfiguration(MOD_MAP_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.MapNS110 should be called", (long)16L, (long)(0x10 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.MapNS110 should not be called", (long)0L, (long)(0x80 & this.getBaseConfigData(bs)));
        cm.getConfiguration(MOD_MAP_NS110, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.MapNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_MAP_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.MapNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_CC_BC_MAP_NS110);
        cm.getConfiguration(MOD_CC_BC_MAP_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.CcBcMapNS110 should be called", (long)32L, (long)(0x20 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.CcBcMapNS110 should not be called", (long)0L, (long)(0x80 & this.getBaseConfigData(bs)));
        cm.getConfiguration(MOD_CC_BC_MAP_NS110, null).update(unsatisfyingProps);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.CcBcMapNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_CC_BC_MAP_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.CcBcMapNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        this.uninstallBundle(tb21a);
    }

    @Test
    public void testModifiedSpecialCases() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Bundle tb21a = this.installBundle("tb21a");
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(10);
        props.put("config.dummy.data", 1);
        cm.getConfiguration(MOD_CC_NS110, null).update(props);
        cm.getConfiguration(MOD_NOT_EXIST_NS110, null).update(props);
        cm.getConfiguration(MOD_THROW_EX_NS110, null).update(props);
        cm.getConfiguration(MOD_BC_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        tb21a.start();
        this.waitBundleStart();
        PropertiesProvider bs = this.getBaseService(MOD_CC_NS110);
        props.put("config.dummy.data", 2);
        cm.getConfiguration(MOD_CC_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Object val = ((ComponentContextProvider)bs).getComponentContext().getProperties().get("config.dummy.data");
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.CcNS110 should be called", (long)4L, (long)(4 & this.getBaseConfigData(bs)));
        Assert.assertTrue((String)"Component properties should be updated properly for org.eclipse.equinox.ds.tests.tb21.CcNS110", (boolean)Integer.valueOf(2).equals(val));
        bs = this.getBaseService(MOD_NOT_EXIST_NS110);
        cm.getConfiguration(MOD_NOT_EXIST_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.NotExistNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_NOT_EXIST_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.NotExistNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_THROW_EX_NS110);
        cm.getConfiguration(MOD_THROW_EX_NS110, null).update(props);
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.ThrowExNS110 should not be called", (long)0L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_BC_NS110);
        cm.getConfiguration(MOD_BC_NS110, null).delete();
        Thread.sleep(timeout * 2);
        Assert.assertEquals((String)"Modified method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should not be called", (long)0L, (long)(0x20 & this.getBaseConfigData(bs)));
        Assert.assertEquals((String)"Deactivate method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should be called", (long)128L, (long)(0x80 & this.getBaseConfigData(bs)));
        bs = this.getBaseService(MOD_BC_NS110);
        Assert.assertEquals((String)"Activate method of org.eclipse.equinox.ds.tests.tb21.BcNS110 should be called", (long)64L, (long)(0x40 & this.getBaseConfigData(bs)));
        this.uninstallBundle(tb21a);
    }

    @Test
    public void testPrivateProperties() throws Exception {
        Bundle tb22 = this.installBundle("tb22");
        tb22.start();
        this.waitBundleStart();
        ServiceReference ref = this.trackerBaseService.getServiceReference();
        Assert.assertNotNull((String)"Provided service of org.eclipse.equinox.ds.tests.tb22.component should be available", (Object)ref);
        String[] keys = ref.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            Assert.assertTrue((String)"Private properties should not be propagated", (!keys[i].startsWith(".") ? 1 : 0) != 0);
            ++i;
        }
        this.uninstallBundle(tb22);
    }

    @Test
    public void testBindException() throws Exception {
        Bundle tb23 = this.installBundle("tb23");
        tb23.start();
        this.waitBundleStart();
        PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb23.mandatory");
        Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb23.mandatory should not be activated", (Object)bs);
        bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb23.optional");
        Assert.assertEquals((String)"Component org.eclipse.equinox.ds.tests.tb23.optional should be activated", (long)4L, (long)(4 & this.getBaseConfigData(bs)));
        this.uninstallBundle(tb23);
    }

    @Test
    public void testConfigAdminOnOff() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(11);
        props.put("config.base.data", 1);
        Configuration config = cm.getConfiguration(COMP_OPTIONAL, null);
        config.update(props);
        config = cm.getConfiguration(COMP_REQUIRE, null);
        config.update(props);
        config = cm.getConfiguration(COMP_IGNORE, null);
        config.update(props);
        Thread.sleep(timeout * 2);
        Bundle cmBundle = this.trackerCM.getServiceReference().getBundle();
        cmBundle.stop();
        Bundle tb24 = this.installBundle("tb24");
        try {
            tb24.start();
            this.waitBundleStart();
            Assert.assertEquals((String)"Component with optional configuration should be activated", (long)0L, (long)this.getBaseConfigData(COMP_OPTIONAL));
            Assert.assertEquals((String)"Component with ignored configuration should be activated", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE));
            Assert.assertEquals((String)"Component with required configuration should NOT be activated", (long)-1L, (long)this.getBaseConfigData(COMP_REQUIRE));
            cmBundle.start();
            Thread.sleep(timeout * 2);
            Assert.assertEquals((String)"Component with optional configuration should be activated and inited by configuration", (long)1L, (long)this.getBaseConfigData(COMP_OPTIONAL));
            Assert.assertEquals((String)"Component with ignored configuration should be activated", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE));
            Assert.assertEquals((String)"Component with required configuration should be activated", (long)1L, (long)this.getBaseConfigData(COMP_REQUIRE));
            cmBundle.stop();
            Assert.assertEquals((String)"Component with optional configuration should be activated", (long)1L, (long)this.getBaseConfigData(COMP_OPTIONAL));
            Assert.assertEquals((String)"Component with ignored configuration should be activated", (long)0L, (long)this.getBaseConfigData(COMP_IGNORE));
            Assert.assertEquals((String)"Component with required configuration should be activated", (long)1L, (long)this.getBaseConfigData(COMP_REQUIRE));
        }
        finally {
            this.uninstallBundle(tb24);
            cmBundle.start();
        }
    }

    @Test
    public void testServicePropertiesUpdate() throws Exception {
        Bundle tb25 = this.installBundle("tb25");
        ServiceRegistration sr = null;
        try {
            tb25.start();
            this.waitBundleStart();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("service.provider", "service.properties.update.test");
            props.put("test.property", Boolean.FALSE);
            sr = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.ServicePropertiesComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.ServicePropertiesComp should be activated", (Object)bs);
            props.put("test.property", Boolean.TRUE);
            sr.setProperties((Dictionary)props.clone());
            Thread.sleep(timeout);
            bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.ServicePropertiesComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.ServicePropertiesComp should still be active", (Object)bs);
            Dictionary compProps = bs.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            Assert.assertEquals((String)"Test property should be updated.", (Object)Boolean.TRUE, compProps.get("test.property"));
            Assert.assertEquals((String)"Updated method for static reference should be called.", (Object)Boolean.TRUE, compProps.get("serviceUpdatedStatic"));
            Assert.assertEquals((String)"Updated method for dynamic reference should be called.", (Object)Boolean.TRUE, compProps.get("serviceUpdatedDynamic"));
        }
        catch (Throwable throwable) {
            this.uninstallBundle(tb25);
            if (sr != null) {
                this.unregisterService(sr);
            }
            throw throwable;
        }
        this.uninstallBundle(tb25);
        if (sr != null) {
            this.unregisterService(sr);
        }
    }

    @Test
    public void testPolicyOptionReluctant() throws Exception {
        Bundle tb25 = this.installBundle("tb25");
        ServiceRegistration sr = null;
        ServiceRegistration srLower = null;
        ServiceRegistration srHigher = null;
        try {
            Integer RANK_1 = 1;
            Integer RANK_2 = 2;
            Integer RANK_3 = 3;
            tb25.start();
            this.waitBundleStart();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("service.provider", "reluctant.policy.option.test");
            props.put("service.ranking", RANK_2);
            sr = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            PropertiesProvider bsStatic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyReluctantStaticComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyReluctantStaticComp should be activated", (Object)bsStatic);
            PropertiesProvider bsDynamic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyReluctantDynamicComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyReluctantDynamicComp should be activated", (Object)bsDynamic);
            props.put("service.ranking", RANK_1);
            srLower = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            bsStatic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyReluctantStaticComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyReluctantStaticComp should still be active", (Object)bsStatic);
            Dictionary compProps = bsStatic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for static 0..1.", this.toList(RANK_2), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for static 1..1.", this.toList(RANK_2), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for static 0..n.", this.toList(RANK_2), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for static 1..n.", this.toList(RANK_2), (List)compProps.get("bind1n"));
            bsDynamic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyReluctantDynamicComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyReluctantDynamicComp should still be active", (Object)bsDynamic);
            compProps = bsDynamic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for dynamic 0..1.", this.toList(RANK_2), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for dynamic 1..1.", this.toList(RANK_2), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with lower ranking should be bound for dynamic 0..n.", this.toList(RANK_1, RANK_2), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with lower ranking should be bound for dynamic 1..n.", this.toList(RANK_1, RANK_2), (List)compProps.get("bind1n"));
            props.put("service.ranking", RANK_3);
            srHigher = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            bsStatic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyReluctantStaticComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyReluctantStaticComp should still be active", (Object)bsStatic);
            compProps = bsStatic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with higher ranking should be ignored for static 0..1.", this.toList(RANK_2), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with higher ranking should be ignored for static 1..1.", this.toList(RANK_2), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with higher ranking should be ignored for static 0..n.", this.toList(RANK_2), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with higher ranking should be ignored for static 1..n.", this.toList(RANK_2), (List)compProps.get("bind1n"));
            bsDynamic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyReluctantDynamicComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyReluctantDynamicComp should still be active", (Object)bsDynamic);
            compProps = bsDynamic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with higher ranking should be ignored for dynamic 0..1.", this.toList(RANK_2), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with higher ranking should be ignored for dynamic 1..1.", this.toList(RANK_2), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for dynamic 0..n.", this.toList(RANK_1, RANK_2, RANK_3), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for dynamic 1..n.", this.toList(RANK_1, RANK_2, RANK_3), (List)compProps.get("bind1n"));
        }
        catch (Throwable throwable) {
            this.uninstallBundle(tb25);
            if (sr != null) {
                this.unregisterService(sr);
            }
            if (srLower != null) {
                this.unregisterService(srLower);
            }
            if (srHigher != null) {
                this.unregisterService(srHigher);
            }
            throw throwable;
        }
        this.uninstallBundle(tb25);
        if (sr != null) {
            this.unregisterService(sr);
        }
        if (srLower != null) {
            this.unregisterService(srLower);
        }
        if (srHigher != null) {
            this.unregisterService(srHigher);
        }
    }

    @Test
    public void testPolicyOptionGreedy() throws Exception {
        Bundle tb25 = this.installBundle("tb25");
        ServiceRegistration sr = null;
        ServiceRegistration srLower = null;
        ServiceRegistration srHigher = null;
        try {
            Integer RANK_1 = 1;
            Integer RANK_2 = 2;
            Integer RANK_3 = 3;
            tb25.start();
            this.waitBundleStart();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("service.provider", "greedy.policy.option.test");
            props.put("service.ranking", RANK_2);
            sr = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            PropertiesProvider bsStatic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyGreedyStaticComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyGreedyStaticComp should be activated", (Object)bsStatic);
            PropertiesProvider bsDynamic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyGreedyDynamicComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyGreedyDynamicComp should be activated", (Object)bsDynamic);
            props.put("service.ranking", RANK_1);
            srLower = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            bsStatic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyGreedyStaticComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyGreedyStaticComp should still be active", (Object)bsStatic);
            Dictionary compProps = bsStatic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for static 0..1.", this.toList(RANK_2), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for static 1..1.", this.toList(RANK_2), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with lower ranking should be bound for static 0..n.", this.toList(RANK_1, RANK_2), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with lower ranking should be bound for static 1..n.", this.toList(RANK_1, RANK_2), (List)compProps.get("bind1n"));
            bsDynamic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyGreedyDynamicComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyGreedyDynamicComp should still be active", (Object)bsDynamic);
            compProps = bsDynamic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for dynamic 0..1.", this.toList(RANK_2), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with lower ranking should be ignored for dynamic 1..1.", this.toList(RANK_2), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with lower ranking should be bound for dynamic 0..n.", this.toList(RANK_1, RANK_2), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with lower ranking should be bound for dynamic 1..n.", this.toList(RANK_1, RANK_2), (List)compProps.get("bind1n"));
            props.put("service.ranking", RANK_3);
            srHigher = this.registerService(PropertiesProvider.class.getName(), new DefaultPropertiesProvider(null), (Dictionary)props.clone());
            Thread.sleep(timeout);
            bsStatic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyGreedyStaticComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyGreedyStaticComp should still be active", (Object)bsStatic);
            compProps = bsStatic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with higher ranking should be bound for static 0..1.", this.toList(RANK_3), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for static 1..1.", this.toList(RANK_3), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for static 0..n.", this.toList(RANK_1, RANK_2, RANK_3), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for static 1..n.", this.toList(RANK_1, RANK_2, RANK_3), (List)compProps.get("bind1n"));
            bsDynamic = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.PolicyGreedyDynamicComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.PolicyGreedyDynamicComp should still be active", (Object)bsDynamic);
            compProps = bsDynamic.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            DSTest.assertEqualElements("New target service with higher ranking should be bound for dynamic 0..1.", this.toList(RANK_2, RANK_3), (List)compProps.get("bind01"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for dynamic 1..1.", this.toList(RANK_2, RANK_3), (List)compProps.get("bind11"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for dynamic 0..n.", this.toList(RANK_1, RANK_2, RANK_3), (List)compProps.get("bind0n"));
            DSTest.assertEqualElements("New target service with higher ranking should be bound for dynamic 1..n.", this.toList(RANK_1, RANK_2, RANK_3), (List)compProps.get("bind1n"));
        }
        catch (Throwable throwable) {
            this.uninstallBundle(tb25);
            if (sr != null) {
                this.unregisterService(sr);
            }
            if (srLower != null) {
                this.unregisterService(srLower);
            }
            if (srHigher != null) {
                this.unregisterService(srHigher);
            }
            throw throwable;
        }
        this.uninstallBundle(tb25);
        if (sr != null) {
            this.unregisterService(sr);
        }
        if (srLower != null) {
            this.unregisterService(srLower);
        }
        if (srHigher != null) {
            this.unregisterService(srHigher);
        }
    }

    @Test
    public void testComponentConfigurationPID() throws Exception {
        ConfigurationAdmin cm = (ConfigurationAdmin)this.trackerCM.getService();
        if (cm == null) {
            return;
        }
        Bundle tb25 = this.installBundle("tb25");
        Configuration config = null;
        try {
            config = cm.getConfiguration("test.changed.configuration.pid", null);
            Hashtable<String, Boolean> configProperties = config.getProperties();
            if (configProperties == null) {
                configProperties = new Hashtable<String, Boolean>();
            }
            ((Dictionary)configProperties).put("test.property", Boolean.TRUE);
            config.update(configProperties);
            Thread.sleep(timeout);
            tb25.start();
            this.waitBundleStart();
            PropertiesProvider bs = this.getBaseService("org.eclipse.equinox.ds.tests.tb25.ConfigPIDComp");
            Assert.assertNotNull((String)"Component org.eclipse.equinox.ds.tests.tb25.ConfigPIDComp should be activated", (Object)bs);
            Dictionary compProps = bs.getProperties();
            Assert.assertNotNull((String)"Component properties should be available.", (Object)compProps);
            Assert.assertEquals((String)"Test property should be set.", (Object)Boolean.TRUE, compProps.get("test.property"));
        }
        finally {
            this.uninstallBundle(tb25);
            if (config != null) {
                config.delete();
            }
        }
    }

    @Test
    public void testScrService() throws BundleException {
        Bundle tb27 = this.installBundle("tb27");
        ServiceReference ref = this.getContext().getServiceReference(ScrService.class);
        ScrService scrService = ref == null ? null : (ScrService)this.getContext().getService(ref);
        Assert.assertNotNull((String)"No ScrService.", (Object)scrService);
        try {
            tb27.start();
            this.waitBundleStart();
            Component[] tb27Comps = scrService.getComponents(tb27);
            Assert.assertNotNull((String)"No tb26 components.", (Object)tb27Comps);
            Assert.assertEquals((String)"Wrong number of components.", (long)1L, (long)tb27Comps.length);
            Component test1 = tb27Comps[0];
            Assert.assertEquals((String)"Wrong name.", (Object)"test1", (Object)test1.getName());
            Reference[] refs = test1.getReferences();
            Assert.assertNotNull((String)"No references.", (Object)refs);
            Assert.assertEquals((String)"Wrong number of references.", (long)1L, (long)refs.length);
            Assert.assertEquals((String)"Wrong ref name.", (Object)"log", (Object)refs[0].getName());
            ServiceReference[] services = refs[0].getServiceReferences();
            Assert.assertNotNull((String)"No service references.", (Object)services);
            Assert.assertEquals((String)"Wrong number of service refs.", (long)1L, (long)services.length);
        }
        finally {
            this.uninstallBundle(tb27);
        }
    }

    private static void assertEqualElements(String message, List list1, List list2) {
        if (list1 == null || list2 == null) {
            Assert.fail((String)message);
        }
        if (list1.size() != list2.size()) {
            Assert.fail((String)message);
        }
        ArrayList tmp = new ArrayList(list2);
        for (Object el : list1) {
            if (!tmp.contains(el)) {
                Assert.fail((String)message);
            }
            tmp.remove(el);
        }
    }

    private List toList(Object el) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(el);
        return list;
    }

    private List toList(Object el1, Object el2) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(el1);
        list.add(el2);
        return list;
    }

    private List toList(Object el1, Object el2, Object el3) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(el1);
        list.add(el2);
        list.add(el3);
        return list;
    }

    private int getBaseConfigData(String componentName) {
        PropertiesProvider s = this.getBaseService(componentName);
        return this.getBaseConfigData(s);
    }

    private int getBaseConfigData(PropertiesProvider s) {
        Dictionary props = null;
        int value = -1;
        if (s != null) {
            Object prop;
            value = 0;
            props = s.getProperties();
            if (props != null && (prop = props.get("config.base.data")) instanceof Integer) {
                value = (Integer)prop;
            }
        }
        return value;
    }

    private PropertiesProvider getBaseService(String componentName) {
        Object[] services = this.trackerBaseService.getServices();
        if (services == null) {
            return null;
        }
        int i = 0;
        while (i < services.length) {
            PropertiesProvider s;
            Dictionary props;
            if (services[i] instanceof PropertiesProvider && (props = (s = (PropertiesProvider)services[i]).getProperties()) != null && ((String)props.get("component.name")).equals(componentName)) {
                return s;
            }
            ++i;
        }
        return null;
    }

    private BundleContext getContext() {
        return DSTestsActivator.getContext();
    }

    private Bundle installBundle(String bundle) throws BundleException {
        Bundle b = this.installer.installBundle(bundle);
        return b;
    }

    private Bundle installBundleAsDirectory(String bundle) throws Exception {
        String reference;
        BundleContext context = this.getContext();
        String location = this.installer.getBundleLocation(bundle);
        if (location.startsWith(reference = "reference:")) {
            location = location.substring(location.indexOf(58) + 1);
        }
        if (!location.endsWith(".jar")) {
            return context.installBundle(location);
        }
        File file = context.getBundle().getDataFile(bundle);
        ZipInputStream in = new ZipInputStream(new URL(location).openStream());
        try {
            ZipEntry ze = in.getNextEntry();
            while (ze != null) {
                String name = ze.getName();
                if (!ze.isDirectory()) {
                    File destination;
                    int index = name.lastIndexOf(47);
                    if (index == -1) {
                        destination = new File(file, name);
                    } else {
                        File dir = new File(file, name.substring(0, index));
                        dir.mkdirs();
                        destination = new File(dir, name.substring(index));
                    }
                    byte[] bytes = new byte[1024];
                    FileOutputStream out = new FileOutputStream(destination);
                    try {
                        int read;
                        while ((read = in.read(bytes)) != -1) {
                            out.write(bytes, 0, read);
                        }
                    }
                    finally {
                        out.close();
                    }
                    in.closeEntry();
                }
                ze = in.getNextEntry();
            }
        }
        finally {
            in.close();
        }
        return context.installBundle(String.valueOf(reference) + file.toURI());
    }

    private void uninstallBundle(Bundle bundle) throws BundleException {
        this.installer.uninstallBundle(bundle);
    }

    private ServiceRegistration registerService(String className, Object service, Dictionary props) {
        ServiceRegistration sr = this.getContext().registerService(className, service, props);
        this.registeredServices.put(service, sr);
        return sr;
    }

    private void unregisterService(Object service) {
        ServiceRegistration sr = (ServiceRegistration)this.registeredServices.get(service);
        if (sr != null) {
            sr.unregister();
            this.registeredServices.remove(service);
        }
    }

    private void unregisterService(ServiceRegistration reg) {
        Enumeration e = this.registeredServices.keys();
        while (e.hasMoreElements()) {
            Object service = e.nextElement();
            if (reg != null && this.registeredServices.get(service) != reg) continue;
            this.unregisterService(service);
        }
    }

    private void unregisterAllServices() {
        Enumeration e = this.registeredServices.keys();
        while (e.hasMoreElements()) {
            Object service = e.nextElement();
            this.unregisterService(service);
        }
    }

    private void log(String msg) {
    }

    public void sleep0(long millisToSleep) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        } while (System.currentTimeMillis() - start < millisToSleep);
    }

    private void waitBundleStart() {
        if (!this.synchronousBuild) {
            this.sleep0(2 * timeout);
        }
    }

    public void disableTestComponentDefinitionReloadedOnBundleUpdateInDevModeWhenUsingWildcardInServiceComponentHeader() throws Exception {
        System.setProperty("equinox.ds.dbstore", Boolean.TRUE.toString());
        System.setProperty("osgi.checkConfiguration", Boolean.TRUE.toString());
        String serviceName = "org.eclipse.equinox.ds.tests.tb26.Component";
        Bundle b = this.installBundleAsDirectory("tb26");
        try {
            b.start();
            this.waitBundleStart();
            BundleContext context = this.getContext();
            ServiceReference ref = context.getServiceReference(serviceName);
            Assert.assertNotNull((String)"Component service not registered on start", (Object)ref);
            Object service = context.getService(ref);
            Class<?> clazz = service.getClass();
            Assert.assertEquals((String)"Wrong Component service", (Object)"org.eclipse.equinox.ds.tests.tb26.impl.Component1", (Object)clazz.getName());
            clazz.getMethod("update", null).invoke(service, null);
            b.stop();
            b.start();
            this.waitBundleStart();
            ref = context.getServiceReference(serviceName);
            Assert.assertNotNull((String)"Component service not registered on restart", (Object)ref);
            service = context.getService(ref);
            clazz = service.getClass();
            Assert.assertEquals((String)"Wrong component service", (Object)"org.eclipse.equinox.ds.tests.tb26.impl.Component2", (Object)clazz.getName());
        }
        finally {
            this.uninstallBundle(b);
        }
    }

    class OverloadManager
    extends Thread {
        private String compPrefix;
        private int firstComp;
        private int lastComp;

        public OverloadManager(String compPrefix, int first, int last) {
            this.compPrefix = compPrefix;
            this.firstComp = first;
            this.lastComp = last;
        }

        public void run() {
            ConfigurationAdmin cm = (ConfigurationAdmin)DSTest.this.trackerCM.getService();
            Assert.assertNotNull((String)"The ConfigurationAdmin should be available", (Object)cm);
            try {
                int i = this.firstComp;
                while (i <= this.lastComp) {
                    Configuration config = cm.getConfiguration(String.valueOf(this.compPrefix) + i, null);
                    Hashtable<String, Integer> properties = config.getProperties();
                    if (properties == null) {
                        properties = new Hashtable<String, Integer>();
                    }
                    ((Dictionary)properties).put("component.index", i);
                    config.update(properties);
                    DSTest.this.sleep0(100L);
                    ++i;
                }
            }
            catch (IOException iOException) {
                return;
            }
        }

        public boolean isAllComponentsRunning() {
            int i = this.firstComp;
            while (i <= this.lastComp) {
                if (DSTest.this.getBaseService(String.valueOf(this.compPrefix) + i) == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

