/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public class Bug196525
extends AbstractFwkAdminTest {
    private File installFolder = null;
    private File configurationFolder = null;
    private String launcherName = "eclipse";
    private File bundleTXT;
    private File configINI;

    public Bug196525(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        this.installFolder = Activator.getContext().getDataFile(Bug196525.class.getName());
        this.configurationFolder = new File(this.installFolder, "configuration");
        this.bundleTXT = new File(this.configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.configINI = new File(this.configurationFolder, "config.ini");
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(this.configurationFolder);
        launcherData.setLauncher(new File(this.installFolder, this.launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
    }

    public void testConfigContent() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException, URISyntaxException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(this.configurationFolder);
        launcherData.setLauncher(new File(this.installFolder, this.launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            this.assertContains("1.0", manipulator.getConfigData().getBundles(), URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))));
            this.assertContains("2.0", manipulator.getConfigData().getBundles(), URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))));
        }
        catch (URISyntaxException uRISyntaxException) {
            Bug196525.fail((String)"Unexpected failure while creating URI");
        }
        BundleInfo bundle1Bi = new BundleInfo("bundle_1", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, true);
        manipulator.getConfigData().addBundle(bundle1Bi);
        manipulator.save(false);
        this.assertContent(this.bundleTXT, "org.eclipse.osgi");
        this.assertContent(this.configINI, "org.eclipse.osgi");
        this.assertContent(this.bundleTXT, "org.eclipse.equinox.simpleconfigurator");
        this.assertContent(this.configINI, "org.eclipse.equinox.simpleconfigurator");
        this.assertContent(this.bundleTXT, "bundle_1");
    }
}

