/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;

public class CleanupTest
extends FwkAdminAndSimpleConfiguratorTest {
    Manipulator m = null;

    public CleanupTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m = this.createMinimalConfiguration(CleanupTest.class.getName());
    }

    public void testSimpleConfiguratorRemoval() {
        BundleInfo[] bis = this.m.getConfigData().getBundles();
        int i = 0;
        while (i < bis.length) {
            if (bis[i].getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bis[i]);
            }
            ++i;
        }
        try {
            this.m.save(false);
        }
        catch (IOException iOException) {
            CleanupTest.fail((String)"Error while saving");
        }
        this.assertNothing(new File(this.getConfigurationFolder(), "org.eclipse.equinox.simpleconfigurator"));
        this.assertIsDirectory(this.getConfigurationFolder());
        bis = this.m.getConfigData().getBundles();
        i = 0;
        while (i < bis.length) {
            if (bis[i].getSymbolicName().equals("org.eclipse.osgi")) {
                this.m.getConfigData().removeBundle(bis[i]);
            }
            ++i;
        }
        try {
            this.m.save(false);
        }
        catch (IOException iOException) {
            CleanupTest.fail((String)"Error while saving");
        }
        this.assertNothing(this.getConfigurationFolder());
        this.assertNothing(new File(this.getInstallFolder(), String.valueOf(this.getLauncherName()) + ".ini"));
    }

    public void testOSGiRemoval() {
        BundleInfo[] bis = this.m.getConfigData().getBundles();
        int i = 0;
        while (i < bis.length) {
            if (bis[i].getSymbolicName().equals("org.eclipse.osgi")) {
                this.m.getConfigData().removeBundle(bis[i]);
            }
            ++i;
        }
        try {
            this.m.save(false);
        }
        catch (IOException iOException) {
            CleanupTest.fail((String)"Error while saving");
        }
        this.assertIsDirectory(new File(this.getConfigurationFolder(), "org.eclipse.equinox.simpleconfigurator"));
        this.assertIsDirectory(this.getConfigurationFolder());
        this.assertNotContent(new File(this.getConfigurationFolder(), "org.eclipse.equinox.simpleconfigurator/bundles.info"), "org.eclipse.osgi");
        bis = this.m.getConfigData().getBundles();
        i = 0;
        while (i < bis.length) {
            if (bis[i].getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bis[i]);
            }
            ++i;
        }
        try {
            this.m.save(false);
        }
        catch (IOException iOException) {
            CleanupTest.fail((String)"Error while saving");
        }
        this.assertNothing(this.getConfigurationFolder());
        this.assertNothing(new File(this.getInstallFolder(), String.valueOf(this.getLauncherName()) + ".ini"));
    }

    public void testWithMutipleBundles() throws IOException, URISyntaxException {
        BundleInfo bi = new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, false);
        this.m.getConfigData().addBundle(bi);
        this.m.save(false);
        BundleInfo[] bis = this.m.getConfigData().getBundles();
        int i = 0;
        while (i < bis.length) {
            if (bis[i].getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bis[i]);
            }
            ++i;
        }
        this.m.save(false);
        this.assertNothing(this.getBundleTxt());
        this.assertContent(this.getConfigIni(), "bundle_1");
    }
}

