/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.internal.frameworkadmin.equinox.ParserUtils;

public class ParserUtilsTest
extends AbstractFwkAdminTest {
    public ParserUtilsTest(String name) {
        super(name);
    }

    public void testGetValueForArgument() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-foo");
        args.add("bar");
        ParserUtilsTest.assertEquals((String)"bar", (String)ParserUtils.getValueForArgument((String)"-foo", args));
        args.set(1, "-bar");
        ParserUtilsTest.assertEquals(null, (String)ParserUtils.getValueForArgument((String)"-foo", args));
    }

    public void testRemoveArgument() throws Exception {
        String[] args = new String[]{"-bar", "-foo", "-other"};
        ParserUtils.removeArgument((String)"-foo", Arrays.asList(args));
        String[] stringArray = new String[3];
        stringArray[0] = "-bar";
        stringArray[2] = "-other";
        this.assertEquals(args, stringArray);
        args = new String[]{"-bar", "-foo", "other"};
        ParserUtils.removeArgument((String)"-foo", Arrays.asList(args));
        String[] stringArray2 = new String[3];
        stringArray2[0] = "-bar";
        this.assertEquals(args, stringArray2);
        args = new String[]{"-bar", "-foo", "s-pecial"};
        ParserUtils.removeArgument((String)"-foo", Arrays.asList(args));
        String[] stringArray3 = new String[3];
        stringArray3[0] = "-bar";
        this.assertEquals(args, stringArray3);
    }

    public void testSetValueForArgument() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        ParserUtils.setValueForArgument((String)"-foo", (String)"bar", args);
        ParserUtilsTest.assertTrue((args.size() == 2 ? 1 : 0) != 0);
        ParserUtilsTest.assertEquals((String)((String)args.get(0)), (String)"-foo");
        ParserUtilsTest.assertEquals((String)((String)args.get(1)), (String)"bar");
        args.add("-other");
        args.set(1, "s-pecial");
        ParserUtils.setValueForArgument((String)"-foo", (String)"bas", args);
        ParserUtilsTest.assertTrue((args.size() == 3 ? 1 : 0) != 0);
        ParserUtilsTest.assertEquals((String)((String)args.get(0)), (String)"-foo");
        ParserUtilsTest.assertEquals((String)((String)args.get(1)), (String)"bas");
        ParserUtilsTest.assertEquals((String)((String)args.get(2)), (String)"-other");
        args.remove(1);
        ParserUtils.setValueForArgument((String)"-foo", (String)"bas", args);
        ParserUtilsTest.assertTrue((args.size() == 3 ? 1 : 0) != 0);
        ParserUtilsTest.assertEquals((String)((String)args.get(0)), (String)"-foo");
        ParserUtilsTest.assertEquals((String)((String)args.get(1)), (String)"bas");
        ParserUtilsTest.assertEquals((String)((String)args.get(2)), (String)"-other");
    }

    public void testFromOSGiJarToOSGiInstallArea() {
        String path = "";
        File result = ParserUtils.fromOSGiJarToOSGiInstallArea((String)path);
        ParserUtilsTest.assertNotNull((String)"1.0", (Object)result);
        path = "osgi.jar";
        result = ParserUtils.fromOSGiJarToOSGiInstallArea((String)path);
        ParserUtilsTest.assertNotNull((String)"1.0", (Object)result);
        ParserUtilsTest.assertEquals((String)"1.1", (String)"", (String)result.toString());
    }
}

