/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.BundleException;

public class SimpleConfiguratorComingAndGoing
extends FwkAdminAndSimpleConfiguratorTest {
    Manipulator m = null;

    public SimpleConfiguratorComingAndGoing(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m = this.createMinimalConfiguration(SimpleConfiguratorComingAndGoing.class.getName());
    }

    public void testWithMutipleBundles() throws IOException, BundleException, URISyntaxException {
        BundleInfo bi = new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, false);
        this.m.getConfigData().addBundle(bi);
        this.m.save(false);
        BundleInfo[] bis = this.m.getConfigData().getBundles();
        int i = 0;
        while (i < bis.length) {
            if (bis[i].getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bis[i]);
            }
            ++i;
        }
        this.m.save(false);
        this.assertNothing(this.getBundleTxt());
        this.assertContent(this.getConfigIni(), "bundle_1");
        this.assertContent(this.getConfigIni(), "org.eclipse.osgi");
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator newManipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = newManipulator.getLauncherData();
        launcherData.setFwConfigLocation(this.getConfigurationFolder());
        launcherData.setLauncher(new File(this.getInstallFolder(), this.getLauncherName()));
        try {
            newManipulator.load();
        }
        catch (IllegalStateException illegalStateException) {}
        newManipulator.getConfigData().addBundle(new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true));
        newManipulator.save(false);
        this.assertContent(this.getBundleTxt(), "org.eclipse.osgi");
        this.assertContent(this.getBundleTxt(), "bundle_1");
        this.assertContent(this.getBundleTxt(), "org.eclipse.equinox.simpleconfigurator");
    }
}

