/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.testbase;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.tests.bundle.Activator;
import org.eclipse.equinox.http.servlet.tests.bundle.BundleAdvisor;
import org.eclipse.equinox.http.servlet.tests.bundle.BundleInstaller;
import org.eclipse.equinox.http.servlet.tests.util.ServletRequestAdvisor;
import org.junit.After;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.util.tracker.ServiceTracker;

public class BaseTest {
    protected static final String PROTOTYPE = "prototype/";
    protected static final String CONFIGURE = "configure";
    protected static final String UNREGISTER = "unregister";
    protected static final String ERROR = "error";
    protected static final String STATUS_PARAM = "servlet.init.status";
    protected static final String TEST_PROTOTYPE_NAME = "test.prototype.name";
    protected static final String TEST_PATH_CUSTOMIZER_NAME = "test.path.customizer.name";
    protected static final String TEST_ERROR_CODE = "test.error.code";
    protected static final String EQUINOX_DS_BUNDLE = "org.eclipse.equinox.ds";
    protected static final String EQUINOX_JETTY_BUNDLE = "org.eclipse.equinox.http.jetty";
    protected static final String JETTY_PROPERTY_PREFIX = "org.eclipse.equinox.http.jetty.";
    protected static final String OSGI_HTTP_PORT_PROPERTY = "org.osgi.service.http.port";
    protected static final String STATUS_OK = "OK";
    protected static final String TEST_BUNDLES_BINARY_DIRECTORY = "/bundles_bin/";
    protected static final String TEST_BUNDLE_1 = "tb1";
    protected static final String TEST_BUNDLE_2 = "tb2";
    protected static final String[] BUNDLES = new String[]{"org.eclipse.equinox.ds"};
    protected BundleInstaller installer;
    protected BundleAdvisor advisor;
    protected ServletRequestAdvisor requestAdvisor;
    protected final Collection<ServiceRegistration<? extends Object>> registrations = new ArrayList<ServiceRegistration<? extends Object>>();
    protected ServiceTracker<HttpServiceRuntime, HttpServiceRuntime> runtimeTracker;

    @Before
    public void setUp() throws Exception {
        System.setProperty("/.LEVEL", "OFF");
        System.setProperty("org.eclipse.jetty.server.LEVEL", "OFF");
        System.setProperty("org.eclipse.jetty.servlet.LEVEL", "OFF");
        System.setProperty(OSGI_HTTP_PORT_PROPERTY, "0");
        BundleContext bundleContext = this.getBundleContext();
        this.installer = new BundleInstaller(TEST_BUNDLES_BINARY_DIRECTORY, bundleContext);
        this.advisor = new BundleAdvisor(bundleContext);
        this.startBundles();
        this.stopJetty();
        this.runtimeTracker = new ServiceTracker(bundleContext, HttpServiceRuntime.class, null);
        this.runtimeTracker.open();
        this.runtimeTracker.waitForService(100L);
        this.startJetty();
    }

    @After
    public void tearDown() throws Exception {
        for (ServiceRegistration<? extends Object> serviceRegistration : this.registrations) {
            serviceRegistration.unregister();
        }
        this.runtimeTracker.close();
        this.stopJetty();
        this.stopBundles();
        this.requestAdvisor = null;
        this.advisor = null;
        this.registrations.clear();
        try {
            this.installer.shutdown();
        }
        finally {
            this.installer = null;
        }
    }

    protected String doRequest(String action, Map<String, String> params) throws IOException {
        return this.doRequestGetResponse(action, params).get("responseBody").get(0);
    }

    protected Map<String, List<String>> doRequestGetResponse(String action, Map<String, String> params) throws IOException {
        StringBuilder requestInfo = new StringBuilder(PROTOTYPE);
        requestInfo.append(action);
        if (!params.isEmpty()) {
            boolean firstParam = true;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (firstParam) {
                    requestInfo.append('?');
                    firstParam = false;
                } else {
                    requestInfo.append('&');
                }
                requestInfo.append(param.getKey());
                requestInfo.append('=');
                requestInfo.append(param.getValue());
            }
        }
        return this.requestAdvisor.request(requestInfo.toString(), null);
    }

    protected BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    protected String getContextPath() {
        return this.getJettyProperty("context.path", "");
    }

    protected HttpService getHttpService() {
        ServiceReference serviceReference = this.getBundleContext().getServiceReference(HttpService.class);
        return (HttpService)this.getBundleContext().getService(serviceReference);
    }

    protected String getJettyProperty(String key, String defaultValue) {
        String qualifiedKey = JETTY_PROPERTY_PREFIX + key;
        String value = this.getProperty(qualifiedKey);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected String getPort() {
        String defaultPort = this.getProperty(OSGI_HTTP_PORT_PROPERTY);
        if (defaultPort == null) {
            defaultPort = "80";
        }
        return this.getJettyProperty("port", defaultPort);
    }

    protected String getProperty(String key) {
        BundleContext bundleContext = this.getBundleContext();
        String value = bundleContext.getProperty(key);
        return value;
    }

    protected List<String> getStringPlus(String key, ServiceReference<?> ref) {
        Object property = ref.getProperty(key);
        if (String.class.isInstance(property)) {
            return Collections.singletonList((String)property);
        }
        if (String[].class.isInstance(property)) {
            return Arrays.asList((String[])property);
        }
        if (Collection.class.isInstance(property)) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object o : (Collection)property) {
                if (!String.class.isInstance(o)) continue;
                list.add((String)o);
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected Bundle installBundle(String bundle) throws BundleException {
        return this.installer.installBundle(bundle);
    }

    protected void startBundles() throws BundleException {
        String[] stringArray = BUNDLES;
        int n = BUNDLES.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            this.advisor.startBundle(bundle);
            ++n2;
        }
    }

    protected void startJetty() throws Exception {
        this.advisor.startBundle(EQUINOX_JETTY_BUNDLE);
        ServiceReference runtimeReference = this.runtimeTracker.getServiceReference();
        List<String> endpoints = this.getStringPlus("osgi.http.endpoint", runtimeReference);
        String port = this.getPort();
        if (port.equals("0") && !endpoints.isEmpty()) {
            for (String endpoint : endpoints) {
                if (!endpoint.startsWith("http://")) continue;
                port = String.valueOf(new URL(endpoint).getPort());
                break;
            }
            if (port.equals("-1")) {
                port = "80";
            }
        }
        String contextPath = this.getContextPath();
        this.requestAdvisor = new ServletRequestAdvisor(port, contextPath);
    }

    protected void stopBundles() throws BundleException {
        int i = BUNDLES.length - 1;
        while (i >= 0) {
            String bundle = BUNDLES[i];
            this.advisor.stopBundle(bundle);
            --i;
        }
    }

    protected void stopJetty() throws BundleException {
        this.advisor.stopBundle(EQUINOX_JETTY_BUNDLE);
    }

    protected void uninstallBundle(Bundle bundle) throws BundleException {
        this.installer.uninstallBundle(bundle);
    }

    protected void write(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(StandardCharsets.UTF_8));
    }

    protected static class ErrorServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private final String errorCode;

        public ErrorServlet(String errorCode) {
            this.errorCode = errorCode;
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (response.isCommitted()) {
                System.out.println("Problem?");
                return;
            }
            PrintWriter writer = response.getWriter();
            String requestURI = (String)request.getAttribute("javax.servlet.error.request_uri");
            Integer status = (Integer)request.getAttribute("javax.servlet.error.status_code");
            writer.print(String.valueOf(this.errorCode) + " : " + status + " : ERROR : " + requestURI);
        }
    }

    protected static class TestContextPathAdaptor
    extends ContextPathCustomizer {
        private final String defaultFilter;
        private final String contextPrefix;
        private final String testName;

        public TestContextPathAdaptor(String defaultFilter, String contextPrefix, String testName) {
            this.defaultFilter = defaultFilter;
            this.contextPrefix = contextPrefix;
            this.testName = testName;
        }

        public String getDefaultContextSelectFilter(ServiceReference<?> httpWhiteBoardService) {
            if (this.testName.equals(httpWhiteBoardService.getProperty("servlet.init.test.path.customizer.name"))) {
                return this.defaultFilter;
            }
            return null;
        }

        public String getContextPathPrefix(ServiceReference<ServletContextHelper> helper) {
            if (this.testName.equals(helper.getProperty(BaseTest.TEST_PATH_CUSTOMIZER_NAME))) {
                return this.contextPrefix;
            }
            return null;
        }
    }

    protected static class TestFilter
    implements Filter {
        AtomicInteger called = new AtomicInteger(0);

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.called.incrementAndGet();
            chain.doFilter(request, response);
        }

        public void destroy() {
        }

        public void clear() {
            this.called.set(0);
        }

        public boolean getCalled() {
            return this.called.get() >= 1;
        }

        public int getCount() {
            return this.called.get();
        }
    }

    protected static class TestServletContextHelperFactory
    implements ServiceFactory<ServletContextHelper> {
        public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
            return new TestServletContextHelper(bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
        }

        static class TestServletContextHelper
        extends ServletContextHelper {
            public TestServletContextHelper(Bundle bundle) {
                super(bundle);
            }
        }
    }
}

