/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.equinox.http.servlet.RangeAwareServletContextHelper;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.session.HttpSessionInvalidator;
import org.eclipse.equinox.http.servlet.testbase.BaseTest;
import org.eclipse.equinox.http.servlet.tests.util.AsyncOutputServlet;
import org.eclipse.equinox.http.servlet.tests.util.BaseAsyncServlet;
import org.eclipse.equinox.http.servlet.tests.util.BaseChangeSessionIdServlet;
import org.eclipse.equinox.http.servlet.tests.util.BaseHttpContext;
import org.eclipse.equinox.http.servlet.tests.util.BaseHttpSessionAttributeListener;
import org.eclipse.equinox.http.servlet.tests.util.BaseHttpSessionIdListener;
import org.eclipse.equinox.http.servlet.tests.util.BaseServlet;
import org.eclipse.equinox.http.servlet.tests.util.BaseServletContextAttributeListener;
import org.eclipse.equinox.http.servlet.tests.util.BaseServletContextListener;
import org.eclipse.equinox.http.servlet.tests.util.BaseServletRequestAttributeListener;
import org.eclipse.equinox.http.servlet.tests.util.BaseServletRequestListener;
import org.eclipse.equinox.http.servlet.tests.util.BufferedServlet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;
import org.osgi.util.tracker.ServiceTracker;

public class ServletTest
extends BaseTest {
    @Rule
    public TestName testName = new TestName();
    private static final String HTTP_CONTEXT_TEST_ROOT = "http.context.test";

    @Test
    public void test_ErrorPage1() throws Exception {
        String expected = "403 ERROR :";
        String actual = null;
        Map<Object, Object> response = Collections.emptyMap();
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            response = this.requestAdvisor.request("TestErrorPage1/a", null);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        String responseCode = (String)((List)response.get("responseCode")).get(0);
        actual = (String)((List)response.get("responseBody")).get(0);
        Assert.assertEquals((Object)"403", (Object)responseCode);
        Assert.assertTrue((String)("Expected <" + expected + "*> but got <" + actual + ">"), (boolean)actual.startsWith(expected));
    }

    @Test
    public void test_ErrorPage2() throws Exception {
        String expected = "org.eclipse.equinox.http.servlet.tests.tb1.TestErrorPage2$MyException ERROR :";
        String actual = null;
        Map<Object, Object> response = Collections.emptyMap();
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            response = this.requestAdvisor.request("TestErrorPage2/a", null);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        String responseCode = (String)((List)response.get("responseCode")).get(0);
        actual = (String)((List)response.get("responseBody")).get(0);
        Assert.assertEquals((Object)"500", (Object)responseCode);
        Assert.assertTrue((String)("Expected <" + expected + "*> but got <" + actual + ">"), (boolean)actual.startsWith(expected));
    }

    @Test
    public void test_ErrorPage3() throws Exception {
        String expected = "400 ERROR :";
        String actual = null;
        Map<Object, Object> response = Collections.emptyMap();
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            response = this.requestAdvisor.request("TestErrorPage3/a", null);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        String responseCode = (String)((List)response.get("responseCode")).get(0);
        actual = (String)((List)response.get("responseBody")).get(0);
        Assert.assertEquals((Object)"400", (Object)responseCode);
        Assert.assertTrue((String)("Expected <" + expected + "*> but got <" + actual + ">"), (boolean)actual.startsWith(expected));
    }

    @Test
    public void test_ErrorPage4() throws Exception {
        String actual = null;
        Map<Object, Object> response = Collections.emptyMap();
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            response = this.requestAdvisor.request("TestErrorPage4/a", null);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        String responseCode = (String)((List)response.get("responseCode")).get(0);
        actual = (String)((List)response.get("responseBody")).get(0);
        Assert.assertEquals((Object)"401", (Object)responseCode);
        Assert.assertEquals((Object)"", (Object)actual);
    }

    @Test
    public void test_ErrorPage5() throws Exception {
        Hashtable<String, String> errorProps = new Hashtable<String, String>();
        ((Dictionary)errorProps).put("osgi.http.whiteboard.servlet.name", "E5.4xx");
        ((Dictionary)errorProps).put("osgi.http.whiteboard.servlet.errorPage", "4xx");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BaseTest.ErrorServlet("4xx"), errorProps));
        errorProps = new Hashtable();
        ((Dictionary)errorProps).put("osgi.http.whiteboard.servlet.name", "E5.5xx");
        ((Dictionary)errorProps).put("osgi.http.whiteboard.servlet.errorPage", "5xx");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BaseTest.ErrorServlet("5xx"), errorProps));
        for (String expectedCode : Arrays.asList("400", "450", "499", "500", "550", "599")) {
            Map<String, List<String>> response = this.doRequestGetResponse("error", Collections.singletonMap("test.error.code", expectedCode));
            String expectedResponse = String.valueOf(expectedCode.charAt(0)) + "xx : " + expectedCode + " : ERROR";
            String actualCode = response.get("responseCode").get(0);
            String actualResponse = response.get("responseBody").get(0);
            Assert.assertEquals((Object)expectedCode, (Object)actualCode);
            Assert.assertTrue((String)("Expected <" + expectedResponse + "*> but got <" + actualResponse + ">"), (boolean)actualResponse.startsWith(expectedResponse));
        }
    }

    @Test
    public void test_ErrorPage6() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getWriter().write("Hello!");
                response.setStatus(444);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E6");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/TestErrorPage6/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E6.error");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.errorPage", "444");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BaseTest.ErrorServlet("444"), props));
        Map<String, List<String>> response = this.requestAdvisor.request("TestErrorPage6/a", null);
        String responseCode = response.get("responseCode").get(0);
        String responseBody = response.get("responseBody").get(0);
        Assert.assertEquals((Object)"444", (Object)responseCode);
        Assert.assertNotEquals((Object)"444 : 444 : ERROR : /TestErrorPage6/a", (Object)responseBody);
    }

    @Test
    public void test_ErrorPage7() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.setStatus(422);
                PrintWriter printWriter = new PrintWriter((OutputStream)resp.getOutputStream());
                printWriter.println("{");
                printWriter.println("error: 'An error message',");
                printWriter.println("code: 'An error code'");
                printWriter.println("}");
                printWriter.flush();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E7");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/TestErrorPage7/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E7.error");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.errorPage", String.valueOf(422));
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BaseTest.ErrorServlet(String.valueOf(422)), props));
        Map<String, List<String>> response = this.requestAdvisor.request("TestErrorPage7/a", null);
        String responseCode = response.get("responseCode").get(0);
        String responseBody = response.get("responseBody").get(0);
        Assert.assertEquals((Object)String.valueOf(422), (Object)responseCode);
        Assert.assertNotEquals((Object)"422 : 422 : ERROR : /TestErrorPage7/a", (Object)responseBody);
    }

    @Test
    public void test_ErrorPage8() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                throw new RuntimeException();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E8");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/TestErrorPage8/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E8.error");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.errorPage", RuntimeException.class.getName());
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BaseTest.ErrorServlet("500"), props));
        Map<String, List<String>> response = this.requestAdvisor.request("TestErrorPage8/a", null);
        String responseCode = response.get("responseCode").get(0);
        String responseBody = response.get("responseBody").get(0);
        Assert.assertEquals((Object)"500", (Object)responseCode);
        Assert.assertEquals((Object)"500 : 500 : ERROR : /TestErrorPage8/a", (Object)responseBody);
    }

    @Test
    public void test_ErrorPage9() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                throw new IOException();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E9");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/TestErrorPage9/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E9.error");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.errorPage", IOException.class.getName());
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BaseTest.ErrorServlet("500"), props));
        Map<String, List<String>> response = this.requestAdvisor.request("TestErrorPage9/a", null);
        String responseCode = response.get("responseCode").get(0);
        String responseBody = response.get("responseBody").get(0);
        Assert.assertEquals((Object)"500", (Object)responseCode);
        Assert.assertEquals((Object)"500 : 500 : ERROR : /TestErrorPage9/a", (Object)responseBody);
    }

    @Test
    public void test_ErrorPage10() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.getWriter().write("some output");
                resp.flushBuffer();
                throw new IOException();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E10");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/TestErrorPage10/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        try {
            this.requestAdvisor.request("TestErrorPage10/a");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            return;
        }
        Assert.fail((String)"Expecting java.io.IOException: Premature EOF");
    }

    @Test
    public void test_ErrorPage11() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.sendError(403);
                resp.getOutputStream().flush();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "E10");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/TestErrorPage11/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        try {
            this.requestAdvisor.request("TestErrorPage11/a");
        }
        catch (IOException iOException) {}
    }

    @Test
    public void test_Filter1() throws Exception {
        String actual;
        String expected = "bab";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter1/bab");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter2() throws Exception {
        String actual;
        String expected = "cbabc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter2/cbabc");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter3() throws Exception {
        String actual;
        String expected = "cbdadbc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter3/cbdadbc");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter4() throws Exception {
        String actual;
        String expected = "dcbabcd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter4/dcbabcd");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter5() throws Exception {
        String actual;
        String expected = "bab";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/bab.TestFilter5");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter6() throws Exception {
        String actual;
        String expected = "cbabc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/cbabc.TestFilter6");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter7() throws Exception {
        String actual;
        String expected = "cbdadbc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/cbdadbc.TestFilter7");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter8() throws Exception {
        String actual;
        String expected = "dcbabcd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/dcbabcd.TestFilter8");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter9() throws Exception {
        String actual;
        String expected = "bab";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter9/bab");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter10() throws Exception {
        String actual;
        String expected = "cbabc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter10/cbabc");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter11() throws Exception {
        String actual;
        String expected = "cbdadbc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter11/cbdadbc");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter12() throws Exception {
        String actual;
        String expected = "dcbabcd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter12/dcbabcd");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter13() throws Exception {
        String actual;
        String expected = "bab";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/a.TestFilter13");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter14() throws Exception {
        String actual;
        String expected = "cbabc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/a.TestFilter14");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter15() throws Exception {
        String actual;
        String expected = "cbdadbc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/a.TestFilter15");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter16() throws Exception {
        String actual;
        String expected = "dcbabcd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/a.TestFilter16");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter17() throws Exception {
        String actual;
        String expected = "ebcdadcbe";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter17/foo/bar/baz");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter18() throws Exception {
        String actual;
        String expected = "dbcacbd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter18/foo/bar/baz");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter19() throws Exception {
        String actual;
        String expected = "dfbcacbfd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestFilter18/foo/bar/baz/with/path/info");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Filter20() throws Exception {
        String expected = "a";
        BaseTest.TestFilter testFilter1 = new BaseTest.TestFilter();
        BaseTest.TestFilter testFilter2 = new BaseTest.TestFilter();
        BaseServlet testServlet = new BaseServlet(expected);
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        extendedHttpService.registerFilter("/hello", (Filter)testFilter1, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerFilter("/hello/*", (Filter)testFilter2, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerServlet("/hello", (Servlet)testServlet, null, extendedHttpService.createDefaultHttpContext());
        String actual = this.requestAdvisor.request("hello");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
        testFilter1.clear();
        testFilter2.clear();
        actual = this.requestAdvisor.request("hello/test");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
    }

    @Test
    public void test_Filter21() throws Exception {
        String expected = "a";
        BaseTest.TestFilter testFilter1 = new BaseTest.TestFilter();
        BaseTest.TestFilter testFilter2 = new BaseTest.TestFilter();
        BaseServlet testServlet = new BaseServlet(expected);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F1");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/hello");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)testFilter1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F2");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", "/hello/*");
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)testFilter2, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/hello/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)testServlet, props));
        String actual = this.requestAdvisor.request("hello");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
        testFilter1.clear();
        testFilter2.clear();
        actual = this.requestAdvisor.request("hello/test");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertFalse((String)"testFilter1 got called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
    }

    public void basicFilterTest22(String servlet1Pattern, String servlet2Pattern, String filterPattern, String expected, String[] dispatchers) throws Exception {
        final AtomicReference httpServletRequestWrapper = new AtomicReference();
        final AtomicReference httpServletResponseWrapper = new AtomicReference();
        BaseServlet servlet1 = new BaseServlet(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getRequestDispatcher("index.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        BaseServlet servlet2 = new BaseServlet("a"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                if (httpServletRequestWrapper.get() != null && !request.equals(httpServletRequestWrapper.get())) {
                    throw new ServletException("not the same request");
                }
                if (httpServletResponseWrapper.get() != null && !response.equals(httpServletResponseWrapper.get())) {
                    throw new ServletException("not the same response");
                }
                response.getWriter().print(this.content);
            }
        };
        BaseTest.TestFilter filter = new BaseTest.TestFilter(){

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                response.getWriter().write(98);
                httpServletRequestWrapper.set(new HttpServletRequestWrapper((HttpServletRequest)request));
                httpServletResponseWrapper.set(new HttpServletResponseWrapper((HttpServletResponse)response));
                chain.doFilter((ServletRequest)httpServletRequestWrapper.get(), (ServletResponse)httpServletResponseWrapper.get());
                response.getWriter().write(98);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", servlet1Pattern);
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet1, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", servlet2Pattern);
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet2, props));
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.filter.name", "F22");
        ((Dictionary)props).put("osgi.http.whiteboard.filter.dispatcher", dispatchers);
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", filterPattern);
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)filter, props));
        String response = this.requestAdvisor.request("f22/a");
        Assert.assertEquals((Object)expected, (Object)response);
    }

    @Test
    public void test_Filter22a() throws Exception {
        this.basicFilterTest22("/f22/*", "*.jsp", "/f22/*", "a", new String[]{"REQUEST"});
    }

    @Test
    public void test_Filter22b() throws Exception {
        this.basicFilterTest22("/*", "*.jsp", "/*", "a", new String[]{"REQUEST"});
    }

    @Test
    public void test_Filter22c() throws Exception {
        this.basicFilterTest22("/f22/*", "*.jsp", "*.jsp", "a", new String[]{"REQUEST"});
    }

    @Test
    public void test_Filter22d() throws Exception {
        this.basicFilterTest22("/f22/*", "*.jsp", "/f22/*", "bab", new String[]{"FORWARD"});
    }

    @Test
    public void test_Filter22e() throws Exception {
        this.basicFilterTest22("/*", "*.jsp", "/*", "bab", new String[]{"FORWARD"});
    }

    @Test
    public void test_Filter22f() throws Exception {
        this.basicFilterTest22("/f22/*", "*.jsp", "*.jsp", "bab", new String[]{"FORWARD"});
    }

    @Test
    public void test_Filter22g() throws Exception {
        this.basicFilterTest22("/f22/*", "*.jsp", "/f22/*", "bab", new String[]{"REQUEST", "FORWARD"});
    }

    @Test
    public void test_Filter22h() throws Exception {
        this.basicFilterTest22("/*", "*.jsp", "/*", "bab", new String[]{"REQUEST", "FORWARD"});
    }

    @Test
    public void test_Filter22i() throws Exception {
        this.basicFilterTest22("/f22/*", "*.jsp", "*.jsp", "bab", new String[]{"REQUEST", "FORWARD"});
    }

    @Test
    public void test_Filter23a() throws Exception {
        String expected = "a";
        BaseTest.TestFilter testFilter1 = new BaseTest.TestFilter();
        BaseTest.TestFilter testFilter2 = new BaseTest.TestFilter();
        BaseTest.TestFilter testFilter3 = new BaseTest.TestFilter();
        BaseServlet testServlet = new BaseServlet(expected);
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        extendedHttpService.registerFilter("*.ext", (Filter)testFilter1, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerFilter("/hello/*.ext", (Filter)testFilter2, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerFilter("/hello/test/*.ext", (Filter)testFilter3, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerServlet("/hello", (Servlet)testServlet, null, extendedHttpService.createDefaultHttpContext());
        String actual = this.requestAdvisor.request("hello/test/request");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertFalse((String)"testFilter1 did get called.", (boolean)testFilter1.getCalled());
        Assert.assertFalse((String)"testFilter2 did get called.", (boolean)testFilter2.getCalled());
        Assert.assertFalse((String)"testFilter3 did get called.", (boolean)testFilter3.getCalled());
        testFilter1.clear();
        testFilter2.clear();
        testFilter3.clear();
        actual = this.requestAdvisor.request("hello/test/request.ext");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
        Assert.assertTrue((String)"testFilter3 did not get called.", (boolean)testFilter3.getCalled());
    }

    @Test
    public void test_Filter23b() throws Exception {
        String expected = "a";
        BaseTest.TestFilter testFilter1 = new BaseTest.TestFilter();
        BaseTest.TestFilter testFilter2 = new BaseTest.TestFilter();
        BaseServlet testServlet = new BaseServlet(expected);
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        extendedHttpService.registerFilter("/", (Filter)testFilter1, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerFilter("/hello", (Filter)testFilter2, null, extendedHttpService.createDefaultHttpContext());
        extendedHttpService.registerServlet("/", (Servlet)testServlet, null, extendedHttpService.createDefaultHttpContext());
        String actual = this.requestAdvisor.request("hello_test/request");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertFalse((String)"testFilter2 did get called.", (boolean)testFilter2.getCalled());
        actual = this.requestAdvisor.request("hello/request");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
    }

    @Test
    public void test_Filter23c() throws Exception {
        String expected = "a";
        BaseTest.TestFilter testFilter1 = new BaseTest.TestFilter();
        BaseTest.TestFilter testFilter2 = new BaseTest.TestFilter();
        BaseServlet testServlet = new BaseServlet(expected);
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)testFilter1, new Hashtable<String, String>(Collections.singletonMap("osgi.http.whiteboard.filter.pattern", "/*"))));
        this.registrations.add(this.getBundleContext().registerService(Filter.class, (Object)testFilter2, new Hashtable<String, String>(Collections.singletonMap("osgi.http.whiteboard.filter.pattern", "/hello/*"))));
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)testServlet, new Hashtable<String, String>(Collections.singletonMap("osgi.http.whiteboard.servlet.pattern", "/"))));
        String actual = this.requestAdvisor.request("hello_test/request");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertFalse((String)"testFilter2 did get called.", (boolean)testFilter2.getCalled());
        actual = this.requestAdvisor.request("hello/request");
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
        Assert.assertTrue((String)"testFilter2 did not get called.", (boolean)testFilter2.getCalled());
    }

    @Test
    public void test_Filter24() throws Exception {
        String expected = "a";
        BaseTest.TestFilter testFilter1 = new BaseTest.TestFilter();
        BaseServlet testServlet = new BaseServlet(expected);
        ServiceRegistration filterReg = this.getBundleContext().registerService(Filter.class, (Object)testFilter1, new Hashtable<String, String>(Collections.singletonMap("osgi.http.whiteboard.filter.pattern", "/hello/*")));
        try {
            this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)testServlet, new Hashtable<String, String>(Collections.singletonMap("osgi.http.whiteboard.servlet.pattern", "/hello/*"))));
            String actual = this.requestAdvisor.request("hello/request");
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertTrue((String)"testFilter1 did not get called.", (boolean)testFilter1.getCalled());
            filterReg.unregister();
            filterReg = null;
            testFilter1.clear();
            actual = this.requestAdvisor.request("hello/request");
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertFalse((String)"testFilter1 did get called.", (boolean)testFilter1.getCalled());
        }
        finally {
            if (filterReg != null) {
                filterReg.unregister();
            }
        }
    }

    @Test
    public void test_Registration1() throws Exception {
        String expected = "Alias cannot be null";
        try {
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            extendedHttpService.registerServlet(null, (Servlet)new BaseServlet(), null, null);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)expected, (Object)iae.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void test_Registration2() throws Exception {
        String pattern = "blah";
        String expected = "Invalid pattern '" + pattern + "'";
        try {
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            extendedHttpService.registerServlet(pattern, (Servlet)new BaseServlet(), null, null);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)expected, (Object)iae.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void test_Registration3() throws Exception {
        String pattern = "/blah/";
        String expected = "Invalid pattern '" + pattern + "'";
        try {
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            extendedHttpService.registerServlet(pattern, (Servlet)new BaseServlet(), null, null);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)expected, (Object)iae.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void test_Registration4() throws Exception {
        String pattern = "/blah";
        String expected = "Pattern already in use: " + pattern;
        try {
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            extendedHttpService.registerServlet(pattern, (Servlet)new BaseServlet(), null, null);
            extendedHttpService.registerServlet(pattern, (Servlet)new BaseServlet(), null, null);
        }
        catch (NamespaceException ne) {
            Assert.assertEquals((Object)expected, (Object)ne.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void test_Registration5() throws Exception {
        String alias = "/blah";
        String expected = "Servlet cannot be null";
        try {
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            extendedHttpService.registerServlet(alias, null, null, null);
        }
        catch (IllegalArgumentException iae) {
            Assert.assertEquals((Object)expected, (Object)iae.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void test_Registration6() throws Exception {
        String expected = "Servlet has already been registered:";
        try {
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            BaseServlet servlet = new BaseServlet();
            extendedHttpService.registerServlet("/blah1", (Servlet)servlet, null, null);
            extendedHttpService.registerServlet("/blah2", (Servlet)servlet, null, null);
        }
        catch (ServletException se) {
            Assert.assertTrue((boolean)se.getMessage().startsWith(expected));
            return;
        }
        Assert.fail();
    }

    @Test
    public void test_unregister() throws Exception {
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        BaseServlet servlet = new BaseServlet();
        BaseTest.TestFilter filter = new BaseTest.TestFilter();
        extendedHttpService.registerServlet("/s1", (Servlet)servlet, null, null);
        extendedHttpService.registerFilter("/f1", (Filter)filter, null, null);
        extendedHttpService.registerResources("/r1", "/resources", null);
        extendedHttpService.unregister("/s1");
        extendedHttpService.unregisterFilter((Filter)filter);
        extendedHttpService.unregister("/r1");
    }

    @Test
    public void test_Registration11() throws Exception {
        ServletContextDTO[] servletContextDTOs;
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        BaseServlet servlet = new BaseServlet();
        extendedHttpService.registerServlet("/blah1", (Servlet)servlet, null, null);
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(HttpServiceRuntime.class);
        HttpServiceRuntime runtime = (HttpServiceRuntime)bundleContext.getService(serviceReference);
        RuntimeDTO runtimeDTO = runtime.getRuntimeDTO();
        ServletContextDTO[] servletContextDTOArray = servletContextDTOs = runtimeDTO.servletContextDTOs;
        int n = servletContextDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ServletContextDTO servletContextDTO = servletContextDTOArray[n2];
            if (servletContextDTO.name.startsWith("org.eclipse.equinox.http.servlet.internal.HttpServiceImpl$")) {
                ServletDTO servletDTO = servletContextDTO.servletDTOs[0];
                Assert.assertFalse((boolean)servletDTO.asyncSupported);
                Assert.assertEquals((Object)((Object)((Object)servlet)).getClass().getName(), (Object)servletDTO.name);
                Assert.assertEquals((Object)"/blah1", (Object)servletDTO.patterns[0]);
                Assert.assertTrue((servletDTO.serviceId < 0L ? 1 : 0) != 0);
            }
            ++n2;
        }
    }

    @Test
    public void test_Registration12() throws Exception {
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            BundleContext bundleContext = this.getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(HttpServiceRuntime.class);
            HttpServiceRuntime runtime = (HttpServiceRuntime)bundleContext.getService(serviceReference);
            RuntimeDTO runtimeDTO = runtime.getRuntimeDTO();
            ServletContextDTO[] servletContextDTOs = runtimeDTO.servletContextDTOs;
            ServletContextDTO servletContextDTO = servletContextDTOs[0];
            Assert.assertNotNull((Object)servletContextDTO.name);
        }
        finally {
            this.uninstallBundle(bundle);
        }
    }

    @Test
    public void test_Registration13() throws Exception {
        ServletContextDTO[] servletContextDTOs;
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        extendedHttpService.registerResources("/blah1", "/foo", null);
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(HttpServiceRuntime.class);
        HttpServiceRuntime runtime = (HttpServiceRuntime)bundleContext.getService(serviceReference);
        RuntimeDTO runtimeDTO = runtime.getRuntimeDTO();
        ServletContextDTO[] servletContextDTOArray = servletContextDTOs = runtimeDTO.servletContextDTOs;
        int n = servletContextDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ServletContextDTO servletContextDTO = servletContextDTOArray[n2];
            if (servletContextDTO.name.startsWith("org.eclipse.equinox.http.servlet.internal.HttpServiceImpl$")) {
                ResourceDTO resourceDTO = servletContextDTO.resourceDTOs[0];
                Assert.assertEquals((Object)"/blah1/*", (Object)resourceDTO.patterns[0]);
                Assert.assertEquals((Object)"/foo", (Object)resourceDTO.prefix);
                Assert.assertTrue((resourceDTO.serviceId < 0L ? 1 : 0) != 0);
            }
            ++n2;
        }
    }

    @Test
    public void test_Registration14() throws Exception {
        HttpServlet initError = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            public void init(ServletConfig config) throws ServletException {
                throw new ServletException("Init error.");
            }
        };
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        try {
            extendedHttpService.registerServlet("/foo", (Servlet)initError, null, null);
            Assert.fail((String)"Expected an init failure.");
        }
        catch (ServletException e) {
            Assert.assertEquals((String)"Wrong exception message.", (Object)"Init error.", (Object)e.getMessage());
        }
    }

    @Test
    public void test_Registration15() throws Exception {
        HttpServlet initError = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            public void init(ServletConfig config) throws ServletException {
                throw new IllegalStateException("Init error.");
            }
        };
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        try {
            extendedHttpService.registerServlet("/foo", (Servlet)initError, null, null);
            Assert.fail((String)"Expected an init failure.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Wrong exception message.", (Object)"Init error.", (Object)e.getMessage());
        }
    }

    @Test
    public void test_Registration16() throws Exception {
        Filter initError = new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
                throw new IllegalStateException("Init error.");
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            }

            public void destroy() {
            }
        };
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        try {
            extendedHttpService.registerFilter("/foo", initError, null, null);
            Assert.fail((String)"Expected an init failure.");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"Wrong exception message.", (Object)"Init error.", (Object)e.getMessage());
        }
    }

    @Test
    public void test_Registration17() throws Exception {
        Filter initError = new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
                throw new ServletException("Init error.");
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            }

            public void destroy() {
            }
        };
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        try {
            extendedHttpService.registerFilter("/foo", initError, null, null);
            Assert.fail((String)"Expected an init failure.");
        }
        catch (ServletException e) {
            Assert.assertEquals((String)"Wrong exception message.", (Object)"Init error.", (Object)e.getMessage());
        }
    }

    @Test
    public void test_Registration18_WhiteboardServletByNameOnly() throws Exception {
        String expected = "a";
        BaseServlet namedServlet = new BaseServlet(expected);
        HttpServlet targetServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getServletContext().getNamedDispatcher("hello_servlet").forward((ServletRequest)request, (ServletResponse)response);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("osgi.http.whiteboard.servlet.name", "hello_servlet");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)namedServlet, props));
        props = new Hashtable();
        props.put("osgi.http.whiteboard.servlet.pattern", "/s");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)targetServlet, props));
        String actual = this.requestAdvisor.request("s");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_RegistrationTCCL1() {
        String actual;
        String expected;
        Set servletTCCL;
        Set filterTCCL;
        block11: {
            filterTCCL = Collections.synchronizedSet(new HashSet());
            servletTCCL = Collections.synchronizedSet(new HashSet());
            Filter tcclFilter = new Filter(){

                public void init(FilterConfig filterConfig) throws ServletException {
                    filterTCCL.add(Thread.currentThread().getContextClassLoader().getClass().getName());
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                    filterTCCL.add(Thread.currentThread().getContextClassLoader().getClass().getName());
                    chain.doFilter(request, response);
                }

                public void destroy() {
                    filterTCCL.add(Thread.currentThread().getContextClassLoader().getClass().getName());
                }
            };
            HttpServlet tcclServlet = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                public void destroy() {
                    super.destroy();
                    servletTCCL.add(Thread.currentThread().getContextClassLoader().getClass().getName());
                }

                public void init(ServletConfig config) throws ServletException {
                    super.init(config);
                    servletTCCL.add(Thread.currentThread().getContextClassLoader().getClass().getName());
                }

                protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                    servletTCCL.add(Thread.currentThread().getContextClassLoader().getClass().getName());
                    response.getWriter().print(Thread.currentThread().getContextClassLoader().getClass().getName());
                }
            };
            ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
            ClassLoader dummy = new ClassLoader(){};
            Thread.currentThread().setContextClassLoader(dummy);
            expected = dummy.getClass().getName();
            actual = null;
            ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
            try {
                try {
                    extendedHttpService.registerFilter("/tccl", tcclFilter, null, null);
                    extendedHttpService.registerServlet("/tccl", (Servlet)tcclServlet, null, null);
                    actual = this.requestAdvisor.request("tccl");
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception: " + e));
                    Thread.currentThread().setContextClassLoader(originalTCCL);
                    try {
                        extendedHttpService.unregister("/tccl");
                        extendedHttpService.unregisterFilter(tcclFilter);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(originalTCCL);
                try {
                    extendedHttpService.unregister("/tccl");
                    extendedHttpService.unregisterFilter(tcclFilter);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                throw throwable;
            }
            Thread.currentThread().setContextClassLoader(originalTCCL);
            try {
                extendedHttpService.unregister("/tccl");
                extendedHttpService.unregisterFilter(tcclFilter);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)("Wrong filterTCCL size: " + filterTCCL), (long)1L, (long)filterTCCL.size());
        Assert.assertTrue((String)("Wrong filterTCCL: " + filterTCCL), (boolean)filterTCCL.contains(expected));
        Assert.assertEquals((String)("Wrong httpTCCL size: " + servletTCCL), (long)1L, (long)servletTCCL.size());
        Assert.assertTrue((String)("Wrong servletTCCL: " + servletTCCL), (boolean)servletTCCL.contains(expected));
    }

    @Test
    public void test_Sessions01() {
        final AtomicBoolean valueBound = new AtomicBoolean(false);
        final AtomicBoolean valueUnbound = new AtomicBoolean(false);
        final HttpSessionBindingListener bindingListener = new HttpSessionBindingListener(){

            public void valueUnbound(HttpSessionBindingEvent event) {
                valueUnbound.set(true);
            }

            public void valueBound(HttpSessionBindingEvent event) {
                valueBound.set(true);
            }
        };
        final AtomicBoolean sessionCreated = new AtomicBoolean(false);
        final AtomicBoolean sessionDestroyed = new AtomicBoolean(false);
        HttpSessionListener sessionListener = new HttpSessionListener(){

            public void sessionDestroyed(HttpSessionEvent se) {
                sessionDestroyed.set(true);
            }

            public void sessionCreated(HttpSessionEvent se) {
                sessionCreated.set(true);
            }
        };
        HttpServlet sessionServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                HttpSession session = request.getSession();
                if (session.getAttribute("test.attribute") == null) {
                    session.setAttribute("test.attribute", (Object)bindingListener);
                    response.getWriter().print("created");
                } else {
                    session.invalidate();
                    response.getWriter().print("invalidated");
                }
            }
        };
        ServiceRegistration servletReg = null;
        ServiceRegistration sessionListenerReg = null;
        Hashtable<String, String> servletProps = new Hashtable<String, String>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/sessions");
        String actual = null;
        CookieHandler previous = CookieHandler.getDefault();
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        try {
            try {
                servletReg = this.getBundleContext().registerService(Servlet.class, (Object)sessionServlet, servletProps);
                Hashtable<String, String> listenerProps = new Hashtable<String, String>();
                ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
                sessionListenerReg = this.getBundleContext().registerService(HttpSessionListener.class, (Object)sessionListener, listenerProps);
                sessionCreated.set(false);
                valueBound.set(false);
                sessionDestroyed.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"created", (Object)actual);
                Assert.assertTrue((String)"No sessionCreated called", (boolean)sessionCreated.get());
                Assert.assertTrue((String)"No valueBound called", (boolean)valueBound.get());
                Assert.assertFalse((String)"sessionDestroyed was called", (boolean)sessionDestroyed.get());
                Assert.assertFalse((String)"valueUnbound was called", (boolean)valueUnbound.get());
                sessionCreated.set(false);
                valueBound.set(false);
                sessionDestroyed.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"invalidated", (Object)actual);
                Assert.assertFalse((String)"sessionCreated was called", (boolean)sessionCreated.get());
                Assert.assertFalse((String)"valueBound was called", (boolean)valueBound.get());
                Assert.assertTrue((String)"No sessionDestroyed called", (boolean)sessionDestroyed.get());
                Assert.assertTrue((String)"No valueUnbound called", (boolean)valueUnbound.get());
                sessionCreated.set(false);
                sessionDestroyed.set(false);
                valueBound.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"created", (Object)actual);
                Assert.assertTrue((String)"No sessionCreated called", (boolean)sessionCreated.get());
                Assert.assertTrue((String)"No valueBound called", (boolean)valueBound.get());
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception: " + e));
                if (servletReg != null) {
                    servletReg.unregister();
                }
                if (sessionListenerReg != null) {
                    sessionListenerReg.unregister();
                }
                CookieHandler.setDefault(previous);
            }
        }
        finally {
            if (servletReg != null) {
                servletReg.unregister();
            }
            if (sessionListenerReg != null) {
                sessionListenerReg.unregister();
            }
            CookieHandler.setDefault(previous);
        }
    }

    @Test
    public void test_Sessions02() {
        final AtomicReference sessionReference = new AtomicReference();
        HttpServlet sessionServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                HttpSession session = request.getSession();
                sessionReference.set(session);
                if (session.getAttribute("test.attribute") == null) {
                    session.setAttribute("test.attribute", (Object)"foo");
                    response.getWriter().print("created");
                } else {
                    session.setAttribute("test.attribute", null);
                    response.getWriter().print("attribute set to null");
                }
            }
        };
        ServiceRegistration servletReg = null;
        Hashtable<String, String> servletProps = new Hashtable<String, String>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/sessions");
        String actual = null;
        CookieHandler previous = CookieHandler.getDefault();
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        try {
            try {
                servletReg = this.getBundleContext().registerService(Servlet.class, (Object)sessionServlet, servletProps);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"created", (Object)actual);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"attribute set to null", (Object)actual);
                HttpSession httpSession = (HttpSession)sessionReference.get();
                Enumeration names = httpSession.getAttributeNames();
                boolean exist = false;
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (!name.equals("test.attribute")) continue;
                    exist = true;
                }
                Assert.assertFalse((String)"Session atribute was not removed", (boolean)exist);
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception: " + e));
                if (servletReg != null) {
                    servletReg.unregister();
                }
                CookieHandler.setDefault(previous);
            }
        }
        finally {
            if (servletReg != null) {
                servletReg.unregister();
            }
            CookieHandler.setDefault(previous);
        }
    }

    @Test
    public void test_Sessions03_HttpSessionInvalidator() throws Exception {
        ServiceTracker sessionInvalidatorTracker = new ServiceTracker(this.getBundleContext(), HttpSessionInvalidator.class, null);
        sessionInvalidatorTracker.open();
        HttpSessionInvalidator invalidator = (HttpSessionInvalidator)sessionInvalidatorTracker.waitForService(100L);
        final AtomicBoolean valueBound = new AtomicBoolean(false);
        final AtomicBoolean valueUnbound = new AtomicBoolean(false);
        final HttpSessionBindingListener bindingListener = new HttpSessionBindingListener(){

            public void valueUnbound(HttpSessionBindingEvent event) {
                valueUnbound.set(true);
            }

            public void valueBound(HttpSessionBindingEvent event) {
                valueBound.set(true);
            }
        };
        final AtomicBoolean sessionCreated = new AtomicBoolean(false);
        final AtomicBoolean sessionDestroyed = new AtomicBoolean(false);
        final AtomicReference sessionId = new AtomicReference();
        HttpSessionListener sessionListener = new HttpSessionListener(){

            public void sessionDestroyed(HttpSessionEvent se) {
                sessionDestroyed.set(true);
            }

            public void sessionCreated(HttpSessionEvent se) {
                sessionCreated.set(true);
            }
        };
        HttpServlet sessionServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                HttpSession session = request.getSession();
                if (session.getAttribute("test.attribute") == null) {
                    session.setAttribute("test.attribute", (Object)bindingListener);
                    sessionId.set(session.getId());
                    response.getWriter().print("created");
                } else {
                    session.invalidate();
                    response.getWriter().print("invalidated");
                }
            }
        };
        ServiceRegistration servletReg = null;
        ServiceRegistration sessionListenerReg = null;
        Hashtable<String, String> servletProps = new Hashtable<String, String>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/sessions");
        String actual = null;
        CookieHandler previous = CookieHandler.getDefault();
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        try {
            try {
                servletReg = this.getBundleContext().registerService(Servlet.class, (Object)sessionServlet, servletProps);
                Hashtable<String, String> listenerProps = new Hashtable<String, String>();
                ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
                sessionListenerReg = this.getBundleContext().registerService(HttpSessionListener.class, (Object)sessionListener, listenerProps);
                sessionCreated.set(false);
                valueBound.set(false);
                sessionDestroyed.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"created", (Object)actual);
                Assert.assertTrue((String)"No sessionCreated called", (boolean)sessionCreated.get());
                Assert.assertTrue((String)"No valueBound called", (boolean)valueBound.get());
                Assert.assertFalse((String)"sessionDestroyed was called", (boolean)sessionDestroyed.get());
                Assert.assertFalse((String)"valueUnbound was called", (boolean)valueUnbound.get());
                sessionCreated.set(false);
                valueBound.set(false);
                sessionDestroyed.set(false);
                valueUnbound.set(false);
                Assert.assertNotNull(sessionId.get());
                invalidator.invalidate((String)sessionId.get(), true);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"created", (Object)actual);
                Assert.assertTrue((String)"No sessionCreated was called", (boolean)sessionCreated.get());
                Assert.assertTrue((String)"No valueBound was called", (boolean)valueBound.get());
                Assert.assertTrue((String)"No sessionDestroyed called", (boolean)sessionDestroyed.get());
                Assert.assertTrue((String)"No valueUnbound called", (boolean)valueUnbound.get());
                sessionCreated.set(false);
                sessionDestroyed.set(false);
                valueBound.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request("sessions");
                Assert.assertEquals((String)"Wrong result", (Object)"invalidated", (Object)actual);
                Assert.assertFalse((String)"sessionCreated called", (boolean)sessionCreated.get());
                Assert.assertFalse((String)"valueBound called", (boolean)valueBound.get());
                Assert.assertTrue((String)"No sessionDestroyed called", (boolean)sessionDestroyed.get());
                Assert.assertTrue((String)"No valueUnbound called", (boolean)valueUnbound.get());
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception: " + e));
                if (servletReg != null) {
                    servletReg.unregister();
                }
                if (sessionListenerReg != null) {
                    sessionListenerReg.unregister();
                }
                CookieHandler.setDefault(previous);
                sessionInvalidatorTracker.close();
            }
        }
        finally {
            if (servletReg != null) {
                servletReg.unregister();
            }
            if (sessionListenerReg != null) {
                sessionListenerReg.unregister();
            }
            CookieHandler.setDefault(previous);
            sessionInvalidatorTracker.close();
        }
    }

    @Test
    public void test_Sessions04_inlineSessionId() {
        final AtomicBoolean valueBound = new AtomicBoolean(false);
        final AtomicBoolean valueUnbound = new AtomicBoolean(false);
        final HttpSessionBindingListener bindingListener = new HttpSessionBindingListener(){

            public void valueUnbound(HttpSessionBindingEvent event) {
                valueUnbound.set(true);
            }

            public void valueBound(HttpSessionBindingEvent event) {
                valueBound.set(true);
            }
        };
        final AtomicBoolean sessionCreated = new AtomicBoolean(false);
        final AtomicBoolean sessionDestroyed = new AtomicBoolean(false);
        HttpSessionListener sessionListener = new HttpSessionListener(){

            public void sessionDestroyed(HttpSessionEvent se) {
                sessionDestroyed.set(true);
            }

            public void sessionCreated(HttpSessionEvent se) {
                sessionCreated.set(true);
            }
        };
        HttpServlet sessionServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                HttpSession session = request.getSession();
                if (session.getAttribute("test.attribute") == null) {
                    session.setAttribute("test.attribute", (Object)bindingListener);
                    response.getWriter().print(response.encodeURL(request.getRequestURI()));
                } else {
                    session.invalidate();
                    response.getWriter().print("invalidated");
                }
            }
        };
        ServiceRegistration servletReg = null;
        ServiceRegistration sessionListenerReg = null;
        Hashtable<String, String> servletProps = new Hashtable<String, String>();
        ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/sessions");
        String actual = null;
        try {
            try {
                servletReg = this.getBundleContext().registerService(Servlet.class, (Object)sessionServlet, servletProps);
                Hashtable<String, String> listenerProps = new Hashtable<String, String>();
                ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
                sessionListenerReg = this.getBundleContext().registerService(HttpSessionListener.class, (Object)sessionListener, listenerProps);
                sessionCreated.set(false);
                valueBound.set(false);
                sessionDestroyed.set(false);
                valueUnbound.set(false);
                String inlined = this.requestAdvisor.request("sessions");
                Assert.assertTrue((String)("Wrong result: " + inlined), (boolean)inlined.startsWith("/sessions;jsessionid="));
                Assert.assertTrue((String)"No sessionCreated called", (boolean)sessionCreated.get());
                Assert.assertTrue((String)"No valueBound called", (boolean)valueBound.get());
                Assert.assertFalse((String)"sessionDestroyed was called", (boolean)sessionDestroyed.get());
                Assert.assertFalse((String)"valueUnbound was called", (boolean)valueUnbound.get());
                sessionCreated.set(false);
                valueBound.set(false);
                sessionDestroyed.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request(inlined.substring(1));
                Assert.assertEquals((String)"Wrong result", (Object)"invalidated", (Object)actual);
                Assert.assertFalse((String)"sessionCreated was called", (boolean)sessionCreated.get());
                Assert.assertFalse((String)"valueBound was called", (boolean)valueBound.get());
                Assert.assertTrue((String)"No sessionDestroyed called", (boolean)sessionDestroyed.get());
                Assert.assertTrue((String)"No valueUnbound called", (boolean)valueUnbound.get());
                sessionCreated.set(false);
                sessionDestroyed.set(false);
                valueBound.set(false);
                valueUnbound.set(false);
                actual = this.requestAdvisor.request(String.valueOf(inlined.substring(1)) + "?bar=2");
                Assert.assertTrue((String)("Wrong result: " + actual), (boolean)actual.startsWith("/sessions;jsessionid="));
                Assert.assertTrue((String)"No sessionCreated called", (boolean)sessionCreated.get());
                Assert.assertTrue((String)"No valueBound called", (boolean)valueBound.get());
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception: " + e));
                if (servletReg != null) {
                    servletReg.unregister();
                }
                if (sessionListenerReg != null) {
                    sessionListenerReg.unregister();
                }
            }
        }
        finally {
            if (servletReg != null) {
                servletReg.unregister();
            }
            if (sessionListenerReg != null) {
                sessionListenerReg.unregister();
            }
        }
    }

    @Test
    public void test_Resource1() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestResource1/resource1.txt");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Resource2() throws Exception {
        String actual;
        String expected = "cbdadbc";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestResource2/resource1.txt");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Resource3() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestResource3/resource1.txt");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Resource4() throws Exception {
        String actual;
        String expected = "dcbabcd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestResource4/resource1.txt");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Resource5() throws Exception {
        String actual;
        String expected = "dcbabcd";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestResource5/resource1.txt");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_ResourceRangeRequest_Complete() throws Exception {
        Map<String, List<String>> actual;
        Bundle bundle = this.installBundle("tb2");
        ServletContextHelper customSCH = new ServletContextHelper(bundle){

            public String getMimeType(String filename) {
                if (filename.endsWith(".mp4")) {
                    return "video/mp4";
                }
                return null;
            }
        };
        Hashtable<String, String> contextProps = new Hashtable<String, String>();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "foo");
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "/foo");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)customSCH, contextProps));
        HashMap<String, List<String>> requestHeader = new HashMap<String, List<String>>();
        requestHeader.put("Range", Collections.singletonList("bytes=0-"));
        try {
            bundle.start();
            actual = this.requestAdvisor.request("foo/TestResource1/rangerequest.mp4", requestHeader);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((String)"Response Code", Collections.singletonList("206"), actual.get("responseCode"));
        Assert.assertEquals((String)"Content-Length", Collections.singletonList("20655"), actual.get("Content-Length"));
        Assert.assertEquals((String)"Accept-Ranges", Collections.singletonList("bytes"), actual.get("Accept-Ranges"));
        Assert.assertEquals((String)"Content-Range", Collections.singletonList("bytes 0-20654/20655"), actual.get("Content-Range"));
    }

    @Test
    public void test_ResourceRangeRequest_WithRange() throws Exception {
        Map<String, List<String>> actual;
        Bundle bundle = this.installBundle("tb2");
        ServletContextHelper customSCH = new ServletContextHelper(bundle){

            public String getMimeType(String filename) {
                if (filename.endsWith(".mp4")) {
                    return "video/mp4";
                }
                return null;
            }
        };
        Hashtable<String, String> contextProps = new Hashtable<String, String>();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "foo");
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "/foo");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)customSCH, contextProps));
        HashMap<String, List<String>> requestHeader = new HashMap<String, List<String>>();
        requestHeader.put("Range", Collections.singletonList("bytes=1000-9999"));
        try {
            bundle.start();
            actual = this.requestAdvisor.request("foo/TestResource1/rangerequest.mp4", requestHeader);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((String)"Response Code", Collections.singletonList("206"), actual.get("responseCode"));
        Assert.assertEquals((String)"Content-Length", Collections.singletonList("9000"), actual.get("Content-Length"));
        Assert.assertEquals((String)"Accept-Ranges", Collections.singletonList("bytes"), actual.get("Accept-Ranges"));
        Assert.assertEquals((String)"Content-Range", Collections.singletonList("bytes 1000-9999/20655"), actual.get("Content-Range"));
        Assert.assertEquals((String)"Response Body Prefix", (Object)"901", (Object)actual.get("responseBody").get(0).substring(0, 3));
        Assert.assertEquals((String)"Response Body Suffix", (Object)"567", (Object)actual.get("responseBody").get(0).substring(8997, 9000));
    }

    @Test
    public void test_ResourceRangeRequest_WithRange_customContext() throws Exception {
        Map<String, List<String>> actual;
        Bundle bundle = this.installBundle("tb2");
        RangeAwareServletContextHelper customSCH = new RangeAwareServletContextHelper(bundle){

            public String getMimeType(String filename) {
                if (filename.endsWith(".mp4")) {
                    return "video/mp4";
                }
                return null;
            }

            public boolean rangeableContentType(String contentType, String userAgent) {
                return userAgent.contains("Foo") && contentType.startsWith("video/");
            }
        };
        Hashtable<String, String> contextProps = new Hashtable<String, String>();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "foo");
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "/foo");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)customSCH, contextProps));
        HashMap<String, List<String>> requestHeader = new HashMap<String, List<String>>();
        requestHeader.put("User-Agent", Collections.singletonList("Foo"));
        try {
            bundle.start();
            actual = this.requestAdvisor.request("foo/TestResource1/rangerequest.mp4", requestHeader);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((String)"Response Code", Collections.singletonList("206"), actual.get("responseCode"));
        Assert.assertEquals((String)"Content-Length", Collections.singletonList("20655"), actual.get("Content-Length"));
        Assert.assertEquals((String)"Accept-Ranges", Collections.singletonList("bytes"), actual.get("Accept-Ranges"));
        Assert.assertEquals((String)"Content-Range", Collections.singletonList("bytes 0-20654/20655"), actual.get("Content-Range"));
        Assert.assertEquals((String)"Response Body Prefix", (Object)"123", (Object)actual.get("responseBody").get(0).substring(0, 3));
        Assert.assertEquals((String)"Response Body Suffix", (Object)"789", (Object)actual.get("responseBody").get(0).substring(8997, 9000));
    }

    @Test
    public void test_Runtime() throws Exception {
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            BundleContext bundleContext = this.getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(HttpServiceRuntime.class);
            HttpServiceRuntime runtime = (HttpServiceRuntime)bundleContext.getService(serviceReference);
            Assert.assertNotNull((Object)runtime);
            RuntimeDTO runtimeDTO = runtime.getRuntimeDTO();
            ServletContextDTO[] servletContextDTOs = runtimeDTO.servletContextDTOs;
            Assert.assertTrue((servletContextDTOs.length > 0 ? 1 : 0) != 0);
        }
        finally {
            this.uninstallBundle(bundle);
        }
    }

    @Test
    public void test_Servlet1() throws Exception {
        String actual;
        String expected = "OK";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet1");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet2() throws Exception {
        String actual;
        String expected = "3";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet2");
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet3() throws Exception {
        String actual;
        String expected = "OK";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet3");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet4() throws Exception {
        String actual;
        String expected = System.getProperty("org.eclipse.equinox.http.jetty.context.path", "");
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet4");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet5() throws Exception {
        String actual;
        String expected = "Equinox Jetty-based Http Service";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet5");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet6() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("something/a.TestServlet6");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet7() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet7/a");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet9() throws Exception {
        String actual;
        String expected = "Equinox Jetty-based Http Service";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet9");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet10() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet10");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet11() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServlet11");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_Servlet12() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getWriter().write(97);
            }
        };
        HttpServlet sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getWriter().write(98);
            }
        };
        HttpService httpService = this.getHttpService();
        HttpContext httpContext = httpService.createDefaultHttpContext();
        httpService.registerServlet("*.txt", (Servlet)sA, null, httpContext);
        httpService.registerServlet("/files/*.txt", (Servlet)sB, null, httpContext);
        Assert.assertEquals((Object)"b", (Object)this.requestAdvisor.request("files/help.txt"));
    }

    @Test
    public void test_Servlet13() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                PrintWriter writer = resp.getWriter();
                writer.write(req.getQueryString());
                writer.write("|");
                writer.write(req.getParameter("p"));
                writer.write("|");
                writer.write(Arrays.toString(req.getParameterValues("p")));
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S13");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet13/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        String result = this.requestAdvisor.request("Servlet13/a?p=1&p=2");
        Assert.assertEquals((Object)"p=1&p=2|1|[1, 2]", (Object)result);
    }

    @Test
    public void test_ServletExactMatchPrecidence() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getWriter().write(97);
            }
        };
        HttpServlet sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getWriter().write(98);
            }
        };
        HttpService httpService = this.getHttpService();
        HttpContext httpContext = httpService.createDefaultHttpContext();
        httpService.registerServlet("*.txt", (Servlet)sA, null, httpContext);
        httpService.registerServlet("/files/help.txt", (Servlet)sB, null, httpContext);
        Assert.assertEquals((Object)"b", (Object)this.requestAdvisor.request("files/help.txt"));
    }

    @Test
    public void test_Servlet16() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                Part part = req.getPart("file");
                Assert.assertNotNull((Object)part);
                String submittedFileName = part.getSubmittedFileName();
                String contentType = part.getContentType();
                long size = part.getSize();
                PrintWriter writer = resp.getWriter();
                writer.write(submittedFileName);
                writer.write("|");
                writer.write(contentType);
                writer.write("|" + size);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        ((Dictionary)props).put("equinox.http.multipartSupported", Boolean.TRUE);
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("resource1.txt")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"200", (Object)result.get("responseCode").get(0));
        Assert.assertEquals((Object)"resource1.txt|text/plain|25", (Object)result.get("responseBody").get(0));
    }

    @Test
    public void test_Servlet16_notEnabled() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                req.getPart("file");
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("resource1.txt")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"500", (Object)result.get("responseCode").get(0));
    }

    @Test
    public void test_Servlet16_fileuploadWithLocation() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                Part part = req.getPart("file");
                Assert.assertNotNull((Object)part);
                String submittedFileName = part.getSubmittedFileName();
                String contentType = part.getContentType();
                long size = part.getSize();
                File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
                File location = new File(tempDir, "file-upload-test");
                File[] listFiles = location.listFiles();
                PrintWriter writer = resp.getWriter();
                writer.write(submittedFileName);
                writer.write("|");
                writer.write(contentType);
                writer.write("|" + size);
                writer.write("|" + listFiles.length);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        ((Dictionary)props).put("equinox.http.multipartSupported", Boolean.TRUE);
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.location", "file-upload-test");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("resource1.txt")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"200", (Object)result.get("responseCode").get(0));
        Assert.assertEquals((Object)"resource1.txt|text/plain|25|0", (Object)result.get("responseBody").get(0));
    }

    @Test
    public void test_Servlet16_fileuploadWithLocationAndThreshold() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                Part part = req.getPart("file");
                Assert.assertNotNull((Object)part);
                String submittedFileName = part.getSubmittedFileName();
                String contentType = part.getContentType();
                long size = part.getSize();
                File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
                File location = new File(tempDir, "file-upload-test");
                File[] listFiles = location.listFiles();
                PrintWriter writer = resp.getWriter();
                writer.write(submittedFileName);
                writer.write("|");
                writer.write(contentType);
                writer.write("|" + size);
                writer.write("|" + listFiles.length);
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        ((Dictionary)props).put("equinox.http.multipartSupported", Boolean.TRUE);
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.location", "file-upload-test");
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.fileSizeThreshold", 10);
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("resource1.txt")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"200", (Object)result.get("responseCode").get(0));
        Assert.assertEquals((Object)"resource1.txt|text/plain|25|1", (Object)result.get("responseBody").get(0));
    }

    @Test
    public void test_Servlet16_fileuploadWithLocationMaxFileSize() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                req.getPart("file");
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        ((Dictionary)props).put("equinox.http.multipartSupported", Boolean.TRUE);
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.location", "file-upload-test");
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.maxFileSize", 24L);
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("resource1.txt")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"500", (Object)result.get("responseCode").get(0));
    }

    @Test
    public void test_Servlet16_fileuploadWithLocationMaxRequestSize() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                req.getPart("file");
            }
        };
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        ((Dictionary)props).put("equinox.http.multipartSupported", Boolean.TRUE);
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.location", "file-upload-test");
        ((Dictionary)props).put("equinox.http.whiteboard.servlet.multipart.maxRequestSize", 26L);
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("resource1.txt")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"500", (Object)result.get("responseCode").get(0));
    }

    @Test
    public void test_Servlet18() throws Exception {
        HttpServlet sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                URL url = request.getServletContext().getResource("org/osgi/service/http/HttpService.class");
                response.getWriter().write(url == null ? "null" : url.getProtocol());
            }
        };
        HttpService httpService = this.getHttpService();
        HttpContext httpContext = httpService.createDefaultHttpContext();
        httpService.registerServlet("/testDefaultHttpContextResource", (Servlet)sA, null, httpContext);
        Assert.assertEquals((Object)"bundleresource", (Object)this.requestAdvisor.request("testDefaultHttpContextResource"));
    }

    @Test
    public void test_commonsFileUpload() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
                Assert.assertTrue((boolean)isMultipart);
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletContext servletContext = this.getServletConfig().getServletContext();
                File repository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                factory.setRepository(repository);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = null;
                try {
                    List parseRequest;
                    items = parseRequest = upload.parseRequest(req);
                }
                catch (FileUploadException e) {
                    e.printStackTrace();
                }
                Assert.assertNotNull((Object)items);
                Assert.assertFalse((boolean)items.isEmpty());
                FileItem fileItem = (FileItem)items.get(0);
                String submittedFileName = fileItem.getName();
                String contentType = fileItem.getContentType();
                long size = fileItem.getSize();
                PrintWriter writer = resp.getWriter();
                writer.write(submittedFileName);
                writer.write("|");
                writer.write(contentType);
                writer.write("|" + size);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S16");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/Servlet16/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("file", Arrays.asList(this.getClass().getResource("blue.png")));
        Map<String, List<String>> result = this.requestAdvisor.upload("Servlet16/do", map);
        Assert.assertEquals((Object)"200", (Object)result.get("responseCode").get(0));
        Assert.assertEquals((Object)"blue.png|image/png|292", (Object)result.get("responseBody").get(0));
    }

    @Test
    public void test_ServletContext1() throws Exception {
        String actual;
        String expected = "/org/eclipse/equinox/http/servlet/tests/tb1/resource1.txt";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServletContext1");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_ServletContext1_2() throws Exception {
        String actual;
        String expected = "/org/eclipse/equinox/http/servlet/tests/tb1/resource1.txt";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("TestServletContext1");
            Assert.assertEquals((Object)expected, (Object)actual);
            bundle.stop();
            bundle.start();
            bundle.stop();
            bundle.start();
            actual = this.requestAdvisor.request("TestServletContext1");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_ServletContext2() throws Exception {
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                this.getServletContext().setAttribute("name", null);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", "S1");
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", "/S1/*");
        this.registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servlet, props));
        Map<String, List<String>> response = this.requestAdvisor.request("S1/a", null);
        String responseCode = response.get("responseCode").get(0);
        Assert.assertEquals((Object)"200", (Object)responseCode);
    }

    @Test
    public void testServletContextUnsupportedOperations() {
        AtomicReference contextHolder;
        block9: {
            contextHolder = new AtomicReference();
            HttpServlet unsupportedServlet = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                public void init(ServletConfig config) throws ServletException {
                    contextHolder.set(config.getServletContext());
                }
            };
            ServiceRegistration servletReg = null;
            Hashtable<String, String> servletProps = new Hashtable<String, String>();
            ((Dictionary)servletProps).put("osgi.http.whiteboard.servlet.pattern", "/sessions");
            try {
                try {
                    servletReg = this.getBundleContext().registerService(Servlet.class, (Object)unsupportedServlet, servletProps);
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception: " + e));
                    if (servletReg != null) {
                        servletReg.unregister();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (servletReg != null) {
                    servletReg.unregister();
                }
                throw throwable;
            }
            if (servletReg != null) {
                servletReg.unregister();
            }
        }
        ServletContext context = (ServletContext)contextHolder.get();
        Assert.assertNotNull((String)"Null context.", (Object)context);
        for (Method m : ServletTest.getUnsupportedMethods()) {
            this.checkMethod(m, context);
        }
    }

    private void checkMethod(Method m, ServletContext context) throws RuntimeException {
        block3: {
            Class<?>[] types = m.getParameterTypes();
            Object[] params = new Object[types.length];
            try {
                m.invoke((Object)context, params);
                Assert.fail((String)"Expected an exception.");
            }
            catch (IllegalAccessException e) {
                Assert.fail((String)("unexpected: " + e));
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof UnsupportedOperationException) break block3;
                Assert.fail((String)("unexpected exception for " + m.getName() + ": " + cause));
            }
        }
    }

    private static List<Method> getUnsupportedMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<ServletContext> contextClass = ServletContext.class;
        Method[] methodArray = contextClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            String name = m.getName();
            if (name.equals("addFilter") || name.equals("addListener") || name.equals("addServlet") || name.equals("createFilter") || name.equals("createListener") || name.equals("createServlet") | name.equals("declareRoles")) {
                methods.add(m);
            }
            ++n2;
        }
        return methods;
    }

    @Test
    public void test_ServletContextHelper1() throws Exception {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        ServletContextHelper servletContextHelper = new ServletContextHelper(bundle){};
        Hashtable<String, String> contextProps = new Hashtable<String, String>();
        this.registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
        servletContextHelper = new ServletContextHelper(bundle){};
        contextProps = new Hashtable();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "test.sch.one");
        this.registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
        servletContextHelper = new ServletContextHelper(bundle){};
        contextProps = new Hashtable();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "/test-sch2");
        this.registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
        servletContextHelper = new ServletContextHelper(bundle){};
        contextProps = new Hashtable();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "Test SCH 3!");
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "/test-sch3");
        this.registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
        servletContextHelper = new ServletContextHelper(bundle){};
        contextProps = new Hashtable();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "test.sch.four");
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "test$sch$4");
        this.registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
        ServiceReference serviceReference = bundleContext.getServiceReference(HttpServiceRuntime.class);
        HttpServiceRuntime runtime = (HttpServiceRuntime)bundleContext.getService(serviceReference);
        RuntimeDTO runtimeDTO = runtime.getRuntimeDTO();
        Assert.assertEquals((long)5L, (long)runtimeDTO.failedServletContextDTOs.length);
        for (ServiceRegistration registration : this.registrations) {
            registration.unregister();
        }
        this.registrations.clear();
        runtimeDTO = runtime.getRuntimeDTO();
        Assert.assertEquals((long)0L, (long)runtimeDTO.failedServletContextDTOs.length);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper7() throws Exception {
        expected = "a";
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        s1 = new BaseServlet("a");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            servletProps = new Hashtable<String, String>();
            servletProps.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps.put("osgi.http.whiteboard.servlet.pattern", "/s1");
            servletProps.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s1, servletProps));
            actual = this.requestAdvisor.request("s1");
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl31:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper8() throws Exception {
        expected = "b";
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        s1 = new BaseServlet("b");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            servletProps = new Hashtable<String, String>();
            servletProps.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps.put("osgi.http.whiteboard.servlet.pattern", "/s1");
            servletProps.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s1, servletProps));
            actual = this.requestAdvisor.request("a/s1");
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl31:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper9() throws Exception {
        expected1 = "c";
        expected2 = "d";
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        s1 = new BaseServlet(expected1);
        s2 = new BaseServlet(expected2);
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s1, servletProps1));
            servletProps2 = new Hashtable<String, String>();
            servletProps2.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps2.put("osgi.http.whiteboard.servlet.pattern", "/s");
            servletProps2.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s2, servletProps2));
            actual = this.requestAdvisor.request("s");
            Assert.assertEquals((Object)expected1, (Object)actual);
            actual = this.requestAdvisor.request("a/s");
            Assert.assertEquals((Object)expected2, (Object)actual);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl42:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelperVisibility() throws Exception {
        expected1 = "c";
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        s1 = new BaseServlet(expected1);
        registrations = new ArrayList<ServiceRegistration>();
        try {
            registrations.add(bundleContext.registerService(FindHook.class, (Object)new FindHook(){

                public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
                    if (ServletContextHelper.class.getName().equals(name) && context.getBundle().equals(ServletTest.this.getBundleContext().getBundle())) {
                        references.clear();
                    }
                }
            }, null));
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            servletProps2 = new Hashtable<String, String>();
            servletProps2.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps2.put("osgi.http.whiteboard.servlet.pattern", "/s");
            servletProps2.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s1, servletProps2));
            try {
                this.requestAdvisor.request("a/s");
            }
            catch (FileNotFoundException v0) {
            }
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl36:
        // 1 sources

    }

    @Test
    public void test_ServletContextHelper10() throws Exception {
        String actual;
        String expected = "cac";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("a/TestServletContextHelper10/a");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_ServletContextHelper11() throws Exception {
        BaseHttpContext ctx1 = new BaseHttpContext(true, "http.context.test/1", this.getBundleContext().getBundle());
        BaseHttpContext ctx2 = new BaseHttpContext(true, "http.context.test/2", this.getBundleContext().getBundle());
        try {
            this.getHttpService().registerResources("/http.context.test/1", "", (HttpContext)ctx1);
            this.getHttpService().registerResources("/http.context.test/2", "", (HttpContext)ctx2);
            String actual = this.requestAdvisor.request("http.context.test/1/test");
            Assert.assertEquals((Object)"1", (Object)actual);
            actual = this.requestAdvisor.request("http.context.test/2/test");
            Assert.assertEquals((Object)"2", (Object)actual);
        }
        catch (Throwable throwable) {
            try {
                this.getHttpService().unregister("/http.context.test/1");
                this.getHttpService().unregister("/http.context.test/2");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            throw throwable;
        }
        try {
            this.getHttpService().unregister("/http.context.test/1");
            this.getHttpService().unregister("/http.context.test/2");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper12() throws Exception {
        expected1 = "a,b,1";
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        s1 = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                StringBuilder builder = new StringBuilder();
                builder.append(request.getServletContext().getInitParameter("a")).append(',');
                builder.append(request.getServletContext().getInitParameter("b")).append(',');
                builder.append(request.getServletContext().getInitParameter("c"));
                response.getWriter().print(builder.toString());
            }
        };
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, Object>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            contextProps.put("context.init.a", "a");
            contextProps.put("context.init.b", "b");
            contextProps.put("context.init.c", new Integer(1));
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            servletProps1.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s1, servletProps1));
            actual = this.requestAdvisor.request("a/s");
            Assert.assertEquals((Object)expected1, (Object)actual);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl37:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper13() throws Exception {
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){

            public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                request.setAttribute(ServletTest.this.testName.getMethodName(), (Object)Boolean.TRUE);
                return super.handleSecurity(request, response);
            }
        };
        f1 = new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                if (request.getAttribute(ServletTest.this.testName.getMethodName()) == Boolean.TRUE) {
                    request.setAttribute(String.valueOf(ServletTest.this.testName.getMethodName()) + ".fromFilter", (Object)Boolean.TRUE);
                }
                chain.doFilter(request, response);
            }

            public void destroy() {
            }
        };
        s1 = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                res.getWriter().print(req.getAttribute(String.valueOf(ServletTest.this.testName.getMethodName()) + ".fromFilter"));
            }
        };
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            filterProps = new Hashtable<String, String>();
            filterProps.put("osgi.http.whiteboard.filter.pattern", "/*");
            filterProps.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Filter.class, (Object)f1, filterProps));
            servletProps = new Hashtable<String, String>();
            servletProps.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps.put("osgi.http.whiteboard.servlet.pattern", "/s1");
            servletProps.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            registrations.add(bundleContext.registerService(Servlet.class, (Object)s1, servletProps));
            actual = this.requestAdvisor.request("s1");
            Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)actual);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl38:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper14_uniqueTempDirs() throws Exception {
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelperA = new ServletContextHelper(bundle){};
        servletContextHelperB = new ServletContextHelper(bundle){};
        registrations = new ArrayList<ServiceRegistration>();
        try {
            fileA = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    fileA.set((File)this.getServletContext().getAttribute("javax.servlet.context.tempdir"));
                    new File((File)fileA.get(), "test").createNewFile();
                }
            };
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelperA, contextProps));
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/SA");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            this.requestAdvisor.request("a/SA");
            Assert.assertNotNull(fileA.get());
            Assert.assertTrue((boolean)new File((File)fileA.get(), "test").exists());
            contextProps = new Hashtable<K, V>();
            contextProps.put("osgi.http.whiteboard.context.name", "b");
            contextProps.put("osgi.http.whiteboard.context.path", "/b");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelperB, contextProps));
            Assert.assertNotNull(fileA.get());
            Assert.assertTrue((boolean)new File((File)fileA.get(), "test").exists());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl43:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper15_fullContextPath_include() throws Exception {
        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "/foo");
        }
        finally {
            this.startJetty();
        }
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelperA = new ServletContextHelper(bundle){};
        registrations = new ArrayList<ServiceRegistration>();
        try {
            path = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    RequestDispatcher rd = req.getRequestDispatcher("/foo/a/SB");
                    rd.include((ServletRequest)req, (ServletResponse)resp);
                }
            };
            servletB = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    path.set((String)req.getAttribute("javax.servlet.include.context_path"));
                }
            };
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelperA, contextProps));
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/SA");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            props = new Hashtable<K, V>();
            props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            props.put("osgi.http.whiteboard.servlet.name", "SB");
            props.put("osgi.http.whiteboard.servlet.pattern", "/SB");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletB, props));
            this.requestAdvisor.request("a/SA");
            Assert.assertEquals((Object)"/foo/a", path.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl51:
        // 1 sources

        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "");
        }
        finally {
            this.startJetty();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_ServletContextHelper15_fullContextPath_forward() throws Exception {
        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "/foo");
        }
        finally {
            this.startJetty();
        }
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelperA = new ServletContextHelper(bundle){};
        registrations = new ArrayList<ServiceRegistration>();
        try {
            path = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    RequestDispatcher rd = req.getRequestDispatcher("/foo/a/SB");
                    rd.forward((ServletRequest)req, (ServletResponse)resp);
                }
            };
            servletB = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    path.set((String)req.getAttribute("javax.servlet.forward.context_path"));
                }
            };
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelperA, contextProps));
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/SA");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            props = new Hashtable<K, V>();
            props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            props.put("osgi.http.whiteboard.servlet.name", "SB");
            props.put("osgi.http.whiteboard.servlet.pattern", "/SB");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletB, props));
            this.requestAdvisor.request("a/SA");
            Assert.assertEquals((Object)"/foo/a", path.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl51:
        // 1 sources

        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "");
        }
        finally {
            this.startJetty();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_getRequestURI_trailingSlash1() throws Exception {
        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "/foo");
        }
        finally {
            this.startJetty();
        }
        registrations = new ArrayList<ServiceRegistration>();
        try {
            getRequestURI = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    getRequestURI.set(req.getRequestURI());
                }
            };
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/*");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            props = new Hashtable<K, V>();
            this.requestAdvisor.request("a/b/c/");
            Assert.assertEquals((Object)"/foo/a/b/c/", getRequestURI.get());
            this.requestAdvisor.request("a/b/");
            Assert.assertEquals((Object)"/foo/a/b/", getRequestURI.get());
            this.requestAdvisor.request("a/");
            Assert.assertEquals((Object)"/foo/a/", getRequestURI.get());
            this.requestAdvisor.request("");
            Assert.assertEquals((Object)"/foo/", getRequestURI.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl39:
        // 1 sources

        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "");
        }
        finally {
            this.startJetty();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_getRequestURI_trailingSlash2() throws Exception {
        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "/foo");
        }
        finally {
            this.startJetty();
        }
        registrations = new ArrayList<ServiceRegistration>();
        try {
            getRequestURI = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    HttpSession session = req.getSession();
                    session.setAttribute("test", (Object)req.getParameter("p1"));
                    getRequestURI.set(resp.encodeURL(req.getRequestURI()));
                }
            };
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/*");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            props = new Hashtable<K, V>();
            this.requestAdvisor.request("a/b/c/?p1=v1");
            initialURI = (String)getRequestURI.get();
            sessionIdx = initialURI.indexOf(";jsessionid=");
            Assert.assertTrue((String)("No session: " + initialURI), (boolean)(sessionIdx > -1));
            sessionPostfix = initialURI.substring(sessionIdx);
            Assert.assertEquals((Object)("/foo/a/b/c/" + sessionPostfix), getRequestURI.get());
            this.requestAdvisor.request("a/b/" + sessionPostfix);
            Assert.assertEquals((Object)("/foo/a/b/" + sessionPostfix), getRequestURI.get());
            this.requestAdvisor.request("a/" + sessionPostfix);
            Assert.assertEquals((Object)("/foo/a/" + sessionPostfix), getRequestURI.get());
            this.requestAdvisor.request(sessionPostfix);
            Assert.assertEquals((Object)("/foo/" + sessionPostfix), getRequestURI.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl43:
        // 1 sources

        try {
            this.stopJetty();
            System.setProperty("org.eclipse.equinox.http.jetty.context.path", "");
        }
        finally {
            this.startJetty();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_getRequestURI_trailingSlash3() throws Exception {
        registrations = new ArrayList<ServiceRegistration>();
        try {
            getRequestURI = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    getRequestURI.set(req.getRequestURI());
                }
            };
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/*");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            props = new Hashtable<K, V>();
            this.requestAdvisor.request("a/b/c/");
            Assert.assertEquals((Object)"/a/b/c/", getRequestURI.get());
            this.requestAdvisor.request("a/b/");
            Assert.assertEquals((Object)"/a/b/", getRequestURI.get());
            this.requestAdvisor.request("a/");
            Assert.assertEquals((Object)"/a/", getRequestURI.get());
            this.requestAdvisor.request("");
            Assert.assertEquals((Object)"/", getRequestURI.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl30:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_getRequestURI_trailingSlash4() throws Exception {
        registrations = new ArrayList<ServiceRegistration>();
        try {
            getRequestURI = new AtomicReference<V>();
            servletA = new HttpServlet(){
                private static final long serialVersionUID = 1L;

                protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
                    HttpSession session = req.getSession();
                    session.setAttribute("test", (Object)req.getParameter("p1"));
                    getRequestURI.set(resp.encodeURL(req.getRequestURI()));
                }
            };
            props = new Hashtable<String, String>();
            props.put("osgi.http.whiteboard.servlet.name", "SA");
            props.put("osgi.http.whiteboard.servlet.pattern", "/*");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)servletA, props));
            props = new Hashtable<K, V>();
            this.requestAdvisor.request("a/b/c/?p1=v1");
            initialURI = (String)getRequestURI.get();
            sessionIdx = initialURI.indexOf(";jsessionid=");
            Assert.assertTrue((String)("No session: " + initialURI), (boolean)(sessionIdx > -1));
            sessionPostfix = initialURI.substring(sessionIdx);
            Assert.assertEquals((Object)("/a/b/c/" + sessionPostfix), getRequestURI.get());
            this.requestAdvisor.request("a/b/" + sessionPostfix);
            Assert.assertEquals((Object)("/a/b/" + sessionPostfix), getRequestURI.get());
            this.requestAdvisor.request("a/" + sessionPostfix);
            Assert.assertEquals((Object)("/a/" + sessionPostfix), getRequestURI.get());
            this.requestAdvisor.request(sessionPostfix);
            Assert.assertEquals((Object)("/" + sessionPostfix), getRequestURI.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl34:
        // 1 sources

    }

    @Test
    public void test_Listener1() throws Exception {
        BaseServletContextListener scl1 = new BaseServletContextListener();
        Hashtable<String, String> listenerProps = new Hashtable<String, String>();
        ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
        ServiceRegistration registration = this.getBundleContext().registerService(ServletContextListener.class, (Object)scl1, listenerProps);
        registration.unregister();
        Assert.assertTrue((boolean)scl1.initialized.get());
        Assert.assertTrue((boolean)scl1.destroyed.get());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener2() throws Exception {
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            scl1 = new BaseServletContextListener();
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registration = this.getBundleContext().registerService(ServletContextListener.class, (Object)scl1, listenerProps);
            registration.unregister();
            Assert.assertTrue((boolean)scl1.initialized.get());
            Assert.assertTrue((boolean)scl1.destroyed.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl28:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener3() throws Exception {
        bundleContext = this.getBundleContext();
        bundle = bundleContext.getBundle();
        servletContextHelper = new ServletContextHelper(bundle){};
        scl1 = new BaseServletContextListener();
        registrations = new ArrayList<ServiceRegistration>();
        try {
            contextProps = new Hashtable<String, String>();
            contextProps.put("osgi.http.whiteboard.context.name", "a");
            contextProps.put("osgi.http.whiteboard.context.path", "/a");
            registrations.add(bundleContext.registerService(ServletContextHelper.class, (Object)servletContextHelper, contextProps));
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(bundleContext.registerService(ServletContextListener.class, (Object)scl1, listenerProps));
            Assert.assertTrue((boolean)scl1.initialized.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl27:
        // 1 sources

        Assert.assertTrue((boolean)scl1.destroyed.get());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener4() throws Exception {
        scal1 = new BaseServletContextAttributeListener();
        s1 = new BaseServlet("a");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(ServletContextAttributeListener.class, (Object)scal1, listenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            this.requestAdvisor.request("s");
            Assert.assertTrue((boolean)scal1.added.get());
            Assert.assertFalse((boolean)scal1.replaced.get());
            Assert.assertFalse((boolean)scal1.removed.get());
            this.requestAdvisor.request("s");
            Assert.assertTrue((boolean)scal1.added.get());
            Assert.assertTrue((boolean)scal1.replaced.get());
            Assert.assertFalse((boolean)scal1.removed.get());
            this.requestAdvisor.request("s");
            Assert.assertTrue((boolean)scal1.added.get());
            Assert.assertTrue((boolean)scal1.replaced.get());
            Assert.assertTrue((boolean)scal1.removed.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl37:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener5() throws Exception {
        srl1 = new BaseServletRequestListener();
        s1 = new BaseServlet("a");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(ServletRequestListener.class, (Object)srl1, listenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            this.requestAdvisor.request("s");
            Assert.assertTrue((boolean)srl1.initialized.get());
            Assert.assertTrue((boolean)srl1.destroyed.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl26:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener6() throws Exception {
        sral1 = new BaseServletRequestAttributeListener();
        s1 = new BaseServlet("a");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(ServletRequestAttributeListener.class, (Object)sral1, listenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            this.requestAdvisor.request("s");
            Assert.assertTrue((boolean)sral1.added.get());
            Assert.assertTrue((boolean)sral1.replaced.get());
            Assert.assertTrue((boolean)sral1.removed.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl27:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener7() throws Exception {
        hsal1 = new BaseHttpSessionAttributeListener();
        s1 = new BaseServlet("test_Listener7");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(HttpSessionAttributeListener.class, (Object)hsal1, listenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            responseMap = this.requestAdvisor.request("s", null);
            Assert.assertTrue((boolean)hsal1.added.get());
            Assert.assertFalse((boolean)hsal1.replaced.get());
            Assert.assertFalse((boolean)hsal1.removed.get());
            list = responseMap.get("Set-Cookie");
            sessionId = "";
            for (String string : list) {
                if (!string.startsWith("JSESSIONID=") || (pos = (sessionId = string).indexOf(59)) == -1) continue;
                sessionId = sessionId.substring(0, pos);
            }
            requestHeaders = new HashMap<String, List<String>>();
            requestHeaders.put("Cookie", Arrays.asList(new String[]{sessionId}));
            this.requestAdvisor.request("s", requestHeaders);
            Assert.assertTrue((boolean)hsal1.added.get());
            Assert.assertTrue((boolean)hsal1.replaced.get());
            Assert.assertFalse((boolean)hsal1.removed.get());
            this.requestAdvisor.request("s", requestHeaders);
            Assert.assertTrue((boolean)hsal1.added.get());
            Assert.assertTrue((boolean)hsal1.replaced.get());
            Assert.assertTrue((boolean)hsal1.removed.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl45:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener8() throws Exception {
        hsil1 = new BaseHttpSessionIdListener();
        s1 = new BaseChangeSessionIdServlet("test_Listener8");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(HttpSessionIdListener.class, (Object)hsil1, listenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S8");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            this.requestAdvisor.request("s");
            Assert.assertTrue((boolean)hsil1.changed.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl25:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener9() throws Exception {
        sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                RequestDispatcher requestDispatcher = req.getRequestDispatcher("/s9B");
                requestDispatcher.include((ServletRequest)req, (ServletResponse)resp);
            }
        };
        sB = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                PrintWriter writer = resp.getWriter();
                writer.write("S9 included");
            }
        };
        srl1 = new BaseServletRequestListener();
        registrations = new ArrayList<ServiceRegistration>();
        try {
            listenerProps = new Hashtable<String, String>();
            listenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(ServletRequestListener.class, (Object)srl1, listenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S9A");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s9A");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, servletProps1));
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S9B");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s9B");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sB, servletProps1));
            result = this.requestAdvisor.request("s9A");
            Assert.assertEquals((Object)"S9 included", (Object)result);
            Assert.assertEquals((long)0L, (long)srl1.number.get());
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl32:
        // 1 sources

    }

    @Test
    public void test_Listener10() throws Exception {
        BaseServletContextListener scl1 = new BaseServletContextListener();
        BaseServletContextListener scl2 = new BaseServletContextListener();
        BaseServletContextListener scl3 = new BaseServletContextListener();
        Hashtable<String, String> listenerProps = new Hashtable<String, String>();
        ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
        this.registrations.add(this.getBundleContext().registerService(ServletContextListener.class, (Object)scl1, listenerProps));
        listenerProps = new Hashtable();
        ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
        this.registrations.add(this.getBundleContext().registerService(ServletContextListener.class, (Object)scl2, listenerProps));
        Hashtable<String, String> contextProps = new Hashtable<String, String>();
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.name", "a");
        ((Dictionary)contextProps).put("osgi.http.whiteboard.context.path", "/a");
        this.registrations.add(this.getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){}, contextProps));
        listenerProps = new Hashtable();
        ((Dictionary)listenerProps).put("osgi.http.whiteboard.listener", "true");
        ((Dictionary)listenerProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=a)");
        this.registrations.add(this.getBundleContext().registerService(ServletContextListener.class, (Object)scl3, listenerProps));
        ServletContext servletContext1 = scl1.servletContext;
        ServletContext servletContext2 = scl2.servletContext;
        ServletContext servletContext3 = scl3.servletContext;
        Assert.assertNotNull((Object)servletContext1);
        Assert.assertNotNull((Object)servletContext2);
        Assert.assertNotNull((Object)servletContext3);
        Assert.assertTrue((boolean)servletContext1.equals(servletContext1));
        Assert.assertTrue((boolean)servletContext2.equals(servletContext2));
        Assert.assertTrue((boolean)servletContext3.equals(servletContext3));
        Assert.assertTrue((boolean)servletContext1.equals(servletContext2));
        Assert.assertFalse((boolean)servletContext1.equals(servletContext3));
        Assert.assertFalse((boolean)servletContext2.equals(servletContext3));
        Assert.assertEquals((long)servletContext1.hashCode(), (long)servletContext1.hashCode());
        Assert.assertEquals((long)servletContext2.hashCode(), (long)servletContext2.hashCode());
        Assert.assertEquals((long)servletContext3.hashCode(), (long)servletContext3.hashCode());
        Assert.assertEquals((long)servletContext1.hashCode(), (long)servletContext2.hashCode());
        Assert.assertNotEquals((long)servletContext1.hashCode(), (long)servletContext3.hashCode());
        Assert.assertNotEquals((long)servletContext2.hashCode(), (long)servletContext3.hashCode());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Listener11() throws Exception {
        listenerBalance = new AtomicInteger(0);
        sessionReference = new AtomicReference<V>();
        scl = new ServletContextListener(){

            public void contextInitialized(ServletContextEvent arg0) {
            }

            public void contextDestroyed(ServletContextEvent arg0) {
                listenerBalance.decrementAndGet();
            }
        };
        sl = new HttpSessionListener(){

            public void sessionDestroyed(HttpSessionEvent se) {
                listenerBalance.incrementAndGet();
            }

            public void sessionCreated(HttpSessionEvent se) {
            }
        };
        sA = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                HttpSession session = req.getSession();
                sessionReference.set(session);
                session.setAttribute("testAttribute", (Object)"testValue");
                PrintWriter writer = resp.getWriter();
                writer.write("S11 requested");
            }
        };
        registrations = new ArrayList<ServiceRegistration>();
        try {
            scListenerProps = new Hashtable<String, String>();
            scListenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(ServletContextListener.class, (Object)scl, scListenerProps));
            sListenerProps = new Hashtable<String, String>();
            sListenerProps.put("osgi.http.whiteboard.listener", "true");
            registrations.add(this.getBundleContext().registerService(HttpSessionListener.class, (Object)sl, sListenerProps));
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S11");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s11");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)sA, servletProps1));
            result = this.requestAdvisor.request("s11");
            Assert.assertEquals((Object)"S11 requested", (Object)result);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl32:
        // 1 sources

        session = (HttpSession)sessionReference.get();
        session.invalidate();
        Assert.assertEquals((long)0L, (long)listenerBalance.get());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_Async1() throws Exception {
        s1 = new BaseAsyncServlet("test_Listener8");
        registrations = new ArrayList<ServiceRegistration>();
        try {
            servletProps1 = new Hashtable<String, Object>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S1");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s");
            servletProps1.put("osgi.http.whiteboard.servlet.asyncSupported", true);
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            output1 = this.requestAdvisor.request("s");
            Assert.assertTrue((String)output1, (boolean)output1.endsWith("test_Listener8"));
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl20:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_AsyncOutput1() throws Exception {
        s1 = new AsyncOutputServlet();
        registrations = new ArrayList<ServiceRegistration>();
        try {
            servletProps1 = new Hashtable<String, Object>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "AsyncOutputServlet");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/asyncOutput");
            servletProps1.put("osgi.http.whiteboard.servlet.asyncSupported", true);
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)s1, servletProps1));
            output1 = this.requestAdvisor.request("asyncOutput?iterations=2");
            Assert.assertEquals((String)"write(int)", (Object)"01234567890123456789", (Object)output1);
            output2 = this.requestAdvisor.request("asyncOutput?bytes=true&iterations=4");
            Assert.assertEquals((String)"write(byte[], int, int)", (Object)"0123456789012345678901234567890123456789", (Object)output2);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl22:
        // 1 sources

    }

    @Test
    public void test_WBServlet1() throws Exception {
        String actual;
        String expected = "a";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("WBServlet1/a");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test_WBServlet2() throws Exception {
        String actual;
        String expected = "bab";
        Bundle bundle = this.installBundle("tb1");
        try {
            bundle.start();
            actual = this.requestAdvisor.request("WBServlet2/a");
        }
        finally {
            this.uninstallBundle(bundle);
        }
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_BufferedOutput() throws Exception {
        registrations = new ArrayList<ServiceRegistration>();
        try {
            servletProps1 = new Hashtable<String, String>();
            servletProps1.put("osgi.http.whiteboard.servlet.name", "S9");
            servletProps1.put("osgi.http.whiteboard.servlet.pattern", "/s9");
            registrations.add(this.getBundleContext().registerService(Servlet.class, (Object)new BufferedServlet(), servletProps1));
            response = this.requestAdvisor.request("s9", Collections.emptyMap());
            responseCode = response.get("responseCode").get(0);
            Assert.assertEquals((Object)"200", (Object)responseCode);
        }
        finally {
            ** for (registration : registrations)
        }
lbl-1000:
        // 1 sources

        {
            registration.unregister();
            continue;
        }
lbl18:
        // 1 sources

    }

    @Test
    public void testWBServletChangeInitParams() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test.prototype.name", this.testName.getMethodName());
        params.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
        params.put("servlet.init.status", this.testName.getMethodName());
        String actual = this.doRequest("configure", params);
        Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        params.put("servlet.init.status", "changed");
        this.doRequest("configure", params);
        actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)"changed", (Object)actual);
    }

    @Test
    public void testWBServletChangePattern() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test.prototype.name", this.testName.getMethodName());
        params.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
        params.put("servlet.init.status", this.testName.getMethodName());
        String actual = this.doRequest("configure", params);
        Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        params.put("osgi.http.whiteboard.servlet.pattern", "/changed");
        this.doRequest("configure", params);
        actual = this.requestAdvisor.request("changed");
        Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
    }

    @Test
    public void testWBServletChangeRanking() throws Exception {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("test.prototype.name", String.valueOf(this.testName.getMethodName()) + 1);
        params1.put("service.ranking", "1");
        params1.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
        params1.put("servlet.init.status", String.valueOf(this.testName.getMethodName()) + 1);
        String actual = this.doRequest("configure", params1);
        Assert.assertEquals((Object)(String.valueOf(this.testName.getMethodName()) + 1), (Object)actual);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("test.prototype.name", String.valueOf(this.testName.getMethodName()) + 2);
        params2.put("service.ranking", "2");
        params2.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
        params2.put("servlet.init.status", String.valueOf(this.testName.getMethodName()) + 2);
        actual = this.doRequest("configure", params2);
        Assert.assertEquals((Object)(String.valueOf(this.testName.getMethodName()) + 2), (Object)actual);
        actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)(String.valueOf(this.testName.getMethodName()) + 2), (Object)actual);
        params2.put("service.ranking", "0");
        this.doRequest("configure", params2);
        actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)(String.valueOf(this.testName.getMethodName()) + 1), (Object)actual);
        actual = this.doRequest("unregister", Collections.singletonMap("test.prototype.name", String.valueOf(this.testName.getMethodName()) + 1));
        Assert.assertEquals((Object)(String.valueOf(this.testName.getMethodName()) + 1), (Object)actual);
        actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)(String.valueOf(this.testName.getMethodName()) + 2), (Object)actual);
    }

    @Test
    public void testWBServletDefaultContextAdaptor1() throws Exception {
        Hashtable<String, String> helperProps = new Hashtable<String, String>();
        ((Dictionary)helperProps).put("osgi.http.whiteboard.context.name", "testContext" + this.testName.getMethodName());
        ((Dictionary)helperProps).put("osgi.http.whiteboard.context.path", "/testContext");
        ((Dictionary)helperProps).put("test.path.customizer.name", this.testName.getMethodName());
        ServiceRegistration helperReg = this.getBundleContext().registerService(ServletContextHelper.class, (ServiceFactory)new BaseTest.TestServletContextHelperFactory(), helperProps);
        ServiceRegistration pathAdaptorReg = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("test.prototype.name", this.testName.getMethodName());
            params.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
            params.put("servlet.init.status", this.testName.getMethodName());
            params.put("servlet.init.test.path.customizer.name", this.testName.getMethodName());
            String actual = this.doRequest("configure", params);
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            actual = this.requestAdvisor.request(this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            BaseTest.TestContextPathAdaptor pathAdaptor = new BaseTest.TestContextPathAdaptor("(osgi.http.whiteboard.context.name=testContext" + this.testName.getMethodName() + ")", null, this.testName.getMethodName());
            pathAdaptorReg = this.getBundleContext().registerService(ContextPathCustomizer.class, (Object)pathAdaptor, null);
            actual = this.requestAdvisor.request("testContext/" + this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            pathAdaptorReg.unregister();
            pathAdaptorReg = null;
            actual = this.requestAdvisor.request(this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        }
        finally {
            helperReg.unregister();
            if (pathAdaptorReg != null) {
                pathAdaptorReg.unregister();
            }
        }
    }

    @Test
    public void testWBServletDefaultContextAdaptor2() throws Exception {
        Hashtable<String, String> helperProps = new Hashtable<String, String>();
        ((Dictionary)helperProps).put("osgi.http.whiteboard.context.name", "testContext" + this.testName.getMethodName());
        ((Dictionary)helperProps).put("osgi.http.whiteboard.context.path", "/testContext");
        ((Dictionary)helperProps).put("test.path.customizer.name", this.testName.getMethodName());
        ServiceRegistration helperReg = this.getBundleContext().registerService(ServletContextHelper.class, (ServiceFactory)new BaseTest.TestServletContextHelperFactory(), helperProps);
        ServiceRegistration pathAdaptorReg = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("test.prototype.name", this.testName.getMethodName());
            params.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
            params.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=testContext" + this.testName.getMethodName() + ")");
            params.put("servlet.init.status", this.testName.getMethodName());
            params.put("servlet.init.test.path.customizer.name", this.testName.getMethodName());
            String actual = this.doRequest("configure", params);
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            actual = this.requestAdvisor.request("testContext/" + this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            BaseTest.TestContextPathAdaptor pathAdaptor = new BaseTest.TestContextPathAdaptor(null, "testPrefix", this.testName.getMethodName());
            pathAdaptorReg = this.getBundleContext().registerService(ContextPathCustomizer.class, (Object)pathAdaptor, null);
            actual = this.requestAdvisor.request("testPrefix/testContext/" + this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            pathAdaptorReg.unregister();
            pathAdaptorReg = null;
            actual = this.requestAdvisor.request("testContext/" + this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        }
        finally {
            helperReg.unregister();
            if (pathAdaptorReg != null) {
                pathAdaptorReg.unregister();
            }
        }
    }

    @Test
    public void testWBServletDefaultContextAdaptor3() throws Exception {
        Hashtable<String, String> helperProps = new Hashtable<String, String>();
        ((Dictionary)helperProps).put("osgi.http.whiteboard.context.name", "testContext" + this.testName.getMethodName());
        ((Dictionary)helperProps).put("osgi.http.whiteboard.context.path", "/");
        ((Dictionary)helperProps).put("test.path.customizer.name", this.testName.getMethodName());
        ServiceRegistration helperReg = this.getBundleContext().registerService(ServletContextHelper.class, (ServiceFactory)new BaseTest.TestServletContextHelperFactory(), helperProps);
        ServiceRegistration pathAdaptorReg = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("test.prototype.name", this.testName.getMethodName());
            params.put("osgi.http.whiteboard.servlet.pattern", String.valueOf('/') + this.testName.getMethodName());
            params.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=testContext" + this.testName.getMethodName() + ")");
            params.put("servlet.init.status", this.testName.getMethodName());
            params.put("servlet.init.test.path.customizer.name", this.testName.getMethodName());
            String actual = this.doRequest("configure", params);
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            actual = this.requestAdvisor.request(this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            BaseTest.TestContextPathAdaptor pathAdaptor = new BaseTest.TestContextPathAdaptor(null, "testPrefix", this.testName.getMethodName());
            pathAdaptorReg = this.getBundleContext().registerService(ContextPathCustomizer.class, (Object)pathAdaptor, null);
            actual = this.requestAdvisor.request("testPrefix/" + this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
            pathAdaptorReg.unregister();
            pathAdaptorReg = null;
            actual = this.requestAdvisor.request(this.testName.getMethodName());
            Assert.assertEquals((Object)this.testName.getMethodName(), (Object)actual);
        }
        finally {
            helperReg.unregister();
            if (pathAdaptorReg != null) {
                pathAdaptorReg.unregister();
            }
        }
    }

    @Test
    public void testHttpContextSetUser() throws ServletException, NamespaceException, IOException {
        ExtendedHttpService extendedHttpService = (ExtendedHttpService)this.getHttpService();
        HttpContext testContext = new HttpContext(){

            public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)"TEST");
                request.setAttribute("org.osgi.service.http.authentication.type", (Object)"Basic");
                return true;
            }

            public URL getResource(String name) {
                return null;
            }

            public String getMimeType(String name) {
                return null;
            }
        };
        HttpServlet testServlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.setContentType("text/html");
                PrintWriter out = resp.getWriter();
                out.print("USER: " + req.getRemoteUser() + " AUTH_TYPE: " + req.getAuthType());
            }
        };
        extendedHttpService.registerServlet("/" + this.testName.getMethodName(), (Servlet)testServlet, null, testContext);
        String expected = "USER: TEST AUTH_TYPE: Basic";
        String actual = this.requestAdvisor.request(this.testName.getMethodName());
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

