/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests.util;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncOutputServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setContentType("text/plain");
        resp.setBufferSize(16);
        resp.flushBuffer();
        AsyncContext async = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ServletOutputStream out = resp.getOutputStream();
        out.setWriteListener((WriteListener)new AsyncWriter(async, Integer.parseInt(req.getParameter("iterations") == null ? "1" : req.getParameter("iterations")), Boolean.parseBoolean(req.getParameter("bytes"))));
    }

    private class AsyncWriter
    implements WriteListener {
        private final AsyncContext async;
        private final boolean writeBytes;
        private final int iterations;
        private boolean eof;

        public AsyncWriter(AsyncContext async, int iterations, boolean writeBytes) {
            this.async = async;
            this.iterations = iterations;
            this.writeBytes = writeBytes;
        }

        public void onWritePossible() throws IOException {
            HttpServletResponse resp = (HttpServletResponse)this.async.getResponse();
            ServletOutputStream out = resp.getOutputStream();
            if (this.eof) {
                out.close();
                this.async.complete();
                return;
            }
            int count = 0;
            if (this.writeBytes) {
                byte[] buf = new byte[10];
                int i = 0;
                while (i < buf.length) {
                    buf[i] = (byte)(48 + i);
                    ++i;
                }
                do {
                    out.write(buf);
                } while (out.isReady() && ++count < this.iterations);
            } else {
                int i = -1;
                do {
                    int b = 48 + ++i % 10;
                    out.write(b);
                } while (out.isReady() && ++count < this.iterations * 10);
            }
            out.close();
            this.async.complete();
            this.eof = true;
        }

        public void onError(Throwable t) {
            try {
                this.async.complete();
            }
            finally {
                AsyncOutputServlet.this.getServletContext().log("Error writing response.", t);
            }
        }
    }
}

