/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.tests.util.BaseServlet;

public class BaseAsyncServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(4);

    public BaseAsyncServlet() {
    }

    public BaseAsyncServlet(String content) {
        super(content);
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        this.executor.execute(new AsyncOperation(asyncContext));
    }

    public class AsyncOperation
    implements Runnable {
        AsyncContext asyncContext;

        public AsyncOperation(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        @Override
        public void run() {
            PrintWriter writer = null;
            try {
                try {
                    writer = this.asyncContext.getResponse().getWriter();
                    writer.print(Thread.currentThread().getName());
                    writer.print(" - ");
                    writer.print(BaseAsyncServlet.this.content);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (writer != null) {
                        writer.close();
                    }
                    this.asyncContext.complete();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                this.asyncContext.complete();
            }
        }
    }
}

