/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.tests.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.http.servlet.tests.util.EventHandler;

public class ServletRequestAdvisor {
    private final String contextPath;
    private final String port;

    public ServletRequestAdvisor(String port, String contextPath) {
        if (port == null) {
            throw new IllegalArgumentException("port must not be null");
        }
        this.port = port;
        this.contextPath = contextPath;
    }

    private String createUrlSpec(String value) {
        StringBuffer buffer = new StringBuffer(100);
        String protocol = "http://";
        String host = "localhost";
        buffer.append(protocol);
        buffer.append(host);
        buffer.append(':');
        buffer.append(this.port);
        buffer.append(this.contextPath);
        if (value != null) {
            buffer.append('/');
            buffer.append(value);
        }
        return buffer.toString();
    }

    private String drain(InputStream stream) throws IOException {
        int length;
        byte[] bytes = new byte[100];
        StringBuffer buffer = new StringBuffer(500);
        while ((length = stream.read(bytes)) != -1) {
            String chunk = new String(bytes, 0, length);
            buffer.append(chunk);
        }
        return buffer.toString();
    }

    private void log(String message) {
        String value = this + ": " + message;
        System.out.println(value);
    }

    public String request(String value) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(150000);
        connection.setReadTimeout(150000);
        connection.connect();
        try (InputStream stream = connection.getInputStream();){
            String string = this.drain(stream);
            return string;
        }
    }

    public Map<String, List<String>> request(String value, Map<String, List<String>> headers) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(150000);
        connection.setReadTimeout(150000);
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String entryValue : entry.getValue()) {
                    connection.setRequestProperty(entry.getKey(), entryValue);
                }
            }
        }
        int responseCode = connection.getResponseCode();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(connection.getHeaderFields());
        map.put("responseCode", Collections.singletonList(String.valueOf(responseCode)));
        try (InputStream stream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
            map.put("responseBody", Arrays.asList(this.drain(stream)));
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    public Map<String, List<String>> eventSource(String value, Map<String, List<String>> headers, EventHandler handler) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setChunkedStreamingMode(0);
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(150000);
        connection.setReadTimeout(150000);
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String entryValue : entry.getValue()) {
                    connection.setRequestProperty(entry.getKey(), entryValue);
                }
            }
        }
        int responseCode = connection.getResponseCode();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(connection.getHeaderFields());
        map.put("responseCode", Collections.singletonList(String.valueOf(responseCode)));
        InputStream stream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();
        handler.open(stream);
        return map;
    }

    public Map<String, List<String>> upload(String value, Map<String, List<Object>> headers) throws IOException {
        String spec = this.createUrlSpec(value);
        this.log("Requesting " + spec);
        URL url = new URL(spec);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setConnectTimeout(150000);
        connection.setReadTimeout(150000);
        if (headers != null) {
            for (Map.Entry<String, List<Object>> entry : headers.entrySet()) {
                for (Object entryValue : entry.getValue()) {
                    if (entryValue instanceof String) {
                        connection.setRequestProperty(entry.getKey(), (String)entryValue);
                        continue;
                    }
                    if (entryValue instanceof URL) {
                        this.uploadFileConnection(connection, entry.getKey(), (URL)entryValue);
                        continue;
                    }
                    throw new IllegalArgumentException("only supports strings and files");
                }
            }
        }
        int responseCode = connection.getResponseCode();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(connection.getHeaderFields());
        map.put("responseCode", Collections.singletonList(String.valueOf(responseCode)));
        try (InputStream stream = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
            map.put("responseBody", Arrays.asList(this.drain(stream)));
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    private void uploadFileConnection(HttpURLConnection connection, String param, URL file) throws IOException {
        String fileName = file.getPath();
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        connection.setDoOutput(true);
        String boundary = Long.toHexString(System.currentTimeMillis());
        String CRLF = "\r\n";
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        InputStream input = null;
        OutputStream output = null;
        PrintWriter writer = null;
        try {
            output = connection.getOutputStream();
            writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), true);
            writer.append("--" + boundary);
            writer.append(CRLF);
            writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"");
            writer.append(fileName);
            writer.append("\"");
            writer.append(CRLF);
            writer.append("Content-Type: ");
            String contentType = URLConnection.guessContentTypeFromName(fileName);
            writer.append(contentType);
            writer.append(CRLF);
            if (!contentType.startsWith("text/")) {
                writer.append("Content-Transfer-Encoding: binary");
                writer.append(CRLF);
            }
            writer.append(CRLF);
            writer.flush();
            byte[] buf = new byte[64];
            input = file.openStream();
            int c = 0;
            while ((c = input.read(buf, 0, buf.length)) > 0) {
                output.write(buf, 0, c);
                output.flush();
            }
            output.flush();
            writer.append(CRLF);
            writer.flush();
            writer.append("--" + boundary + "--");
            writer.append(CRLF);
            writer.flush();
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

