/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.discovery.Policy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Certification;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.p2.discovery.tests.core.mock.MockBundleDiscoveryStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BundleDiscoveryStrategyTest {
    private MockBundleDiscoveryStrategy discoveryStrategy;
    private final List<CatalogCategory> categories = new ArrayList<CatalogCategory>();
    private final List<CatalogItem> connectors = new ArrayList<CatalogItem>();
    private final List<Certification> certifications = new ArrayList<Certification>();
    private final List<Tag> tags = new ArrayList<Tag>();

    @Before
    public void setUp() throws Exception {
        this.discoveryStrategy = new MockBundleDiscoveryStrategy();
        this.discoveryStrategy.setPolicy(new Policy(true));
        this.discoveryStrategy.setCategories(this.categories);
        this.discoveryStrategy.setItems(this.connectors);
        this.discoveryStrategy.setCertifications(this.certifications);
        this.discoveryStrategy.setTags(this.tags);
    }

    @Test
    public void testDiscovery() throws CoreException {
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.categories.isEmpty());
        Assert.assertFalse((boolean)this.connectors.isEmpty());
        CatalogCategory category = this.findCategoryById("org.eclipse.mylyn.discovery.tests.connectorCategory1");
        Assert.assertNotNull((Object)category);
        CatalogItem connector = this.findConnectorById("org.eclipse.mylyn.discovery.tests.connectorDescriptor1");
        Assert.assertNotNull((Object)connector);
        Certification certification = this.findCertificationById("org.eclipse.mylyn.discovery.tests.certification1");
        Assert.assertNotNull((Object)certification);
    }

    @Test
    public void testCustomTag() throws CoreException {
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        CatalogItem connector = this.findConnectorById("org.eclipse.mylyn.discovery.test.tagged");
        Assert.assertEquals(new HashSet<Tag>(Arrays.asList(new Tag("Custom", "Custom"))), (Object)connector.getTags());
        Assert.assertEquals(Arrays.asList(new Tag("task", "Tasks"), new Tag("Custom", "Custom")), (Object)this.discoveryStrategy.getTags());
    }

    @Test
    public void testDiscoveryNoCategoriesPolicy() throws CoreException {
        this.discoveryStrategy.setPolicy(new Policy(false));
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)this.categories.isEmpty());
    }

    private CatalogItem findConnectorById(String id) {
        for (CatalogItem descriptor : this.connectors) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }

    private CatalogCategory findCategoryById(String id) {
        for (CatalogCategory descriptor : this.categories) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }

    private Certification findCertificationById(String id) {
        for (Certification descriptor : this.certifications) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }
}

