/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.discovery.tests.core;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.discovery.tests.core.mock.CatalogItemMockFactory;
import org.eclipse.equinox.p2.discovery.tests.core.mock.MockDiscoveryStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Version;

public class ConnectorDiscoveryTest {
    private Catalog connectorDiscovery;
    private MockDiscoveryStrategy mockDiscoveryStrategy;

    @Before
    public void setUp() throws Exception {
        this.connectorDiscovery = new Catalog();
        this.mockDiscoveryStrategy = new MockDiscoveryStrategy();
        this.connectorDiscovery.getDiscoveryStrategies().add(this.mockDiscoveryStrategy);
    }

    @Test
    public void testPlatformFilter_None() {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)this.mockDiscoveryStrategy.getConnectorCount(), (long)this.connectorDiscovery.getItems().size());
    }

    @Test
    public void testPlatformFilter_NegativeMatch() {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new CatalogItemMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.platformFilter("(& (osgi.os=macosx) (osgi.ws=carbon))");
            }
        });
        Properties environment = new Properties();
        ((Dictionary)environment).put("osgi.os", "win32");
        ((Dictionary)environment).put("osgi.ws", "windows");
        this.connectorDiscovery.setEnvironment((Dictionary)environment);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)this.connectorDiscovery.getItems().isEmpty());
    }

    @Test
    public void testPlatformFilter_PositiveMatch() {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new CatalogItemMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.platformFilter("(& (osgi.os=macosx) (osgi.ws=carbon))");
            }
        });
        Properties environment = new Properties();
        ((Dictionary)environment).put("osgi.os", "macosx");
        ((Dictionary)environment).put("osgi.ws", "carbon");
        this.connectorDiscovery.setEnvironment((Dictionary)environment);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.connectorDiscovery.getItems().isEmpty());
        Assert.assertEquals((long)this.mockDiscoveryStrategy.getConnectorCount(), (long)this.connectorDiscovery.getItems().size());
    }

    @Test
    public void testFeatureFilter_PositiveMatch() {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new CatalogItemMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.featureFilter("com.foo.bar.feature", "[1.0,2.0)");
            }
        });
        HashMap<String, Version> featureToVersion = new HashMap<String, Version>();
        featureToVersion.put("com.foo.bar.feature", new Version("1.1"));
        this.connectorDiscovery.setFeatureToVersion(featureToVersion);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.connectorDiscovery.getItems().isEmpty());
        Assert.assertEquals((long)this.mockDiscoveryStrategy.getConnectorCount(), (long)this.connectorDiscovery.getItems().size());
    }

    @Test
    public void testFeatureFilter_NegativeMatch_VersionMismatch() {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new CatalogItemMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.featureFilter("com.foo.bar.feature", "[1.2,2.0)");
            }
        });
        HashMap<String, Version> featureToVersion = new HashMap<String, Version>();
        featureToVersion.put("com.foo.bar.feature", new Version("1.1"));
        this.connectorDiscovery.setFeatureToVersion(featureToVersion);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)this.connectorDiscovery.getItems().isEmpty());
    }

    @Test
    public void testFeatureFilter_NegativeMatch_NotPresent() {
        this.mockDiscoveryStrategy.setConnectorMockFactory(new CatalogItemMockFactory(){

            @Override
            protected void populateMockData() {
                super.populateMockData();
                this.featureFilter("com.foo.bar.feature", "[1.2,2.0)");
            }
        });
        HashMap featureToVersion = new HashMap();
        this.connectorDiscovery.setFeatureToVersion(featureToVersion);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)this.connectorDiscovery.getItems().isEmpty());
    }

    @Test
    public void testCategorization() {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((!this.connectorDiscovery.getItems().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((!this.connectorDiscovery.getCategories().isEmpty() ? 1 : 0) != 0);
        for (CatalogItem connector : this.connectorDiscovery.getItems()) {
            Assert.assertNotNull((Object)connector.getCategory());
            Assert.assertEquals((Object)connector.getCategoryId(), (Object)connector.getCategory().getId());
            Assert.assertTrue((boolean)connector.getCategory().getItems().contains(connector));
        }
    }

    @Test
    public void testMultipleStrategies() {
        MockDiscoveryStrategy strategy = new MockDiscoveryStrategy();
        strategy.setConnectorMockFactory(this.mockDiscoveryStrategy.getConnectorMockFactory());
        strategy.setCategoryMockFactory(this.mockDiscoveryStrategy.getCategoryMockFactory());
        this.connectorDiscovery.getDiscoveryStrategies().add(strategy);
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)this.mockDiscoveryStrategy.getConnectorMockFactory().getCreatedCount(), (long)this.connectorDiscovery.getItems().size());
        Assert.assertEquals((long)this.mockDiscoveryStrategy.getCategoryMockFactory().getCreatedCount(), (long)this.connectorDiscovery.getCategories().size());
    }
}

