/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.tests.ui.dialogs.WizardTest;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Tree;

public class UninstallWizardTest
extends WizardTest {
    private static final String SELECTION_PAGE = "IUSelectionPage";

    public void testUninstallWizardResolved() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.top1);
        iusInvolved.add(this.top2);
        UninstallOperation op = this.getProvisioningUI().getUninstallOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        UninstallWizard wizard = new UninstallWizard(this.getProvisioningUI(), op, iusInvolved, null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.create();
        dialog.open();
        ProfileModificationJob longOp = null;
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            UninstallWizardTest.assertTrue((boolean)page1.isPageComplete());
            ResolutionResultsWizardPage page2 = (ResolutionResultsWizardPage)wizard.getNextPage((IWizardPage)page1);
            dialog.showPage((IWizardPage)page2);
            UninstallWizardTest.assertTrue((boolean)page2.isPageComplete());
            Tree tree = this.findTree(page2);
            tree.setSelection(tree.getTopItem());
            longOp = this.getLongTestOperation();
            this.getProvisioningUI().schedule((ProvisioningJob)longOp, 1);
            UninstallWizardTest.assertTrue((boolean)page1.isPageComplete());
            wizard.recomputePlan((IRunnableContext)dialog);
            UninstallWizardTest.assertFalse((boolean)page1.isPageComplete());
            longOp.cancel();
        }
        finally {
            dialog.getShell().close();
            if (longOp != null) {
                longOp.cancel();
            }
        }
    }

    public void testUninstallWizardUnresolved() {
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.top1);
        iusInvolved.add(this.top2);
        UninstallOperation operation = this.getProvisioningUI().getUninstallOperation(iusInvolved, null);
        UninstallWizard wizard = new UninstallWizard(this.getProvisioningUI(), operation, iusInvolved, null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.create();
        dialog.open();
        try {
            SelectableIUsPage page1 = (SelectableIUsPage)wizard.getPage(SELECTION_PAGE);
            UninstallWizardTest.assertTrue((boolean)page1.isPageComplete());
            wizard.recomputePlan((IRunnableContext)dialog);
            UninstallWizardTest.assertTrue((boolean)page1.isPageComplete());
        }
        finally {
            dialog.getShell().close();
        }
    }
}

