/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.equinox.internal.p2.operations.SearchForUpdatesResolutionJob;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.ui.AbstractProvisioningUITest;

public class UpdateOperationTests
extends AbstractProvisioningUITest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit b12;
    IInstallableUnit a120WithDifferentId;
    IInstallableUnit a130;
    IInstallableUnit a140WithDifferentId;
    IInstallableUnitPatch firstPatchForA1;
    IInstallableUnitPatch secondPatchForA1;
    IInstallableUnitPatch thirdPatchForA1;
    IInstallableUnitPatch patchFora2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = UpdateOperationTests.createIU((String)"A", (Version)Version.create((String)"1.0.0"));
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)"update description");
        this.a120WithDifferentId = UpdateOperationTests.createIU((String)"UpdateA", (Version)Version.createOSGi((int)1, (int)2, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)false, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        this.a130 = UpdateOperationTests.createIU((String)"A", (Version)Version.createOSGi((int)1, (int)3, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)false, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        this.a140WithDifferentId = UpdateOperationTests.createIU((String)"UpdateForA", (Version)Version.createOSGi((int)1, (int)4, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)false, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        this.firstPatchForA1 = UpdateOperationTests.createIUPatch((String)"P", (Version)Version.create((String)"1.0.0"), (boolean)true, (IRequirementChange[])new IRequirementChange[]{change}, (IRequirement[][])new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, (IRequirement)lifeCycle);
        this.secondPatchForA1 = UpdateOperationTests.createIUPatch((String)"P", (Version)Version.create((String)"2.0.0"), (boolean)true, (IRequirementChange[])new IRequirementChange[]{change}, (IRequirement[][])new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, (IRequirement)lifeCycle);
        this.thirdPatchForA1 = UpdateOperationTests.createIUPatch((String)"P2", (Version)Version.create((String)"1.0.0"), (boolean)true, (IRequirementChange[])new IRequirementChange[]{change}, (IRequirement[][])new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, (IRequirement)lifeCycle);
        IRequirementChange change2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 3.2.0]"), null, (boolean)false, (boolean)false);
        this.patchFora2 = UpdateOperationTests.createIUPatch((String)"P", (Version)Version.create((String)"1.0.0"), (boolean)true, (IRequirementChange[])new IRequirementChange[]{change2}, (IRequirement[][])new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, (IRequirement)lifeCycle2);
        this.b1 = UpdateOperationTests.createIU((String)"B", (Version)Version.create((String)"1.0.0"));
        update = MetadataFactory.createUpdateDescriptor((String)"B", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)"update description");
        this.b12 = UpdateOperationTests.createIU((String)"B", (Version)Version.createOSGi((int)1, (int)2, (int)0), null, (IRequirement[])NO_REQUIRES, (IProvidedCapability[])NO_PROVIDES, (Map)NO_PROPERTIES, null, (ITouchpointData)NO_TP_DATA, (boolean)false, (IUpdateDescriptor)update, (IRequirement[])NO_REQUIRES);
        this.getPolicy().setShowLatestVersionsOnly(false);
    }

    public void testChooseUpdateOverPatch() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a120WithDifferentId, this.a130, this.firstPatchForA1, this.patchFora2});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        IProfileChangeRequest request = op.getProfileChangeRequest();
        UpdateOperationTests.assertTrue((String)"1.0", (request.getAdditions().size() == 1 ? 1 : 0) != 0);
        UpdateOperationTests.assertTrue((String)"1.1", (boolean)((IInstallableUnit)request.getAdditions().iterator().next()).equals((Object)this.a130));
        UpdateOperationTests.assertTrue((String)"1.2", (request.getRemovals().size() == 1 ? 1 : 0) != 0);
        UpdateOperationTests.assertTrue((String)"1.3", (boolean)((IInstallableUnit)request.getRemovals().iterator().next()).equals((Object)this.a1));
    }

    public void testForcePatchOverUpdate() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a120WithDifferentId, this.a130, this.firstPatchForA1, this.patchFora2});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        Update[] updates = op.getPossibleUpdates();
        Update firstPatch = null;
        int i = 0;
        while (i < updates.length) {
            if (updates[i].replacement.equals((Object)this.firstPatchForA1)) {
                firstPatch = updates[i];
                break;
            }
            ++i;
        }
        UpdateOperationTests.assertNotNull((String)".99", firstPatch);
        op.setSelectedUpdates(new Update[]{firstPatch});
        op.resolveModal(this.getMonitor());
        IProfileChangeRequest request = op.getProfileChangeRequest();
        UpdateOperationTests.assertTrue((String)"1.0", (request.getAdditions().size() == 1 ? 1 : 0) != 0);
        UpdateOperationTests.assertTrue((String)"1.1", (boolean)((IInstallableUnit)request.getAdditions().iterator().next()).equals((Object)this.firstPatchForA1));
        UpdateOperationTests.assertTrue((String)"1.2", (request.getRemovals().size() == 0 ? 1 : 0) != 0);
    }

    public void testRecognizePatchIsInstalled() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a120WithDifferentId, this.a130, this.firstPatchForA1, this.patchFora2});
        this.install(this.a1, true, false);
        this.install((IInstallableUnit)this.firstPatchForA1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        IProfileChangeRequest request = op.getProfileChangeRequest();
        UpdateOperationTests.assertTrue((String)"1.0", (request.getAdditions().size() == 1 ? 1 : 0) != 0);
        UpdateOperationTests.assertTrue((String)"1.1", (boolean)((IInstallableUnit)request.getAdditions().iterator().next()).equals((Object)this.a130));
        UpdateOperationTests.assertEquals((String)"1.2", (int)2, (int)op.getPossibleUpdates().length);
    }

    public void testChooseNotTheNewest() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a120WithDifferentId, this.a130, this.firstPatchForA1, this.patchFora2});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        Update[] updates = op.getPossibleUpdates();
        Update notNewest = null;
        int i = 0;
        while (i < updates.length) {
            if (updates[i].replacement.equals((Object)this.a120WithDifferentId)) {
                notNewest = updates[i];
                break;
            }
            ++i;
        }
        UpdateOperationTests.assertNotNull((String)".99", notNewest);
        op.setSelectedUpdates(new Update[]{notNewest});
        op.resolveModal(this.getMonitor());
        IProfileChangeRequest request = op.getProfileChangeRequest();
        UpdateOperationTests.assertTrue((String)"1.0", (request.getAdditions().size() == 1 ? 1 : 0) != 0);
        UpdateOperationTests.assertTrue((String)"1.1", (boolean)((IInstallableUnit)request.getAdditions().iterator().next()).equals((Object)this.a120WithDifferentId));
        UpdateOperationTests.assertEquals((String)"1.2", (int)3, (int)op.getPossibleUpdates().length);
    }

    public void testChooseLatestPatches() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.firstPatchForA1, this.secondPatchForA1, this.thirdPatchForA1});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        IProfileChangeRequest request = op.getProfileChangeRequest();
        HashSet chosen = new HashSet();
        UpdateOperationTests.assertTrue((String)"1.0", (request.getAdditions().size() == 2 ? 1 : 0) != 0);
        chosen.addAll(request.getAdditions());
        UpdateOperationTests.assertTrue((String)"1.1", (boolean)chosen.contains(this.secondPatchForA1));
        UpdateOperationTests.assertTrue((String)"1.2", (boolean)chosen.contains(this.thirdPatchForA1));
        UpdateOperationTests.assertEquals((String)"1.2", (int)3, (int)op.getPossibleUpdates().length);
    }

    public void testLatestHasDifferentId() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.firstPatchForA1, this.secondPatchForA1, this.thirdPatchForA1, this.a120WithDifferentId, this.a130, this.a140WithDifferentId});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        IProfileChangeRequest request = op.getProfileChangeRequest();
        UpdateOperationTests.assertTrue((String)"1.0", (request.getAdditions().size() == 1 ? 1 : 0) != 0);
        UpdateOperationTests.assertTrue((String)"1.1", (boolean)((IInstallableUnit)request.getAdditions().iterator().next()).equals((Object)this.a140WithDifferentId));
        UpdateOperationTests.assertEquals((String)"1.2", (int)6, (int)op.getPossibleUpdates().length);
    }

    public void testRemoveSelectionAfterResolve() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a130, this.b1, this.b12});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        iusInvolved.add(this.b1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        op.resolveModal(this.getMonitor());
        Update[] updates = op.getSelectedUpdates();
        UpdateOperationTests.assertEquals((String)"1.0", (int)2, (int)updates.length);
        op.setSelectedUpdates(new Update[]{updates[0]});
        op.resolveModal(this.getMonitor());
        UpdateOperationTests.assertEquals((String)"1.1", (int)1, (int)op.getSelectedUpdates().length);
    }

    public void testSearchForUpdatesInJob() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a130, this.b1, this.b12});
        this.install(this.a1, true, false);
        ArrayList<IInstallableUnit> iusInvolved = new ArrayList<IInstallableUnit>();
        iusInvolved.add(this.a1);
        iusInvolved.add(this.b1);
        UpdateOperation op = this.getProvisioningUI().getUpdateOperation(iusInvolved, null);
        ProvisioningJob job = op.getResolveJob(this.getMonitor());
        UpdateOperationTests.assertTrue((String)"1.0", (boolean)(job instanceof SearchForUpdatesResolutionJob));
        UpdateOperationTests.assertNull((String)"1.1", (Object)((SearchForUpdatesResolutionJob)job).getProfileChangeRequest());
        job.runModal(this.getMonitor());
        UpdateOperationTests.assertNotNull((String)"1.2", (Object)((SearchForUpdatesResolutionJob)job).getProfileChangeRequest());
    }
}

