/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ui.query;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.ui.query.AbstractQueryTest;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class AnyRequiredCapabilityTest
extends AbstractQueryTest {
    public void testMatchOtherObjects() {
        IRequirement requires = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"test.bundle", (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false);
        IInstallableUnit match = AnyRequiredCapabilityTest.createIU((String)"test.bundle");
        IInstallableUnit noMatch = AnyRequiredCapabilityTest.createIU((String)"another.bundle");
        ArrayList<IInstallableUnit> items = new ArrayList<IInstallableUnit>();
        items.add(match);
        items.add(noMatch);
        IQueryResult result = QueryUtil.createMatchQuery((IExpression)requires.getMatches(), (Object[])new Object[0]).perform(items.iterator());
        AnyRequiredCapabilityTest.assertEquals((String)"1.0", (int)1, (int)AnyRequiredCapabilityTest.queryResultSize((IQueryResult)result));
        AnyRequiredCapabilityTest.assertEquals((String)"1.1", (IInstallableUnit)match, (IInstallableUnit)((IInstallableUnit)result.iterator().next()));
    }

    public void testExistingRepository() {
        URI location;
        try {
            location = TestData.getFile((String)"metadataRepo", (String)"good").toURI();
        }
        catch (Exception e) {
            AnyRequiredCapabilityTest.fail((String)"0.99", (Throwable)e);
            return;
        }
        IMetadataRepositoryManager metadataRepositoryManager = AnyRequiredCapabilityTest.getMetadataRepositoryManager();
        metadataRepositoryManager.addRepository(location);
        QueryableMetadataRepositoryManager manager = new QueryableMetadataRepositoryManager(ProvisioningUI.getDefaultUI(), false);
        IRequirement requires = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"test.bundle", (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false);
        IQueryResult result = manager.query(QueryUtil.createMatchQuery((IExpression)requires.getMatches(), (Object[])new Object[0]), this.getMonitor());
        AnyRequiredCapabilityTest.assertEquals((String)"1.0", (int)1, (int)AnyRequiredCapabilityTest.queryResultSize((IQueryResult)result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        AnyRequiredCapabilityTest.assertEquals((String)"1.1", (String)"test.bundle", (String)iu.getId());
    }
}

